/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 53:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "environment": () => (/* binding */ environment)
/* harmony export */ });
const environment = {
    csfloat_base_api_url: 'https://csfloat.com/api',
};


/***/ }),

/***/ 408:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearAccessTokenFromStorage": () => (/* binding */ clearAccessTokenFromStorage),
/* harmony export */   "getAccessToken": () => (/* binding */ getAccessToken)
/* harmony export */ });
/* unused harmony export saveAccessToken */
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62);
/* harmony import */ var _storage_keys__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function getAccessToken(expectedSteamID) {
    return __awaiter(this, void 0, void 0, function* () {
        // Do we have a fresh local copy?
        const tokenData = yield _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.getWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_1__.StorageKey.ACCESS_TOKEN);
        if ((tokenData === null || tokenData === void 0 ? void 0 : tokenData.token) && tokenData.updated_at > Date.now() - 30 * 60 * 1000) {
            // Token refreshed within the last 30 min, we can re-use
            if (!expectedSteamID || expectedSteamID === (tokenData === null || tokenData === void 0 ? void 0 : tokenData.steam_id)) {
                return tokenData;
            }
        }
        // Need to fetch a new one
        const resp = yield fetch(`https://steamcommunity.com`, {
            credentials: 'include',
            headers: {
                // Required for Steam to refresh the JWT when it expires
                Accept: 'text/html,application/xhtml+xml,application/xml;q=0.9;q=0.8,application/signed-exchange;v=b3;q=0.7',
            },
        });
        const body = yield resp.text();
        const webAPITokenMatch = /data-loyalty_webapi_token="&quot;([a-zA-Z0-9_.-]+)&quot;"/.exec(body);
        if (!webAPITokenMatch || webAPITokenMatch.length === 0) {
            throw new Error('failed to parse web api token');
        }
        const token = webAPITokenMatch[1];
        const steamID = extractSteamID(body);
        if (steamID && expectedSteamID && steamID !== expectedSteamID) {
            throw new Error('user is not logged into the expected steam account');
        }
        try {
            yield saveAccessToken(token, steamID);
        }
        catch (e) {
            console.error('failed ot save access token to storage', e);
        }
        return { token, steam_id: steamID, updated_at: Date.now() };
    });
}
function extractSteamID(body) {
    const steamIDMatch = /g_steamID = "(\d+?)"/.exec(body);
    if (!steamIDMatch || steamIDMatch.length === 0) {
        return null;
    }
    return steamIDMatch[1];
}
function saveAccessToken(token, steamID) {
    // Explicitly use local storage to prevent issues with sync storage quota or connectivity issues
    return _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.setWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_1__.StorageKey.ACCESS_TOKEN, {
        token,
        steam_id: steamID,
        updated_at: Date.now(),
    });
}
function clearAccessTokenFromStorage() {
    return _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.removeWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_1__.StorageKey.ACCESS_TOKEN);
}


/***/ }),

/***/ 405:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PING_CSFLOAT_TRADE_STATUS_ALARM_NAME": () => (/* binding */ PING_CSFLOAT_TRADE_STATUS_ALARM_NAME),
/* harmony export */   "pingTradeStatus": () => (/* binding */ pingTradeStatus)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_fetch_pending_trades__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(396);
/* harmony import */ var _trade_history__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(406);
/* harmony import */ var _trade_offer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(409);
/* harmony import */ var _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(398);
/* harmony import */ var _bridge_handlers_ping_extension_status__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(414);
/* harmony import */ var _access_token__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(408);
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(62);
/* harmony import */ var _storage_keys__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(60);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








const PING_CSFLOAT_TRADE_STATUS_ALARM_NAME = 'ping_csfloat_trade_status_alarm';
function pingTradeStatus(expectedSteamID) {
    return __awaiter(this, void 0, void 0, function* () {
        yield _storage_store__WEBPACK_IMPORTED_MODULE_6__.gStore.setWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_7__.StorageKey.LAST_TRADE_PING_ATTEMPT, Date.now());
        const hasPermissions = yield _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_3__.HasPermissions.handleRequest({
            permissions: [],
            origins: ['*://*.steampowered.com/*'],
        }, {});
        if (!hasPermissions.granted) {
            // They didn't enable offer tracking, skip for now
            return;
        }
        let pendingTrades;
        try {
            const resp = yield _bridge_handlers_fetch_pending_trades__WEBPACK_IMPORTED_MODULE_0__.FetchPendingTrades.handleRequest({ limit: 1000 }, {});
            pendingTrades = resp.trades;
        }
        catch (e) {
            console.error(e);
            console.log('cannot fetch pending trades for CSFloat, may not be logged in or CSFloat down');
            return;
        }
        let access = null;
        try {
            access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_5__.getAccessToken)(expectedSteamID);
        }
        catch (e) {
            console.error('failed to fetch access token', e);
        }
        let errors;
        if (pendingTrades.length > 0) {
            errors = yield pingUpdates(pendingTrades);
        }
        // Ping status of ext + permissions
        try {
            yield _bridge_handlers_ping_extension_status__WEBPACK_IMPORTED_MODULE_4__.PingExtensionStatus.handleRequest({
                access_token_steam_id: access === null || access === void 0 ? void 0 : access.steam_id,
                history_error: errors === null || errors === void 0 ? void 0 : errors.history_error,
                trade_offer_error: errors === null || errors === void 0 ? void 0 : errors.trade_offer_error,
            }, {});
        }
        catch (e) {
            console.error('failed to ping extension status to csfloat', e);
        }
    });
}
function pingUpdates(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const errors = {};
        try {
            yield (0,_trade_offer__WEBPACK_IMPORTED_MODULE_2__.cancelUnconfirmedTradeOffers)(pendingTrades);
        }
        catch (e) {
            console.error(`failed to cancel unconfirmed trade offers`, e);
        }
        try {
            yield (0,_trade_history__WEBPACK_IMPORTED_MODULE_1__.pingTradeHistory)(pendingTrades);
        }
        catch (e) {
            console.error('failed to ping trade history', e);
            errors.history_error = e.toString();
        }
        try {
            yield (0,_trade_offer__WEBPACK_IMPORTED_MODULE_2__.pingSentTradeOffers)(pendingTrades);
        }
        catch (e) {
            console.error('failed to ping sent trade offer state', e);
            errors.trade_offer_error = e.toString();
        }
        try {
            yield (0,_trade_offer__WEBPACK_IMPORTED_MODULE_2__.pingCancelTrades)(pendingTrades);
        }
        catch (e) {
            console.error('failed to ping cancel ping trade offers', e);
        }
        return errors;
    });
}


/***/ }),

/***/ 404:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "registerTradeAlarmIfPossible": () => (/* binding */ registerTradeAlarmIfPossible)
/* harmony export */ });
/* unused harmony export alarmListener */
/* harmony import */ var _csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(405);
/* harmony import */ var _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(398);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function alarmListener(alarm) {
    return __awaiter(this, void 0, void 0, function* () {
        if (alarm.name === _csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME) {
            yield (0,_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.pingTradeStatus)();
        }
    });
}
function registerAlarmListenerIfPossible() {
    return __awaiter(this, void 0, void 0, function* () {
        if (chrome.alarms) {
            chrome.alarms.onAlarm.addListener(alarmListener);
        }
    });
}
function registerTradeAlarmIfPossible() {
    return __awaiter(this, void 0, void 0, function* () {
        const hasPermissions = yield _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_1__.HasPermissions.handleRequest({ permissions: ['alarms'], origins: [] }, {});
        if (!hasPermissions.granted) {
            return;
        }
        yield registerAlarmListenerIfPossible();
        const alarm = yield chrome.alarms.get(_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME);
        const hasAlarmWithOutdatedTimer = ((alarm === null || alarm === void 0 ? void 0 : alarm.periodInMinutes) && (alarm === null || alarm === void 0 ? void 0 : alarm.periodInMinutes) > 3) ||
            ((alarm === null || alarm === void 0 ? void 0 : alarm.scheduledTime) && (alarm === null || alarm === void 0 ? void 0 : alarm.scheduledTime) > Date.now() + 10 * 60 * 1000); // Alarm scheduled more than 10 minutes in the future (can be caused by bad system clock)
        if (!alarm || hasAlarmWithOutdatedTimer) {
            yield chrome.alarms.create(_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME, {
                periodInMinutes: 3,
                delayInMinutes: 1,
            });
        }
    });
}


/***/ }),

/***/ 406:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "pingTradeHistory": () => (/* binding */ pingTradeHistory)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(407);
/* harmony import */ var _types_steam_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58);
/* harmony import */ var _access_token__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(408);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function pingTradeHistory(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const { history, type } = yield getTradeHistory();
        // premature optimization in case it's 100 trades
        const assetsToFind = pendingTrades.reduce((acc, e) => {
            acc[e.contract.item.asset_id] = true;
            return acc;
        }, {});
        // We only want to send history that is relevant to verifying trades on CSFloat
        const historyForCSFloat = history.filter((e) => {
            const received_ids = e.received_assets.map((e) => e.asset_id);
            const given_ids = e.given_assets.map((e) => e.asset_id);
            return !![...received_ids, ...given_ids].find((e) => {
                return assetsToFind[e];
            });
        });
        if (historyForCSFloat.length === 0) {
            return;
        }
        yield _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__.TradeHistoryStatus.handleRequest({ history: historyForCSFloat, type }, {});
    });
}
function getTradeHistory() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const history = yield getTradeHistoryFromAPI();
            if (history.length > 0) {
                // Hedge in case this endpoint gets killed, only return if there are results, fallback to HTML parser
                return { history, type: _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__.TradeHistoryType.API };
            }
            else {
                throw new Error('failed to get trade history');
            }
        }
        catch (e) {
            yield (0,_access_token__WEBPACK_IMPORTED_MODULE_2__.clearAccessTokenFromStorage)();
            // Fallback to HTML parsing
            const history = yield getTradeHistoryFromHTML();
            return { history, type: _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__.TradeHistoryType.HTML };
        }
    });
}
function getTradeHistoryFromAPI() {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_2__.getAccessToken)();
        // This only works if they have granted permission for https://api.steampowered.com
        const resp = yield fetch(`https://api.steampowered.com/IEconService/GetTradeHistory/v1/?access_token=${access.token}&max_trades=200`, {
            credentials: 'include',
        });
        if (resp.status !== 200) {
            throw new Error('invalid status');
        }
        const data = (yield resp.json());
        return (((_a = data.response) === null || _a === void 0 ? void 0 : _a.trades) || [])
            .filter((e) => e.status === 3) // Ensure we only count _complete_ trades (k_ETradeStatus_Complete)
            .filter((e) => !e.time_escrow_end || new Date(parseInt(e.time_escrow_end) * 1000).getTime() < Date.now())
            .map((e) => {
            return {
                other_party_url: `https://steamcommunity.com/profiles/${e.steamid_other}`,
                received_assets: (e.assets_received || [])
                    .filter((e) => e.appid === _types_steam_constants__WEBPACK_IMPORTED_MODULE_1__.AppId.CSGO)
                    .map((e) => {
                    return { asset_id: e.assetid, new_asset_id: e.new_assetid };
                }),
                given_assets: (e.assets_given || [])
                    .filter((e) => e.appid === _types_steam_constants__WEBPACK_IMPORTED_MODULE_1__.AppId.CSGO)
                    .map((e) => {
                    return { asset_id: e.assetid, new_asset_id: e.new_assetid };
                }),
            };
        })
            .filter((e) => {
            // Remove non-CS related assets
            return e.received_assets.length > 0 || e.given_assets.length > 0;
        });
    });
}
function getTradeHistoryFromHTML() {
    return __awaiter(this, void 0, void 0, function* () {
        const resp = yield fetch(`https://steamcommunity.com/id/me/tradehistory`, {
            credentials: 'include',
            // Expect redirect since we're using `me` above
            redirect: 'follow',
        });
        const body = yield resp.text();
        if (body.includes('too many requests')) {
            throw 'Too many requests';
        }
        return parseTradeHistoryHTML(body);
    });
}
function parseTradeHistoryHTML(body) {
    const links = body.matchAll(/<div class="tradehistory_event_description">.+?<a href="https:\/\/steamcommunity\.com\/(.+?)">/gms);
    const statuses = [...links].map((e) => {
        return {
            other_party_url: `https://steamcommunity.com/${e[1]}`,
            received_assets: [],
            given_assets: [],
        };
    });
    const matches = body.matchAll(/HistoryPageCreateItemHover\( 'trade(\d+)_(received|given)item\d+', 730, '2', '(\d+)', '1' \);/g);
    for (const match of matches) {
        const [text, index, type, assetId] = match;
        const tradeIndex = parseInt(index);
        if (type === 'received') {
            statuses[tradeIndex].received_assets.push({ asset_id: assetId });
        }
        else if (type === 'given') {
            statuses[tradeIndex].given_assets.push({ asset_id: assetId });
        }
    }
    return statuses;
}


/***/ }),

/***/ 409:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cancelUnconfirmedTradeOffers": () => (/* binding */ cancelUnconfirmedTradeOffers),
/* harmony export */   "pingCancelTrades": () => (/* binding */ pingCancelTrades),
/* harmony export */   "pingSentTradeOffers": () => (/* binding */ pingSentTradeOffers)
/* harmony export */ });
/* harmony import */ var _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58);
/* harmony import */ var _types_float_market__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(397);
/* harmony import */ var _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(410);
/* harmony import */ var _access_token__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(408);
/* harmony import */ var _bridge_handlers_annotate_offer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(400);
/* harmony import */ var _bridge_handlers_ping_cancel_trade__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(411);
/* harmony import */ var _bridge_handlers_cancel_trade_offer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(412);
/* harmony import */ var _bridge_handlers_fetch_steam_user__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(413);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








function pingSentTradeOffers(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const { offers, type } = yield getSentTradeOffers();
        const offersToFind = pendingTrades.reduce((acc, e) => {
            acc[e.steam_offer.id] = true;
            return acc;
        }, {});
        // We only want to send offers that are relevant to verifying trades on CSFloat
        const offersForCSFloat = offers.filter((e) => {
            return !!offersToFind[e.offer_id];
        });
        if (offersForCSFloat.length > 0) {
            yield _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__.TradeOfferStatus.handleRequest({ sent_offers: offersForCSFloat, type }, {});
        }
        // Any trade offers to attempt to annotate in case they sent the trade offer outside of CSFloat
        // This is something they shouldn't do, but you can't control the will of users to defy
        for (const offer of offers) {
            if (offer.state !== _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Active) {
                // If it was already accepted, trade history will send the appropriate ping
                continue;
            }
            const hasTradeWithNoOfferAnnotated = pendingTrades.find((e) => {
                if (e.steam_offer.id) {
                    // Already has a steam offer
                    return false;
                }
                return (offer.given_asset_ids || []).includes(e.contract.item.asset_id);
            });
            if (!hasTradeWithNoOfferAnnotated) {
                // Couldn't find matching trade on CSFloat
                continue;
            }
            try {
                yield _bridge_handlers_annotate_offer__WEBPACK_IMPORTED_MODULE_4__.AnnotateOffer.handleRequest({
                    offer_id: offer.offer_id,
                    given_asset_ids: offer.given_asset_ids || [],
                    received_asset_ids: offer.received_asset_ids || [],
                    other_steam_id64: offer.other_steam_id64,
                }, {});
            }
            catch (e) {
                console.error(`failed to annotate offer ${offer.offer_id} post-hoc`, e);
            }
        }
    });
}
function pingCancelTrades(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const hasWaitForCancelPing = pendingTrades.find((e) => e.state === _types_float_market__WEBPACK_IMPORTED_MODULE_1__.TradeState.PENDING && e.wait_for_cancel_ping);
        if (!hasWaitForCancelPing) {
            // Nothing to process/ping, exit
            return;
        }
        const tradeOffers = yield getSentAndReceivedTradeOffersFromAPI();
        const allTradeOffers = [...(tradeOffers.sent || []), ...(tradeOffers.received || [])];
        for (const trade of pendingTrades) {
            if (trade.state !== _types_float_market__WEBPACK_IMPORTED_MODULE_1__.TradeState.PENDING) {
                continue;
            }
            if (!trade.wait_for_cancel_ping) {
                continue;
            }
            const tradeOffer = allTradeOffers.find((e) => e.offer_id === trade.steam_offer.id);
            if (tradeOffer &&
                (tradeOffer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Active || tradeOffer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Accepted)) {
                // We don't want to send a cancel ping if the offer is active or valid
                continue;
            }
            try {
                yield _bridge_handlers_ping_cancel_trade__WEBPACK_IMPORTED_MODULE_5__.PingCancelTrade.handleRequest({ trade_id: trade.id, steam_id: tradeOffers.steam_id }, {});
            }
            catch (e) {
                console.error(`failed to send cancel ping for trade ${trade.id}`, e);
            }
        }
    });
}
// cancelUnconfirmedTradeOffers related to sales on CSFloat that haven't been confirmed for a while
// Helps prevent the user from sending a trade offer _way after_ the sale has already failed
function cancelUnconfirmedTradeOffers(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const offerIDsToCancel = [
            ...new Set(pendingTrades
                .filter((e) => e.steam_offer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.CreatedNeedsConfirmation &&
                new Date(e.steam_offer.sent_at).getTime() < Date.now() - 60 * 60 * 1000)
                .map((e) => e.steam_offer.id)),
        ];
        if (offerIDsToCancel.length === 0) {
            return;
        }
        const resp = yield getSentTradeOffers();
        const offersIDsStillNeedsConfirmation = offerIDsToCancel.filter((id) => {
            const sentOffer = resp.offers.find((offer) => offer.offer_id === id);
            if (!sentOffer) {
                return false;
            }
            return sentOffer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.CreatedNeedsConfirmation;
        });
        if (offersIDsStillNeedsConfirmation.length === 0) {
            return;
        }
        const steamUser = yield _bridge_handlers_fetch_steam_user__WEBPACK_IMPORTED_MODULE_7__.FetchSteamUser.handleRequest({}, {});
        if (!steamUser.sessionID) {
            // Can't cancel offers without a session
            return;
        }
        for (const offerID of offersIDsStillNeedsConfirmation) {
            try {
                yield _bridge_handlers_cancel_trade_offer__WEBPACK_IMPORTED_MODULE_6__.CancelTradeOffer.handleRequest({ trade_offer_id: offerID, session_id: steamUser.sessionID }, {});
            }
            catch (e) {
                console.error(`failed to cancel needs confirmation trade, returning early: ${e.toString()}`);
                return;
            }
        }
    });
}
function getEnglishSentTradeOffersHTML() {
    return __awaiter(this, void 0, void 0, function* () {
        const resp = yield fetch(`https://steamcommunity.com/id/me/tradeoffers/sent`, {
            credentials: 'include',
            // Expect redirect since we're using `me` above
            redirect: 'follow',
        });
        const body = yield resp.text();
        if (body.match(/<html .+? lang="en">/)) {
            // Already english, return
            return body;
        }
        // Explicitly fetch in english instead (we need to use the redirect URL)
        const englishResp = yield fetch(`${resp.url}?l=english`, {
            credentials: 'include',
            // Expect redirect since we're using `me` above
            redirect: 'follow',
        });
        return englishResp.text();
    });
}
function getSentTradeOffers() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const offers = yield getSentTradeOffersFromAPI();
            if (offers.length > 0) {
                // Hedge in case this endpoint gets killed, only return if there are results, fallback to HTML parser
                return { offers, type: _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__.TradeOffersType.API };
            }
            else {
                throw new Error('failed to get trade offers');
            }
        }
        catch (e) {
            yield (0,_access_token__WEBPACK_IMPORTED_MODULE_3__.clearAccessTokenFromStorage)();
            // Fallback to HTML parsing
            const offers = yield getTradeOffersFromHTML();
            return { offers, type: _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__.TradeOffersType.HTML };
        }
    });
}
function offerStateMapper(e) {
    return {
        offer_id: e.tradeofferid,
        state: e.trade_offer_state,
        given_asset_ids: (e.items_to_give || []).map((e) => e.assetid),
        received_asset_ids: (e.items_to_receive || []).map((e) => e.assetid),
        time_created: e.time_created,
        time_updated: e.time_updated,
        other_steam_id64: (BigInt('76561197960265728') + BigInt(e.accountid_other)).toString(),
    };
}
function getSentTradeOffersFromAPI() {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_3__.getAccessToken)();
        const resp = yield fetch(`https://api.steampowered.com/IEconService/GetTradeOffers/v1/?access_token=${access.token}&get_sent_offers=true`, {
            credentials: 'include',
        });
        if (resp.status !== 200) {
            throw new Error('invalid status');
        }
        const data = (yield resp.json());
        return (((_a = data.response) === null || _a === void 0 ? void 0 : _a.trade_offers_sent) || []).map(offerStateMapper);
    });
}
function getSentAndReceivedTradeOffersFromAPI() {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function* () {
        const access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_3__.getAccessToken)();
        const resp = yield fetch(`https://api.steampowered.com/IEconService/GetTradeOffers/v1/?access_token=${access.token}&get_received_offers=true&get_sent_offers=true`, {
            credentials: 'include',
        });
        if (resp.status !== 200) {
            throw new Error('invalid status');
        }
        const data = (yield resp.json());
        return {
            received: (((_a = data.response) === null || _a === void 0 ? void 0 : _a.trade_offers_received) || []).map(offerStateMapper),
            sent: (((_b = data.response) === null || _b === void 0 ? void 0 : _b.trade_offers_sent) || []).map(offerStateMapper),
            steam_id: access.steam_id,
        };
    });
}
const BANNER_TO_STATE = {
    accepted: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Accepted,
    counter: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Countered,
    expired: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Expired,
    cancel: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Canceled,
    declined: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Declined,
    invalid: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.InvalidItems,
    'mobile confirmation': _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.CreatedNeedsConfirmation,
    escrow: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.InEscrow,
};
function getTradeOffersFromHTML() {
    return __awaiter(this, void 0, void 0, function* () {
        const body = yield getEnglishSentTradeOffersHTML();
        return parseTradeOffersHTML(body);
    });
}
function parseTradeOffersHTML(body) {
    const matches = body.matchAll(/<div class="tradeoffer" id="tradeofferid_(\d+?)">.+?tradeoffer_items_ctn(.+?inactive.+?tradeoffer_items_banner\s*">([^<]+))?/gms);
    return [...matches]
        .map((e) => {
        const offerID = e[1];
        if (!e[2]) {
            // It is active since it didn't match on inactive groups
            return {
                offer_id: offerID,
                state: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Active,
            };
        }
        const bannerText = e[3].toLowerCase();
        const stateEntry = Object.entries(BANNER_TO_STATE).find((e) => bannerText.includes(e[0]));
        if (!stateEntry) {
            return {
                offer_id: offerID,
                state: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Invalid,
            };
        }
        return {
            offer_id: offerID,
            state: stateEntry[1],
        };
    })
        .filter((e) => !!e.offer_id);
}


/***/ }),

/***/ 6:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClientSend": () => (/* binding */ ClientSend)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function canUseSendMessage() {
    // Not supported in Firefox Page Context
    return !((0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.isFirefox)() && (0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)());
}
/**
 * Send a request to be handled by the background worker
 *
 * Can be called from a content script or page itself
 */
function ClientSend(handler, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const bundle = {
            version: _types__WEBPACK_IMPORTED_MODULE_0__.Version.V1,
            request_type: handler.getType(),
            request: args,
            id: Math.ceil(Math.random() * 100000000000),
        };
        if (canUseSendMessage()) {
            return new Promise((resolve, reject) => {
                // @ts-ignore Bad types
                (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(window.CSFLOAT_EXTENSION_ID || chrome.runtime.id, bundle, 
                // @ts-ignore Bad types
                (resp) => {
                    if (resp === null || resp === void 0 ? void 0 : resp.response) {
                        resolve(resp.response);
                    }
                    else {
                        reject(resp === null || resp === void 0 ? void 0 : resp.error);
                    }
                });
            });
        }
        else {
            // Fallback to postmessage bus for browsers that don't implement
            // specs fully
            return _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__.g_PostMessageBus.sendRequest(bundle);
        }
    });
}


/***/ }),

/***/ 400:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnnotateOffer": () => (/* binding */ AnnotateOffer)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const AnnotateOffer = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.ANNOTATE_OFFER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/steam-status/new-offer`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 412:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CancelTradeOffer": () => (/* binding */ CancelTradeOffer)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const CancelTradeOffer = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.CANCEL_TRADE_OFFER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const formData = {
        sessionid: req.session_id,
    };
    const resp = yield fetch(`https://steamcommunity.com/tradeoffer/${req.trade_offer_id}/cancel`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
        },
        body: new URLSearchParams(formData).toString(),
    });
    if (!resp.ok) {
        throw new Error(`failed to cancel offer: ${resp.status}`);
    }
    return {};
}));


/***/ }),

/***/ 11:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteCssOnPage": () => (/* binding */ ExecuteCssOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteCssOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_CSS_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    yield chrome.scripting.insertCSS({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        files: [req.path],
    });
})));


/***/ }),

/***/ 2:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteScriptOnPage": () => (/* binding */ ExecuteScriptOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteScriptOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_SCRIPT_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    // We need to inject the extension ID dynamically so the client knows who to
    // communicate with.
    //
    // On Firefox, extension IDs are random, so this is necessary.
    yield chrome.scripting.executeScript({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        world: 'MAIN',
        args: [chrome.runtime.id],
        func: function ExtensionId(extensionId) {
            window.CSFLOAT_EXTENSION_ID = extensionId;
        },
    });
    yield chrome.scripting.executeScript({
        target: { tabId: (_b = sender.tab) === null || _b === void 0 ? void 0 : _b.id },
        files: [req.path],
        world: 'MAIN',
    });
})));


/***/ }),

/***/ 13:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExtensionVersion": () => (/* binding */ ExtensionVersion)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExtensionVersion = new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyRequestHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXTENSION_VERSION, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const manifest = (0,_utils_detect__WEBPACK_IMPORTED_MODULE_2__.runtimeNamespace)().runtime.getManifest();
    return {
        version: manifest.version,
    };
}));


/***/ }),

/***/ 12:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchExtensionFile": () => (/* binding */ FetchExtensionFile)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchExtensionFile = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_EXTENSION_FILE, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const url = chrome.runtime.getURL(req.path);
    const r = yield fetch(url);
    const text = yield r.text();
    return {
        text,
    };
})));


/***/ }),

/***/ 396:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchPendingTrades": () => (/* binding */ FetchPendingTrades)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchPendingTrades = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_PENDING_TRADES, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const state = req.state ? req.state : 'pending';
    const limit = req.limit ? req.limit : 100;
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/me/trades?state=${state}&limit=${limit}&page=0`, {
        credentials: 'include',
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 413:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchSteamUser": () => (/* binding */ FetchSteamUser)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const FetchSteamUser = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_STEAM_USER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch('https://steamcommunity.com', {
        headers: {
            // Required for Steam to refresh the JWT when it expires
            Accept: 'text/html,application/xhtml+xml,application/xml;q=0.9;q=0.8,application/signed-exchange;v=b3;q=0.7',
        },
    });
    if (!resp.ok) {
        throw new Error('non-ok response for steamcommunity.com');
    }
    const res = {
        isLoggedIn: false,
    };
    const text = yield resp.text();
    const steamIDMatch = text.match(/g_steamID = "(\d+)"/);
    if (steamIDMatch) {
        res.isLoggedIn = true;
        res.steamID = steamIDMatch[1];
    }
    const sessionIDMatch = text.match(/g_sessionID = "([0-9a-fA-F]+)"/);
    if (sessionIDMatch) {
        res.sessionID = sessionIDMatch[1];
    }
    return res;
}));


/***/ }),

/***/ 398:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HasPermissions": () => (/* binding */ HasPermissions)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const HasPermissions = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.HAS_PERMISSIONS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    // @ts-ignore
    const granted = (yield chrome.permissions.contains({
        permissions: req.permissions,
        origins: req.origins,
    }));
    return {
        granted,
    };
}));


/***/ }),

/***/ 3:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EmptyRequestHandler": () => (/* binding */ EmptyRequestHandler),
/* harmony export */   "EmptyResponseHandler": () => (/* binding */ EmptyResponseHandler),
/* harmony export */   "SimpleHandler": () => (/* binding */ SimpleHandler)
/* harmony export */ });
class SimpleHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}
class EmptyRequestHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(sender);
    }
}
class EmptyResponseHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}


/***/ }),

/***/ 411:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingCancelTrade": () => (/* binding */ PingCancelTrade)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const PingCancelTrade = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_CANCEL_TRADE, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/${req.trade_id}/cancel-ping`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            steam_id: req.steam_id,
        }),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    const trade = (yield resp.json());
    return {
        trade,
    };
}));


/***/ }),

/***/ 414:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingExtensionStatus": () => (/* binding */ PingExtensionStatus)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
/* harmony import */ var _has_permissions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(398);
/* harmony import */ var _extension_version__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const PingExtensionStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_EXTENSION_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const steamPoweredPermissions = yield _has_permissions__WEBPACK_IMPORTED_MODULE_3__.HasPermissions.handleRequest({
        permissions: [],
        origins: ['*://*.steampowered.com/*'],
    }, {});
    const steamCommunityPermissions = yield _has_permissions__WEBPACK_IMPORTED_MODULE_3__.HasPermissions.handleRequest({
        permissions: [],
        origins: ['*://*.steamcommunity.com/*'],
    }, {});
    const versionResp = yield _extension_version__WEBPACK_IMPORTED_MODULE_4__.ExtensionVersion.handleRequest({}, {});
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/me/extension/status`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            steam_community_permission: steamCommunityPermissions.granted,
            steam_powered_permission: steamPoweredPermissions.granted,
            version: versionResp.version,
            access_token_steam_id: req.access_token_steam_id || '',
            history_error: req.history_error || '',
            trade_offer_error: req.trade_offer_error || '',
        }),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 403:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingSetupExtension": () => (/* binding */ PingSetupExtension)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
/* harmony import */ var _alarms_setup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(404);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const PingSetupExtension = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_SETUP_EXTENSION, (req) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0,_alarms_setup__WEBPACK_IMPORTED_MODULE_3__.registerTradeAlarmIfPossible)();
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/me/extension/setup`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 407:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TradeHistoryStatus": () => (/* binding */ TradeHistoryStatus),
/* harmony export */   "TradeHistoryType": () => (/* binding */ TradeHistoryType)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



var TradeHistoryType;
(function (TradeHistoryType) {
    TradeHistoryType[TradeHistoryType["API"] = 1] = "API";
    TradeHistoryType[TradeHistoryType["HTML"] = 2] = "HTML";
})(TradeHistoryType || (TradeHistoryType = {}));
const TradeHistoryStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.TRADE_HISTORY_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/steam-status/trade-history`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 410:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TradeOfferStatus": () => (/* binding */ TradeOfferStatus),
/* harmony export */   "TradeOffersType": () => (/* binding */ TradeOffersType)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



var TradeOffersType;
(function (TradeOffersType) {
    TradeOffersType[TradeOffersType["API"] = 1] = "API";
    TradeOffersType[TradeOffersType["HTML"] = 2] = "HTML";
})(TradeOffersType || (TradeOffersType = {}));
const TradeOfferStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.TRADE_OFFER_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/steam-status/offer`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 4:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RequestType": () => (/* binding */ RequestType)
/* harmony export */ });
var RequestType;
(function (RequestType) {
    RequestType[RequestType["EXECUTE_SCRIPT_ON_PAGE"] = 0] = "EXECUTE_SCRIPT_ON_PAGE";
    RequestType[RequestType["EXECUTE_CSS_ON_PAGE"] = 1] = "EXECUTE_CSS_ON_PAGE";
    RequestType[RequestType["FETCH_INSPECT_INFO"] = 2] = "FETCH_INSPECT_INFO";
    RequestType[RequestType["FETCH_STALL"] = 3] = "FETCH_STALL";
    RequestType[RequestType["STORAGE_GET"] = 4] = "STORAGE_GET";
    RequestType[RequestType["STORAGE_SET"] = 5] = "STORAGE_SET";
    RequestType[RequestType["STORAGE_REMOVE"] = 6] = "STORAGE_REMOVE";
    RequestType[RequestType["FETCH_PENDING_TRADES"] = 7] = "FETCH_PENDING_TRADES";
    RequestType[RequestType["FETCH_EXTENSION_FILE"] = 8] = "FETCH_EXTENSION_FILE";
    RequestType[RequestType["ANNOTATE_OFFER"] = 9] = "ANNOTATE_OFFER";
    RequestType[RequestType["EXTENSION_VERSION"] = 10] = "EXTENSION_VERSION";
    RequestType[RequestType["TRADE_HISTORY_STATUS"] = 11] = "TRADE_HISTORY_STATUS";
    RequestType[RequestType["TRADE_OFFER_STATUS"] = 12] = "TRADE_OFFER_STATUS";
    RequestType[RequestType["HAS_PERMISSIONS"] = 13] = "HAS_PERMISSIONS";
    RequestType[RequestType["PING_SETUP_EXTENSION"] = 14] = "PING_SETUP_EXTENSION";
    RequestType[RequestType["PING_EXTENSION_STATUS"] = 15] = "PING_EXTENSION_STATUS";
    RequestType[RequestType["PING_CANCEL_TRADE"] = 16] = "PING_CANCEL_TRADE";
    RequestType[RequestType["CREATE_TRADE_OFFER"] = 17] = "CREATE_TRADE_OFFER";
    RequestType[RequestType["FETCH_STEAM_USER"] = 18] = "FETCH_STEAM_USER";
    RequestType[RequestType["PING_TRADE_STATUS"] = 19] = "PING_TRADE_STATUS";
    RequestType[RequestType["PING_STATUS"] = 20] = "PING_STATUS";
    RequestType[RequestType["FETCH_OWN_INVENTORY"] = 21] = "FETCH_OWN_INVENTORY";
    RequestType[RequestType["CANCEL_TRADE_OFFER"] = 22] = "CANCEL_TRADE_OFFER";
})(RequestType || (RequestType = {}));


/***/ }),

/***/ 7:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Version": () => (/* binding */ Version)
/* harmony export */ });
var Version;
(function (Version) {
    Version["V1"] = "CSFLOAT_V1";
})(Version || (Version = {}));


/***/ }),

/***/ 5:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PrivilegedHandler": () => (/* binding */ PrivilegedHandler)
/* harmony export */ });
/**
 * Restricts a given handler such that it can only run if the sender is
 * verified to be from the extension's origin (ie. content script)
 */
class PrivilegedHandler {
    constructor(handler) {
        this.handler = handler;
    }
    getType() {
        return this.handler.getType();
    }
    handleRequest(request, sender) {
        if (sender.id !== chrome.runtime.id) {
            throw new Error('Attempt to access restricted method outside of secure context (ie. content script)');
        }
        return this.handler.handleRequest(request, sender);
    }
}


/***/ }),

/***/ 10:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g_PostMessageBus": () => (/* binding */ g_PostMessageBus)
/* harmony export */ });
/* harmony import */ var _bridge_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);


/**
 * Message bus that uses `postMessage` in order to communicate with the background
 * service worker/script.
 *
 * Why? Because the client page (ie. Steam page) on Firefox is not capable of
 * sending a message directly to the extension background.
 *
 * So it requires us to do the following dance:
 * page <--(postmessage)--> content script <--(sendmessage)--> background script
 *
 * This dance is abstracted in `ClientSend`, and only uses this bus if
 * `sendmessage` is not supported in the page.
 */
class PostMessageBus {
    /**
     * For the requester (ie. page), to wait until it gets a response
     * from the content script via. postMessage for the given request ID
     *
     * @param id Request ID
     */
    waitUntilResponseFor(id) {
        return new Promise((resolve, reject) => {
            const handler = (e) => {
                const resp = e.data;
                if (resp.id !== id || !resp.response) {
                    return;
                }
                // Prevent leaks
                window.removeEventListener('message', handler, false);
                if (resp === null || resp === void 0 ? void 0 : resp.response) {
                    resolve(resp.response);
                }
                else {
                    reject(resp === null || resp === void 0 ? void 0 : resp.error);
                }
            };
            window.addEventListener('message', handler);
        });
    }
    /**
     * Sends a request to be done through the bus, returns the appropriate
     * response for the input bundle handler
     *
     * @param bundle Request Bundle
     */
    sendRequest(bundle) {
        window.postMessage(bundle);
        return this.waitUntilResponseFor(bundle.id);
    }
    /**
     * Request handler (content script) for new requests from the page.
     *
     * Each request is effectively "proxied" to the background script/worker
     * to actually execute it's handler.
     */
    handleRequests() {
        const h = (e) => {
            if (e.data.version !== _bridge_types__WEBPACK_IMPORTED_MODULE_0__.Version.V1 || !e.data.request) {
                // Ignore messages that aren't for this bridge
                return;
            }
            // Send to the background script
            // @ts-ignore Bad types
            (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(chrome.runtime.id, e.data, 
            // @ts-ignore Bad types
            (resp) => {
                window.postMessage(resp);
            });
        };
        window.addEventListener('message', h);
    }
}
const g_PostMessageBus = new PostMessageBus();


/***/ }),

/***/ 377:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony export SteamButton */
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/* harmony import */ var lit_html_directives_class_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(378);
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17);
/* harmony import */ var _injectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16);
/* harmony import */ var _custom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





var ButtonType;
(function (ButtonType) {
    ButtonType["GreenWhite"] = "green_white";
    ButtonType["GreyWhite"] = "grey_white";
})(ButtonType || (ButtonType = {}));
let SteamButton = class SteamButton extends _custom__WEBPACK_IMPORTED_MODULE_4__.FloatElement {
    constructor() {
        super(...arguments);
        this.text = '';
        this.type = ButtonType.GreenWhite;
    }
    connectedCallback() {
        const _super = Object.create(null, {
            connectedCallback: { get: () => super.connectedCallback }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.connectedCallback.call(this);
        });
    }
    btnClass() {
        const r = { btn_small: true };
        r[`btn_${this.type}_innerfade`] = true;
        return (0,lit_html_directives_class_map_js__WEBPACK_IMPORTED_MODULE_1__.classMap)(r);
    }
    render() {
        return lit__WEBPACK_IMPORTED_MODULE_0__.html `
            <a class="${this.btnClass()}">
                <span>${this.text}</span>
            </a>
        `;
    }
};
SteamButton.styles = [
    ..._custom__WEBPACK_IMPORTED_MODULE_4__.FloatElement.styles,
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            .btn_green_white_innerfade {
                border-radius: 2px;
                border: none;
                padding: 1px;
                display: inline-block;
                cursor: pointer;
                text-decoration: none !important;
                color: #d2e885 !important;

                background: #a4d007;
                background: -webkit-linear-gradient(top, #a4d007 5%, #536904 95%);
                background: linear-gradient(to bottom, #a4d007 5%, #536904 95%);
            }

            .btn_green_white_innerfade > span {
                border-radius: 2px;
                display: block;

                background: #799905;
                background: -webkit-linear-gradient(top, #799905 5%, #536904 95%);
                background: linear-gradient(to bottom, #799905 5%, #536904 95%);
            }

            .btn_green_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover {
                text-decoration: none !important;
                color: #fff !important;

                background: #b6d908;
                background: -webkit-linear-gradient(top, #b6d908 5%, #80a006 95%);
                background: linear-gradient(to bottom, #b6d908 5%, #80a006 95%);
            }

            .btn_green_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover > span {
                background: #a1bf07;
                background: -webkit-linear-gradient(top, #a1bf07 5%, #80a006 95%);
                background: linear-gradient(to bottom, #a1bf07 5%, #80a006 95%);
            }

            .btn_grey_white_innerfade {
                border-radius: 2px;
                border: none;
                padding: 1px;
                display: inline-block;
                cursor: pointer;
                text-decoration: none !important;
                color: #fff !important;

                background: #acb5bd;
                background: -webkit-linear-gradient(top, #acb5bd 5%, #414a52 95%);
                background: linear-gradient(to bottom, #acb5bd 5%, #414a52 95%);
            }

            .btn_grey_white_innerfade > span {
                border-radius: 2px;
                display: block;

                background: #778088;
                background: -webkit-linear-gradient(top, #778088 5%, #414a52 95%);
                background: linear-gradient(to bottom, #778088 5%, #414a52 95%);
            }

            .btn_grey_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover {
                text-decoration: none !important;
                color: #fff !important;

                background: #cfd8e0;
                background: -webkit-linear-gradient(top, #cfd8e0 5%, #565f67 95%);
                background: linear-gradient(to bottom, #cfd8e0 5%, #565f67 95%);
            }

            .btn_grey_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover > span {
                background: #99a2aa;
                background: -webkit-linear-gradient(top, #99a2aa 5%, #565f67 95%);
                background: linear-gradient(to bottom, #99a2aa 5%, #565f67 95%);
            }

            .btn_small > span {
                padding: 0 15px;
                font-size: 12px;
                line-height: 20px;
            }
        `,
];
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__.property)({ type: String })
], SteamButton.prototype, "text", void 0);
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__.property)({ type: String })
], SteamButton.prototype, "type", void 0);
SteamButton = __decorate([
    (0,_injectors__WEBPACK_IMPORTED_MODULE_3__.CustomElement)()
], SteamButton);



/***/ }),

/***/ 29:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FloatElement": () => (/* binding */ FloatElement)
/* harmony export */ });
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);

function camelToDashCase(str) {
    return str
        .split(/(?=[A-Z])/)
        .join('-')
        .toLowerCase();
}
// LitElement wrapper with a pre-determined tag
class FloatElement extends lit__WEBPACK_IMPORTED_MODULE_0__.LitElement {
    static tag() {
        return `csfloat-${camelToDashCase(this.name)}`;
    }
    static elem() {
        return document.createElement(this.tag());
    }
}
FloatElement.styles = [
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            hr {
                background-color: #1b2939;
                border-style: solid none none;
                border-color: black;
                border-width: 1px 0 0;
                height: 2px;
            }

            a {
                color: #ebebeb;
                cursor: pointer;
            }

            input[type='text'],
            input[type='password'],
            input[type='number'],
            select {
                color: #909090;
                background-color: rgba(0, 0, 0, 0.2);
                border: 1px solid #000;
                border-radius: 3px;
            }

            input[type='color'] {
                float: left;
                margin-top: 2px;
                -webkit-appearance: none;
                border: none;
                width: 20px;
                height: 20px;
                padding: 0;
            }

            input[type='color']::-webkit-color-swatch-wrapper {
                padding: 0;
            }

            input[type='color']::-webkit-color-swatch {
                border: none;
            }
        `,
];


/***/ }),

/***/ 16:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CustomElement": () => (/* binding */ CustomElement),
/* harmony export */   "InjectAfter": () => (/* binding */ InjectAfter),
/* harmony export */   "InjectionMode": () => (/* binding */ InjectionMode)
/* harmony export */ });
/* unused harmony exports InjectAppend, InjectBefore */
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9);


var InjectionMode;
(function (InjectionMode) {
    // Injects once at page load for elements matching the selector
    InjectionMode[InjectionMode["ONCE"] = 0] = "ONCE";
    // Continually injects whenever new elements that match the
    // selector exist that haven't been injected into yet
    //
    // Should be use for "dynamic" elements
    InjectionMode[InjectionMode["CONTINUOUS"] = 1] = "CONTINUOUS";
})(InjectionMode || (InjectionMode = {}));
var InjectionType;
(function (InjectionType) {
    InjectionType[InjectionType["Append"] = 0] = "Append";
    InjectionType[InjectionType["Before"] = 1] = "Before";
    InjectionType[InjectionType["After"] = 2] = "After";
})(InjectionType || (InjectionType = {}));
const InjectionConfigs = {
    [InjectionType.Append]: {
        exists: (ctx, selector) => !!ctx.children(selector).length,
        op: (ctx, target) => ctx.append(target.elem()),
    },
    [InjectionType.Before]: {
        exists: (ctx, selector) => !!ctx.parent().children(selector).length,
        op: (ctx, target) => ctx.before(target.elem()),
    },
    [InjectionType.After]: {
        exists: (ctx, selector) => !!ctx.parent().children(selector).length,
        op: (ctx, target) => ctx.after(target.elem()),
    },
};
function CustomElement() {
    return function (target, propertyKey, descriptor) {
        if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_1__.inPageContext)()) {
            return;
        }
        if (customElements.get(target.tag())) {
            // Already defined
            return;
        }
        (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_0__.customElement)(target.tag())(target);
    };
}
function Inject(selector, mode, type) {
    return function (target, propertyKey, descriptor) {
        if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_1__.inPageContext)()) {
            return;
        }
        switch (mode) {
            case InjectionMode.ONCE:
                $J(selector).each(function () {
                    InjectionConfigs[type].op($J(this), target);
                });
                break;
            case InjectionMode.CONTINUOUS:
                setInterval(() => {
                    $J(selector).each(function () {
                        // Don't add the item again if we already have
                        if (InjectionConfigs[type].exists($J(this), target.tag()))
                            return;
                        InjectionConfigs[type].op($J(this), target);
                    });
                }, 250);
                break;
        }
    };
}
function InjectAppend(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.Append);
}
function InjectBefore(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.Before);
}
function InjectAfter(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.After);
}


/***/ }),

/***/ 402:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony export BetterTrackingWidget */
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/* harmony import */ var _injectors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _custom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29);
/* harmony import */ var _common_ui_steam_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(377);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6);
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(17);
/* harmony import */ var _bridge_handlers_fetch_pending_trades__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(396);
/* harmony import */ var _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(398);
/* harmony import */ var _bridge_handlers_ping_setup_extension__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(403);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









let BetterTrackingWidget = class BetterTrackingWidget extends _custom__WEBPACK_IMPORTED_MODULE_2__.FloatElement {
    constructor() {
        super(...arguments);
        this.show = false;
    }
    connectedCallback() {
        const _super = Object.create(null, {
            connectedCallback: { get: () => super.connectedCallback }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.connectedCallback.call(this);
            try {
                // Used for api.steampowered.com requests, all tokens stay on the users' device
                const hasPermissions = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_4__.ClientSend)(_bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_7__.HasPermissions, {
                    permissions: ['alarms'],
                    origins: ['*://*.steampowered.com/*'],
                });
                if (hasPermissions.granted) {
                    // In case they switched accounts on CSFloat or Steam or initial ping was lost, send redundant pings
                    (0,_bridge_client__WEBPACK_IMPORTED_MODULE_4__.ClientSend)(_bridge_handlers_ping_setup_extension__WEBPACK_IMPORTED_MODULE_8__.PingSetupExtension, {});
                    return;
                }
                const trades = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_4__.ClientSend)(_bridge_handlers_fetch_pending_trades__WEBPACK_IMPORTED_MODULE_6__.FetchPendingTrades, { state: 'queued,pending,verified', limit: 1 });
                if (trades.count === 0) {
                    // They aren't actively using CSFloat Market, no need to show this
                    return;
                }
                this.show = true;
            }
            catch (e) {
                console.info('user is not logged into CSFloat');
            }
        });
    }
    render() {
        return this.show
            ? lit__WEBPACK_IMPORTED_MODULE_0__.html `
                  <div class="container" style="margin: 20px 0 20px 0;">
                      <div>
                          <div class="float-icon">
                              <img
                                  src="https://avatars.cloudflare.steamstatic.com/6ab5219d0bbcce1300a2c6d7cbc638da52edda48_full.jpg"
                                  style="height: 32px;"
                              />
                          </div>
                          <span class="item-name">Setup Offer Tracking on CSFloat</span>
                          <div class="sale-info">Verify trades while preserving your privacy.</div>
                      </div>
                      <csfloat-steam-button id="csfloat-enable-enhanced" .text="${'Enable'}"></csfloat-steam-button>
                  </div>
              `
            : lit__WEBPACK_IMPORTED_MODULE_0__.html ``;
    }
};
BetterTrackingWidget.styles = [
    ..._custom__WEBPACK_IMPORTED_MODULE_2__.FloatElement.styles,
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            .container {
                margin-top: 10px;
                margin-bottom: 10px;
                padding: 15px;
                background-color: #15171c;
                color: white;
                display: flex;
                justify-content: space-between;
                align-items: center;
                border-radius: 6px;
            }
            .container.warning {
                background-color: rgb(179, 0, 0);
            }
            .float-icon {
                float: left;
            }
            .item-name {
                font-size: 18px;
                margin-left: 15px;
                line-height: 32px;
            }
            .sale-info {
                padding-left: 45px;
                color: darkgrey;
            }
        `,
];
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_5__.state)()
], BetterTrackingWidget.prototype, "show", void 0);
BetterTrackingWidget = __decorate([
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.CustomElement)(),
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.InjectAfter)('.maincontent .profile_leftcol .nonresponsive_hidden:not(.responsive_createtradeoffer)', _injectors__WEBPACK_IMPORTED_MODULE_1__.InjectionMode.ONCE)
], BetterTrackingWidget);



/***/ }),

/***/ 1:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "init": () => (/* binding */ init)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_execute_script__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bridge_handlers_execute_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function initiateChromium(scriptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_execute_css__WEBPACK_IMPORTED_MODULE_3__.ExecuteCssOnPage, {
            path: 'src/global.css',
        });
        (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_execute_script__WEBPACK_IMPORTED_MODULE_0__.ExecuteScriptOnPage, {
            path: scriptPath,
        });
    });
}
function initiateFirefox(scriptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_6__.g_PostMessageBus.handleRequests();
        // Why do we need to use manual DOM script injection and
        // fetch the text of the script?
        // See https://github.com/csfloat/extension/issues/155#issuecomment-1639781914
        // We want to inject the ID of the extension
        const id = browser.runtime.id;
        const entryScript = document.createElement('script');
        entryScript.appendChild(document.createTextNode(`
        window.CSFLOAT_EXTENSION_ID = '${id}';
    `));
        document.head.appendChild(entryScript);
        const scriptResp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__.FetchExtensionFile, {
            path: scriptPath,
        });
        const script = document.createElement('script');
        script.appendChild(document.createTextNode(scriptResp.text));
        document.head.appendChild(script);
        const styleResp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__.FetchExtensionFile, {
            path: 'src/global.css',
        });
        const style = document.createElement('style');
        style.appendChild(document.createTextNode(styleResp.text));
        document.head.appendChild(style);
    });
}
/**
 * Initializes a page script, executing it in the page context if necessary
 *
 * @param scriptPath Relative path of the script (always in .js)
 * @param ifPage Fn to run if we are in the page's execution context
 */
function init(scriptPath, ifPage) {
    return __awaiter(this, void 0, void 0, function* () {
        // Don't allow the page script to run this.
        if ((0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)()) {
            // @ts-ignore Set global identifier for other extensions to use
            window.csfloat = true;
            // @ts-ignore Deprecated name
            window.csgofloat = true;
            ifPage();
            return;
        }
        if ((0,_utils_detect__WEBPACK_IMPORTED_MODULE_5__.isFirefox)()) {
            yield initiateFirefox(scriptPath);
        }
        else {
            yield initiateChromium(scriptPath);
        }
        console.log(`%c CSFloat Market Checker (v${chrome.runtime.getManifest().version}) by Step7750 `, 'background: #004594; color: #fff;');
        console.log('%c Changelog can be found here: https://github.com/csfloat/extension ', 'background: #004594; color: #fff;');
    });
}


/***/ }),

/***/ 60:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageKey": () => (/* binding */ StorageKey)
/* harmony export */ });
/* unused harmony exports PAGE_SIZE, DYNAMIC_ITEM_FILTERS, GLOBAL_FILTERS */
var StorageKey;
(function (StorageKey) {
    // Backwards compatible with <3.0.0
    StorageKey["PAGE_SIZE"] = "pageSize";
    StorageKey["ITEM_FILTERS"] = "expressions";
    StorageKey["GLOBAL_FILTERS"] = "global";
    StorageKey["ACCESS_TOKEN"] = "access_token";
    StorageKey["LAST_TRADE_PING_ATTEMPT"] = "last_trade_ping_attempt";
})(StorageKey || (StorageKey = {}));
function newRow(name) {
    return { key: name };
}
/**
 * Allows defining a "dynamic" row that has different keys at runtime, but share a similar
 * type.
 *
 * NOTE: This is generally **discouraged** and you should instead store under a static key with
 * an object of your desire. It exists to be compatible with historical poor decisions.
 *
 * @param suffix Storage key used as a suffix for the internal storage key
 */
function newDynamicRow(suffix) {
    return function (prefix) {
        return { key: `${prefix}_${suffix}` };
    };
}
// Explicitly create each row here that is used in the application
// This is designed to have type safety for all operations on the same key
const PAGE_SIZE = newRow(StorageKey.PAGE_SIZE);
// Dynamic prefixes should be the market hash name of the item
const DYNAMIC_ITEM_FILTERS = newDynamicRow(StorageKey.ITEM_FILTERS);
const GLOBAL_FILTERS = newRow(StorageKey.GLOBAL_FILTERS);


/***/ }),

/***/ 62:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gStore": () => (/* binding */ gStore)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class Store {
    // Prefer to use sync storage if possible
    get defaultStorageLayer() {
        return chrome.storage.sync ? chrome.storage.sync : chrome.storage.local;
    }
    // getWithStorage using a specified storage layer
    getWithStorage(storage, key) {
        return __awaiter(this, void 0, void 0, function* () {
            const a = yield storage.get(key);
            if (!a || !(key in a)) {
                return null;
            }
            try {
                return JSON.parse(a[key]);
            }
            catch (e) {
                // Fallback if this is an old key not stored as JSON
                return a[key];
            }
        });
    }
    // get using the default storage layer
    get(key) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.getWithStorage(this.defaultStorageLayer, key);
        });
    }
    // setWithStorage using a specified storage layer
    setWithStorage(storage, key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            return storage.set({ [key]: JSON.stringify(value) });
        });
    }
    // set using the default storage layer
    set(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.setWithStorage(this.defaultStorageLayer, key, value);
        });
    }
    // removeWithStorage using a specified storage layer
    removeWithStorage(storage, key) {
        return __awaiter(this, void 0, void 0, function* () {
            return storage.remove([key]);
        });
    }
    // remove using the default storage layer
    remove(key) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.removeWithStorage(this.defaultStorageLayer, key);
        });
    }
}
const gStore = new Store();


/***/ }),

/***/ 397:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TradeState": () => (/* binding */ TradeState)
/* harmony export */ });
/* unused harmony exports ContractState, ContractType */
var ContractState;
(function (ContractState) {
    ContractState["SOLD"] = "sold";
    ContractState["LISTED"] = "listed";
    ContractState["DELISTED"] = "delisted";
    ContractState["REFUNDED"] = "refunded";
})(ContractState || (ContractState = {}));
var ContractType;
(function (ContractType) {
    ContractType["BUY_NOW"] = "buy_now";
    ContractType["AUCTION"] = "auction";
})(ContractType || (ContractType = {}));
var TradeState;
(function (TradeState) {
    TradeState["QUEUED"] = "queued";
    TradeState["PENDING"] = "pending";
    TradeState["VERIFIED"] = "verified";
    TradeState["FAILED"] = "failed";
    TradeState["CANCELLED"] = "cancelled";
})(TradeState || (TradeState = {}));


/***/ }),

/***/ 58:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppId": () => (/* binding */ AppId),
/* harmony export */   "TradeOfferState": () => (/* binding */ TradeOfferState)
/* harmony export */ });
/* unused harmony exports Currency, ContextId */
// See g_rgCurrencyData
var Currency;
(function (Currency) {
    Currency[Currency["USD"] = 2001] = "USD";
})(Currency || (Currency = {}));
var AppId;
(function (AppId) {
    AppId[AppId["CSGO"] = 730] = "CSGO";
})(AppId || (AppId = {}));
var ContextId;
(function (ContextId) {
    ContextId[ContextId["PRIMARY"] = 2] = "PRIMARY";
})(ContextId || (ContextId = {}));
// https://developer.valvesoftware.com/wiki/Steam_Web_API/IEconService
var TradeOfferState;
(function (TradeOfferState) {
    TradeOfferState[TradeOfferState["Invalid"] = 1] = "Invalid";
    TradeOfferState[TradeOfferState["Active"] = 2] = "Active";
    TradeOfferState[TradeOfferState["Accepted"] = 3] = "Accepted";
    TradeOfferState[TradeOfferState["Countered"] = 4] = "Countered";
    TradeOfferState[TradeOfferState["Expired"] = 5] = "Expired";
    TradeOfferState[TradeOfferState["Canceled"] = 6] = "Canceled";
    TradeOfferState[TradeOfferState["Declined"] = 7] = "Declined";
    TradeOfferState[TradeOfferState["InvalidItems"] = 8] = "InvalidItems";
    TradeOfferState[TradeOfferState["CreatedNeedsConfirmation"] = 9] = "CreatedNeedsConfirmation";
    TradeOfferState[TradeOfferState["CancelledBySecondFactor"] = 10] = "CancelledBySecondFactor";
    TradeOfferState[TradeOfferState["InEscrow"] = 11] = "InEscrow";
})(TradeOfferState || (TradeOfferState = {}));


/***/ }),

/***/ 8:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isFirefox": () => (/* binding */ isFirefox),
/* harmony export */   "runtimeNamespace": () => (/* binding */ runtimeNamespace)
/* harmony export */ });
function isFirefox() {
    return navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
}
/**
 * Thanks to our browser overlords, we have two namespaces for `x.runtime.fn()`
 */
function runtimeNamespace() {
    if (isFirefox()) {
        return browser;
    }
    else {
        return chrome;
    }
}


/***/ }),

/***/ 9:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "inPageContext": () => (/* binding */ inPageContext)
/* harmony export */ });
function inPageContext() {
    return typeof chrome === 'undefined' || !chrome.extension;
}


/***/ }),

/***/ 32:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "adoptStyles": () => (/* binding */ S),
/* harmony export */   "css": () => (/* binding */ i),
/* harmony export */   "getCompatibleStyle": () => (/* binding */ c)
/* harmony export */ });
/* unused harmony exports CSSResult, supportsAdoptingStyleSheets, unsafeCSS */
/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t=window,e=t.ShadowRoot&&(void 0===t.ShadyCSS||t.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s=Symbol(),n=new WeakMap;class o{constructor(t,e,n){if(this._$cssResult$=!0,n!==s)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e}get styleSheet(){let t=this.o;const s=this.t;if(e&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=n.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&n.set(s,t))}return t}toString(){return this.cssText}}const r=t=>new o("string"==typeof t?t:t+"",void 0,s),i=(t,...e)=>{const n=1===t.length?t[0]:e.reduce(((e,s,n)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[n+1]),t[0]);return new o(n,t,s)},S=(s,n)=>{e?s.adoptedStyleSheets=n.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet)):n.forEach((e=>{const n=document.createElement("style"),o=t.litNonce;void 0!==o&&n.setAttribute("nonce",o),n.textContent=e.cssText,s.appendChild(n)}))},c=e?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r(e)})(t):t;
//# sourceMappingURL=css-tag.js.map


/***/ }),

/***/ 22:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "decorateProperty": () => (/* binding */ o)
/* harmony export */ });
/* unused harmony exports legacyPrototypeMethod, standardPrototypeMethod */
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e=(e,t,o)=>{Object.defineProperty(t,o,e)},t=(e,t)=>({kind:"method",placement:"prototype",key:t.key,descriptor:e}),o=({finisher:e,descriptor:t})=>(o,n)=>{var r;if(void 0===n){const n=null!==(r=o.originalKey)&&void 0!==r?r:o.key,i=null!=t?{kind:"method",placement:"prototype",key:n,descriptor:t(o.key)}:{...o,key:n};return null!=e&&(i.finisher=function(t){e(t,n)}),i}{const r=o.constructor;void 0!==t&&Object.defineProperty(o,n,t(n)),null==e||e(r,n)}};
//# sourceMappingURL=base.js.map


/***/ }),

/***/ 18:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "customElement": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e=e=>n=>"function"==typeof n?((e,n)=>(customElements.define(e,n),n))(e,n):((e,n)=>{const{kind:t,elements:s}=n;return{kind:t,elements:s,finisher(n){customElements.define(e,n)}}})(e,n);
//# sourceMappingURL=custom-element.js.map


/***/ }),

/***/ 21:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export eventOptions */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({finisher:(r,t)=>{Object.assign(r.prototype[t],e)}})}
//# sourceMappingURL=event-options.js.map


/***/ }),

/***/ 19:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "property": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const i=(i,e)=>"method"===e.kind&&e.descriptor&&!("value"in e.descriptor)?{...e,finisher(n){n.createProperty(e.key,i)}}:{kind:"field",key:Symbol(),placement:"own",descriptor:{},originalKey:e.key,initializer(){"function"==typeof e.initializer&&(this[e.key]=e.initializer.call(this))},finisher(n){n.createProperty(e.key,i)}};function e(e){return(n,t)=>void 0!==t?((i,e,n)=>{e.constructor.createProperty(n,i)})(e,n,t):i(e,n)}
//# sourceMappingURL=property.js.map


/***/ }),

/***/ 24:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAll */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:r=>({get(){var r,o;return null!==(o=null===(r=this.renderRoot)||void 0===r?void 0:r.querySelectorAll(e))&&void 0!==o?o:[]},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-all.js.map


/***/ }),

/***/ 26:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "queryAssignedElements": () => (/* binding */ l)
/* harmony export */ });
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var n;const e=null!=(null===(n=window.HTMLSlotElement)||void 0===n?void 0:n.prototype.assignedElements)?(o,n)=>o.assignedElements(n):(o,n)=>o.assignedNodes(n).filter((o=>o.nodeType===Node.ELEMENT_NODE));function l(n){const{slot:l,selector:t}=null!=n?n:{};return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:o=>({get(){var o;const r="slot"+(l?`[name=${l}]`:":not([name])"),i=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(r),s=null!=i?e(i,n):[];return t?s.filter((o=>o.matches(t))):s},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-assigned-elements.js.map


/***/ }),

/***/ 27:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAssignedNodes */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);
/* harmony import */ var _query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function o(o,n,r){let l,s=o;return"object"==typeof o?(s=o.slot,l=o):l={flatten:n},r?(0,_query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_1__.queryAssignedElements)({slot:s,flatten:n,selector:r}):(0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:e=>({get(){var e,t;const o="slot"+(s?`[name=${s}]`:":not([name])"),n=null===(e=this.renderRoot)||void 0===e?void 0:e.querySelector(o);return null!==(t=null==n?void 0:n.assignedNodes(l))&&void 0!==t?t:[]},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-assigned-nodes.js.map


/***/ }),

/***/ 25:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAsync */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:r=>({async get(){var r;return await this.updateComplete,null===(r=this.renderRoot)||void 0===r?void 0:r.querySelector(e)},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-async.js.map


/***/ }),

/***/ 23:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export query */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function i(i,n){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:o=>{const t={get(){var o,n;return null!==(n=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(i))&&void 0!==n?n:null},enumerable:!0,configurable:!0};if(n){const n="symbol"==typeof o?Symbol():"__"+o;t.get=function(){var o,t;return void 0===this[n]&&(this[n]=null!==(t=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(i))&&void 0!==t?t:null),this[n]}}return t}})}
//# sourceMappingURL=query.js.map


/***/ }),

/***/ 20:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "state": () => (/* binding */ t)
/* harmony export */ });
/* harmony import */ var _property_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function t(t){return (0,_property_js__WEBPACK_IMPORTED_MODULE_0__.property)({...t,state:!0})}
//# sourceMappingURL=state.js.map


/***/ }),

/***/ 31:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReactiveElement": () => (/* binding */ d),
/* harmony export */   "css": () => (/* reexport safe */ _css_tag_js__WEBPACK_IMPORTED_MODULE_0__.css)
/* harmony export */ });
/* unused harmony exports defaultConverter, notEqual */
/* harmony import */ var _css_tag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var s;const e=window,r=e.trustedTypes,h=r?r.emptyScript:"",o=e.reactiveElementPolyfillSupport,n={toAttribute(t,i){switch(i){case Boolean:t=t?h:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t)}return t},fromAttribute(t,i){let s=t;switch(i){case Boolean:s=null!==t;break;case Number:s=null===t?null:Number(t);break;case Object:case Array:try{s=JSON.parse(t)}catch(t){s=null}}return s}},a=(t,i)=>i!==t&&(i==i||t==t),l={attribute:!0,type:String,converter:n,reflect:!1,hasChanged:a};class d extends HTMLElement{constructor(){super(),this._$Ei=new Map,this.isUpdatePending=!1,this.hasUpdated=!1,this._$El=null,this.u()}static addInitializer(t){var i;null!==(i=this.h)&&void 0!==i||(this.h=[]),this.h.push(t)}static get observedAttributes(){this.finalize();const t=[];return this.elementProperties.forEach(((i,s)=>{const e=this._$Ep(s,i);void 0!==e&&(this._$Ev.set(e,s),t.push(e))})),t}static createProperty(t,i=l){if(i.state&&(i.attribute=!1),this.finalize(),this.elementProperties.set(t,i),!i.noAccessor&&!this.prototype.hasOwnProperty(t)){const s="symbol"==typeof t?Symbol():"__"+t,e=this.getPropertyDescriptor(t,s,i);void 0!==e&&Object.defineProperty(this.prototype,t,e)}}static getPropertyDescriptor(t,i,s){return{get(){return this[i]},set(e){const r=this[t];this[i]=e,this.requestUpdate(t,r,s)},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)||l}static finalize(){if(this.hasOwnProperty("finalized"))return!1;this.finalized=!0;const t=Object.getPrototypeOf(this);if(t.finalize(),this.elementProperties=new Map(t.elementProperties),this._$Ev=new Map,this.hasOwnProperty("properties")){const t=this.properties,i=[...Object.getOwnPropertyNames(t),...Object.getOwnPropertySymbols(t)];for(const s of i)this.createProperty(s,t[s])}return this.elementStyles=this.finalizeStyles(this.styles),!0}static finalizeStyles(i){const s=[];if(Array.isArray(i)){const e=new Set(i.flat(1/0).reverse());for(const i of e)s.unshift((0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.getCompatibleStyle)(i))}else void 0!==i&&s.push((0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.getCompatibleStyle)(i));return s}static _$Ep(t,i){const s=i.attribute;return!1===s?void 0:"string"==typeof s?s:"string"==typeof t?t.toLowerCase():void 0}u(){var t;this._$E_=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$Eg(),this.requestUpdate(),null===(t=this.constructor.h)||void 0===t||t.forEach((t=>t(this)))}addController(t){var i,s;(null!==(i=this._$ES)&&void 0!==i?i:this._$ES=[]).push(t),void 0!==this.renderRoot&&this.isConnected&&(null===(s=t.hostConnected)||void 0===s||s.call(t))}removeController(t){var i;null===(i=this._$ES)||void 0===i||i.splice(this._$ES.indexOf(t)>>>0,1)}_$Eg(){this.constructor.elementProperties.forEach(((t,i)=>{this.hasOwnProperty(i)&&(this._$Ei.set(i,this[i]),delete this[i])}))}createRenderRoot(){var t;const s=null!==(t=this.shadowRoot)&&void 0!==t?t:this.attachShadow(this.constructor.shadowRootOptions);return (0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.adoptStyles)(s,this.constructor.elementStyles),s}connectedCallback(){var t;void 0===this.renderRoot&&(this.renderRoot=this.createRenderRoot()),this.enableUpdating(!0),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostConnected)||void 0===i?void 0:i.call(t)}))}enableUpdating(t){}disconnectedCallback(){var t;null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostDisconnected)||void 0===i?void 0:i.call(t)}))}attributeChangedCallback(t,i,s){this._$AK(t,s)}_$EO(t,i,s=l){var e;const r=this.constructor._$Ep(t,s);if(void 0!==r&&!0===s.reflect){const h=(void 0!==(null===(e=s.converter)||void 0===e?void 0:e.toAttribute)?s.converter:n).toAttribute(i,s.type);this._$El=t,null==h?this.removeAttribute(r):this.setAttribute(r,h),this._$El=null}}_$AK(t,i){var s;const e=this.constructor,r=e._$Ev.get(t);if(void 0!==r&&this._$El!==r){const t=e.getPropertyOptions(r),h="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==(null===(s=t.converter)||void 0===s?void 0:s.fromAttribute)?t.converter:n;this._$El=r,this[r]=h.fromAttribute(i,t.type),this._$El=null}}requestUpdate(t,i,s){let e=!0;void 0!==t&&(((s=s||this.constructor.getPropertyOptions(t)).hasChanged||a)(this[t],i)?(this._$AL.has(t)||this._$AL.set(t,i),!0===s.reflect&&this._$El!==t&&(void 0===this._$EC&&(this._$EC=new Map),this._$EC.set(t,s))):e=!1),!this.isUpdatePending&&e&&(this._$E_=this._$Ej())}async _$Ej(){this.isUpdatePending=!0;try{await this._$E_}catch(t){Promise.reject(t)}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){var t;if(!this.isUpdatePending)return;this.hasUpdated,this._$Ei&&(this._$Ei.forEach(((t,i)=>this[i]=t)),this._$Ei=void 0);let i=!1;const s=this._$AL;try{i=this.shouldUpdate(s),i?(this.willUpdate(s),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostUpdate)||void 0===i?void 0:i.call(t)})),this.update(s)):this._$Ek()}catch(t){throw i=!1,this._$Ek(),t}i&&this._$AE(s)}willUpdate(t){}_$AE(t){var i;null===(i=this._$ES)||void 0===i||i.forEach((t=>{var i;return null===(i=t.hostUpdated)||void 0===i?void 0:i.call(t)})),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t)}_$Ek(){this._$AL=new Map,this.isUpdatePending=!1}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$E_}shouldUpdate(t){return!0}update(t){void 0!==this._$EC&&(this._$EC.forEach(((t,i)=>this._$EO(i,this[i],t))),this._$EC=void 0),this._$Ek()}updated(t){}firstUpdated(t){}}d.finalized=!0,d.elementProperties=new Map,d.elementStyles=[],d.shadowRootOptions={mode:"open"},null==o||o({ReactiveElement:d}),(null!==(s=e.reactiveElementVersions)&&void 0!==s?s:e.reactiveElementVersions=[]).push("1.4.0");
//# sourceMappingURL=reactive-element.js.map


/***/ }),

/***/ 34:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LitElement": () => (/* binding */ s),
/* harmony export */   "css": () => (/* reexport safe */ _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.css),
/* harmony export */   "html": () => (/* reexport safe */ lit_html__WEBPACK_IMPORTED_MODULE_1__.html)
/* harmony export */ });
/* unused harmony exports UpdatingElement, _$LE */
/* harmony import */ var _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var l,o;const r=_lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.ReactiveElement;class s extends _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.ReactiveElement{constructor(){super(...arguments),this.renderOptions={host:this},this._$Do=void 0}createRenderRoot(){var t,e;const i=super.createRenderRoot();return null!==(t=(e=this.renderOptions).renderBefore)&&void 0!==t||(e.renderBefore=i.firstChild),i}update(t){const i=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this._$Do=(0,lit_html__WEBPACK_IMPORTED_MODULE_1__.render)(i,this.renderRoot,this.renderOptions)}connectedCallback(){var t;super.connectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!0)}disconnectedCallback(){var t;super.disconnectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!1)}render(){return lit_html__WEBPACK_IMPORTED_MODULE_1__.noChange}}s.finalized=!0,s._$litElement$=!0,null===(l=globalThis.litElementHydrateSupport)||void 0===l||l.call(globalThis,{LitElement:s});const n=globalThis.litElementPolyfillSupport;null==n||n({LitElement:s});const h={_$AK:(t,e,i)=>{t._$AK(e,i)},_$AL:t=>t._$AL};(null!==(o=globalThis.litElementVersions)&&void 0!==o?o:globalThis.litElementVersions=[]).push("3.2.2");
//# sourceMappingURL=lit-element.js.map


/***/ }),

/***/ 379:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Directive": () => (/* binding */ i),
/* harmony export */   "PartType": () => (/* binding */ t),
/* harmony export */   "directive": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t={ATTRIBUTE:1,CHILD:2,PROPERTY:3,BOOLEAN_ATTRIBUTE:4,EVENT:5,ELEMENT:6},e=t=>(...e)=>({_$litDirective$:t,values:e});class i{constructor(t){}get _$AU(){return this._$AM._$AU}_$AT(t,e,i){this._$Ct=t,this._$AM=e,this._$Ci=i}_$AS(t,e){return this.update(t,e)}update(t,e){return this.render(...e)}}
//# sourceMappingURL=directive.js.map


/***/ }),

/***/ 378:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "classMap": () => (/* binding */ o)
/* harmony export */ });
/* harmony import */ var _lit_html_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var _directive_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(379);

/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o=(0,_directive_js__WEBPACK_IMPORTED_MODULE_1__.directive)(class extends _directive_js__WEBPACK_IMPORTED_MODULE_1__.Directive{constructor(t){var i;if(super(t),t.type!==_directive_js__WEBPACK_IMPORTED_MODULE_1__.PartType.ATTRIBUTE||"class"!==t.name||(null===(i=t.strings)||void 0===i?void 0:i.length)>2)throw Error("`classMap()` can only be used in the `class` attribute and must be the only part in the attribute.")}render(t){return" "+Object.keys(t).filter((i=>t[i])).join(" ")+" "}update(i,[s]){var r,o;if(void 0===this.nt){this.nt=new Set,void 0!==i.strings&&(this.st=new Set(i.strings.join(" ").split(/\s/).filter((t=>""!==t))));for(const t in s)s[t]&&!(null===(r=this.st)||void 0===r?void 0:r.has(t))&&this.nt.add(t);return this.render(s)}const e=i.element.classList;this.nt.forEach((t=>{t in s||(e.remove(t),this.nt.delete(t))}));for(const t in s){const i=!!s[t];i===this.nt.has(t)||(null===(o=this.st)||void 0===o?void 0:o.has(t))||(i?(e.add(t),this.nt.add(t)):(e.remove(t),this.nt.delete(t)))}return _lit_html_js__WEBPACK_IMPORTED_MODULE_0__.noChange}});
//# sourceMappingURL=class-map.js.map


/***/ }),

/***/ 33:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "html": () => (/* binding */ y),
/* harmony export */   "noChange": () => (/* binding */ x),
/* harmony export */   "render": () => (/* binding */ A)
/* harmony export */ });
/* unused harmony exports _$LH, nothing, svg */
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
var t;const i=window,s=i.trustedTypes,e=s?s.createPolicy("lit-html",{createHTML:t=>t}):void 0,o=`lit$${(Math.random()+"").slice(9)}$`,n="?"+o,l=`<${n}>`,h=document,r=(t="")=>h.createComment(t),d=t=>null===t||"object"!=typeof t&&"function"!=typeof t,u=Array.isArray,c=t=>u(t)||"function"==typeof(null==t?void 0:t[Symbol.iterator]),v=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,a=/-->/g,f=/>/g,_=RegExp(">|[ \t\n\f\r](?:([^\\s\"'>=/]+)([ \t\n\f\r]*=[ \t\n\f\r]*(?:[^ \t\n\f\r\"'`<>=]|(\"|')|))|$)","g"),m=/'/g,p=/"/g,$=/^(?:script|style|textarea|title)$/i,g=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),y=g(1),w=g(2),x=Symbol.for("lit-noChange"),b=Symbol.for("lit-nothing"),T=new WeakMap,A=(t,i,s)=>{var e,o;const n=null!==(e=null==s?void 0:s.renderBefore)&&void 0!==e?e:i;let l=n._$litPart$;if(void 0===l){const t=null!==(o=null==s?void 0:s.renderBefore)&&void 0!==o?o:null;n._$litPart$=l=new S(i.insertBefore(r(),t),t,void 0,null!=s?s:{})}return l._$AI(t),l},E=h.createTreeWalker(h,129,null,!1),C=(t,i)=>{const s=t.length-1,n=[];let h,r=2===i?"<svg>":"",d=v;for(let i=0;i<s;i++){const s=t[i];let e,u,c=-1,g=0;for(;g<s.length&&(d.lastIndex=g,u=d.exec(s),null!==u);)g=d.lastIndex,d===v?"!--"===u[1]?d=a:void 0!==u[1]?d=f:void 0!==u[2]?($.test(u[2])&&(h=RegExp("</"+u[2],"g")),d=_):void 0!==u[3]&&(d=_):d===_?">"===u[0]?(d=null!=h?h:v,c=-1):void 0===u[1]?c=-2:(c=d.lastIndex-u[2].length,e=u[1],d=void 0===u[3]?_:'"'===u[3]?p:m):d===p||d===m?d=_:d===a||d===f?d=v:(d=_,h=void 0);const y=d===_&&t[i+1].startsWith("/>")?" ":"";r+=d===v?s+l:c>=0?(n.push(e),s.slice(0,c)+"$lit$"+s.slice(c)+o+y):s+o+(-2===c?(n.push(void 0),i):y)}const u=r+(t[s]||"<?>")+(2===i?"</svg>":"");if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return[void 0!==e?e.createHTML(u):u,n]};class P{constructor({strings:t,_$litType$:i},e){let l;this.parts=[];let h=0,d=0;const u=t.length-1,c=this.parts,[v,a]=C(t,i);if(this.el=P.createElement(v,e),E.currentNode=this.el.content,2===i){const t=this.el.content,i=t.firstChild;i.remove(),t.append(...i.childNodes)}for(;null!==(l=E.nextNode())&&c.length<u;){if(1===l.nodeType){if(l.hasAttributes()){const t=[];for(const i of l.getAttributeNames())if(i.endsWith("$lit$")||i.startsWith(o)){const s=a[d++];if(t.push(i),void 0!==s){const t=l.getAttribute(s.toLowerCase()+"$lit$").split(o),i=/([.?@])?(.*)/.exec(s);c.push({type:1,index:h,name:i[2],strings:t,ctor:"."===i[1]?R:"?"===i[1]?H:"@"===i[1]?I:M})}else c.push({type:6,index:h})}for(const i of t)l.removeAttribute(i)}if($.test(l.tagName)){const t=l.textContent.split(o),i=t.length-1;if(i>0){l.textContent=s?s.emptyScript:"";for(let s=0;s<i;s++)l.append(t[s],r()),E.nextNode(),c.push({type:2,index:++h});l.append(t[i],r())}}}else if(8===l.nodeType)if(l.data===n)c.push({type:2,index:h});else{let t=-1;for(;-1!==(t=l.data.indexOf(o,t+1));)c.push({type:7,index:h}),t+=o.length-1}h++}}static createElement(t,i){const s=h.createElement("template");return s.innerHTML=t,s}}function V(t,i,s=t,e){var o,n,l,h;if(i===x)return i;let r=void 0!==e?null===(o=s._$Cl)||void 0===o?void 0:o[e]:s._$Cu;const u=d(i)?void 0:i._$litDirective$;return(null==r?void 0:r.constructor)!==u&&(null===(n=null==r?void 0:r._$AO)||void 0===n||n.call(r,!1),void 0===u?r=void 0:(r=new u(t),r._$AT(t,s,e)),void 0!==e?(null!==(l=(h=s)._$Cl)&&void 0!==l?l:h._$Cl=[])[e]=r:s._$Cu=r),void 0!==r&&(i=V(t,r._$AS(t,i.values),r,e)),i}class N{constructor(t,i){this.v=[],this._$AN=void 0,this._$AD=t,this._$AM=i}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}p(t){var i;const{el:{content:s},parts:e}=this._$AD,o=(null!==(i=null==t?void 0:t.creationScope)&&void 0!==i?i:h).importNode(s,!0);E.currentNode=o;let n=E.nextNode(),l=0,r=0,d=e[0];for(;void 0!==d;){if(l===d.index){let i;2===d.type?i=new S(n,n.nextSibling,this,t):1===d.type?i=new d.ctor(n,d.name,d.strings,this,t):6===d.type&&(i=new L(n,this,t)),this.v.push(i),d=e[++r]}l!==(null==d?void 0:d.index)&&(n=E.nextNode(),l++)}return o}m(t){let i=0;for(const s of this.v)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++}}class S{constructor(t,i,s,e){var o;this.type=2,this._$AH=b,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$C_=null===(o=null==e?void 0:e.isConnected)||void 0===o||o}get _$AU(){var t,i;return null!==(i=null===(t=this._$AM)||void 0===t?void 0:t._$AU)&&void 0!==i?i:this._$C_}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===t.nodeType&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=V(this,t,i),d(t)?t===b||null==t||""===t?(this._$AH!==b&&this._$AR(),this._$AH=b):t!==this._$AH&&t!==x&&this.$(t):void 0!==t._$litType$?this.T(t):void 0!==t.nodeType?this.k(t):c(t)?this.O(t):this.$(t)}S(t,i=this._$AB){return this._$AA.parentNode.insertBefore(t,i)}k(t){this._$AH!==t&&(this._$AR(),this._$AH=this.S(t))}$(t){this._$AH!==b&&d(this._$AH)?this._$AA.nextSibling.data=t:this.k(h.createTextNode(t)),this._$AH=t}T(t){var i;const{values:s,_$litType$:e}=t,o="number"==typeof e?this._$AC(t):(void 0===e.el&&(e.el=P.createElement(e.h,this.options)),e);if((null===(i=this._$AH)||void 0===i?void 0:i._$AD)===o)this._$AH.m(s);else{const t=new N(o,this),i=t.p(this.options);t.m(s),this.k(i),this._$AH=t}}_$AC(t){let i=T.get(t.strings);return void 0===i&&T.set(t.strings,i=new P(t)),i}O(t){u(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const o of t)e===i.length?i.push(s=new S(this.S(r()),this.S(r()),this,this.options)):s=i[e],s._$AI(o),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e)}_$AR(t=this._$AA.nextSibling,i){var s;for(null===(s=this._$AP)||void 0===s||s.call(this,!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i}}setConnected(t){var i;void 0===this._$AM&&(this._$C_=t,null===(i=this._$AP)||void 0===i||i.call(this,t))}}class M{constructor(t,i,s,e,o){this.type=1,this._$AH=b,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=o,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=b}get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}_$AI(t,i=this,s,e){const o=this.strings;let n=!1;if(void 0===o)t=V(this,t,i,0),n=!d(t)||t!==this._$AH&&t!==x,n&&(this._$AH=t);else{const e=t;let l,h;for(t=o[0],l=0;l<o.length-1;l++)h=V(this,e[s+l],i,l),h===x&&(h=this._$AH[l]),n||(n=!d(h)||h!==this._$AH[l]),h===b?t=b:t!==b&&(t+=(null!=h?h:"")+o[l+1]),this._$AH[l]=h}n&&!e&&this.P(t)}P(t){t===b?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,null!=t?t:"")}}class R extends M{constructor(){super(...arguments),this.type=3}P(t){this.element[this.name]=t===b?void 0:t}}const k=s?s.emptyScript:"";class H extends M{constructor(){super(...arguments),this.type=4}P(t){t&&t!==b?this.element.setAttribute(this.name,k):this.element.removeAttribute(this.name)}}class I extends M{constructor(t,i,s,e,o){super(t,i,s,e,o),this.type=5}_$AI(t,i=this){var s;if((t=null!==(s=V(this,t,i,0))&&void 0!==s?s:b)===x)return;const e=this._$AH,o=t===b&&e!==b||t.capture!==e.capture||t.once!==e.once||t.passive!==e.passive,n=t!==b&&(e===b||o);o&&this.element.removeEventListener(this.name,this,e),n&&this.element.addEventListener(this.name,this,t),this._$AH=t}handleEvent(t){var i,s;"function"==typeof this._$AH?this._$AH.call(null!==(s=null===(i=this.options)||void 0===i?void 0:i.host)&&void 0!==s?s:this.element,t):this._$AH.handleEvent(t)}}class L{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s}get _$AU(){return this._$AM._$AU}_$AI(t){V(this,t)}}const z={A:"$lit$",M:o,C:n,L:1,R:C,D:N,V:c,I:V,H:S,N:M,U:H,B:I,F:R,W:L},Z=i.litHtmlPolyfillSupport;null==Z||Z(P,S),(null!==(t=i.litHtmlVersions)&&void 0!==t?t:i.litHtmlVersions=[]).push("2.3.1");
//# sourceMappingURL=lit-html.js.map


/***/ }),

/***/ 17:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "customElement": () => (/* reexport safe */ _lit_reactive_element_decorators_custom_element_js__WEBPACK_IMPORTED_MODULE_0__.customElement),
/* harmony export */   "property": () => (/* reexport safe */ _lit_reactive_element_decorators_property_js__WEBPACK_IMPORTED_MODULE_1__.property),
/* harmony export */   "state": () => (/* reexport safe */ _lit_reactive_element_decorators_state_js__WEBPACK_IMPORTED_MODULE_2__.state)
/* harmony export */ });
/* harmony import */ var _lit_reactive_element_decorators_custom_element_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _lit_reactive_element_decorators_property_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _lit_reactive_element_decorators_state_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _lit_reactive_element_decorators_event_options_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _lit_reactive_element_decorators_query_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23);
/* harmony import */ var _lit_reactive_element_decorators_query_all_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _lit_reactive_element_decorators_query_async_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(25);
/* harmony import */ var _lit_reactive_element_decorators_query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(26);
/* harmony import */ var _lit_reactive_element_decorators_query_assigned_nodes_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27);

//# sourceMappingURL=decorators.js.map


/***/ }),

/***/ 30:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LitElement": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.LitElement),
/* harmony export */   "css": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.css),
/* harmony export */   "html": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.html)
/* harmony export */ });
/* harmony import */ var _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/* harmony import */ var lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);

//# sourceMappingURL=index.js.map


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _components_trade_offers_better_tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(402);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6);
/* harmony import */ var _bridge_handlers_ping_setup_extension__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(403);
/* harmony import */ var _bridge_handlers_ping_extension_status__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(414);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






(0,_utils__WEBPACK_IMPORTED_MODULE_0__.init)('src/lib/page_scripts/trade_offers.js', main);
function main() { }
if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)()) {
    const refresh = setInterval(() => {
        var _a, _b;
        const widget = document.getElementsByTagName('csfloat-better-tracking-widget');
        if (!widget || widget.length === 0) {
            return;
        }
        const btn = (_b = (_a = widget[0]) === null || _a === void 0 ? void 0 : _a.shadowRoot) === null || _b === void 0 ? void 0 : _b.getElementById('csfloat-enable-enhanced');
        if (!btn) {
            return;
        }
        btn.addEventListener('click', () => __awaiter(void 0, void 0, void 0, function* () {
            chrome.runtime.sendMessage({
                message: 'requestPermissions',
                permissions: ['alarms'],
                origins: ['*://*.steampowered.com/*'],
            }, (granted) => {
                var _a;
                if (granted) {
                    (_a = widget[0].parentElement) === null || _a === void 0 ? void 0 : _a.removeChild(widget[0]);
                    (0,_bridge_client__WEBPACK_IMPORTED_MODULE_3__.ClientSend)(_bridge_handlers_ping_setup_extension__WEBPACK_IMPORTED_MODULE_4__.PingSetupExtension, {});
                    (0,_bridge_client__WEBPACK_IMPORTED_MODULE_3__.ClientSend)(_bridge_handlers_ping_extension_status__WEBPACK_IMPORTED_MODULE_5__.PingExtensionStatus, {});
                }
                else {
                    alert('Failed to obtain permissions');
                }
            });
        }));
        clearInterval(refresh);
    }, 500);
}

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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