/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 6:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClientSend": () => (/* binding */ ClientSend)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function canUseSendMessage() {
    // Not supported in Firefox Page Context
    return !((0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.isFirefox)() && (0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)());
}
/**
 * Send a request to be handled by the background worker
 *
 * Can be called from a content script or page itself
 */
function ClientSend(handler, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const bundle = {
            version: _types__WEBPACK_IMPORTED_MODULE_0__.Version.V1,
            request_type: handler.getType(),
            request: args,
            id: Math.ceil(Math.random() * 100000000000),
        };
        if (canUseSendMessage()) {
            return new Promise((resolve, reject) => {
                // @ts-ignore Bad types
                (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(window.CSFLOAT_EXTENSION_ID || chrome.runtime.id, bundle, 
                // @ts-ignore Bad types
                (resp) => {
                    if (resp === null || resp === void 0 ? void 0 : resp.response) {
                        resolve(resp.response);
                    }
                    else {
                        reject(resp === null || resp === void 0 ? void 0 : resp.error);
                    }
                });
            });
        }
        else {
            // Fallback to postmessage bus for browsers that don't implement
            // specs fully
            return _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__.g_PostMessageBus.sendRequest(bundle);
        }
    });
}


/***/ }),

/***/ 11:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteCssOnPage": () => (/* binding */ ExecuteCssOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteCssOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_CSS_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    yield chrome.scripting.insertCSS({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        files: [req.path],
    });
})));


/***/ }),

/***/ 2:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteScriptOnPage": () => (/* binding */ ExecuteScriptOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteScriptOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_SCRIPT_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    // We need to inject the extension ID dynamically so the client knows who to
    // communicate with.
    //
    // On Firefox, extension IDs are random, so this is necessary.
    yield chrome.scripting.executeScript({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        world: 'MAIN',
        args: [chrome.runtime.id],
        func: function ExtensionId(extensionId) {
            window.CSFLOAT_EXTENSION_ID = extensionId;
        },
    });
    yield chrome.scripting.executeScript({
        target: { tabId: (_b = sender.tab) === null || _b === void 0 ? void 0 : _b.id },
        files: [req.path],
        world: 'MAIN',
    });
})));


/***/ }),

/***/ 12:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchExtensionFile": () => (/* binding */ FetchExtensionFile)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchExtensionFile = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_EXTENSION_FILE, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const url = chrome.runtime.getURL(req.path);
    const r = yield fetch(url);
    const text = yield r.text();
    return {
        text,
    };
})));


/***/ }),

/***/ 3:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EmptyResponseHandler": () => (/* binding */ EmptyResponseHandler),
/* harmony export */   "SimpleHandler": () => (/* binding */ SimpleHandler)
/* harmony export */ });
/* unused harmony export EmptyRequestHandler */
class SimpleHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}
class EmptyRequestHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(sender);
    }
}
class EmptyResponseHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}


/***/ }),

/***/ 4:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RequestType": () => (/* binding */ RequestType)
/* harmony export */ });
var RequestType;
(function (RequestType) {
    RequestType[RequestType["EXECUTE_SCRIPT_ON_PAGE"] = 0] = "EXECUTE_SCRIPT_ON_PAGE";
    RequestType[RequestType["EXECUTE_CSS_ON_PAGE"] = 1] = "EXECUTE_CSS_ON_PAGE";
    RequestType[RequestType["FETCH_INSPECT_INFO"] = 2] = "FETCH_INSPECT_INFO";
    RequestType[RequestType["FETCH_STALL"] = 3] = "FETCH_STALL";
    RequestType[RequestType["STORAGE_GET"] = 4] = "STORAGE_GET";
    RequestType[RequestType["STORAGE_SET"] = 5] = "STORAGE_SET";
    RequestType[RequestType["STORAGE_REMOVE"] = 6] = "STORAGE_REMOVE";
    RequestType[RequestType["FETCH_PENDING_TRADES"] = 7] = "FETCH_PENDING_TRADES";
    RequestType[RequestType["FETCH_EXTENSION_FILE"] = 8] = "FETCH_EXTENSION_FILE";
    RequestType[RequestType["ANNOTATE_OFFER"] = 9] = "ANNOTATE_OFFER";
    RequestType[RequestType["EXTENSION_VERSION"] = 10] = "EXTENSION_VERSION";
    RequestType[RequestType["TRADE_HISTORY_STATUS"] = 11] = "TRADE_HISTORY_STATUS";
    RequestType[RequestType["TRADE_OFFER_STATUS"] = 12] = "TRADE_OFFER_STATUS";
    RequestType[RequestType["HAS_PERMISSIONS"] = 13] = "HAS_PERMISSIONS";
    RequestType[RequestType["PING_SETUP_EXTENSION"] = 14] = "PING_SETUP_EXTENSION";
    RequestType[RequestType["PING_EXTENSION_STATUS"] = 15] = "PING_EXTENSION_STATUS";
    RequestType[RequestType["PING_CANCEL_TRADE"] = 16] = "PING_CANCEL_TRADE";
    RequestType[RequestType["CREATE_TRADE_OFFER"] = 17] = "CREATE_TRADE_OFFER";
    RequestType[RequestType["FETCH_STEAM_USER"] = 18] = "FETCH_STEAM_USER";
    RequestType[RequestType["PING_TRADE_STATUS"] = 19] = "PING_TRADE_STATUS";
    RequestType[RequestType["PING_STATUS"] = 20] = "PING_STATUS";
    RequestType[RequestType["FETCH_OWN_INVENTORY"] = 21] = "FETCH_OWN_INVENTORY";
    RequestType[RequestType["CANCEL_TRADE_OFFER"] = 22] = "CANCEL_TRADE_OFFER";
})(RequestType || (RequestType = {}));


/***/ }),

/***/ 7:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Version": () => (/* binding */ Version)
/* harmony export */ });
var Version;
(function (Version) {
    Version["V1"] = "CSFLOAT_V1";
})(Version || (Version = {}));


/***/ }),

/***/ 5:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PrivilegedHandler": () => (/* binding */ PrivilegedHandler)
/* harmony export */ });
/**
 * Restricts a given handler such that it can only run if the sender is
 * verified to be from the extension's origin (ie. content script)
 */
class PrivilegedHandler {
    constructor(handler) {
        this.handler = handler;
    }
    getType() {
        return this.handler.getType();
    }
    handleRequest(request, sender) {
        if (sender.id !== chrome.runtime.id) {
            throw new Error('Attempt to access restricted method outside of secure context (ie. content script)');
        }
        return this.handler.handleRequest(request, sender);
    }
}


/***/ }),

/***/ 10:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g_PostMessageBus": () => (/* binding */ g_PostMessageBus)
/* harmony export */ });
/* harmony import */ var _bridge_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);


/**
 * Message bus that uses `postMessage` in order to communicate with the background
 * service worker/script.
 *
 * Why? Because the client page (ie. Steam page) on Firefox is not capable of
 * sending a message directly to the extension background.
 *
 * So it requires us to do the following dance:
 * page <--(postmessage)--> content script <--(sendmessage)--> background script
 *
 * This dance is abstracted in `ClientSend`, and only uses this bus if
 * `sendmessage` is not supported in the page.
 */
class PostMessageBus {
    /**
     * For the requester (ie. page), to wait until it gets a response
     * from the content script via. postMessage for the given request ID
     *
     * @param id Request ID
     */
    waitUntilResponseFor(id) {
        return new Promise((resolve, reject) => {
            const handler = (e) => {
                const resp = e.data;
                if (resp.id !== id || !resp.response) {
                    return;
                }
                // Prevent leaks
                window.removeEventListener('message', handler, false);
                if (resp === null || resp === void 0 ? void 0 : resp.response) {
                    resolve(resp.response);
                }
                else {
                    reject(resp === null || resp === void 0 ? void 0 : resp.error);
                }
            };
            window.addEventListener('message', handler);
        });
    }
    /**
     * Sends a request to be done through the bus, returns the appropriate
     * response for the input bundle handler
     *
     * @param bundle Request Bundle
     */
    sendRequest(bundle) {
        window.postMessage(bundle);
        return this.waitUntilResponseFor(bundle.id);
    }
    /**
     * Request handler (content script) for new requests from the page.
     *
     * Each request is effectively "proxied" to the background script/worker
     * to actually execute it's handler.
     */
    handleRequests() {
        const h = (e) => {
            if (e.data.version !== _bridge_types__WEBPACK_IMPORTED_MODULE_0__.Version.V1 || !e.data.request) {
                // Ignore messages that aren't for this bridge
                return;
            }
            // Send to the background script
            // @ts-ignore Bad types
            (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(chrome.runtime.id, e.data, 
            // @ts-ignore Bad types
            (resp) => {
                window.postMessage(resp);
            });
        };
        window.addEventListener('message', h);
    }
}
const g_PostMessageBus = new PostMessageBus();


/***/ }),

/***/ 377:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony export SteamButton */
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/* harmony import */ var lit_html_directives_class_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(378);
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17);
/* harmony import */ var _injectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16);
/* harmony import */ var _custom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





var ButtonType;
(function (ButtonType) {
    ButtonType["GreenWhite"] = "green_white";
    ButtonType["GreyWhite"] = "grey_white";
})(ButtonType || (ButtonType = {}));
let SteamButton = class SteamButton extends _custom__WEBPACK_IMPORTED_MODULE_4__.FloatElement {
    constructor() {
        super(...arguments);
        this.text = '';
        this.type = ButtonType.GreenWhite;
    }
    connectedCallback() {
        const _super = Object.create(null, {
            connectedCallback: { get: () => super.connectedCallback }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.connectedCallback.call(this);
        });
    }
    btnClass() {
        const r = { btn_small: true };
        r[`btn_${this.type}_innerfade`] = true;
        return (0,lit_html_directives_class_map_js__WEBPACK_IMPORTED_MODULE_1__.classMap)(r);
    }
    render() {
        return lit__WEBPACK_IMPORTED_MODULE_0__.html `
            <a class="${this.btnClass()}">
                <span>${this.text}</span>
            </a>
        `;
    }
};
SteamButton.styles = [
    ..._custom__WEBPACK_IMPORTED_MODULE_4__.FloatElement.styles,
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            .btn_green_white_innerfade {
                border-radius: 2px;
                border: none;
                padding: 1px;
                display: inline-block;
                cursor: pointer;
                text-decoration: none !important;
                color: #d2e885 !important;

                background: #a4d007;
                background: -webkit-linear-gradient(top, #a4d007 5%, #536904 95%);
                background: linear-gradient(to bottom, #a4d007 5%, #536904 95%);
            }

            .btn_green_white_innerfade > span {
                border-radius: 2px;
                display: block;

                background: #799905;
                background: -webkit-linear-gradient(top, #799905 5%, #536904 95%);
                background: linear-gradient(to bottom, #799905 5%, #536904 95%);
            }

            .btn_green_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover {
                text-decoration: none !important;
                color: #fff !important;

                background: #b6d908;
                background: -webkit-linear-gradient(top, #b6d908 5%, #80a006 95%);
                background: linear-gradient(to bottom, #b6d908 5%, #80a006 95%);
            }

            .btn_green_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover > span {
                background: #a1bf07;
                background: -webkit-linear-gradient(top, #a1bf07 5%, #80a006 95%);
                background: linear-gradient(to bottom, #a1bf07 5%, #80a006 95%);
            }

            .btn_grey_white_innerfade {
                border-radius: 2px;
                border: none;
                padding: 1px;
                display: inline-block;
                cursor: pointer;
                text-decoration: none !important;
                color: #fff !important;

                background: #acb5bd;
                background: -webkit-linear-gradient(top, #acb5bd 5%, #414a52 95%);
                background: linear-gradient(to bottom, #acb5bd 5%, #414a52 95%);
            }

            .btn_grey_white_innerfade > span {
                border-radius: 2px;
                display: block;

                background: #778088;
                background: -webkit-linear-gradient(top, #778088 5%, #414a52 95%);
                background: linear-gradient(to bottom, #778088 5%, #414a52 95%);
            }

            .btn_grey_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover {
                text-decoration: none !important;
                color: #fff !important;

                background: #cfd8e0;
                background: -webkit-linear-gradient(top, #cfd8e0 5%, #565f67 95%);
                background: linear-gradient(to bottom, #cfd8e0 5%, #565f67 95%);
            }

            .btn_grey_white_innerfade:not(.btn_disabled):not(:disabled):not(.btn_active):not(.active):hover > span {
                background: #99a2aa;
                background: -webkit-linear-gradient(top, #99a2aa 5%, #565f67 95%);
                background: linear-gradient(to bottom, #99a2aa 5%, #565f67 95%);
            }

            .btn_small > span {
                padding: 0 15px;
                font-size: 12px;
                line-height: 20px;
            }
        `,
];
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__.property)({ type: String })
], SteamButton.prototype, "text", void 0);
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__.property)({ type: String })
], SteamButton.prototype, "type", void 0);
SteamButton = __decorate([
    (0,_injectors__WEBPACK_IMPORTED_MODULE_3__.CustomElement)()
], SteamButton);



/***/ }),

/***/ 29:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FloatElement": () => (/* binding */ FloatElement)
/* harmony export */ });
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);

function camelToDashCase(str) {
    return str
        .split(/(?=[A-Z])/)
        .join('-')
        .toLowerCase();
}
// LitElement wrapper with a pre-determined tag
class FloatElement extends lit__WEBPACK_IMPORTED_MODULE_0__.LitElement {
    static tag() {
        return `csfloat-${camelToDashCase(this.name)}`;
    }
    static elem() {
        return document.createElement(this.tag());
    }
}
FloatElement.styles = [
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            hr {
                background-color: #1b2939;
                border-style: solid none none;
                border-color: black;
                border-width: 1px 0 0;
                height: 2px;
            }

            a {
                color: #ebebeb;
                cursor: pointer;
            }

            input[type='text'],
            input[type='password'],
            input[type='number'],
            select {
                color: #909090;
                background-color: rgba(0, 0, 0, 0.2);
                border: 1px solid #000;
                border-radius: 3px;
            }

            input[type='color'] {
                float: left;
                margin-top: 2px;
                -webkit-appearance: none;
                border: none;
                width: 20px;
                height: 20px;
                padding: 0;
            }

            input[type='color']::-webkit-color-swatch-wrapper {
                padding: 0;
            }

            input[type='color']::-webkit-color-swatch {
                border: none;
            }
        `,
];


/***/ }),

/***/ 16:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CustomElement": () => (/* binding */ CustomElement),
/* harmony export */   "InjectAfter": () => (/* binding */ InjectAfter),
/* harmony export */   "InjectionMode": () => (/* binding */ InjectionMode)
/* harmony export */ });
/* unused harmony exports InjectAppend, InjectBefore */
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9);


var InjectionMode;
(function (InjectionMode) {
    // Injects once at page load for elements matching the selector
    InjectionMode[InjectionMode["ONCE"] = 0] = "ONCE";
    // Continually injects whenever new elements that match the
    // selector exist that haven't been injected into yet
    //
    // Should be use for "dynamic" elements
    InjectionMode[InjectionMode["CONTINUOUS"] = 1] = "CONTINUOUS";
})(InjectionMode || (InjectionMode = {}));
var InjectionType;
(function (InjectionType) {
    InjectionType[InjectionType["Append"] = 0] = "Append";
    InjectionType[InjectionType["Before"] = 1] = "Before";
    InjectionType[InjectionType["After"] = 2] = "After";
})(InjectionType || (InjectionType = {}));
const InjectionConfigs = {
    [InjectionType.Append]: {
        exists: (ctx, selector) => !!ctx.children(selector).length,
        op: (ctx, target) => ctx.append(target.elem()),
    },
    [InjectionType.Before]: {
        exists: (ctx, selector) => !!ctx.parent().children(selector).length,
        op: (ctx, target) => ctx.before(target.elem()),
    },
    [InjectionType.After]: {
        exists: (ctx, selector) => !!ctx.parent().children(selector).length,
        op: (ctx, target) => ctx.after(target.elem()),
    },
};
function CustomElement() {
    return function (target, propertyKey, descriptor) {
        if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_1__.inPageContext)()) {
            return;
        }
        if (customElements.get(target.tag())) {
            // Already defined
            return;
        }
        (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_0__.customElement)(target.tag())(target);
    };
}
function Inject(selector, mode, type) {
    return function (target, propertyKey, descriptor) {
        if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_1__.inPageContext)()) {
            return;
        }
        switch (mode) {
            case InjectionMode.ONCE:
                $J(selector).each(function () {
                    InjectionConfigs[type].op($J(this), target);
                });
                break;
            case InjectionMode.CONTINUOUS:
                setInterval(() => {
                    $J(selector).each(function () {
                        // Don't add the item again if we already have
                        if (InjectionConfigs[type].exists($J(this), target.tag()))
                            return;
                        InjectionConfigs[type].op($J(this), target);
                    });
                }, 250);
                break;
        }
    };
}
function InjectAppend(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.Append);
}
function InjectBefore(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.Before);
}
function InjectAfter(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.After);
}


/***/ }),

/***/ 389:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony export CommentWarning */
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);
/* harmony import */ var _injectors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _custom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29);
/* harmony import */ var _common_ui_steam_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(377);
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(17);
/* harmony import */ var _utils_observers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(49);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






let CommentWarning = class CommentWarning extends _custom__WEBPACK_IMPORTED_MODULE_2__.FloatElement {
    constructor() {
        super(...arguments);
        this.show = false;
    }
    getRawCommentBoxText() {
        const elems = document.getElementsByClassName('commentthread_textarea');
        if (elems.length === 0) {
            return '';
        }
        const elem = elems[0];
        return elem.value || '';
    }
    connectedCallback() {
        const _super = Object.create(null, {
            connectedCallback: { get: () => super.connectedCallback }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.connectedCallback.call(this);
            (0,_utils_observers__WEBPACK_IMPORTED_MODULE_5__.Observe)(() => {
                return this.getRawCommentBoxText();
            }, () => {
                this.refreshWarningApplicable();
            });
        });
    }
    refreshWarningApplicable() {
        const text = this.getRawCommentBoxText();
        const words = new Set(text.toLowerCase().split(' '));
        const hasTriggerWord = ['buy', 'sell', 'bought', 'sold', 'csfloat'].some((e) => words.has(e));
        this.show = hasTriggerWord;
    }
    render() {
        if (!this.show) {
            return lit__WEBPACK_IMPORTED_MODULE_0__.html ``;
        }
        return lit__WEBPACK_IMPORTED_MODULE_0__.html `<div class="container">
            <b>WARNING:</b> Commenting on profiles with words relating to buying and selling CS2 items
            <b>WILL</b> result in a Steam community ban!
        </div>`;
    }
};
CommentWarning.styles = [
    ..._custom__WEBPACK_IMPORTED_MODULE_2__.FloatElement.styles,
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            .container {
                background-color: rgba(235, 87, 87, 0.05);
                color: #de6667;
                border-radius: 6px;
                padding: 8px;
                margin: 5px;
                font-size: 14px;
            }
        `,
];
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_4__.state)()
], CommentWarning.prototype, "show", void 0);
CommentWarning = __decorate([
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.CustomElement)(),
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.InjectAfter)('.commentthread_area .commentthread_header', _injectors__WEBPACK_IMPORTED_MODULE_1__.InjectionMode.ONCE)
], CommentWarning);



/***/ }),

/***/ 1:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "init": () => (/* binding */ init)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_execute_script__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bridge_handlers_execute_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function initiateChromium(scriptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_execute_css__WEBPACK_IMPORTED_MODULE_3__.ExecuteCssOnPage, {
            path: 'src/global.css',
        });
        (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_execute_script__WEBPACK_IMPORTED_MODULE_0__.ExecuteScriptOnPage, {
            path: scriptPath,
        });
    });
}
function initiateFirefox(scriptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_6__.g_PostMessageBus.handleRequests();
        // Why do we need to use manual DOM script injection and
        // fetch the text of the script?
        // See https://github.com/csfloat/extension/issues/155#issuecomment-1639781914
        // We want to inject the ID of the extension
        const id = browser.runtime.id;
        const entryScript = document.createElement('script');
        entryScript.appendChild(document.createTextNode(`
        window.CSFLOAT_EXTENSION_ID = '${id}';
    `));
        document.head.appendChild(entryScript);
        const scriptResp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__.FetchExtensionFile, {
            path: scriptPath,
        });
        const script = document.createElement('script');
        script.appendChild(document.createTextNode(scriptResp.text));
        document.head.appendChild(script);
        const styleResp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__.FetchExtensionFile, {
            path: 'src/global.css',
        });
        const style = document.createElement('style');
        style.appendChild(document.createTextNode(styleResp.text));
        document.head.appendChild(style);
    });
}
/**
 * Initializes a page script, executing it in the page context if necessary
 *
 * @param scriptPath Relative path of the script (always in .js)
 * @param ifPage Fn to run if we are in the page's execution context
 */
function init(scriptPath, ifPage) {
    return __awaiter(this, void 0, void 0, function* () {
        // Don't allow the page script to run this.
        if ((0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)()) {
            // @ts-ignore Set global identifier for other extensions to use
            window.csfloat = true;
            // @ts-ignore Deprecated name
            window.csgofloat = true;
            ifPage();
            return;
        }
        if ((0,_utils_detect__WEBPACK_IMPORTED_MODULE_5__.isFirefox)()) {
            yield initiateFirefox(scriptPath);
        }
        else {
            yield initiateChromium(scriptPath);
        }
        console.log(`%c CSFloat Market Checker (v${chrome.runtime.getManifest().version}) by Step7750 `, 'background: #004594; color: #fff;');
        console.log('%c Changelog can be found here: https://github.com/csfloat/extension ', 'background: #004594; color: #fff;');
    });
}


/***/ }),

/***/ 8:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isFirefox": () => (/* binding */ isFirefox),
/* harmony export */   "runtimeNamespace": () => (/* binding */ runtimeNamespace)
/* harmony export */ });
function isFirefox() {
    return navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
}
/**
 * Thanks to our browser overlords, we have two namespaces for `x.runtime.fn()`
 */
function runtimeNamespace() {
    if (isFirefox()) {
        return browser;
    }
    else {
        return chrome;
    }
}


/***/ }),

/***/ 49:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Observe": () => (/* binding */ Observe)
/* harmony export */ });
function Observe(computeObject, cb, pollRateMs = 50) {
    let prev = computeObject();
    setInterval(() => {
        const now = computeObject();
        if (prev !== now) {
            cb();
        }
        prev = now;
    }, pollRateMs);
}


/***/ }),

/***/ 9:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "inPageContext": () => (/* binding */ inPageContext)
/* harmony export */ });
function inPageContext() {
    return typeof chrome === 'undefined' || !chrome.extension;
}


/***/ }),

/***/ 32:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "adoptStyles": () => (/* binding */ S),
/* harmony export */   "css": () => (/* binding */ i),
/* harmony export */   "getCompatibleStyle": () => (/* binding */ c)
/* harmony export */ });
/* unused harmony exports CSSResult, supportsAdoptingStyleSheets, unsafeCSS */
/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t=window,e=t.ShadowRoot&&(void 0===t.ShadyCSS||t.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s=Symbol(),n=new WeakMap;class o{constructor(t,e,n){if(this._$cssResult$=!0,n!==s)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e}get styleSheet(){let t=this.o;const s=this.t;if(e&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=n.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&n.set(s,t))}return t}toString(){return this.cssText}}const r=t=>new o("string"==typeof t?t:t+"",void 0,s),i=(t,...e)=>{const n=1===t.length?t[0]:e.reduce(((e,s,n)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[n+1]),t[0]);return new o(n,t,s)},S=(s,n)=>{e?s.adoptedStyleSheets=n.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet)):n.forEach((e=>{const n=document.createElement("style"),o=t.litNonce;void 0!==o&&n.setAttribute("nonce",o),n.textContent=e.cssText,s.appendChild(n)}))},c=e?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r(e)})(t):t;
//# sourceMappingURL=css-tag.js.map


/***/ }),

/***/ 22:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "decorateProperty": () => (/* binding */ o)
/* harmony export */ });
/* unused harmony exports legacyPrototypeMethod, standardPrototypeMethod */
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e=(e,t,o)=>{Object.defineProperty(t,o,e)},t=(e,t)=>({kind:"method",placement:"prototype",key:t.key,descriptor:e}),o=({finisher:e,descriptor:t})=>(o,n)=>{var r;if(void 0===n){const n=null!==(r=o.originalKey)&&void 0!==r?r:o.key,i=null!=t?{kind:"method",placement:"prototype",key:n,descriptor:t(o.key)}:{...o,key:n};return null!=e&&(i.finisher=function(t){e(t,n)}),i}{const r=o.constructor;void 0!==t&&Object.defineProperty(o,n,t(n)),null==e||e(r,n)}};
//# sourceMappingURL=base.js.map


/***/ }),

/***/ 18:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "customElement": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e=e=>n=>"function"==typeof n?((e,n)=>(customElements.define(e,n),n))(e,n):((e,n)=>{const{kind:t,elements:s}=n;return{kind:t,elements:s,finisher(n){customElements.define(e,n)}}})(e,n);
//# sourceMappingURL=custom-element.js.map


/***/ }),

/***/ 21:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export eventOptions */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({finisher:(r,t)=>{Object.assign(r.prototype[t],e)}})}
//# sourceMappingURL=event-options.js.map


/***/ }),

/***/ 19:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "property": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const i=(i,e)=>"method"===e.kind&&e.descriptor&&!("value"in e.descriptor)?{...e,finisher(n){n.createProperty(e.key,i)}}:{kind:"field",key:Symbol(),placement:"own",descriptor:{},originalKey:e.key,initializer(){"function"==typeof e.initializer&&(this[e.key]=e.initializer.call(this))},finisher(n){n.createProperty(e.key,i)}};function e(e){return(n,t)=>void 0!==t?((i,e,n)=>{e.constructor.createProperty(n,i)})(e,n,t):i(e,n)}
//# sourceMappingURL=property.js.map


/***/ }),

/***/ 24:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAll */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:r=>({get(){var r,o;return null!==(o=null===(r=this.renderRoot)||void 0===r?void 0:r.querySelectorAll(e))&&void 0!==o?o:[]},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-all.js.map


/***/ }),

/***/ 26:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "queryAssignedElements": () => (/* binding */ l)
/* harmony export */ });
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var n;const e=null!=(null===(n=window.HTMLSlotElement)||void 0===n?void 0:n.prototype.assignedElements)?(o,n)=>o.assignedElements(n):(o,n)=>o.assignedNodes(n).filter((o=>o.nodeType===Node.ELEMENT_NODE));function l(n){const{slot:l,selector:t}=null!=n?n:{};return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:o=>({get(){var o;const r="slot"+(l?`[name=${l}]`:":not([name])"),i=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(r),s=null!=i?e(i,n):[];return t?s.filter((o=>o.matches(t))):s},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-assigned-elements.js.map


/***/ }),

/***/ 27:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAssignedNodes */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);
/* harmony import */ var _query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function o(o,n,r){let l,s=o;return"object"==typeof o?(s=o.slot,l=o):l={flatten:n},r?(0,_query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_1__.queryAssignedElements)({slot:s,flatten:n,selector:r}):(0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:e=>({get(){var e,t;const o="slot"+(s?`[name=${s}]`:":not([name])"),n=null===(e=this.renderRoot)||void 0===e?void 0:e.querySelector(o);return null!==(t=null==n?void 0:n.assignedNodes(l))&&void 0!==t?t:[]},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-assigned-nodes.js.map


/***/ }),

/***/ 25:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAsync */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:r=>({async get(){var r;return await this.updateComplete,null===(r=this.renderRoot)||void 0===r?void 0:r.querySelector(e)},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-async.js.map


/***/ }),

/***/ 23:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export query */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function i(i,n){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:o=>{const t={get(){var o,n;return null!==(n=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(i))&&void 0!==n?n:null},enumerable:!0,configurable:!0};if(n){const n="symbol"==typeof o?Symbol():"__"+o;t.get=function(){var o,t;return void 0===this[n]&&(this[n]=null!==(t=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(i))&&void 0!==t?t:null),this[n]}}return t}})}
//# sourceMappingURL=query.js.map


/***/ }),

/***/ 20:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "state": () => (/* binding */ t)
/* harmony export */ });
/* harmony import */ var _property_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function t(t){return (0,_property_js__WEBPACK_IMPORTED_MODULE_0__.property)({...t,state:!0})}
//# sourceMappingURL=state.js.map


/***/ }),

/***/ 31:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReactiveElement": () => (/* binding */ d),
/* harmony export */   "css": () => (/* reexport safe */ _css_tag_js__WEBPACK_IMPORTED_MODULE_0__.css)
/* harmony export */ });
/* unused harmony exports defaultConverter, notEqual */
/* harmony import */ var _css_tag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var s;const e=window,r=e.trustedTypes,h=r?r.emptyScript:"",o=e.reactiveElementPolyfillSupport,n={toAttribute(t,i){switch(i){case Boolean:t=t?h:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t)}return t},fromAttribute(t,i){let s=t;switch(i){case Boolean:s=null!==t;break;case Number:s=null===t?null:Number(t);break;case Object:case Array:try{s=JSON.parse(t)}catch(t){s=null}}return s}},a=(t,i)=>i!==t&&(i==i||t==t),l={attribute:!0,type:String,converter:n,reflect:!1,hasChanged:a};class d extends HTMLElement{constructor(){super(),this._$Ei=new Map,this.isUpdatePending=!1,this.hasUpdated=!1,this._$El=null,this.u()}static addInitializer(t){var i;null!==(i=this.h)&&void 0!==i||(this.h=[]),this.h.push(t)}static get observedAttributes(){this.finalize();const t=[];return this.elementProperties.forEach(((i,s)=>{const e=this._$Ep(s,i);void 0!==e&&(this._$Ev.set(e,s),t.push(e))})),t}static createProperty(t,i=l){if(i.state&&(i.attribute=!1),this.finalize(),this.elementProperties.set(t,i),!i.noAccessor&&!this.prototype.hasOwnProperty(t)){const s="symbol"==typeof t?Symbol():"__"+t,e=this.getPropertyDescriptor(t,s,i);void 0!==e&&Object.defineProperty(this.prototype,t,e)}}static getPropertyDescriptor(t,i,s){return{get(){return this[i]},set(e){const r=this[t];this[i]=e,this.requestUpdate(t,r,s)},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)||l}static finalize(){if(this.hasOwnProperty("finalized"))return!1;this.finalized=!0;const t=Object.getPrototypeOf(this);if(t.finalize(),this.elementProperties=new Map(t.elementProperties),this._$Ev=new Map,this.hasOwnProperty("properties")){const t=this.properties,i=[...Object.getOwnPropertyNames(t),...Object.getOwnPropertySymbols(t)];for(const s of i)this.createProperty(s,t[s])}return this.elementStyles=this.finalizeStyles(this.styles),!0}static finalizeStyles(i){const s=[];if(Array.isArray(i)){const e=new Set(i.flat(1/0).reverse());for(const i of e)s.unshift((0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.getCompatibleStyle)(i))}else void 0!==i&&s.push((0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.getCompatibleStyle)(i));return s}static _$Ep(t,i){const s=i.attribute;return!1===s?void 0:"string"==typeof s?s:"string"==typeof t?t.toLowerCase():void 0}u(){var t;this._$E_=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$Eg(),this.requestUpdate(),null===(t=this.constructor.h)||void 0===t||t.forEach((t=>t(this)))}addController(t){var i,s;(null!==(i=this._$ES)&&void 0!==i?i:this._$ES=[]).push(t),void 0!==this.renderRoot&&this.isConnected&&(null===(s=t.hostConnected)||void 0===s||s.call(t))}removeController(t){var i;null===(i=this._$ES)||void 0===i||i.splice(this._$ES.indexOf(t)>>>0,1)}_$Eg(){this.constructor.elementProperties.forEach(((t,i)=>{this.hasOwnProperty(i)&&(this._$Ei.set(i,this[i]),delete this[i])}))}createRenderRoot(){var t;const s=null!==(t=this.shadowRoot)&&void 0!==t?t:this.attachShadow(this.constructor.shadowRootOptions);return (0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.adoptStyles)(s,this.constructor.elementStyles),s}connectedCallback(){var t;void 0===this.renderRoot&&(this.renderRoot=this.createRenderRoot()),this.enableUpdating(!0),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostConnected)||void 0===i?void 0:i.call(t)}))}enableUpdating(t){}disconnectedCallback(){var t;null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostDisconnected)||void 0===i?void 0:i.call(t)}))}attributeChangedCallback(t,i,s){this._$AK(t,s)}_$EO(t,i,s=l){var e;const r=this.constructor._$Ep(t,s);if(void 0!==r&&!0===s.reflect){const h=(void 0!==(null===(e=s.converter)||void 0===e?void 0:e.toAttribute)?s.converter:n).toAttribute(i,s.type);this._$El=t,null==h?this.removeAttribute(r):this.setAttribute(r,h),this._$El=null}}_$AK(t,i){var s;const e=this.constructor,r=e._$Ev.get(t);if(void 0!==r&&this._$El!==r){const t=e.getPropertyOptions(r),h="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==(null===(s=t.converter)||void 0===s?void 0:s.fromAttribute)?t.converter:n;this._$El=r,this[r]=h.fromAttribute(i,t.type),this._$El=null}}requestUpdate(t,i,s){let e=!0;void 0!==t&&(((s=s||this.constructor.getPropertyOptions(t)).hasChanged||a)(this[t],i)?(this._$AL.has(t)||this._$AL.set(t,i),!0===s.reflect&&this._$El!==t&&(void 0===this._$EC&&(this._$EC=new Map),this._$EC.set(t,s))):e=!1),!this.isUpdatePending&&e&&(this._$E_=this._$Ej())}async _$Ej(){this.isUpdatePending=!0;try{await this._$E_}catch(t){Promise.reject(t)}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){var t;if(!this.isUpdatePending)return;this.hasUpdated,this._$Ei&&(this._$Ei.forEach(((t,i)=>this[i]=t)),this._$Ei=void 0);let i=!1;const s=this._$AL;try{i=this.shouldUpdate(s),i?(this.willUpdate(s),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostUpdate)||void 0===i?void 0:i.call(t)})),this.update(s)):this._$Ek()}catch(t){throw i=!1,this._$Ek(),t}i&&this._$AE(s)}willUpdate(t){}_$AE(t){var i;null===(i=this._$ES)||void 0===i||i.forEach((t=>{var i;return null===(i=t.hostUpdated)||void 0===i?void 0:i.call(t)})),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t)}_$Ek(){this._$AL=new Map,this.isUpdatePending=!1}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$E_}shouldUpdate(t){return!0}update(t){void 0!==this._$EC&&(this._$EC.forEach(((t,i)=>this._$EO(i,this[i],t))),this._$EC=void 0),this._$Ek()}updated(t){}firstUpdated(t){}}d.finalized=!0,d.elementProperties=new Map,d.elementStyles=[],d.shadowRootOptions={mode:"open"},null==o||o({ReactiveElement:d}),(null!==(s=e.reactiveElementVersions)&&void 0!==s?s:e.reactiveElementVersions=[]).push("1.4.0");
//# sourceMappingURL=reactive-element.js.map


/***/ }),

/***/ 34:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LitElement": () => (/* binding */ s),
/* harmony export */   "css": () => (/* reexport safe */ _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.css),
/* harmony export */   "html": () => (/* reexport safe */ lit_html__WEBPACK_IMPORTED_MODULE_1__.html)
/* harmony export */ });
/* unused harmony exports UpdatingElement, _$LE */
/* harmony import */ var _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var l,o;const r=_lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.ReactiveElement;class s extends _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.ReactiveElement{constructor(){super(...arguments),this.renderOptions={host:this},this._$Do=void 0}createRenderRoot(){var t,e;const i=super.createRenderRoot();return null!==(t=(e=this.renderOptions).renderBefore)&&void 0!==t||(e.renderBefore=i.firstChild),i}update(t){const i=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this._$Do=(0,lit_html__WEBPACK_IMPORTED_MODULE_1__.render)(i,this.renderRoot,this.renderOptions)}connectedCallback(){var t;super.connectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!0)}disconnectedCallback(){var t;super.disconnectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!1)}render(){return lit_html__WEBPACK_IMPORTED_MODULE_1__.noChange}}s.finalized=!0,s._$litElement$=!0,null===(l=globalThis.litElementHydrateSupport)||void 0===l||l.call(globalThis,{LitElement:s});const n=globalThis.litElementPolyfillSupport;null==n||n({LitElement:s});const h={_$AK:(t,e,i)=>{t._$AK(e,i)},_$AL:t=>t._$AL};(null!==(o=globalThis.litElementVersions)&&void 0!==o?o:globalThis.litElementVersions=[]).push("3.2.2");
//# sourceMappingURL=lit-element.js.map


/***/ }),

/***/ 379:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Directive": () => (/* binding */ i),
/* harmony export */   "PartType": () => (/* binding */ t),
/* harmony export */   "directive": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t={ATTRIBUTE:1,CHILD:2,PROPERTY:3,BOOLEAN_ATTRIBUTE:4,EVENT:5,ELEMENT:6},e=t=>(...e)=>({_$litDirective$:t,values:e});class i{constructor(t){}get _$AU(){return this._$AM._$AU}_$AT(t,e,i){this._$Ct=t,this._$AM=e,this._$Ci=i}_$AS(t,e){return this.update(t,e)}update(t,e){return this.render(...e)}}
//# sourceMappingURL=directive.js.map


/***/ }),

/***/ 378:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "classMap": () => (/* binding */ o)
/* harmony export */ });
/* harmony import */ var _lit_html_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var _directive_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(379);

/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o=(0,_directive_js__WEBPACK_IMPORTED_MODULE_1__.directive)(class extends _directive_js__WEBPACK_IMPORTED_MODULE_1__.Directive{constructor(t){var i;if(super(t),t.type!==_directive_js__WEBPACK_IMPORTED_MODULE_1__.PartType.ATTRIBUTE||"class"!==t.name||(null===(i=t.strings)||void 0===i?void 0:i.length)>2)throw Error("`classMap()` can only be used in the `class` attribute and must be the only part in the attribute.")}render(t){return" "+Object.keys(t).filter((i=>t[i])).join(" ")+" "}update(i,[s]){var r,o;if(void 0===this.nt){this.nt=new Set,void 0!==i.strings&&(this.st=new Set(i.strings.join(" ").split(/\s/).filter((t=>""!==t))));for(const t in s)s[t]&&!(null===(r=this.st)||void 0===r?void 0:r.has(t))&&this.nt.add(t);return this.render(s)}const e=i.element.classList;this.nt.forEach((t=>{t in s||(e.remove(t),this.nt.delete(t))}));for(const t in s){const i=!!s[t];i===this.nt.has(t)||(null===(o=this.st)||void 0===o?void 0:o.has(t))||(i?(e.add(t),this.nt.add(t)):(e.remove(t),this.nt.delete(t)))}return _lit_html_js__WEBPACK_IMPORTED_MODULE_0__.noChange}});
//# sourceMappingURL=class-map.js.map


/***/ }),

/***/ 33:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "html": () => (/* binding */ y),
/* harmony export */   "noChange": () => (/* binding */ x),
/* harmony export */   "render": () => (/* binding */ A)
/* harmony export */ });
/* unused harmony exports _$LH, nothing, svg */
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
var t;const i=window,s=i.trustedTypes,e=s?s.createPolicy("lit-html",{createHTML:t=>t}):void 0,o=`lit$${(Math.random()+"").slice(9)}$`,n="?"+o,l=`<${n}>`,h=document,r=(t="")=>h.createComment(t),d=t=>null===t||"object"!=typeof t&&"function"!=typeof t,u=Array.isArray,c=t=>u(t)||"function"==typeof(null==t?void 0:t[Symbol.iterator]),v=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,a=/-->/g,f=/>/g,_=RegExp(">|[ \t\n\f\r](?:([^\\s\"'>=/]+)([ \t\n\f\r]*=[ \t\n\f\r]*(?:[^ \t\n\f\r\"'`<>=]|(\"|')|))|$)","g"),m=/'/g,p=/"/g,$=/^(?:script|style|textarea|title)$/i,g=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),y=g(1),w=g(2),x=Symbol.for("lit-noChange"),b=Symbol.for("lit-nothing"),T=new WeakMap,A=(t,i,s)=>{var e,o;const n=null!==(e=null==s?void 0:s.renderBefore)&&void 0!==e?e:i;let l=n._$litPart$;if(void 0===l){const t=null!==(o=null==s?void 0:s.renderBefore)&&void 0!==o?o:null;n._$litPart$=l=new S(i.insertBefore(r(),t),t,void 0,null!=s?s:{})}return l._$AI(t),l},E=h.createTreeWalker(h,129,null,!1),C=(t,i)=>{const s=t.length-1,n=[];let h,r=2===i?"<svg>":"",d=v;for(let i=0;i<s;i++){const s=t[i];let e,u,c=-1,g=0;for(;g<s.length&&(d.lastIndex=g,u=d.exec(s),null!==u);)g=d.lastIndex,d===v?"!--"===u[1]?d=a:void 0!==u[1]?d=f:void 0!==u[2]?($.test(u[2])&&(h=RegExp("</"+u[2],"g")),d=_):void 0!==u[3]&&(d=_):d===_?">"===u[0]?(d=null!=h?h:v,c=-1):void 0===u[1]?c=-2:(c=d.lastIndex-u[2].length,e=u[1],d=void 0===u[3]?_:'"'===u[3]?p:m):d===p||d===m?d=_:d===a||d===f?d=v:(d=_,h=void 0);const y=d===_&&t[i+1].startsWith("/>")?" ":"";r+=d===v?s+l:c>=0?(n.push(e),s.slice(0,c)+"$lit$"+s.slice(c)+o+y):s+o+(-2===c?(n.push(void 0),i):y)}const u=r+(t[s]||"<?>")+(2===i?"</svg>":"");if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return[void 0!==e?e.createHTML(u):u,n]};class P{constructor({strings:t,_$litType$:i},e){let l;this.parts=[];let h=0,d=0;const u=t.length-1,c=this.parts,[v,a]=C(t,i);if(this.el=P.createElement(v,e),E.currentNode=this.el.content,2===i){const t=this.el.content,i=t.firstChild;i.remove(),t.append(...i.childNodes)}for(;null!==(l=E.nextNode())&&c.length<u;){if(1===l.nodeType){if(l.hasAttributes()){const t=[];for(const i of l.getAttributeNames())if(i.endsWith("$lit$")||i.startsWith(o)){const s=a[d++];if(t.push(i),void 0!==s){const t=l.getAttribute(s.toLowerCase()+"$lit$").split(o),i=/([.?@])?(.*)/.exec(s);c.push({type:1,index:h,name:i[2],strings:t,ctor:"."===i[1]?R:"?"===i[1]?H:"@"===i[1]?I:M})}else c.push({type:6,index:h})}for(const i of t)l.removeAttribute(i)}if($.test(l.tagName)){const t=l.textContent.split(o),i=t.length-1;if(i>0){l.textContent=s?s.emptyScript:"";for(let s=0;s<i;s++)l.append(t[s],r()),E.nextNode(),c.push({type:2,index:++h});l.append(t[i],r())}}}else if(8===l.nodeType)if(l.data===n)c.push({type:2,index:h});else{let t=-1;for(;-1!==(t=l.data.indexOf(o,t+1));)c.push({type:7,index:h}),t+=o.length-1}h++}}static createElement(t,i){const s=h.createElement("template");return s.innerHTML=t,s}}function V(t,i,s=t,e){var o,n,l,h;if(i===x)return i;let r=void 0!==e?null===(o=s._$Cl)||void 0===o?void 0:o[e]:s._$Cu;const u=d(i)?void 0:i._$litDirective$;return(null==r?void 0:r.constructor)!==u&&(null===(n=null==r?void 0:r._$AO)||void 0===n||n.call(r,!1),void 0===u?r=void 0:(r=new u(t),r._$AT(t,s,e)),void 0!==e?(null!==(l=(h=s)._$Cl)&&void 0!==l?l:h._$Cl=[])[e]=r:s._$Cu=r),void 0!==r&&(i=V(t,r._$AS(t,i.values),r,e)),i}class N{constructor(t,i){this.v=[],this._$AN=void 0,this._$AD=t,this._$AM=i}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}p(t){var i;const{el:{content:s},parts:e}=this._$AD,o=(null!==(i=null==t?void 0:t.creationScope)&&void 0!==i?i:h).importNode(s,!0);E.currentNode=o;let n=E.nextNode(),l=0,r=0,d=e[0];for(;void 0!==d;){if(l===d.index){let i;2===d.type?i=new S(n,n.nextSibling,this,t):1===d.type?i=new d.ctor(n,d.name,d.strings,this,t):6===d.type&&(i=new L(n,this,t)),this.v.push(i),d=e[++r]}l!==(null==d?void 0:d.index)&&(n=E.nextNode(),l++)}return o}m(t){let i=0;for(const s of this.v)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++}}class S{constructor(t,i,s,e){var o;this.type=2,this._$AH=b,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$C_=null===(o=null==e?void 0:e.isConnected)||void 0===o||o}get _$AU(){var t,i;return null!==(i=null===(t=this._$AM)||void 0===t?void 0:t._$AU)&&void 0!==i?i:this._$C_}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===t.nodeType&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=V(this,t,i),d(t)?t===b||null==t||""===t?(this._$AH!==b&&this._$AR(),this._$AH=b):t!==this._$AH&&t!==x&&this.$(t):void 0!==t._$litType$?this.T(t):void 0!==t.nodeType?this.k(t):c(t)?this.O(t):this.$(t)}S(t,i=this._$AB){return this._$AA.parentNode.insertBefore(t,i)}k(t){this._$AH!==t&&(this._$AR(),this._$AH=this.S(t))}$(t){this._$AH!==b&&d(this._$AH)?this._$AA.nextSibling.data=t:this.k(h.createTextNode(t)),this._$AH=t}T(t){var i;const{values:s,_$litType$:e}=t,o="number"==typeof e?this._$AC(t):(void 0===e.el&&(e.el=P.createElement(e.h,this.options)),e);if((null===(i=this._$AH)||void 0===i?void 0:i._$AD)===o)this._$AH.m(s);else{const t=new N(o,this),i=t.p(this.options);t.m(s),this.k(i),this._$AH=t}}_$AC(t){let i=T.get(t.strings);return void 0===i&&T.set(t.strings,i=new P(t)),i}O(t){u(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const o of t)e===i.length?i.push(s=new S(this.S(r()),this.S(r()),this,this.options)):s=i[e],s._$AI(o),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e)}_$AR(t=this._$AA.nextSibling,i){var s;for(null===(s=this._$AP)||void 0===s||s.call(this,!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i}}setConnected(t){var i;void 0===this._$AM&&(this._$C_=t,null===(i=this._$AP)||void 0===i||i.call(this,t))}}class M{constructor(t,i,s,e,o){this.type=1,this._$AH=b,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=o,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=b}get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}_$AI(t,i=this,s,e){const o=this.strings;let n=!1;if(void 0===o)t=V(this,t,i,0),n=!d(t)||t!==this._$AH&&t!==x,n&&(this._$AH=t);else{const e=t;let l,h;for(t=o[0],l=0;l<o.length-1;l++)h=V(this,e[s+l],i,l),h===x&&(h=this._$AH[l]),n||(n=!d(h)||h!==this._$AH[l]),h===b?t=b:t!==b&&(t+=(null!=h?h:"")+o[l+1]),this._$AH[l]=h}n&&!e&&this.P(t)}P(t){t===b?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,null!=t?t:"")}}class R extends M{constructor(){super(...arguments),this.type=3}P(t){this.element[this.name]=t===b?void 0:t}}const k=s?s.emptyScript:"";class H extends M{constructor(){super(...arguments),this.type=4}P(t){t&&t!==b?this.element.setAttribute(this.name,k):this.element.removeAttribute(this.name)}}class I extends M{constructor(t,i,s,e,o){super(t,i,s,e,o),this.type=5}_$AI(t,i=this){var s;if((t=null!==(s=V(this,t,i,0))&&void 0!==s?s:b)===x)return;const e=this._$AH,o=t===b&&e!==b||t.capture!==e.capture||t.once!==e.once||t.passive!==e.passive,n=t!==b&&(e===b||o);o&&this.element.removeEventListener(this.name,this,e),n&&this.element.addEventListener(this.name,this,t),this._$AH=t}handleEvent(t){var i,s;"function"==typeof this._$AH?this._$AH.call(null!==(s=null===(i=this.options)||void 0===i?void 0:i.host)&&void 0!==s?s:this.element,t):this._$AH.handleEvent(t)}}class L{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s}get _$AU(){return this._$AM._$AU}_$AI(t){V(this,t)}}const z={A:"$lit$",M:o,C:n,L:1,R:C,D:N,V:c,I:V,H:S,N:M,U:H,B:I,F:R,W:L},Z=i.litHtmlPolyfillSupport;null==Z||Z(P,S),(null!==(t=i.litHtmlVersions)&&void 0!==t?t:i.litHtmlVersions=[]).push("2.3.1");
//# sourceMappingURL=lit-html.js.map


/***/ }),

/***/ 17:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "customElement": () => (/* reexport safe */ _lit_reactive_element_decorators_custom_element_js__WEBPACK_IMPORTED_MODULE_0__.customElement),
/* harmony export */   "property": () => (/* reexport safe */ _lit_reactive_element_decorators_property_js__WEBPACK_IMPORTED_MODULE_1__.property),
/* harmony export */   "state": () => (/* reexport safe */ _lit_reactive_element_decorators_state_js__WEBPACK_IMPORTED_MODULE_2__.state)
/* harmony export */ });
/* harmony import */ var _lit_reactive_element_decorators_custom_element_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _lit_reactive_element_decorators_property_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _lit_reactive_element_decorators_state_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _lit_reactive_element_decorators_event_options_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _lit_reactive_element_decorators_query_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23);
/* harmony import */ var _lit_reactive_element_decorators_query_all_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _lit_reactive_element_decorators_query_async_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(25);
/* harmony import */ var _lit_reactive_element_decorators_query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(26);
/* harmony import */ var _lit_reactive_element_decorators_query_assigned_nodes_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27);

//# sourceMappingURL=decorators.js.map


/***/ }),

/***/ 30:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LitElement": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.LitElement),
/* harmony export */   "css": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.css),
/* harmony export */   "html": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.html)
/* harmony export */ });
/* harmony import */ var _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/* harmony import */ var lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);

//# sourceMappingURL=index.js.map


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _components_profile_comment_warning__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(389);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


(0,_utils__WEBPACK_IMPORTED_MODULE_0__.init)('src/lib/page_scripts/profile.js', main);
function main() {
    return __awaiter(this, void 0, void 0, function* () { });
}

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbGliL3BhZ2Vfc2NyaXB0cy9wcm9maWxlLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQStGO0FBQ25DO0FBQ2Y7QUFDWTtBQUV6RCxTQUFTLGlCQUFpQjtJQUN0Qix3Q0FBd0M7SUFDeEMsT0FBTyxDQUFDLENBQUMsd0RBQVMsRUFBRSxJQUFJLDJEQUFhLEVBQUUsQ0FBQyxDQUFDO0FBQzdDLENBQUM7QUFFRDs7OztHQUlHO0FBQ0ksU0FBZSxVQUFVLENBQVksT0FBa0MsRUFBRSxJQUFTOztRQUNyRixNQUFNLE1BQU0sR0FBMEI7WUFDbEMsT0FBTyxFQUFFLDhDQUFVO1lBQ25CLFlBQVksRUFBRSxPQUFPLENBQUMsT0FBTyxFQUFFO1lBQy9CLE9BQU8sRUFBRSxJQUFJO1lBQ2IsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxHQUFHLFlBQVksQ0FBQztTQUM5QyxDQUFDO1FBRUYsSUFBSSxpQkFBaUIsRUFBRSxFQUFFO1lBQ3JCLE9BQU8sSUFBSSxPQUFPLENBQUMsQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7Z0JBQ25DLHVCQUF1QjtnQkFDdkIsK0RBQWdCLEVBQUUsQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUNsQyxNQUFNLENBQUMsb0JBQW9CLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxFQUFFLEVBQ2hELE1BQU07Z0JBQ04sdUJBQXVCO2dCQUN2QixDQUFDLElBQTRCLEVBQUUsRUFBRTtvQkFDN0IsSUFBSSxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsUUFBUSxFQUFFO3dCQUNoQixPQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO3FCQUMxQjt5QkFBTTt3QkFDSCxNQUFNLENBQUMsSUFBSSxhQUFKLElBQUksdUJBQUosSUFBSSxDQUFFLEtBQUssQ0FBQyxDQUFDO3FCQUN2QjtnQkFDTCxDQUFDLENBQ0osQ0FBQztZQUNOLENBQUMsQ0FBQyxDQUFDO1NBQ047YUFBTTtZQUNILGdFQUFnRTtZQUNoRSxjQUFjO1lBQ2QsT0FBTywrRUFBNEIsQ0FBQyxNQUFNLENBQUMsQ0FBQztTQUMvQztJQUNMLENBQUM7Q0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM1QzJDO0FBQ1I7QUFDcUI7QUFNbEQsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLG1FQUFpQixDQUNqRCxJQUFJLHVEQUFvQixDQUFvQixtRUFBK0IsRUFBRSxDQUFPLEdBQUcsRUFBRSxNQUFNLEVBQUUsRUFBRTs7SUFDL0YsTUFBTSxNQUFNLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQztRQUM3QixNQUFNLEVBQUUsRUFBQyxLQUFLLEVBQUUsWUFBTSxDQUFDLEdBQUcsMENBQUUsRUFBWSxFQUFDO1FBQ3pDLEtBQUssRUFBRSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUM7S0FDcEIsQ0FBQyxDQUFDO0FBQ1AsQ0FBQyxFQUFDLENBQ0wsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNmMEM7QUFDUjtBQUNxQjtBQU1sRCxNQUFNLG1CQUFtQixHQUFHLElBQUksbUVBQWlCLENBQ3BELElBQUksdURBQW9CLENBQXVCLHNFQUFrQyxFQUFFLENBQU8sR0FBRyxFQUFFLE1BQU0sRUFBRSxFQUFFOztJQUNyRyw0RUFBNEU7SUFDNUUsb0JBQW9CO0lBQ3BCLEVBQUU7SUFDRiw4REFBOEQ7SUFDOUQsTUFBTSxNQUFNLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztRQUNqQyxNQUFNLEVBQUUsRUFBQyxLQUFLLEVBQUUsWUFBTSxDQUFDLEdBQUcsMENBQUUsRUFBWSxFQUFDO1FBQ3pDLEtBQUssRUFBRSxNQUFNO1FBQ2IsSUFBSSxFQUFFLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7UUFDekIsSUFBSSxFQUFFLFNBQVMsV0FBVyxDQUFDLFdBQVc7WUFDbEMsTUFBTSxDQUFDLG9CQUFvQixHQUFHLFdBQVcsQ0FBQztRQUM5QyxDQUFDO0tBQ0osQ0FBQyxDQUFDO0lBRUgsTUFBTSxNQUFNLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztRQUNqQyxNQUFNLEVBQUUsRUFBQyxLQUFLLEVBQUUsWUFBTSxDQUFDLEdBQUcsMENBQUUsRUFBWSxFQUFDO1FBQ3pDLEtBQUssRUFBRSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUM7UUFDakIsS0FBSyxFQUFFLE1BQU07S0FDaEIsQ0FBQyxDQUFDO0FBQ1AsQ0FBQyxFQUFDLENBQ0wsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM3Qm1DO0FBQ0Q7QUFDcUI7QUFVbEQsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLG1FQUFpQixDQUNuRCxJQUFJLGdEQUFhLENBQ2Isb0VBQWdDLEVBQ2hDLENBQU8sR0FBRyxFQUFFLEVBQUU7SUFDVixNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDNUMsTUFBTSxDQUFDLEdBQUcsTUFBTSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDM0IsTUFBTSxJQUFJLEdBQUcsTUFBTSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDNUIsT0FBTztRQUNILElBQUk7S0FDUCxDQUFDO0FBQ04sQ0FBQyxFQUNKLENBQ0osQ0FBQzs7Ozs7Ozs7Ozs7OztBQ3BCSyxNQUFNLGFBQWE7SUFDdEIsWUFBb0IsSUFBaUIsRUFBVSxPQUErRDtRQUExRixTQUFJLEdBQUosSUFBSSxDQUFhO1FBQVUsWUFBTyxHQUFQLE9BQU8sQ0FBd0Q7SUFBRyxDQUFDO0lBRWxILE9BQU87UUFDSCxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDckIsQ0FBQztJQUVELGFBQWEsQ0FBQyxPQUFZLEVBQUUsTUFBcUI7UUFDN0MsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0NBQ0o7QUFJTSxNQUFNLG1CQUFtQjtJQUM1QixZQUFvQixJQUFpQixFQUFVLE9BQWlEO1FBQTVFLFNBQUksR0FBSixJQUFJLENBQWE7UUFBVSxZQUFPLEdBQVAsT0FBTyxDQUEwQztJQUFHLENBQUM7SUFFcEcsT0FBTztRQUNILE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNyQixDQUFDO0lBRUQsYUFBYSxDQUFDLE9BQWMsRUFBRSxNQUFxQjtRQUMvQyxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDaEMsQ0FBQztDQUNKO0FBRU0sTUFBTSxvQkFBb0I7SUFDN0IsWUFBb0IsSUFBaUIsRUFBVSxPQUErRDtRQUExRixTQUFJLEdBQUosSUFBSSxDQUFhO1FBQVUsWUFBTyxHQUFQLE9BQU8sQ0FBd0Q7SUFBRyxDQUFDO0lBRWxILE9BQU87UUFDSCxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDckIsQ0FBQztJQUVELGFBQWEsQ0FBQyxPQUFZLEVBQUUsTUFBcUI7UUFDN0MsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0NBQ0o7Ozs7Ozs7Ozs7O0FDeENELElBQVksV0F3Qlg7QUF4QkQsV0FBWSxXQUFXO0lBQ25CLGlGQUEwQjtJQUMxQiwyRUFBdUI7SUFDdkIseUVBQXNCO0lBQ3RCLDJEQUFlO0lBQ2YsMkRBQWU7SUFDZiwyREFBZTtJQUNmLGlFQUFrQjtJQUNsQiw2RUFBd0I7SUFDeEIsNkVBQXdCO0lBQ3hCLGlFQUFrQjtJQUNsQix3RUFBc0I7SUFDdEIsOEVBQXlCO0lBQ3pCLDBFQUF1QjtJQUN2QixvRUFBb0I7SUFDcEIsOEVBQXlCO0lBQ3pCLGdGQUEwQjtJQUMxQix3RUFBc0I7SUFDdEIsMEVBQXVCO0lBQ3ZCLHNFQUFxQjtJQUNyQix3RUFBc0I7SUFDdEIsNERBQWdCO0lBQ2hCLDRFQUF3QjtJQUN4QiwwRUFBdUI7QUFDM0IsQ0FBQyxFQXhCVyxXQUFXLEtBQVgsV0FBVyxRQXdCdEI7Ozs7Ozs7Ozs7O0FDaEJELElBQVksT0FFWDtBQUZELFdBQVksT0FBTztJQUNmLDRCQUFpQjtBQUNyQixDQUFDLEVBRlcsT0FBTyxLQUFQLE9BQU8sUUFFbEI7Ozs7Ozs7Ozs7O0FDTkQ7OztHQUdHO0FBQ0ksTUFBTSxpQkFBaUI7SUFDMUIsWUFBb0IsT0FBa0M7UUFBbEMsWUFBTyxHQUFQLE9BQU8sQ0FBMkI7SUFBRyxDQUFDO0lBRTFELE9BQU87UUFDSCxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDbEMsQ0FBQztJQUVELGFBQWEsQ0FBQyxPQUFZLEVBQUUsTUFBcUI7UUFDN0MsSUFBSSxNQUFNLENBQUMsRUFBRSxLQUFLLE1BQU0sQ0FBQyxPQUFPLENBQUMsRUFBRSxFQUFFO1lBQ2pDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0ZBQW9GLENBQUMsQ0FBQztTQUN6RztRQUVELE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ3ZELENBQUM7Q0FDSjs7Ozs7Ozs7Ozs7OztBQ3RCc0Y7QUFDdEM7QUFFakQ7Ozs7Ozs7Ozs7OztHQVlHO0FBQ0gsTUFBTSxjQUFjO0lBQ2hCOzs7OztPQUtHO0lBQ0gsb0JBQW9CLENBQUMsRUFBVTtRQUMzQixPQUFPLElBQUksT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLE1BQU0sRUFBRSxFQUFFO1lBQ25DLE1BQU0sT0FBTyxHQUFHLENBQUMsQ0FBZSxFQUFFLEVBQUU7Z0JBQ2hDLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUE4QixDQUFDO2dCQUM5QyxJQUFJLElBQUksQ0FBQyxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRTtvQkFDbEMsT0FBTztpQkFDVjtnQkFFRCxnQkFBZ0I7Z0JBQ2hCLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxTQUFTLEVBQUUsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO2dCQUV0RCxJQUFJLElBQUksYUFBSixJQUFJLHVCQUFKLElBQUksQ0FBRSxRQUFRLEVBQUU7b0JBQ2hCLE9BQU8sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7aUJBQzFCO3FCQUFNO29CQUNILE1BQU0sQ0FBQyxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsS0FBSyxDQUFDLENBQUM7aUJBQ3ZCO1lBQ0wsQ0FBQyxDQUFDO1lBRUYsTUFBTSxDQUFDLGdCQUFnQixDQUFDLFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUNoRCxDQUFDLENBQUMsQ0FBQztJQUNQLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNILFdBQVcsQ0FBQyxNQUE2QjtRQUNyQyxNQUFNLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBRTNCLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSCxjQUFjO1FBQ1YsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFlLEVBQUUsRUFBRTtZQUMxQixJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsT0FBTyxLQUFLLHFEQUFVLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRTtnQkFDbEQsOENBQThDO2dCQUM5QyxPQUFPO2FBQ1Y7WUFFRCxnQ0FBZ0M7WUFDaEMsdUJBQXVCO1lBQ3ZCLCtEQUFnQixFQUFFLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FDbEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxFQUFFLEVBQ2pCLENBQUMsQ0FBQyxJQUFJO1lBQ04sdUJBQXVCO1lBQ3ZCLENBQUMsSUFBNEIsRUFBRSxFQUFFO2dCQUM3QixNQUFNLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzdCLENBQUMsQ0FDSixDQUFDO1FBQ04sQ0FBQyxDQUFDO1FBRUYsTUFBTSxDQUFDLGdCQUFnQixDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUMxQyxDQUFDO0NBQ0o7QUFFTSxNQUFNLGdCQUFnQixHQUFHLElBQUksY0FBYyxFQUFFLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdEZ2QjtBQUM0QjtBQUVmO0FBQ0c7QUFDSjtBQUUxQyxJQUFLLFVBR0o7QUFIRCxXQUFLLFVBQVU7SUFDWCx3Q0FBMEI7SUFDMUIsc0NBQXdCO0FBQzVCLENBQUMsRUFISSxVQUFVLEtBQVYsVUFBVSxRQUdkO0FBR0QsSUFBYSxXQUFXLEdBQXhCLE1BQWEsV0FBWSxTQUFRLGlEQUFZO0lBQTdDOztRQUVZLFNBQUksR0FBVyxFQUFFLENBQUM7UUFHbEIsU0FBSSxHQUFlLFVBQVUsQ0FBQyxVQUFVLENBQUM7SUEwR3JELENBQUM7SUFqQlMsaUJBQWlCOzs7OztZQUNuQixPQUFNLGlCQUFpQixZQUFHO1FBQzlCLENBQUM7S0FBQTtJQUVELFFBQVE7UUFDSixNQUFNLENBQUMsR0FBNkIsRUFBQyxTQUFTLEVBQUUsSUFBSSxFQUFDLENBQUM7UUFDdEQsQ0FBQyxDQUFDLE9BQU8sSUFBSSxDQUFDLElBQUksWUFBWSxDQUFDLEdBQUcsSUFBSSxDQUFDO1FBQ3ZDLE9BQU8sMEVBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN2QixDQUFDO0lBRUQsTUFBTTtRQUNGLE9BQU8scUNBQUk7d0JBQ0ssSUFBSSxDQUFDLFFBQVEsRUFBRTt3QkFDZixJQUFJLENBQUMsSUFBSTs7U0FFeEIsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQXhHVSxrQkFBTSxHQUFHO0lBQ1osR0FBRyx3REFBbUI7SUFDdEIsb0NBQUc7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7U0FrRkY7Q0FDSixDQUFDO0FBMUZGO0lBREMsMkRBQVEsQ0FBQyxFQUFDLElBQUksRUFBRSxNQUFNLEVBQUMsQ0FBQzt5Q0FDQztBQUcxQjtJQURDLDJEQUFRLENBQUMsRUFBQyxJQUFJLEVBQUUsTUFBTSxFQUFDLENBQUM7eUNBQ3dCO0FBTHhDLFdBQVc7SUFEdkIseURBQWEsRUFBRTtHQUNILFdBQVcsQ0ErR3ZCO0FBL0d1Qjs7Ozs7Ozs7Ozs7O0FDYlk7QUFFcEMsU0FBUyxlQUFlLENBQUMsR0FBVztJQUNoQyxPQUFPLEdBQUc7U0FDTCxLQUFLLENBQUMsV0FBVyxDQUFDO1NBQ2xCLElBQUksQ0FBQyxHQUFHLENBQUM7U0FDVCxXQUFXLEVBQUUsQ0FBQztBQUN2QixDQUFDO0FBRUQsK0NBQStDO0FBQ3hDLE1BQU0sWUFBYSxTQUFRLDJDQUFVO0lBOEN4QyxNQUFNLENBQUMsR0FBRztRQUNOLE9BQU8sV0FBVyxlQUFlLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7SUFDbkQsQ0FBQztJQUVELE1BQU0sQ0FBQyxJQUFJO1FBQ1AsT0FBTyxRQUFRLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO0lBQzlDLENBQUM7O0FBbkRNLG1CQUFNLEdBQUc7SUFDWixvQ0FBRzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7U0F5Q0Y7Q0FDSixDQUFDOzs7Ozs7Ozs7Ozs7Ozs7O0FDdEQwQztBQUVIO0FBRTdDLElBQVksYUFRWDtBQVJELFdBQVksYUFBYTtJQUNyQiwrREFBK0Q7SUFDL0QsaURBQUk7SUFDSiwyREFBMkQ7SUFDM0QscURBQXFEO0lBQ3JELEVBQUU7SUFDRix1Q0FBdUM7SUFDdkMsNkRBQVU7QUFDZCxDQUFDLEVBUlcsYUFBYSxLQUFiLGFBQWEsUUFReEI7QUFFRCxJQUFLLGFBSUo7QUFKRCxXQUFLLGFBQWE7SUFDZCxxREFBTTtJQUNOLHFEQUFNO0lBQ04sbURBQUs7QUFDVCxDQUFDLEVBSkksYUFBYSxLQUFiLGFBQWEsUUFJakI7QUFPRCxNQUFNLGdCQUFnQixHQUE4QztJQUNoRSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNwQixNQUFNLEVBQUUsQ0FBQyxHQUFHLEVBQUUsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQyxNQUFNO1FBQzFELEVBQUUsRUFBRSxDQUFDLEdBQUcsRUFBRSxNQUFNLEVBQUUsRUFBRSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDO0tBQ2pEO0lBQ0QsQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDcEIsTUFBTSxFQUFFLENBQUMsR0FBRyxFQUFFLFFBQVEsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUMsTUFBTTtRQUNuRSxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUUsTUFBTSxFQUFFLEVBQUUsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQztLQUNqRDtJQUNELENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxFQUFFO1FBQ25CLE1BQU0sRUFBRSxDQUFDLEdBQUcsRUFBRSxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE1BQU07UUFDbkUsRUFBRSxFQUFFLENBQUMsR0FBRyxFQUFFLE1BQU0sRUFBRSxFQUFFLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLENBQUM7S0FDaEQ7Q0FDSixDQUFDO0FBRUssU0FBUyxhQUFhO0lBQ3pCLE9BQU8sVUFBVSxNQUEyQixFQUFFLFdBQW1CLEVBQUUsVUFBOEI7UUFDN0YsSUFBSSxDQUFDLDJEQUFhLEVBQUUsRUFBRTtZQUNsQixPQUFPO1NBQ1Y7UUFFRCxJQUFJLGNBQWMsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLEVBQUU7WUFDbEMsa0JBQWtCO1lBQ2xCLE9BQU87U0FDVjtRQUVELGdFQUFhLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDeEMsQ0FBQyxDQUFDO0FBQ04sQ0FBQztBQUVELFNBQVMsTUFBTSxDQUFDLFFBQWdCLEVBQUUsSUFBbUIsRUFBRSxJQUFtQjtJQUN0RSxPQUFPLFVBQVUsTUFBMkIsRUFBRSxXQUFtQixFQUFFLFVBQThCO1FBQzdGLElBQUksQ0FBQywyREFBYSxFQUFFLEVBQUU7WUFDbEIsT0FBTztTQUNWO1FBQ0QsUUFBUSxJQUFJLEVBQUU7WUFDVixLQUFLLGFBQWEsQ0FBQyxJQUFJO2dCQUNuQixFQUFFLENBQUMsUUFBUSxDQUFDLENBQUMsSUFBSSxDQUFDO29CQUNkLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUM7Z0JBQ2hELENBQUMsQ0FBQyxDQUFDO2dCQUNILE1BQU07WUFDVixLQUFLLGFBQWEsQ0FBQyxVQUFVO2dCQUN6QixXQUFXLENBQUMsR0FBRyxFQUFFO29CQUNiLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxJQUFJLENBQUM7d0JBQ2QsOENBQThDO3dCQUM5QyxJQUFJLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDOzRCQUFFLE9BQU87d0JBRWxFLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUM7b0JBQ2hELENBQUMsQ0FBQyxDQUFDO2dCQUNQLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDUixNQUFNO1NBQ2I7SUFDTCxDQUFDLENBQUM7QUFDTixDQUFDO0FBRU0sU0FBUyxZQUFZLENBQUMsUUFBZ0IsRUFBRSxPQUFzQixhQUFhLENBQUMsSUFBSTtJQUNuRixPQUFPLE1BQU0sQ0FBQyxRQUFRLEVBQUUsSUFBSSxFQUFFLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQztBQUN4RCxDQUFDO0FBRU0sU0FBUyxZQUFZLENBQUMsUUFBZ0IsRUFBRSxPQUFzQixhQUFhLENBQUMsSUFBSTtJQUNuRixPQUFPLE1BQU0sQ0FBQyxRQUFRLEVBQUUsSUFBSSxFQUFFLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQztBQUN4RCxDQUFDO0FBRU0sU0FBUyxXQUFXLENBQUMsUUFBZ0IsRUFBRSxPQUFzQixhQUFhLENBQUMsSUFBSTtJQUNsRixPQUFPLE1BQU0sQ0FBQyxRQUFRLEVBQUUsSUFBSSxFQUFFLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUN2RCxDQUFDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMxRjZCO0FBRXlDO0FBQ2hDO0FBQ0o7QUFDSztBQUNNO0FBSTlDLElBQWEsY0FBYyxHQUEzQixNQUFhLGNBQWUsU0FBUSxpREFBWTtJQUFoRDs7UUFFSSxTQUFJLEdBQUcsS0FBSyxDQUFDO0lBeURqQixDQUFDO0lBekNXLG9CQUFvQjtRQUN4QixNQUFNLEtBQUssR0FBRyxRQUFRLENBQUMsc0JBQXNCLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUN4RSxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ3BCLE9BQU8sRUFBRSxDQUFDO1NBQ2I7UUFFRCxNQUFNLElBQUksR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUF3QixDQUFDO1FBQzdDLE9BQU8sSUFBSSxDQUFDLEtBQUssSUFBSSxFQUFFLENBQUM7SUFDNUIsQ0FBQztJQUVLLGlCQUFpQjs7Ozs7WUFDbkIsT0FBTSxpQkFBaUIsWUFBRztZQUUxQix5REFBTyxDQUNILEdBQUcsRUFBRTtnQkFDRCxPQUFPLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQ3ZDLENBQUMsRUFDRCxHQUFHLEVBQUU7Z0JBQ0QsSUFBSSxDQUFDLHdCQUF3QixFQUFFLENBQUM7WUFDcEMsQ0FBQyxDQUNKLENBQUM7UUFDTixDQUFDO0tBQUE7SUFFRCx3QkFBd0I7UUFDcEIsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7UUFDekMsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBRXJELE1BQU0sY0FBYyxHQUFHLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQzlGLElBQUksQ0FBQyxJQUFJLEdBQUcsY0FBYyxDQUFDO0lBQy9CLENBQUM7SUFFRCxNQUFNO1FBQ0YsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDWixPQUFPLHFDQUFJLEdBQUUsQ0FBQztTQUNqQjtRQUVELE9BQU8scUNBQUk7OztlQUdKLENBQUM7SUFDWixDQUFDO0NBQ0o7QUF2RFUscUJBQU0sR0FBRztJQUNaLEdBQUcsd0RBQW1CO0lBQ3RCLG9DQUFHOzs7Ozs7Ozs7U0FTRjtDQUNKLENBQUM7QUFkRjtJQURDLHdEQUFLLEVBQUU7NENBQ0s7QUFGSixjQUFjO0lBRjFCLHlEQUFhLEVBQUU7SUFDZix1REFBVyxDQUFDLDJDQUEyQyxFQUFFLDBEQUFrQixDQUFDO0dBQ2hFLGNBQWMsQ0EyRDFCO0FBM0QwQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDVjJDO0FBQzFCO0FBQ0M7QUFDbUI7QUFDVztBQUNqQztBQUNlO0FBRXpELFNBQWUsZ0JBQWdCLENBQUMsVUFBa0I7O1FBQzlDLDBEQUFVLENBQUMsMEVBQWdCLEVBQUU7WUFDekIsSUFBSSxFQUFFLGdCQUFnQjtTQUN6QixDQUFDLENBQUM7UUFFSCwwREFBVSxDQUFDLGdGQUFtQixFQUFFO1lBQzVCLElBQUksRUFBRSxVQUFVO1NBQ25CLENBQUMsQ0FBQztJQUNQLENBQUM7Q0FBQTtBQUVELFNBQWUsZUFBZSxDQUFDLFVBQWtCOztRQUM3QyxrRkFBK0IsRUFBRSxDQUFDO1FBRWxDLHdEQUF3RDtRQUN4RCxnQ0FBZ0M7UUFDaEMsOEVBQThFO1FBRTlFLDRDQUE0QztRQUM1QyxNQUFNLEVBQUUsR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztRQUM5QixNQUFNLFdBQVcsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3JELFdBQVcsQ0FBQyxXQUFXLENBQ25CLFFBQVEsQ0FBQyxjQUFjLENBQUM7eUNBQ1MsRUFBRTtLQUN0QyxDQUFDLENBQ0QsQ0FBQztRQUNGLFFBQVEsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBRXZDLE1BQU0sVUFBVSxHQUFHLE1BQU0sMERBQVUsQ0FBQyxxRkFBa0IsRUFBRTtZQUNwRCxJQUFJLEVBQUUsVUFBVTtTQUNuQixDQUFDLENBQUM7UUFFSCxNQUFNLE1BQU0sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ2hELE1BQU0sQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUM3RCxRQUFRLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUVsQyxNQUFNLFNBQVMsR0FBRyxNQUFNLDBEQUFVLENBQUMscUZBQWtCLEVBQUU7WUFDbkQsSUFBSSxFQUFFLGdCQUFnQjtTQUN6QixDQUFDLENBQUM7UUFFSCxNQUFNLEtBQUssR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzlDLEtBQUssQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUMzRCxRQUFRLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNyQyxDQUFDO0NBQUE7QUFDRDs7Ozs7R0FLRztBQUNJLFNBQWUsSUFBSSxDQUFDLFVBQWtCLEVBQUUsTUFBaUI7O1FBQzVELDJDQUEyQztRQUMzQyxJQUFJLDJEQUFhLEVBQUUsRUFBRTtZQUNqQiwrREFBK0Q7WUFDL0QsTUFBTSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7WUFDdEIsNkJBQTZCO1lBQzdCLE1BQU0sQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO1lBRXhCLE1BQU0sRUFBRSxDQUFDO1lBQ1QsT0FBTztTQUNWO1FBRUQsSUFBSSx3REFBUyxFQUFFLEVBQUU7WUFDYixNQUFNLGVBQWUsQ0FBQyxVQUFVLENBQUMsQ0FBQztTQUNyQzthQUFNO1lBQ0gsTUFBTSxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztTQUN0QztRQUVELE9BQU8sQ0FBQyxHQUFHLENBQ1AsK0JBQStCLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLENBQUMsT0FBTyxnQkFBZ0IsRUFDbkYsbUNBQW1DLENBQ3RDLENBQUM7UUFDRixPQUFPLENBQUMsR0FBRyxDQUNQLHVFQUF1RSxFQUN2RSxtQ0FBbUMsQ0FDdEMsQ0FBQztJQUNOLENBQUM7Q0FBQTs7Ozs7Ozs7Ozs7O0FDbkZNLFNBQVMsU0FBUztJQUNyQixPQUFPLFNBQVMsQ0FBQyxTQUFTLENBQUMsV0FBVyxFQUFFLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0FBQ3JFLENBQUM7QUFFRDs7R0FFRztBQUNJLFNBQVMsZ0JBQWdCO0lBQzVCLElBQUksU0FBUyxFQUFFLEVBQUU7UUFDYixPQUFPLE9BQU8sQ0FBQztLQUNsQjtTQUFNO1FBQ0gsT0FBTyxNQUFNLENBQUM7S0FDakI7QUFDTCxDQUFDOzs7Ozs7Ozs7OztBQ2JNLFNBQVMsT0FBTyxDQUFJLGFBQXNCLEVBQUUsRUFBYSxFQUFFLFVBQVUsR0FBRyxFQUFFO0lBQzdFLElBQUksSUFBSSxHQUFHLGFBQWEsRUFBRSxDQUFDO0lBRTNCLFdBQVcsQ0FBQyxHQUFHLEVBQUU7UUFDYixNQUFNLEdBQUcsR0FBRyxhQUFhLEVBQUUsQ0FBQztRQUM1QixJQUFJLElBQUksS0FBSyxHQUFHLEVBQUU7WUFDZCxFQUFFLEVBQUUsQ0FBQztTQUNSO1FBQ0QsSUFBSSxHQUFHLEdBQUcsQ0FBQztJQUNmLENBQUMsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUNuQixDQUFDOzs7Ozs7Ozs7OztBQ1ZNLFNBQVMsYUFBYTtJQUN6QixPQUFPLE9BQU8sTUFBTSxLQUFLLFdBQVcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUM7QUFDOUQsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7QUNGRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsdUxBQXVMLFFBQVEsbUJBQW1CLCtHQUErRyx3QkFBd0IsaUJBQWlCLGFBQWEsZUFBZSxrQkFBa0IsaUNBQWlDLG1HQUFtRyxTQUFTLFdBQVcscUJBQXFCLGtFQUFrRSxvREFBb0Qsd0NBQXdDLCtCQUErQix5S0FBeUssbUJBQW1CLG9CQUFvQixXQUFXLDRGQUE0RixxREFBcUQsK0VBQStFLEdBQUcsNkNBQTZDLFNBQVMsdUNBQXVDLFlBQVksT0FBZ0k7QUFDejZDOzs7Ozs7Ozs7Ozs7QUNOQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLDZCQUE2QixZQUFZLDJEQUEyRCxNQUFNLHdCQUF3QixXQUFXLE1BQU0sZUFBZSxnRUFBZ0UsOERBQThELEVBQUUsWUFBWSx3Q0FBd0MsT0FBTyxLQUFLLHNCQUFzQiw4REFBb0o7QUFDOWhCOzs7Ozs7Ozs7OztBQ05BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5RkFBeUYsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLDhCQUE4Qiw2QkFBNkIsT0FBa0M7QUFDeE47Ozs7Ozs7Ozs7QUNONkM7QUFDN0M7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpQkFBaUIsT0FBTywwREFBQyxFQUFFLGlCQUFpQixpQ0FBaUMsRUFBNEI7QUFDekc7Ozs7Ozs7Ozs7O0FDTkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLDJFQUEyRSxpQkFBaUIsMkJBQTJCLEVBQUUsdURBQXVELGlDQUFpQyx5RUFBeUUsYUFBYSw0QkFBNEIsY0FBYyxtQ0FBbUMsa0NBQWtDLGdCQUFzQztBQUM1Yjs7Ozs7Ozs7OztBQ042QztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQixPQUFPLDBEQUFDLEVBQUUsZ0JBQWdCLE1BQU0sUUFBUSx1R0FBdUcsK0JBQStCLEVBQUUsRUFBd0I7QUFDek47Ozs7Ozs7Ozs7OztBQ042QztBQUM3QztBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVMscU1BQXFNLGNBQWMsTUFBTSxrQkFBa0IsY0FBYyxPQUFPLDBEQUFDLEVBQUUsZ0JBQWdCLE1BQU0sTUFBTSwyQkFBMkIsRUFBRSwwR0FBMEcsdUNBQXVDLCtCQUErQixFQUFFLEVBQXFDO0FBQzVoQjs7Ozs7Ozs7Ozs7QUNOa0g7QUFDbEg7QUFDQTtBQUNBO0FBQ0E7QUFDQSxxQkFBcUIsVUFBVSwyQ0FBMkMsVUFBVSxHQUFHLGtGQUFDLEVBQUUsNEJBQTRCLEVBQUUsMERBQUMsRUFBRSxnQkFBZ0IsTUFBTSxRQUFRLDJCQUEyQixFQUFFLHNGQUFzRixxRUFBcUUsK0JBQStCLEVBQUUsRUFBa0M7QUFDcFo7Ozs7Ozs7Ozs7QUNONkM7QUFDN0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGNBQWMsT0FBTywwREFBQyxFQUFFLGdCQUFnQixZQUFZLE1BQU0sa0dBQWtHLCtCQUErQixFQUFFLEVBQTBCO0FBQ3ZOOzs7Ozs7Ozs7O0FDUDZDO0FBQzdDO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsbUJBQW1CLE9BQU8sMERBQUMsRUFBRSxlQUFlLFNBQVMsTUFBTSxRQUFRLHNHQUFzRyxnQ0FBZ0MsTUFBTSwyQ0FBMkMsaUJBQWlCLFFBQVEsMklBQTJJLFVBQVUsRUFBcUI7QUFDN2I7Ozs7Ozs7Ozs7OztBQ055QztBQUN6QztBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQixPQUFPLHNEQUFDLEVBQUUsY0FBYyxFQUFxQjtBQUM5RDs7Ozs7Ozs7Ozs7Ozs7QUNOZ0w7QUFDaEw7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLDJGQUEyRixpQkFBaUIsVUFBVSx3QkFBd0IsTUFBTSxxREFBcUQsU0FBUyxvQkFBb0IsUUFBUSxVQUFVLHdCQUF3QixNQUFNLHNDQUFzQyxNQUFNLDJCQUEyQixnQkFBZ0IsU0FBUyxRQUFRLFVBQVUsaUNBQWlDLDhEQUE4RCw0QkFBNEIsY0FBYyw2RkFBNkYseUJBQXlCLE1BQU0sMERBQTBELGdDQUFnQyxnQkFBZ0IsV0FBVywrQ0FBK0MsdUJBQXVCLDJDQUEyQyxLQUFLLDZCQUE2QiwrSEFBK0gsK0VBQStFLHVEQUF1RCxvQ0FBb0MsT0FBTyxNQUFNLGVBQWUsUUFBUSxnQkFBZ0Isb0NBQW9DLGdDQUFnQyw2QkFBNkIsd0NBQXdDLGtCQUFrQiw2Q0FBNkMsa0JBQWtCLG9DQUFvQyx5SEFBeUgsZ0dBQWdHLDZDQUE2Qyw4REFBOEQseUJBQXlCLFdBQVcscUJBQXFCLHVDQUF1QywyQkFBMkIsK0RBQUMsS0FBSyx3QkFBd0IsK0RBQUMsS0FBSyxTQUFTLGlCQUFpQixvQkFBb0IsbUZBQW1GLElBQUksTUFBTSx3S0FBd0ssaUJBQWlCLFFBQVEsMEpBQTBKLG9CQUFvQixNQUFNLHVFQUF1RSxPQUFPLG9EQUFvRCxrRUFBa0UsR0FBRyxtQkFBbUIsTUFBTSx1R0FBdUcsT0FBTyx3REFBQyxxQ0FBcUMsb0JBQW9CLE1BQU0sNklBQTZJLE1BQU0sK0RBQStELEdBQUcsbUJBQW1CLHVCQUF1QixNQUFNLGlEQUFpRCxNQUFNLGtFQUFrRSxHQUFHLGdDQUFnQyxlQUFlLGNBQWMsTUFBTSxtQ0FBbUMsK0JBQStCLGlIQUFpSCxtRkFBbUYsVUFBVSxNQUFNLHlDQUF5Qyw4QkFBOEIsa0VBQWtFLDBCQUEwQixvRkFBb0YsOERBQThELHFCQUFxQixTQUFTLGlSQUFpUixhQUFhLHdCQUF3QixJQUFJLGdCQUFnQixTQUFTLGtCQUFrQiw4QkFBOEIsOENBQThDLGlCQUFpQiw0QkFBNEIsZ0JBQWdCLE1BQU0sZ0NBQWdDLG9GQUFvRixTQUFTLGtCQUFrQixJQUFJLDhGQUE4RixNQUFNLDREQUE0RCwrQkFBK0IsU0FBUyx5QkFBeUIsZ0JBQWdCLGVBQWUsUUFBUSxNQUFNLGlEQUFpRCxNQUFNLDZEQUE2RCw4RUFBOEUsT0FBTywwQ0FBMEMscUJBQXFCLGdDQUFnQyxvQkFBb0IsaUJBQWlCLGdCQUFnQixTQUFTLFVBQVUsc0dBQXNHLFlBQVksa0JBQWtCLG1GQUFtRixZQUFZLGFBQWEsa0JBQWtCLGtHQUFtSztBQUNqa0w7Ozs7Ozs7Ozs7Ozs7Ozs7QUNOaUs7QUFDaks7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLFFBQVEsa0VBQUMsQ0FBQyxnQkFBZ0Isa0VBQUMsQ0FBQyxjQUFjLHdDQUF3QyxVQUFVLGtCQUFrQixtQkFBbUIsUUFBUSxpQ0FBaUMsbUdBQW1HLFVBQVUsc0JBQXNCLDZGQUE2RixnREFBQyx1Q0FBdUMsb0JBQW9CLE1BQU0sK0VBQStFLHVCQUF1QixNQUFNLGtGQUFrRixTQUFTLE9BQU8sOENBQUMsRUFBRSxpSEFBaUgsYUFBYSxFQUFFLDZDQUE2QyxZQUFZLGFBQWEsRUFBRSxTQUFTLGVBQWUsWUFBWSxpQkFBaUIsd0dBQStKO0FBQ3BrQzs7Ozs7Ozs7Ozs7OztBQ05BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLHFFQUFxRSxnQkFBZ0IsMkJBQTJCLEVBQUUsUUFBUSxnQkFBZ0IsV0FBVyxzQkFBc0IsWUFBWSxvQ0FBb0MsVUFBVSx3QkFBd0IsWUFBWSwwQkFBOEU7QUFDaFc7Ozs7Ozs7Ozs7Ozs7QUNObUg7QUFDbkg7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLHdEQUFDLGVBQWUsb0RBQUMsQ0FBQyxlQUFlLE1BQU0scUJBQXFCLDZEQUFXLDJMQUEyTCxVQUFVLHlEQUF5RCxjQUFjLFFBQVEscUJBQXFCLDJHQUEyRyx5RkFBeUYsc0JBQXNCLDRCQUE0QixxQkFBcUIsd0NBQXdDLEdBQUcsa0JBQWtCLGVBQWUsb0lBQW9JLE9BQU8sa0RBQUMsRUFBRSxFQUF3QjtBQUN4M0I7Ozs7Ozs7Ozs7Ozs7O0FDTkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU0sK0RBQStELGdCQUFnQixrQkFBa0IsNEJBQTRCLGlCQUFpQixFQUFFLCthQUErYSxnQ0FBZ0MsbUdBQW1HLFFBQVEsaUVBQWlFLG1CQUFtQixlQUFlLG9FQUFvRSxnRUFBZ0UsRUFBRSxtQkFBbUIsK0NBQStDLHdCQUF3Qiw2QkFBNkIsWUFBWSxJQUFJLEtBQUssYUFBYSxpQkFBaUIsS0FBSyxpREFBaUQsdVRBQXVULDhDQUE4QyxvR0FBb0csNENBQTRDLDZGQUE2Rix3Q0FBd0MsUUFBUSxhQUFhLHVCQUF1QixJQUFJLE1BQU0sY0FBYyxZQUFZLDZDQUE2QyxxRUFBcUUsdUNBQXVDLHFDQUFxQyxLQUFLLG9DQUFvQyxFQUFFLG1CQUFtQixzQkFBc0IsV0FBVyw4RUFBOEUsZUFBZSx5QkFBeUIsa0ZBQWtGLFFBQVEsaUZBQWlGLEVBQUUsYUFBYSxlQUFlLEVBQUUsc0NBQXNDLHNCQUFzQiw0Q0FBNEMsUUFBUSxpQ0FBaUMsWUFBWSxJQUFJLDRDQUE0QyxpQkFBaUIsRUFBRSxxQkFBcUIsNkNBQTZDLGVBQWUsRUFBRSxLQUFLLFNBQVMsS0FBSywrQkFBK0IsU0FBUyxlQUFlLGdCQUFnQixLQUFLLDBCQUEwQixvQ0FBb0Msd0JBQXdCLHNCQUFzQixZQUFZLGtCQUFrQixrRUFBa0Usc0NBQXNDLDZRQUE2USxRQUFRLGlCQUFpQixtREFBbUQsaUJBQWlCLDRCQUE0QixXQUFXLHNCQUFzQixLQUFLLE1BQU0sTUFBTSxJQUFJLFVBQVUsU0FBUywwRkFBMEYsZ0JBQWdCLGtDQUFrQyxLQUFLLFdBQVcsRUFBRSxnQkFBZ0IsTUFBTSxzSkFBc0osbURBQW1ELFNBQVMsS0FBSyxRQUFRLCtHQUErRyxRQUFRLHFCQUFxQixNQUFNLDZKQUE2SixXQUFXLFFBQVEseUZBQXlGLGlCQUFpQiwyQkFBMkIsa0JBQWtCLHVEQUF1RCxnQkFBZ0IsaUJBQWlCLGNBQWMsaUJBQWlCLGVBQWUsME1BQTBNLGlCQUFpQiw4Q0FBOEMsS0FBSyxpREFBaUQsS0FBSyxpR0FBaUcsS0FBSyxNQUFNLE1BQU0sc0JBQXNCLGlHQUFpRyx1RUFBdUUsS0FBSywwQ0FBMEMsOEJBQThCLFFBQVEsdUJBQXVCLGlEQUFpRCxLQUFLLHlDQUF5QyxrQkFBa0IsVUFBVSw4R0FBOEcsNERBQTRELGdDQUFnQyxNQUFNLDJEQUEyRCxpQkFBaUIsRUFBRSxzQkFBc0IsZ0JBQWdCLGdCQUFnQixNQUFNLG9GQUFvRixRQUFRLHVCQUF1QiwwTUFBME0sY0FBYyw0QkFBNEIsV0FBVyxzQkFBc0IsbUJBQW1CLHFCQUFxQixTQUFTLDZFQUE2RSxLQUFLLFVBQVUsUUFBUSxlQUFlLGFBQWEsMklBQTJJLGlCQUFpQixLQUFLLGlHQUFpRyxrQkFBa0IsY0FBYyxnQ0FBZ0MsS0FBSyx3Q0FBd0MsMkJBQTJCLGtCQUFrQixjQUFjLGdDQUFnQyxLQUFLLHlGQUF5RixrQkFBa0IsdUJBQXVCLDZCQUE2QixlQUFlLE1BQU0sMkRBQTJELG9IQUFvSCxxSEFBcUgsZUFBZSxRQUFRLGlLQUFpSyxRQUFRLG1CQUFtQix1RUFBdUUsV0FBVyxzQkFBc0IsUUFBUSxXQUFXLFNBQVMsOERBQThELDRCQUE0QixnR0FBNEs7QUFDeHZQOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDTjhpQjtBQUM5aUI7Ozs7Ozs7Ozs7Ozs7Ozs7QUNEdUY7QUFDdkY7Ozs7Ozs7VUNEQTtVQUNBOztVQUVBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBOztVQUVBO1VBQ0E7O1VBRUE7VUFDQTtVQUNBOzs7OztXQ3RCQTtXQUNBO1dBQ0E7V0FDQTtXQUNBLHlDQUF5Qyx3Q0FBd0M7V0FDakY7V0FDQTtXQUNBOzs7OztXQ1BBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNBNkI7QUFDa0I7QUFFL0MsNENBQUksQ0FBQyxpQ0FBaUMsRUFBRSxJQUFJLENBQUMsQ0FBQztBQUU5QyxTQUFlLElBQUk7MERBQUksQ0FBQztDQUFBIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9icmlkZ2UvY2xpZW50LnRzIiwid2VicGFjazovLy8uL3NyYy9saWIvYnJpZGdlL2hhbmRsZXJzL2V4ZWN1dGVfY3NzLnRzIiwid2VicGFjazovLy8uL3NyYy9saWIvYnJpZGdlL2hhbmRsZXJzL2V4ZWN1dGVfc2NyaXB0LnRzIiwid2VicGFjazovLy8uL3NyYy9saWIvYnJpZGdlL2hhbmRsZXJzL2ZldGNoX2V4dGVuc2lvbl9maWxlLnRzIiwid2VicGFjazovLy8uL3NyYy9saWIvYnJpZGdlL2hhbmRsZXJzL21haW4udHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9icmlkZ2UvaGFuZGxlcnMvdHlwZXMudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9icmlkZ2UvdHlwZXMudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9icmlkZ2Uvd3JhcHBlcnMvcHJpdmlsZWdlZC50cyIsIndlYnBhY2s6Ly8vLi9zcmMvbGliL2J1cy9wb3N0X21lc3NhZ2VfYnVzLnRzIiwid2VicGFjazovLy8uL3NyYy9saWIvY29tcG9uZW50cy9jb21tb24vdWkvc3RlYW0tYnV0dG9uLnRzIiwid2VicGFjazovLy8uL3NyYy9saWIvY29tcG9uZW50cy9jdXN0b20udHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9jb21wb25lbnRzL2luamVjdG9ycy50cyIsIndlYnBhY2s6Ly8vLi9zcmMvbGliL2NvbXBvbmVudHMvcHJvZmlsZS9jb21tZW50X3dhcm5pbmcudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9wYWdlX3NjcmlwdHMvdXRpbHMudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi91dGlscy9kZXRlY3QudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi91dGlscy9vYnNlcnZlcnMudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi91dGlscy9zbmlwcy50cyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2Nzcy10YWcuanMiLCJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BsaXQvcmVhY3RpdmUtZWxlbWVudC9kZWNvcmF0b3JzL2Jhc2UuanMiLCJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BsaXQvcmVhY3RpdmUtZWxlbWVudC9kZWNvcmF0b3JzL2N1c3RvbS1lbGVtZW50LmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbGl0L3JlYWN0aXZlLWVsZW1lbnQvZGVjb3JhdG9ycy9ldmVudC1vcHRpb25zLmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbGl0L3JlYWN0aXZlLWVsZW1lbnQvZGVjb3JhdG9ycy9wcm9wZXJ0eS5qcyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvcXVlcnktYWxsLmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbGl0L3JlYWN0aXZlLWVsZW1lbnQvZGVjb3JhdG9ycy9xdWVyeS1hc3NpZ25lZC1lbGVtZW50cy5qcyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvcXVlcnktYXNzaWduZWQtbm9kZXMuanMiLCJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BsaXQvcmVhY3RpdmUtZWxlbWVudC9kZWNvcmF0b3JzL3F1ZXJ5LWFzeW5jLmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AbGl0L3JlYWN0aXZlLWVsZW1lbnQvZGVjb3JhdG9ycy9xdWVyeS5qcyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvc3RhdGUuanMiLCJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0BsaXQvcmVhY3RpdmUtZWxlbWVudC9yZWFjdGl2ZS1lbGVtZW50LmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9saXQtZWxlbWVudC9saXQtZWxlbWVudC5qcyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvbGl0LWh0bWwvZGlyZWN0aXZlLmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9saXQtaHRtbC9kaXJlY3RpdmVzL2NsYXNzLW1hcC5qcyIsIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvbGl0LWh0bWwvbGl0LWh0bWwuanMiLCJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2xpdC9kZWNvcmF0b3JzLmpzIiwid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9saXQvaW5kZXguanMiLCJ3ZWJwYWNrOi8vL3dlYnBhY2svYm9vdHN0cmFwIiwid2VicGFjazovLy93ZWJwYWNrL3J1bnRpbWUvZGVmaW5lIHByb3BlcnR5IGdldHRlcnMiLCJ3ZWJwYWNrOi8vL3dlYnBhY2svcnVudGltZS9oYXNPd25Qcm9wZXJ0eSBzaG9ydGhhbmQiLCJ3ZWJwYWNrOi8vLy4vc3JjL2xpYi9wYWdlX3NjcmlwdHMvcHJvZmlsZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge0ludGVybmFsUmVxdWVzdEJ1bmRsZSwgSW50ZXJuYWxSZXNwb25zZUJ1bmRsZSwgUmVxdWVzdEhhbmRsZXIsIFZlcnNpb259IGZyb20gJy4vdHlwZXMnO1xuaW1wb3J0IHtpc0ZpcmVmb3gsIHJ1bnRpbWVOYW1lc3BhY2V9IGZyb20gJy4uL3V0aWxzL2RldGVjdCc7XG5pbXBvcnQge2luUGFnZUNvbnRleHR9IGZyb20gJy4uL3V0aWxzL3NuaXBzJztcbmltcG9ydCB7Z19Qb3N0TWVzc2FnZUJ1c30gZnJvbSAnLi4vYnVzL3Bvc3RfbWVzc2FnZV9idXMnO1xuXG5mdW5jdGlvbiBjYW5Vc2VTZW5kTWVzc2FnZSgpIHtcbiAgICAvLyBOb3Qgc3VwcG9ydGVkIGluIEZpcmVmb3ggUGFnZSBDb250ZXh0XG4gICAgcmV0dXJuICEoaXNGaXJlZm94KCkgJiYgaW5QYWdlQ29udGV4dCgpKTtcbn1cblxuLyoqXG4gKiBTZW5kIGEgcmVxdWVzdCB0byBiZSBoYW5kbGVkIGJ5IHRoZSBiYWNrZ3JvdW5kIHdvcmtlclxuICpcbiAqIENhbiBiZSBjYWxsZWQgZnJvbSBhIGNvbnRlbnQgc2NyaXB0IG9yIHBhZ2UgaXRzZWxmXG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBDbGllbnRTZW5kPFJlcSwgUmVzcD4oaGFuZGxlcjogUmVxdWVzdEhhbmRsZXI8UmVxLCBSZXNwPiwgYXJnczogUmVxKTogUHJvbWlzZTxSZXNwPiB7XG4gICAgY29uc3QgYnVuZGxlOiBJbnRlcm5hbFJlcXVlc3RCdW5kbGUgPSB7XG4gICAgICAgIHZlcnNpb246IFZlcnNpb24uVjEsXG4gICAgICAgIHJlcXVlc3RfdHlwZTogaGFuZGxlci5nZXRUeXBlKCksXG4gICAgICAgIHJlcXVlc3Q6IGFyZ3MsXG4gICAgICAgIGlkOiBNYXRoLmNlaWwoTWF0aC5yYW5kb20oKSAqIDEwMDAwMDAwMDAwMCksXG4gICAgfTtcblxuICAgIGlmIChjYW5Vc2VTZW5kTWVzc2FnZSgpKSB7XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgICAgICAgICAvLyBAdHMtaWdub3JlIEJhZCB0eXBlc1xuICAgICAgICAgICAgcnVudGltZU5hbWVzcGFjZSgpLnJ1bnRpbWUuc2VuZE1lc3NhZ2UoXG4gICAgICAgICAgICAgICAgd2luZG93LkNTRkxPQVRfRVhURU5TSU9OX0lEIHx8IGNocm9tZS5ydW50aW1lLmlkLFxuICAgICAgICAgICAgICAgIGJ1bmRsZSxcbiAgICAgICAgICAgICAgICAvLyBAdHMtaWdub3JlIEJhZCB0eXBlc1xuICAgICAgICAgICAgICAgIChyZXNwOiBJbnRlcm5hbFJlc3BvbnNlQnVuZGxlKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChyZXNwPy5yZXNwb25zZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmVzb2x2ZShyZXNwLnJlc3BvbnNlKTtcbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJlamVjdChyZXNwPy5lcnJvcik7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICApO1xuICAgICAgICB9KTtcbiAgICB9IGVsc2Uge1xuICAgICAgICAvLyBGYWxsYmFjayB0byBwb3N0bWVzc2FnZSBidXMgZm9yIGJyb3dzZXJzIHRoYXQgZG9uJ3QgaW1wbGVtZW50XG4gICAgICAgIC8vIHNwZWNzIGZ1bGx5XG4gICAgICAgIHJldHVybiBnX1Bvc3RNZXNzYWdlQnVzLnNlbmRSZXF1ZXN0KGJ1bmRsZSk7XG4gICAgfVxufVxuIiwiaW1wb3J0IHtFbXB0eVJlc3BvbnNlSGFuZGxlcn0gZnJvbSAnLi9tYWluJztcbmltcG9ydCB7UmVxdWVzdFR5cGV9IGZyb20gJy4vdHlwZXMnO1xuaW1wb3J0IHtQcml2aWxlZ2VkSGFuZGxlcn0gZnJvbSAnLi4vd3JhcHBlcnMvcHJpdmlsZWdlZCc7XG5cbmludGVyZmFjZSBFeGVjdXRlQ3NzUmVxdWVzdCB7XG4gICAgcGF0aDogc3RyaW5nO1xufVxuXG5leHBvcnQgY29uc3QgRXhlY3V0ZUNzc09uUGFnZSA9IG5ldyBQcml2aWxlZ2VkSGFuZGxlcihcbiAgICBuZXcgRW1wdHlSZXNwb25zZUhhbmRsZXI8RXhlY3V0ZUNzc1JlcXVlc3Q+KFJlcXVlc3RUeXBlLkVYRUNVVEVfQ1NTX09OX1BBR0UsIGFzeW5jIChyZXEsIHNlbmRlcikgPT4ge1xuICAgICAgICBhd2FpdCBjaHJvbWUuc2NyaXB0aW5nLmluc2VydENTUyh7XG4gICAgICAgICAgICB0YXJnZXQ6IHt0YWJJZDogc2VuZGVyLnRhYj8uaWQgYXMgbnVtYmVyfSxcbiAgICAgICAgICAgIGZpbGVzOiBbcmVxLnBhdGhdLFxuICAgICAgICB9KTtcbiAgICB9KVxuKTtcbiIsImltcG9ydCB7RW1wdHlSZXNwb25zZUhhbmRsZXJ9IGZyb20gJy4vbWFpbic7XG5pbXBvcnQge1JlcXVlc3RUeXBlfSBmcm9tICcuL3R5cGVzJztcbmltcG9ydCB7UHJpdmlsZWdlZEhhbmRsZXJ9IGZyb20gJy4uL3dyYXBwZXJzL3ByaXZpbGVnZWQnO1xuXG5pbnRlcmZhY2UgRXhlY3V0ZVNjcmlwdFJlcXVlc3Qge1xuICAgIHBhdGg6IHN0cmluZztcbn1cblxuZXhwb3J0IGNvbnN0IEV4ZWN1dGVTY3JpcHRPblBhZ2UgPSBuZXcgUHJpdmlsZWdlZEhhbmRsZXIoXG4gICAgbmV3IEVtcHR5UmVzcG9uc2VIYW5kbGVyPEV4ZWN1dGVTY3JpcHRSZXF1ZXN0PihSZXF1ZXN0VHlwZS5FWEVDVVRFX1NDUklQVF9PTl9QQUdFLCBhc3luYyAocmVxLCBzZW5kZXIpID0+IHtcbiAgICAgICAgLy8gV2UgbmVlZCB0byBpbmplY3QgdGhlIGV4dGVuc2lvbiBJRCBkeW5hbWljYWxseSBzbyB0aGUgY2xpZW50IGtub3dzIHdobyB0b1xuICAgICAgICAvLyBjb21tdW5pY2F0ZSB3aXRoLlxuICAgICAgICAvL1xuICAgICAgICAvLyBPbiBGaXJlZm94LCBleHRlbnNpb24gSURzIGFyZSByYW5kb20sIHNvIHRoaXMgaXMgbmVjZXNzYXJ5LlxuICAgICAgICBhd2FpdCBjaHJvbWUuc2NyaXB0aW5nLmV4ZWN1dGVTY3JpcHQoe1xuICAgICAgICAgICAgdGFyZ2V0OiB7dGFiSWQ6IHNlbmRlci50YWI/LmlkIGFzIG51bWJlcn0sXG4gICAgICAgICAgICB3b3JsZDogJ01BSU4nLFxuICAgICAgICAgICAgYXJnczogW2Nocm9tZS5ydW50aW1lLmlkXSxcbiAgICAgICAgICAgIGZ1bmM6IGZ1bmN0aW9uIEV4dGVuc2lvbklkKGV4dGVuc2lvbklkKSB7XG4gICAgICAgICAgICAgICAgd2luZG93LkNTRkxPQVRfRVhURU5TSU9OX0lEID0gZXh0ZW5zaW9uSWQ7XG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcblxuICAgICAgICBhd2FpdCBjaHJvbWUuc2NyaXB0aW5nLmV4ZWN1dGVTY3JpcHQoe1xuICAgICAgICAgICAgdGFyZ2V0OiB7dGFiSWQ6IHNlbmRlci50YWI/LmlkIGFzIG51bWJlcn0sXG4gICAgICAgICAgICBmaWxlczogW3JlcS5wYXRoXSxcbiAgICAgICAgICAgIHdvcmxkOiAnTUFJTicsXG4gICAgICAgIH0pO1xuICAgIH0pXG4pO1xuIiwiaW1wb3J0IHtTaW1wbGVIYW5kbGVyfSBmcm9tICcuL21haW4nO1xuaW1wb3J0IHtSZXF1ZXN0VHlwZX0gZnJvbSAnLi90eXBlcyc7XG5pbXBvcnQge1ByaXZpbGVnZWRIYW5kbGVyfSBmcm9tICcuLi93cmFwcGVycy9wcml2aWxlZ2VkJztcblxuZXhwb3J0IGludGVyZmFjZSBGZXRjaEV4dGVuc2lvbkZpbGVSZXF1ZXN0IHtcbiAgICBwYXRoOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRmV0Y2hFeHRlbnNpb25GaWxlUmVzcG9uc2Uge1xuICAgIHRleHQ6IHN0cmluZztcbn1cblxuZXhwb3J0IGNvbnN0IEZldGNoRXh0ZW5zaW9uRmlsZSA9IG5ldyBQcml2aWxlZ2VkSGFuZGxlcihcbiAgICBuZXcgU2ltcGxlSGFuZGxlcjxGZXRjaEV4dGVuc2lvbkZpbGVSZXF1ZXN0LCBGZXRjaEV4dGVuc2lvbkZpbGVSZXNwb25zZT4oXG4gICAgICAgIFJlcXVlc3RUeXBlLkZFVENIX0VYVEVOU0lPTl9GSUxFLFxuICAgICAgICBhc3luYyAocmVxKSA9PiB7XG4gICAgICAgICAgICBjb25zdCB1cmwgPSBjaHJvbWUucnVudGltZS5nZXRVUkwocmVxLnBhdGgpO1xuICAgICAgICAgICAgY29uc3QgciA9IGF3YWl0IGZldGNoKHVybCk7XG4gICAgICAgICAgICBjb25zdCB0ZXh0ID0gYXdhaXQgci50ZXh0KCk7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHRleHQsXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgKVxuKTtcbiIsImltcG9ydCB7UmVxdWVzdEhhbmRsZXJ9IGZyb20gJy4uL3R5cGVzJztcbmltcG9ydCBNZXNzYWdlU2VuZGVyID0gY2hyb21lLnJ1bnRpbWUuTWVzc2FnZVNlbmRlcjtcbmltcG9ydCB7UmVxdWVzdFR5cGV9IGZyb20gJy4vdHlwZXMnO1xuXG5leHBvcnQgY2xhc3MgU2ltcGxlSGFuZGxlcjxSZXEsIFJlc3A+IGltcGxlbWVudHMgUmVxdWVzdEhhbmRsZXI8UmVxLCBSZXNwPiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSB0eXBlOiBSZXF1ZXN0VHlwZSwgcHJpdmF0ZSBoYW5kbGVyOiAocmVxdWVzdDogUmVxLCBzZW5kZXI6IE1lc3NhZ2VTZW5kZXIpID0+IFByb21pc2U8UmVzcD4pIHt9XG5cbiAgICBnZXRUeXBlKCk6IFJlcXVlc3RUeXBlIHtcbiAgICAgICAgcmV0dXJuIHRoaXMudHlwZTtcbiAgICB9XG5cbiAgICBoYW5kbGVSZXF1ZXN0KHJlcXVlc3Q6IFJlcSwgc2VuZGVyOiBNZXNzYWdlU2VuZGVyKTogUHJvbWlzZTxSZXNwPiB7XG4gICAgICAgIHJldHVybiB0aGlzLmhhbmRsZXIocmVxdWVzdCwgc2VuZGVyKTtcbiAgICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRW1wdHkge31cblxuZXhwb3J0IGNsYXNzIEVtcHR5UmVxdWVzdEhhbmRsZXI8UmVzcD4gaW1wbGVtZW50cyBSZXF1ZXN0SGFuZGxlcjxFbXB0eSwgUmVzcD4ge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgdHlwZTogUmVxdWVzdFR5cGUsIHByaXZhdGUgaGFuZGxlcjogKHNlbmRlcjogTWVzc2FnZVNlbmRlcikgPT4gUHJvbWlzZTxSZXNwPikge31cblxuICAgIGdldFR5cGUoKTogUmVxdWVzdFR5cGUge1xuICAgICAgICByZXR1cm4gdGhpcy50eXBlO1xuICAgIH1cblxuICAgIGhhbmRsZVJlcXVlc3QocmVxdWVzdDogRW1wdHksIHNlbmRlcjogTWVzc2FnZVNlbmRlcik6IFByb21pc2U8UmVzcD4ge1xuICAgICAgICByZXR1cm4gdGhpcy5oYW5kbGVyKHNlbmRlcik7XG4gICAgfVxufVxuXG5leHBvcnQgY2xhc3MgRW1wdHlSZXNwb25zZUhhbmRsZXI8UmVxPiBpbXBsZW1lbnRzIFJlcXVlc3RIYW5kbGVyPFJlcSwgdm9pZD4ge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgdHlwZTogUmVxdWVzdFR5cGUsIHByaXZhdGUgaGFuZGxlcjogKHJlcXVlc3Q6IFJlcSwgc2VuZGVyOiBNZXNzYWdlU2VuZGVyKSA9PiBQcm9taXNlPHZvaWQ+KSB7fVxuXG4gICAgZ2V0VHlwZSgpOiBSZXF1ZXN0VHlwZSB7XG4gICAgICAgIHJldHVybiB0aGlzLnR5cGU7XG4gICAgfVxuXG4gICAgaGFuZGxlUmVxdWVzdChyZXF1ZXN0OiBSZXEsIHNlbmRlcjogTWVzc2FnZVNlbmRlcik6IFByb21pc2U8dm9pZD4ge1xuICAgICAgICByZXR1cm4gdGhpcy5oYW5kbGVyKHJlcXVlc3QsIHNlbmRlcik7XG4gICAgfVxufVxuIiwiZXhwb3J0IGVudW0gUmVxdWVzdFR5cGUge1xuICAgIEVYRUNVVEVfU0NSSVBUX09OX1BBR0UgPSAwLFxuICAgIEVYRUNVVEVfQ1NTX09OX1BBR0UgPSAxLFxuICAgIEZFVENIX0lOU1BFQ1RfSU5GTyA9IDIsXG4gICAgRkVUQ0hfU1RBTEwgPSAzLFxuICAgIFNUT1JBR0VfR0VUID0gNCxcbiAgICBTVE9SQUdFX1NFVCA9IDUsXG4gICAgU1RPUkFHRV9SRU1PVkUgPSA2LFxuICAgIEZFVENIX1BFTkRJTkdfVFJBREVTID0gNyxcbiAgICBGRVRDSF9FWFRFTlNJT05fRklMRSA9IDgsXG4gICAgQU5OT1RBVEVfT0ZGRVIgPSA5LFxuICAgIEVYVEVOU0lPTl9WRVJTSU9OID0gMTAsXG4gICAgVFJBREVfSElTVE9SWV9TVEFUVVMgPSAxMSxcbiAgICBUUkFERV9PRkZFUl9TVEFUVVMgPSAxMixcbiAgICBIQVNfUEVSTUlTU0lPTlMgPSAxMyxcbiAgICBQSU5HX1NFVFVQX0VYVEVOU0lPTiA9IDE0LFxuICAgIFBJTkdfRVhURU5TSU9OX1NUQVRVUyA9IDE1LFxuICAgIFBJTkdfQ0FOQ0VMX1RSQURFID0gMTYsXG4gICAgQ1JFQVRFX1RSQURFX09GRkVSID0gMTcsXG4gICAgRkVUQ0hfU1RFQU1fVVNFUiA9IDE4LFxuICAgIFBJTkdfVFJBREVfU1RBVFVTID0gMTksXG4gICAgUElOR19TVEFUVVMgPSAyMCxcbiAgICBGRVRDSF9PV05fSU5WRU5UT1JZID0gMjEsXG4gICAgQ0FOQ0VMX1RSQURFX09GRkVSID0gMjIsXG59XG4iLCJpbXBvcnQgTWVzc2FnZVNlbmRlciA9IGNocm9tZS5ydW50aW1lLk1lc3NhZ2VTZW5kZXI7XG5pbXBvcnQge1JlcXVlc3RUeXBlfSBmcm9tICcuL2hhbmRsZXJzL3R5cGVzJztcblxuZXhwb3J0IGludGVyZmFjZSBSZXF1ZXN0SGFuZGxlcjxSZXEsIFJlc3A+IHtcbiAgICBoYW5kbGVSZXF1ZXN0KHJlcXVlc3Q6IFJlcSwgc2VuZGVyOiBNZXNzYWdlU2VuZGVyKTogUHJvbWlzZTxSZXNwPjtcbiAgICBnZXRUeXBlKCk6IFJlcXVlc3RUeXBlO1xufVxuXG5leHBvcnQgZW51bSBWZXJzaW9uIHtcbiAgICBWMSA9ICdDU0ZMT0FUX1YxJyxcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJbnRlcm5hbFJlcXVlc3RCdW5kbGUge1xuICAgIHZlcnNpb246IHN0cmluZztcblxuICAgIHJlcXVlc3RfdHlwZTogUmVxdWVzdFR5cGU7XG5cbiAgICAvLyBJbnB1dCByZXF1ZXN0XG4gICAgcmVxdWVzdDogYW55O1xuXG4gICAgLy8gUmFuZG9tIElEIHRvIGlkZW50aWZ5IHRoZSByZXF1ZXN0XG4gICAgaWQ6IG51bWJlcjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJbnRlcm5hbFJlc3BvbnNlQnVuZGxlIHtcbiAgICByZXF1ZXN0X3R5cGU6IFJlcXVlc3RUeXBlO1xuXG4gICAgLy8gUmVzcG9uc2VcbiAgICByZXNwb25zZTogYW55O1xuXG4gICAgZXJyb3I6IHN0cmluZztcblxuICAgIC8vIFJhbmRvbSBJRCB0byBpZGVudGlmeSB0aGUgcmVxdWVzdFxuICAgIGlkOiBudW1iZXI7XG59XG4iLCJpbXBvcnQge1JlcXVlc3RIYW5kbGVyfSBmcm9tICcuLi90eXBlcyc7XG5pbXBvcnQge1JlcXVlc3RUeXBlfSBmcm9tICcuLi9oYW5kbGVycy90eXBlcyc7XG5pbXBvcnQgTWVzc2FnZVNlbmRlciA9IGNocm9tZS5ydW50aW1lLk1lc3NhZ2VTZW5kZXI7XG5cbi8qKlxuICogUmVzdHJpY3RzIGEgZ2l2ZW4gaGFuZGxlciBzdWNoIHRoYXQgaXQgY2FuIG9ubHkgcnVuIGlmIHRoZSBzZW5kZXIgaXNcbiAqIHZlcmlmaWVkIHRvIGJlIGZyb20gdGhlIGV4dGVuc2lvbidzIG9yaWdpbiAoaWUuIGNvbnRlbnQgc2NyaXB0KVxuICovXG5leHBvcnQgY2xhc3MgUHJpdmlsZWdlZEhhbmRsZXI8UmVxLCBSZXNwPiBpbXBsZW1lbnRzIFJlcXVlc3RIYW5kbGVyPFJlcSwgUmVzcD4ge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgaGFuZGxlcjogUmVxdWVzdEhhbmRsZXI8UmVxLCBSZXNwPikge31cblxuICAgIGdldFR5cGUoKTogUmVxdWVzdFR5cGUge1xuICAgICAgICByZXR1cm4gdGhpcy5oYW5kbGVyLmdldFR5cGUoKTtcbiAgICB9XG5cbiAgICBoYW5kbGVSZXF1ZXN0KHJlcXVlc3Q6IFJlcSwgc2VuZGVyOiBNZXNzYWdlU2VuZGVyKTogUHJvbWlzZTxSZXNwPiB7XG4gICAgICAgIGlmIChzZW5kZXIuaWQgIT09IGNocm9tZS5ydW50aW1lLmlkKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0F0dGVtcHQgdG8gYWNjZXNzIHJlc3RyaWN0ZWQgbWV0aG9kIG91dHNpZGUgb2Ygc2VjdXJlIGNvbnRleHQgKGllLiBjb250ZW50IHNjcmlwdCknKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiB0aGlzLmhhbmRsZXIuaGFuZGxlUmVxdWVzdChyZXF1ZXN0LCBzZW5kZXIpO1xuICAgIH1cbn1cbiIsImltcG9ydCB7SW50ZXJuYWxSZXF1ZXN0QnVuZGxlLCBJbnRlcm5hbFJlc3BvbnNlQnVuZGxlLCBWZXJzaW9ufSBmcm9tICcuLi9icmlkZ2UvdHlwZXMnO1xuaW1wb3J0IHtydW50aW1lTmFtZXNwYWNlfSBmcm9tICcuLi91dGlscy9kZXRlY3QnO1xuXG4vKipcbiAqIE1lc3NhZ2UgYnVzIHRoYXQgdXNlcyBgcG9zdE1lc3NhZ2VgIGluIG9yZGVyIHRvIGNvbW11bmljYXRlIHdpdGggdGhlIGJhY2tncm91bmRcbiAqIHNlcnZpY2Ugd29ya2VyL3NjcmlwdC5cbiAqXG4gKiBXaHk/IEJlY2F1c2UgdGhlIGNsaWVudCBwYWdlIChpZS4gU3RlYW0gcGFnZSkgb24gRmlyZWZveCBpcyBub3QgY2FwYWJsZSBvZlxuICogc2VuZGluZyBhIG1lc3NhZ2UgZGlyZWN0bHkgdG8gdGhlIGV4dGVuc2lvbiBiYWNrZ3JvdW5kLlxuICpcbiAqIFNvIGl0IHJlcXVpcmVzIHVzIHRvIGRvIHRoZSBmb2xsb3dpbmcgZGFuY2U6XG4gKiBwYWdlIDwtLShwb3N0bWVzc2FnZSktLT4gY29udGVudCBzY3JpcHQgPC0tKHNlbmRtZXNzYWdlKS0tPiBiYWNrZ3JvdW5kIHNjcmlwdFxuICpcbiAqIFRoaXMgZGFuY2UgaXMgYWJzdHJhY3RlZCBpbiBgQ2xpZW50U2VuZGAsIGFuZCBvbmx5IHVzZXMgdGhpcyBidXMgaWZcbiAqIGBzZW5kbWVzc2FnZWAgaXMgbm90IHN1cHBvcnRlZCBpbiB0aGUgcGFnZS5cbiAqL1xuY2xhc3MgUG9zdE1lc3NhZ2VCdXMge1xuICAgIC8qKlxuICAgICAqIEZvciB0aGUgcmVxdWVzdGVyIChpZS4gcGFnZSksIHRvIHdhaXQgdW50aWwgaXQgZ2V0cyBhIHJlc3BvbnNlXG4gICAgICogZnJvbSB0aGUgY29udGVudCBzY3JpcHQgdmlhLiBwb3N0TWVzc2FnZSBmb3IgdGhlIGdpdmVuIHJlcXVlc3QgSURcbiAgICAgKlxuICAgICAqIEBwYXJhbSBpZCBSZXF1ZXN0IElEXG4gICAgICovXG4gICAgd2FpdFVudGlsUmVzcG9uc2VGb3IoaWQ6IG51bWJlcik6IFByb21pc2U8YW55PiB7XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgICAgICAgICBjb25zdCBoYW5kbGVyID0gKGU6IE1lc3NhZ2VFdmVudCkgPT4ge1xuICAgICAgICAgICAgICAgIGNvbnN0IHJlc3AgPSBlLmRhdGEgYXMgSW50ZXJuYWxSZXNwb25zZUJ1bmRsZTtcbiAgICAgICAgICAgICAgICBpZiAocmVzcC5pZCAhPT0gaWQgfHwgIXJlc3AucmVzcG9uc2UpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIC8vIFByZXZlbnQgbGVha3NcbiAgICAgICAgICAgICAgICB3aW5kb3cucmVtb3ZlRXZlbnRMaXN0ZW5lcignbWVzc2FnZScsIGhhbmRsZXIsIGZhbHNlKTtcblxuICAgICAgICAgICAgICAgIGlmIChyZXNwPy5yZXNwb25zZSkge1xuICAgICAgICAgICAgICAgICAgICByZXNvbHZlKHJlc3AucmVzcG9uc2UpO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJlamVjdChyZXNwPy5lcnJvcik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfTtcblxuICAgICAgICAgICAgd2luZG93LmFkZEV2ZW50TGlzdGVuZXIoJ21lc3NhZ2UnLCBoYW5kbGVyKTtcbiAgICAgICAgfSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogU2VuZHMgYSByZXF1ZXN0IHRvIGJlIGRvbmUgdGhyb3VnaCB0aGUgYnVzLCByZXR1cm5zIHRoZSBhcHByb3ByaWF0ZVxuICAgICAqIHJlc3BvbnNlIGZvciB0aGUgaW5wdXQgYnVuZGxlIGhhbmRsZXJcbiAgICAgKlxuICAgICAqIEBwYXJhbSBidW5kbGUgUmVxdWVzdCBCdW5kbGVcbiAgICAgKi9cbiAgICBzZW5kUmVxdWVzdChidW5kbGU6IEludGVybmFsUmVxdWVzdEJ1bmRsZSk6IFByb21pc2U8YW55PiB7XG4gICAgICAgIHdpbmRvdy5wb3N0TWVzc2FnZShidW5kbGUpO1xuXG4gICAgICAgIHJldHVybiB0aGlzLndhaXRVbnRpbFJlc3BvbnNlRm9yKGJ1bmRsZS5pZCk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogUmVxdWVzdCBoYW5kbGVyIChjb250ZW50IHNjcmlwdCkgZm9yIG5ldyByZXF1ZXN0cyBmcm9tIHRoZSBwYWdlLlxuICAgICAqXG4gICAgICogRWFjaCByZXF1ZXN0IGlzIGVmZmVjdGl2ZWx5IFwicHJveGllZFwiIHRvIHRoZSBiYWNrZ3JvdW5kIHNjcmlwdC93b3JrZXJcbiAgICAgKiB0byBhY3R1YWxseSBleGVjdXRlIGl0J3MgaGFuZGxlci5cbiAgICAgKi9cbiAgICBoYW5kbGVSZXF1ZXN0cygpIHtcbiAgICAgICAgY29uc3QgaCA9IChlOiBNZXNzYWdlRXZlbnQpID0+IHtcbiAgICAgICAgICAgIGlmIChlLmRhdGEudmVyc2lvbiAhPT0gVmVyc2lvbi5WMSB8fCAhZS5kYXRhLnJlcXVlc3QpIHtcbiAgICAgICAgICAgICAgICAvLyBJZ25vcmUgbWVzc2FnZXMgdGhhdCBhcmVuJ3QgZm9yIHRoaXMgYnJpZGdlXG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAvLyBTZW5kIHRvIHRoZSBiYWNrZ3JvdW5kIHNjcmlwdFxuICAgICAgICAgICAgLy8gQHRzLWlnbm9yZSBCYWQgdHlwZXNcbiAgICAgICAgICAgIHJ1bnRpbWVOYW1lc3BhY2UoKS5ydW50aW1lLnNlbmRNZXNzYWdlKFxuICAgICAgICAgICAgICAgIGNocm9tZS5ydW50aW1lLmlkLFxuICAgICAgICAgICAgICAgIGUuZGF0YSxcbiAgICAgICAgICAgICAgICAvLyBAdHMtaWdub3JlIEJhZCB0eXBlc1xuICAgICAgICAgICAgICAgIChyZXNwOiBJbnRlcm5hbFJlc3BvbnNlQnVuZGxlKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgIHdpbmRvdy5wb3N0TWVzc2FnZShyZXNwKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICApO1xuICAgICAgICB9O1xuXG4gICAgICAgIHdpbmRvdy5hZGRFdmVudExpc3RlbmVyKCdtZXNzYWdlJywgaCk7XG4gICAgfVxufVxuXG5leHBvcnQgY29uc3QgZ19Qb3N0TWVzc2FnZUJ1cyA9IG5ldyBQb3N0TWVzc2FnZUJ1cygpO1xuIiwiaW1wb3J0IHtjc3MsIGh0bWx9IGZyb20gJ2xpdCc7XG5pbXBvcnQge2NsYXNzTWFwfSBmcm9tICdsaXQtaHRtbC9kaXJlY3RpdmVzL2NsYXNzLW1hcC5qcyc7XG5cbmltcG9ydCB7cHJvcGVydHl9IGZyb20gJ2xpdC9kZWNvcmF0b3JzLmpzJztcbmltcG9ydCB7Q3VzdG9tRWxlbWVudH0gZnJvbSAnLi4vLi4vaW5qZWN0b3JzJztcbmltcG9ydCB7RmxvYXRFbGVtZW50fSBmcm9tICcuLi8uLi9jdXN0b20nO1xuXG5lbnVtIEJ1dHRvblR5cGUge1xuICAgIEdyZWVuV2hpdGUgPSAnZ3JlZW5fd2hpdGUnLFxuICAgIEdyZXlXaGl0ZSA9ICdncmV5X3doaXRlJyxcbn1cblxuQEN1c3RvbUVsZW1lbnQoKVxuZXhwb3J0IGNsYXNzIFN0ZWFtQnV0dG9uIGV4dGVuZHMgRmxvYXRFbGVtZW50IHtcbiAgICBAcHJvcGVydHkoe3R5cGU6IFN0cmluZ30pXG4gICAgcHJpdmF0ZSB0ZXh0OiBzdHJpbmcgPSAnJztcblxuICAgIEBwcm9wZXJ0eSh7dHlwZTogU3RyaW5nfSlcbiAgICBwcml2YXRlIHR5cGU6IEJ1dHRvblR5cGUgPSBCdXR0b25UeXBlLkdyZWVuV2hpdGU7XG5cbiAgICBzdGF0aWMgc3R5bGVzID0gW1xuICAgICAgICAuLi5GbG9hdEVsZW1lbnQuc3R5bGVzLFxuICAgICAgICBjc3NgXG4gICAgICAgICAgICAuYnRuX2dyZWVuX3doaXRlX2lubmVyZmFkZSB7XG4gICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogMnB4O1xuICAgICAgICAgICAgICAgIGJvcmRlcjogbm9uZTtcbiAgICAgICAgICAgICAgICBwYWRkaW5nOiAxcHg7XG4gICAgICAgICAgICAgICAgZGlzcGxheTogaW5saW5lLWJsb2NrO1xuICAgICAgICAgICAgICAgIGN1cnNvcjogcG9pbnRlcjtcbiAgICAgICAgICAgICAgICB0ZXh0LWRlY29yYXRpb246IG5vbmUgIWltcG9ydGFudDtcbiAgICAgICAgICAgICAgICBjb2xvcjogI2QyZTg4NSAhaW1wb3J0YW50O1xuXG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZDogI2E0ZDAwNztcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCh0b3AsICNhNGQwMDcgNSUsICM1MzY5MDQgOTUlKTtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiBsaW5lYXItZ3JhZGllbnQodG8gYm90dG9tLCAjYTRkMDA3IDUlLCAjNTM2OTA0IDk1JSk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIC5idG5fZ3JlZW5fd2hpdGVfaW5uZXJmYWRlID4gc3BhbiB7XG4gICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogMnB4O1xuICAgICAgICAgICAgICAgIGRpc3BsYXk6IGJsb2NrO1xuXG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZDogIzc5OTkwNTtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCh0b3AsICM3OTk5MDUgNSUsICM1MzY5MDQgOTUlKTtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiBsaW5lYXItZ3JhZGllbnQodG8gYm90dG9tLCAjNzk5OTA1IDUlLCAjNTM2OTA0IDk1JSk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIC5idG5fZ3JlZW5fd2hpdGVfaW5uZXJmYWRlOm5vdCguYnRuX2Rpc2FibGVkKTpub3QoOmRpc2FibGVkKTpub3QoLmJ0bl9hY3RpdmUpOm5vdCguYWN0aXZlKTpob3ZlciB7XG4gICAgICAgICAgICAgICAgdGV4dC1kZWNvcmF0aW9uOiBub25lICFpbXBvcnRhbnQ7XG4gICAgICAgICAgICAgICAgY29sb3I6ICNmZmYgIWltcG9ydGFudDtcblxuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6ICNiNmQ5MDg7XG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQodG9wLCAjYjZkOTA4IDUlLCAjODBhMDA2IDk1JSk7XG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KHRvIGJvdHRvbSwgI2I2ZDkwOCA1JSwgIzgwYTAwNiA5NSUpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAuYnRuX2dyZWVuX3doaXRlX2lubmVyZmFkZTpub3QoLmJ0bl9kaXNhYmxlZCk6bm90KDpkaXNhYmxlZCk6bm90KC5idG5fYWN0aXZlKTpub3QoLmFjdGl2ZSk6aG92ZXIgPiBzcGFuIHtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAjYTFiZjA3O1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KHRvcCwgI2ExYmYwNyA1JSwgIzgwYTAwNiA5NSUpO1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCh0byBib3R0b20sICNhMWJmMDcgNSUsICM4MGEwMDYgOTUlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLmJ0bl9ncmV5X3doaXRlX2lubmVyZmFkZSB7XG4gICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogMnB4O1xuICAgICAgICAgICAgICAgIGJvcmRlcjogbm9uZTtcbiAgICAgICAgICAgICAgICBwYWRkaW5nOiAxcHg7XG4gICAgICAgICAgICAgICAgZGlzcGxheTogaW5saW5lLWJsb2NrO1xuICAgICAgICAgICAgICAgIGN1cnNvcjogcG9pbnRlcjtcbiAgICAgICAgICAgICAgICB0ZXh0LWRlY29yYXRpb246IG5vbmUgIWltcG9ydGFudDtcbiAgICAgICAgICAgICAgICBjb2xvcjogI2ZmZiAhaW1wb3J0YW50O1xuXG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZDogI2FjYjViZDtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCh0b3AsICNhY2I1YmQgNSUsICM0MTRhNTIgOTUlKTtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiBsaW5lYXItZ3JhZGllbnQodG8gYm90dG9tLCAjYWNiNWJkIDUlLCAjNDE0YTUyIDk1JSk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIC5idG5fZ3JleV93aGl0ZV9pbm5lcmZhZGUgPiBzcGFuIHtcbiAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiAycHg7XG4gICAgICAgICAgICAgICAgZGlzcGxheTogYmxvY2s7XG5cbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAjNzc4MDg4O1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KHRvcCwgIzc3ODA4OCA1JSwgIzQxNGE1MiA5NSUpO1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCh0byBib3R0b20sICM3NzgwODggNSUsICM0MTRhNTIgOTUlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLmJ0bl9ncmV5X3doaXRlX2lubmVyZmFkZTpub3QoLmJ0bl9kaXNhYmxlZCk6bm90KDpkaXNhYmxlZCk6bm90KC5idG5fYWN0aXZlKTpub3QoLmFjdGl2ZSk6aG92ZXIge1xuICAgICAgICAgICAgICAgIHRleHQtZGVjb3JhdGlvbjogbm9uZSAhaW1wb3J0YW50O1xuICAgICAgICAgICAgICAgIGNvbG9yOiAjZmZmICFpbXBvcnRhbnQ7XG5cbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAjY2ZkOGUwO1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KHRvcCwgI2NmZDhlMCA1JSwgIzU2NWY2NyA5NSUpO1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCh0byBib3R0b20sICNjZmQ4ZTAgNSUsICM1NjVmNjcgOTUlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLmJ0bl9ncmV5X3doaXRlX2lubmVyZmFkZTpub3QoLmJ0bl9kaXNhYmxlZCk6bm90KDpkaXNhYmxlZCk6bm90KC5idG5fYWN0aXZlKTpub3QoLmFjdGl2ZSk6aG92ZXIgPiBzcGFuIHtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kOiAjOTlhMmFhO1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KHRvcCwgIzk5YTJhYSA1JSwgIzU2NWY2NyA5NSUpO1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCh0byBib3R0b20sICM5OWEyYWEgNSUsICM1NjVmNjcgOTUlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLmJ0bl9zbWFsbCA+IHNwYW4ge1xuICAgICAgICAgICAgICAgIHBhZGRpbmc6IDAgMTVweDtcbiAgICAgICAgICAgICAgICBmb250LXNpemU6IDEycHg7XG4gICAgICAgICAgICAgICAgbGluZS1oZWlnaHQ6IDIwcHg7XG4gICAgICAgICAgICB9XG4gICAgICAgIGAsXG4gICAgXTtcblxuICAgIGFzeW5jIGNvbm5lY3RlZENhbGxiYWNrKCkge1xuICAgICAgICBzdXBlci5jb25uZWN0ZWRDYWxsYmFjaygpO1xuICAgIH1cblxuICAgIGJ0bkNsYXNzKCkge1xuICAgICAgICBjb25zdCByOiB7W2tleTogc3RyaW5nXTogYm9vbGVhbn0gPSB7YnRuX3NtYWxsOiB0cnVlfTtcbiAgICAgICAgcltgYnRuXyR7dGhpcy50eXBlfV9pbm5lcmZhZGVgXSA9IHRydWU7XG4gICAgICAgIHJldHVybiBjbGFzc01hcChyKTtcbiAgICB9XG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIHJldHVybiBodG1sYFxuICAgICAgICAgICAgPGEgY2xhc3M9XCIke3RoaXMuYnRuQ2xhc3MoKX1cIj5cbiAgICAgICAgICAgICAgICA8c3Bhbj4ke3RoaXMudGV4dH08L3NwYW4+XG4gICAgICAgICAgICA8L2E+XG4gICAgICAgIGA7XG4gICAgfVxufVxuIiwiaW1wb3J0IHtjc3MsIExpdEVsZW1lbnR9IGZyb20gJ2xpdCc7XG5cbmZ1bmN0aW9uIGNhbWVsVG9EYXNoQ2FzZShzdHI6IHN0cmluZykge1xuICAgIHJldHVybiBzdHJcbiAgICAgICAgLnNwbGl0KC8oPz1bQS1aXSkvKVxuICAgICAgICAuam9pbignLScpXG4gICAgICAgIC50b0xvd2VyQ2FzZSgpO1xufVxuXG4vLyBMaXRFbGVtZW50IHdyYXBwZXIgd2l0aCBhIHByZS1kZXRlcm1pbmVkIHRhZ1xuZXhwb3J0IGNsYXNzIEZsb2F0RWxlbWVudCBleHRlbmRzIExpdEVsZW1lbnQge1xuICAgIHN0YXRpYyBzdHlsZXMgPSBbXG4gICAgICAgIGNzc2BcbiAgICAgICAgICAgIGhyIHtcbiAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjMWIyOTM5O1xuICAgICAgICAgICAgICAgIGJvcmRlci1zdHlsZTogc29saWQgbm9uZSBub25lO1xuICAgICAgICAgICAgICAgIGJvcmRlci1jb2xvcjogYmxhY2s7XG4gICAgICAgICAgICAgICAgYm9yZGVyLXdpZHRoOiAxcHggMCAwO1xuICAgICAgICAgICAgICAgIGhlaWdodDogMnB4O1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBhIHtcbiAgICAgICAgICAgICAgICBjb2xvcjogI2ViZWJlYjtcbiAgICAgICAgICAgICAgICBjdXJzb3I6IHBvaW50ZXI7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlucHV0W3R5cGU9J3RleHQnXSxcbiAgICAgICAgICAgIGlucHV0W3R5cGU9J3Bhc3N3b3JkJ10sXG4gICAgICAgICAgICBpbnB1dFt0eXBlPSdudW1iZXInXSxcbiAgICAgICAgICAgIHNlbGVjdCB7XG4gICAgICAgICAgICAgICAgY29sb3I6ICM5MDkwOTA7XG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogcmdiYSgwLCAwLCAwLCAwLjIpO1xuICAgICAgICAgICAgICAgIGJvcmRlcjogMXB4IHNvbGlkICMwMDA7XG4gICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpbnB1dFt0eXBlPSdjb2xvciddIHtcbiAgICAgICAgICAgICAgICBmbG9hdDogbGVmdDtcbiAgICAgICAgICAgICAgICBtYXJnaW4tdG9wOiAycHg7XG4gICAgICAgICAgICAgICAgLXdlYmtpdC1hcHBlYXJhbmNlOiBub25lO1xuICAgICAgICAgICAgICAgIGJvcmRlcjogbm9uZTtcbiAgICAgICAgICAgICAgICB3aWR0aDogMjBweDtcbiAgICAgICAgICAgICAgICBoZWlnaHQ6IDIwcHg7XG4gICAgICAgICAgICAgICAgcGFkZGluZzogMDtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaW5wdXRbdHlwZT0nY29sb3InXTo6LXdlYmtpdC1jb2xvci1zd2F0Y2gtd3JhcHBlciB7XG4gICAgICAgICAgICAgICAgcGFkZGluZzogMDtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaW5wdXRbdHlwZT0nY29sb3InXTo6LXdlYmtpdC1jb2xvci1zd2F0Y2gge1xuICAgICAgICAgICAgICAgIGJvcmRlcjogbm9uZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgYCxcbiAgICBdO1xuXG4gICAgc3RhdGljIHRhZygpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gYGNzZmxvYXQtJHtjYW1lbFRvRGFzaENhc2UodGhpcy5uYW1lKX1gO1xuICAgIH1cblxuICAgIHN0YXRpYyBlbGVtKCk6IGFueSB7XG4gICAgICAgIHJldHVybiBkb2N1bWVudC5jcmVhdGVFbGVtZW50KHRoaXMudGFnKCkpO1xuICAgIH1cbn1cbiIsImltcG9ydCB7Y3VzdG9tRWxlbWVudH0gZnJvbSAnbGl0L2RlY29yYXRvcnMuanMnO1xuaW1wb3J0IHtGbG9hdEVsZW1lbnR9IGZyb20gJy4vY3VzdG9tJztcbmltcG9ydCB7aW5QYWdlQ29udGV4dH0gZnJvbSAnLi4vdXRpbHMvc25pcHMnO1xuXG5leHBvcnQgZW51bSBJbmplY3Rpb25Nb2RlIHtcbiAgICAvLyBJbmplY3RzIG9uY2UgYXQgcGFnZSBsb2FkIGZvciBlbGVtZW50cyBtYXRjaGluZyB0aGUgc2VsZWN0b3JcbiAgICBPTkNFLFxuICAgIC8vIENvbnRpbnVhbGx5IGluamVjdHMgd2hlbmV2ZXIgbmV3IGVsZW1lbnRzIHRoYXQgbWF0Y2ggdGhlXG4gICAgLy8gc2VsZWN0b3IgZXhpc3QgdGhhdCBoYXZlbid0IGJlZW4gaW5qZWN0ZWQgaW50byB5ZXRcbiAgICAvL1xuICAgIC8vIFNob3VsZCBiZSB1c2UgZm9yIFwiZHluYW1pY1wiIGVsZW1lbnRzXG4gICAgQ09OVElOVU9VUyxcbn1cblxuZW51bSBJbmplY3Rpb25UeXBlIHtcbiAgICBBcHBlbmQsXG4gICAgQmVmb3JlLFxuICAgIEFmdGVyLFxufVxuXG5pbnRlcmZhY2UgSW5qZWN0aW9uQ29uZmlnIHtcbiAgICBleGlzdHM6IChjdHg6IEpRdWVyeTxIVE1MRWxlbWVudD4sIHNlbGVjdG9yOiBzdHJpbmcpID0+IGJvb2xlYW47XG4gICAgb3A6IChjdHg6IEpRdWVyeTxIVE1MRWxlbWVudD4sIHRhcmdldDogdHlwZW9mIEZsb2F0RWxlbWVudCkgPT4gdm9pZDtcbn1cblxuY29uc3QgSW5qZWN0aW9uQ29uZmlnczoge1trZXkgaW4gSW5qZWN0aW9uVHlwZV06IEluamVjdGlvbkNvbmZpZ30gPSB7XG4gICAgW0luamVjdGlvblR5cGUuQXBwZW5kXToge1xuICAgICAgICBleGlzdHM6IChjdHgsIHNlbGVjdG9yKSA9PiAhIWN0eC5jaGlsZHJlbihzZWxlY3RvcikubGVuZ3RoLFxuICAgICAgICBvcDogKGN0eCwgdGFyZ2V0KSA9PiBjdHguYXBwZW5kKHRhcmdldC5lbGVtKCkpLFxuICAgIH0sXG4gICAgW0luamVjdGlvblR5cGUuQmVmb3JlXToge1xuICAgICAgICBleGlzdHM6IChjdHgsIHNlbGVjdG9yKSA9PiAhIWN0eC5wYXJlbnQoKS5jaGlsZHJlbihzZWxlY3RvcikubGVuZ3RoLFxuICAgICAgICBvcDogKGN0eCwgdGFyZ2V0KSA9PiBjdHguYmVmb3JlKHRhcmdldC5lbGVtKCkpLFxuICAgIH0sXG4gICAgW0luamVjdGlvblR5cGUuQWZ0ZXJdOiB7XG4gICAgICAgIGV4aXN0czogKGN0eCwgc2VsZWN0b3IpID0+ICEhY3R4LnBhcmVudCgpLmNoaWxkcmVuKHNlbGVjdG9yKS5sZW5ndGgsXG4gICAgICAgIG9wOiAoY3R4LCB0YXJnZXQpID0+IGN0eC5hZnRlcih0YXJnZXQuZWxlbSgpKSxcbiAgICB9LFxufTtcblxuZXhwb3J0IGZ1bmN0aW9uIEN1c3RvbUVsZW1lbnQoKTogYW55IHtcbiAgICByZXR1cm4gZnVuY3Rpb24gKHRhcmdldDogdHlwZW9mIEZsb2F0RWxlbWVudCwgcHJvcGVydHlLZXk6IHN0cmluZywgZGVzY3JpcHRvcjogUHJvcGVydHlEZXNjcmlwdG9yKSB7XG4gICAgICAgIGlmICghaW5QYWdlQ29udGV4dCgpKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoY3VzdG9tRWxlbWVudHMuZ2V0KHRhcmdldC50YWcoKSkpIHtcbiAgICAgICAgICAgIC8vIEFscmVhZHkgZGVmaW5lZFxuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgY3VzdG9tRWxlbWVudCh0YXJnZXQudGFnKCkpKHRhcmdldCk7XG4gICAgfTtcbn1cblxuZnVuY3Rpb24gSW5qZWN0KHNlbGVjdG9yOiBzdHJpbmcsIG1vZGU6IEluamVjdGlvbk1vZGUsIHR5cGU6IEluamVjdGlvblR5cGUpOiBhbnkge1xuICAgIHJldHVybiBmdW5jdGlvbiAodGFyZ2V0OiB0eXBlb2YgRmxvYXRFbGVtZW50LCBwcm9wZXJ0eUtleTogc3RyaW5nLCBkZXNjcmlwdG9yOiBQcm9wZXJ0eURlc2NyaXB0b3IpIHtcbiAgICAgICAgaWYgKCFpblBhZ2VDb250ZXh0KCkpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICBzd2l0Y2ggKG1vZGUpIHtcbiAgICAgICAgICAgIGNhc2UgSW5qZWN0aW9uTW9kZS5PTkNFOlxuICAgICAgICAgICAgICAgICRKKHNlbGVjdG9yKS5lYWNoKGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICAgICAgSW5qZWN0aW9uQ29uZmlnc1t0eXBlXS5vcCgkSih0aGlzKSwgdGFyZ2V0KTtcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGNhc2UgSW5qZWN0aW9uTW9kZS5DT05USU5VT1VTOlxuICAgICAgICAgICAgICAgIHNldEludGVydmFsKCgpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgJEooc2VsZWN0b3IpLmVhY2goZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgLy8gRG9uJ3QgYWRkIHRoZSBpdGVtIGFnYWluIGlmIHdlIGFscmVhZHkgaGF2ZVxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKEluamVjdGlvbkNvbmZpZ3NbdHlwZV0uZXhpc3RzKCRKKHRoaXMpLCB0YXJnZXQudGFnKCkpKSByZXR1cm47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgIEluamVjdGlvbkNvbmZpZ3NbdHlwZV0ub3AoJEoodGhpcyksIHRhcmdldCk7XG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIH0sIDI1MCk7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cbiAgICB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gSW5qZWN0QXBwZW5kKHNlbGVjdG9yOiBzdHJpbmcsIG1vZGU6IEluamVjdGlvbk1vZGUgPSBJbmplY3Rpb25Nb2RlLk9OQ0UpOiBhbnkge1xuICAgIHJldHVybiBJbmplY3Qoc2VsZWN0b3IsIG1vZGUsIEluamVjdGlvblR5cGUuQXBwZW5kKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIEluamVjdEJlZm9yZShzZWxlY3Rvcjogc3RyaW5nLCBtb2RlOiBJbmplY3Rpb25Nb2RlID0gSW5qZWN0aW9uTW9kZS5PTkNFKTogYW55IHtcbiAgICByZXR1cm4gSW5qZWN0KHNlbGVjdG9yLCBtb2RlLCBJbmplY3Rpb25UeXBlLkJlZm9yZSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBJbmplY3RBZnRlcihzZWxlY3Rvcjogc3RyaW5nLCBtb2RlOiBJbmplY3Rpb25Nb2RlID0gSW5qZWN0aW9uTW9kZS5PTkNFKTogYW55IHtcbiAgICByZXR1cm4gSW5qZWN0KHNlbGVjdG9yLCBtb2RlLCBJbmplY3Rpb25UeXBlLkFmdGVyKTtcbn1cbiIsImltcG9ydCB7Y3NzLCBodG1sfSBmcm9tICdsaXQnO1xuXG5pbXBvcnQge0N1c3RvbUVsZW1lbnQsIEluamVjdEFmdGVyLCBJbmplY3Rpb25Nb2RlfSBmcm9tICcuLi9pbmplY3RvcnMnO1xuaW1wb3J0IHtGbG9hdEVsZW1lbnR9IGZyb20gJy4uL2N1c3RvbSc7XG5pbXBvcnQgJy4uL2NvbW1vbi91aS9zdGVhbS1idXR0b24nO1xuaW1wb3J0IHtzdGF0ZX0gZnJvbSAnbGl0L2RlY29yYXRvcnMuanMnO1xuaW1wb3J0IHtPYnNlcnZlfSBmcm9tICcuLi8uLi91dGlscy9vYnNlcnZlcnMnO1xuXG5AQ3VzdG9tRWxlbWVudCgpXG5ASW5qZWN0QWZ0ZXIoJy5jb21tZW50dGhyZWFkX2FyZWEgLmNvbW1lbnR0aHJlYWRfaGVhZGVyJywgSW5qZWN0aW9uTW9kZS5PTkNFKVxuZXhwb3J0IGNsYXNzIENvbW1lbnRXYXJuaW5nIGV4dGVuZHMgRmxvYXRFbGVtZW50IHtcbiAgICBAc3RhdGUoKVxuICAgIHNob3cgPSBmYWxzZTtcblxuICAgIHN0YXRpYyBzdHlsZXMgPSBbXG4gICAgICAgIC4uLkZsb2F0RWxlbWVudC5zdHlsZXMsXG4gICAgICAgIGNzc2BcbiAgICAgICAgICAgIC5jb250YWluZXIge1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYmEoMjM1LCA4NywgODcsIDAuMDUpO1xuICAgICAgICAgICAgICAgIGNvbG9yOiAjZGU2NjY3O1xuICAgICAgICAgICAgICAgIGJvcmRlci1yYWRpdXM6IDZweDtcbiAgICAgICAgICAgICAgICBwYWRkaW5nOiA4cHg7XG4gICAgICAgICAgICAgICAgbWFyZ2luOiA1cHg7XG4gICAgICAgICAgICAgICAgZm9udC1zaXplOiAxNHB4O1xuICAgICAgICAgICAgfVxuICAgICAgICBgLFxuICAgIF07XG5cbiAgICBwcml2YXRlIGdldFJhd0NvbW1lbnRCb3hUZXh0KCk6IHN0cmluZyB7XG4gICAgICAgIGNvbnN0IGVsZW1zID0gZG9jdW1lbnQuZ2V0RWxlbWVudHNCeUNsYXNzTmFtZSgnY29tbWVudHRocmVhZF90ZXh0YXJlYScpO1xuICAgICAgICBpZiAoZWxlbXMubGVuZ3RoID09PSAwKSB7XG4gICAgICAgICAgICByZXR1cm4gJyc7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCBlbGVtID0gZWxlbXNbMF0gYXMgSFRNTFRleHRBcmVhRWxlbWVudDtcbiAgICAgICAgcmV0dXJuIGVsZW0udmFsdWUgfHwgJyc7XG4gICAgfVxuXG4gICAgYXN5bmMgY29ubmVjdGVkQ2FsbGJhY2soKSB7XG4gICAgICAgIHN1cGVyLmNvbm5lY3RlZENhbGxiYWNrKCk7XG5cbiAgICAgICAgT2JzZXJ2ZShcbiAgICAgICAgICAgICgpID0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdGhpcy5nZXRSYXdDb21tZW50Qm94VGV4dCgpO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICgpID0+IHtcbiAgICAgICAgICAgICAgICB0aGlzLnJlZnJlc2hXYXJuaW5nQXBwbGljYWJsZSgpO1xuICAgICAgICAgICAgfVxuICAgICAgICApO1xuICAgIH1cblxuICAgIHJlZnJlc2hXYXJuaW5nQXBwbGljYWJsZSgpIHtcbiAgICAgICAgY29uc3QgdGV4dCA9IHRoaXMuZ2V0UmF3Q29tbWVudEJveFRleHQoKTtcbiAgICAgICAgY29uc3Qgd29yZHMgPSBuZXcgU2V0KHRleHQudG9Mb3dlckNhc2UoKS5zcGxpdCgnICcpKTtcblxuICAgICAgICBjb25zdCBoYXNUcmlnZ2VyV29yZCA9IFsnYnV5JywgJ3NlbGwnLCAnYm91Z2h0JywgJ3NvbGQnLCAnY3NmbG9hdCddLnNvbWUoKGUpID0+IHdvcmRzLmhhcyhlKSk7XG4gICAgICAgIHRoaXMuc2hvdyA9IGhhc1RyaWdnZXJXb3JkO1xuICAgIH1cblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgaWYgKCF0aGlzLnNob3cpIHtcbiAgICAgICAgICAgIHJldHVybiBodG1sYGA7XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gaHRtbGA8ZGl2IGNsYXNzPVwiY29udGFpbmVyXCI+XG4gICAgICAgICAgICA8Yj5XQVJOSU5HOjwvYj4gQ29tbWVudGluZyBvbiBwcm9maWxlcyB3aXRoIHdvcmRzIHJlbGF0aW5nIHRvIGJ1eWluZyBhbmQgc2VsbGluZyBDUzIgaXRlbXNcbiAgICAgICAgICAgIDxiPldJTEw8L2I+IHJlc3VsdCBpbiBhIFN0ZWFtIGNvbW11bml0eSBiYW4hXG4gICAgICAgIDwvZGl2PmA7XG4gICAgfVxufVxuIiwiaW1wb3J0IHtFeGVjdXRlU2NyaXB0T25QYWdlfSBmcm9tICcuLi9icmlkZ2UvaGFuZGxlcnMvZXhlY3V0ZV9zY3JpcHQnO1xuaW1wb3J0IHtDbGllbnRTZW5kfSBmcm9tICcuLi9icmlkZ2UvY2xpZW50JztcbmltcG9ydCB7aW5QYWdlQ29udGV4dH0gZnJvbSAnLi4vdXRpbHMvc25pcHMnO1xuaW1wb3J0IHtFeGVjdXRlQ3NzT25QYWdlfSBmcm9tICcuLi9icmlkZ2UvaGFuZGxlcnMvZXhlY3V0ZV9jc3MnO1xuaW1wb3J0IHtGZXRjaEV4dGVuc2lvbkZpbGV9IGZyb20gJy4uL2JyaWRnZS9oYW5kbGVycy9mZXRjaF9leHRlbnNpb25fZmlsZSc7XG5pbXBvcnQge2lzRmlyZWZveH0gZnJvbSAnLi4vdXRpbHMvZGV0ZWN0JztcbmltcG9ydCB7Z19Qb3N0TWVzc2FnZUJ1c30gZnJvbSAnLi4vYnVzL3Bvc3RfbWVzc2FnZV9idXMnO1xuXG5hc3luYyBmdW5jdGlvbiBpbml0aWF0ZUNocm9taXVtKHNjcmlwdFBhdGg6IHN0cmluZykge1xuICAgIENsaWVudFNlbmQoRXhlY3V0ZUNzc09uUGFnZSwge1xuICAgICAgICBwYXRoOiAnc3JjL2dsb2JhbC5jc3MnLFxuICAgIH0pO1xuXG4gICAgQ2xpZW50U2VuZChFeGVjdXRlU2NyaXB0T25QYWdlLCB7XG4gICAgICAgIHBhdGg6IHNjcmlwdFBhdGgsXG4gICAgfSk7XG59XG5cbmFzeW5jIGZ1bmN0aW9uIGluaXRpYXRlRmlyZWZveChzY3JpcHRQYXRoOiBzdHJpbmcpIHtcbiAgICBnX1Bvc3RNZXNzYWdlQnVzLmhhbmRsZVJlcXVlc3RzKCk7XG5cbiAgICAvLyBXaHkgZG8gd2UgbmVlZCB0byB1c2UgbWFudWFsIERPTSBzY3JpcHQgaW5qZWN0aW9uIGFuZFxuICAgIC8vIGZldGNoIHRoZSB0ZXh0IG9mIHRoZSBzY3JpcHQ/XG4gICAgLy8gU2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9jc2Zsb2F0L2V4dGVuc2lvbi9pc3N1ZXMvMTU1I2lzc3VlY29tbWVudC0xNjM5NzgxOTE0XG5cbiAgICAvLyBXZSB3YW50IHRvIGluamVjdCB0aGUgSUQgb2YgdGhlIGV4dGVuc2lvblxuICAgIGNvbnN0IGlkID0gYnJvd3Nlci5ydW50aW1lLmlkO1xuICAgIGNvbnN0IGVudHJ5U2NyaXB0ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnc2NyaXB0Jyk7XG4gICAgZW50cnlTY3JpcHQuYXBwZW5kQ2hpbGQoXG4gICAgICAgIGRvY3VtZW50LmNyZWF0ZVRleHROb2RlKGBcbiAgICAgICAgd2luZG93LkNTRkxPQVRfRVhURU5TSU9OX0lEID0gJyR7aWR9JztcbiAgICBgKVxuICAgICk7XG4gICAgZG9jdW1lbnQuaGVhZC5hcHBlbmRDaGlsZChlbnRyeVNjcmlwdCk7XG5cbiAgICBjb25zdCBzY3JpcHRSZXNwID0gYXdhaXQgQ2xpZW50U2VuZChGZXRjaEV4dGVuc2lvbkZpbGUsIHtcbiAgICAgICAgcGF0aDogc2NyaXB0UGF0aCxcbiAgICB9KTtcblxuICAgIGNvbnN0IHNjcmlwdCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ3NjcmlwdCcpO1xuICAgIHNjcmlwdC5hcHBlbmRDaGlsZChkb2N1bWVudC5jcmVhdGVUZXh0Tm9kZShzY3JpcHRSZXNwLnRleHQpKTtcbiAgICBkb2N1bWVudC5oZWFkLmFwcGVuZENoaWxkKHNjcmlwdCk7XG5cbiAgICBjb25zdCBzdHlsZVJlc3AgPSBhd2FpdCBDbGllbnRTZW5kKEZldGNoRXh0ZW5zaW9uRmlsZSwge1xuICAgICAgICBwYXRoOiAnc3JjL2dsb2JhbC5jc3MnLFxuICAgIH0pO1xuXG4gICAgY29uc3Qgc3R5bGUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzdHlsZScpO1xuICAgIHN0eWxlLmFwcGVuZENoaWxkKGRvY3VtZW50LmNyZWF0ZVRleHROb2RlKHN0eWxlUmVzcC50ZXh0KSk7XG4gICAgZG9jdW1lbnQuaGVhZC5hcHBlbmRDaGlsZChzdHlsZSk7XG59XG4vKipcbiAqIEluaXRpYWxpemVzIGEgcGFnZSBzY3JpcHQsIGV4ZWN1dGluZyBpdCBpbiB0aGUgcGFnZSBjb250ZXh0IGlmIG5lY2Vzc2FyeVxuICpcbiAqIEBwYXJhbSBzY3JpcHRQYXRoIFJlbGF0aXZlIHBhdGggb2YgdGhlIHNjcmlwdCAoYWx3YXlzIGluIC5qcylcbiAqIEBwYXJhbSBpZlBhZ2UgRm4gdG8gcnVuIGlmIHdlIGFyZSBpbiB0aGUgcGFnZSdzIGV4ZWN1dGlvbiBjb250ZXh0XG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBpbml0KHNjcmlwdFBhdGg6IHN0cmluZywgaWZQYWdlOiAoKSA9PiBhbnkpIHtcbiAgICAvLyBEb24ndCBhbGxvdyB0aGUgcGFnZSBzY3JpcHQgdG8gcnVuIHRoaXMuXG4gICAgaWYgKGluUGFnZUNvbnRleHQoKSkge1xuICAgICAgICAvLyBAdHMtaWdub3JlIFNldCBnbG9iYWwgaWRlbnRpZmllciBmb3Igb3RoZXIgZXh0ZW5zaW9ucyB0byB1c2VcbiAgICAgICAgd2luZG93LmNzZmxvYXQgPSB0cnVlO1xuICAgICAgICAvLyBAdHMtaWdub3JlIERlcHJlY2F0ZWQgbmFtZVxuICAgICAgICB3aW5kb3cuY3Nnb2Zsb2F0ID0gdHJ1ZTtcblxuICAgICAgICBpZlBhZ2UoKTtcbiAgICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGlmIChpc0ZpcmVmb3goKSkge1xuICAgICAgICBhd2FpdCBpbml0aWF0ZUZpcmVmb3goc2NyaXB0UGF0aCk7XG4gICAgfSBlbHNlIHtcbiAgICAgICAgYXdhaXQgaW5pdGlhdGVDaHJvbWl1bShzY3JpcHRQYXRoKTtcbiAgICB9XG5cbiAgICBjb25zb2xlLmxvZyhcbiAgICAgICAgYCVjIENTRmxvYXQgTWFya2V0IENoZWNrZXIgKHYke2Nocm9tZS5ydW50aW1lLmdldE1hbmlmZXN0KCkudmVyc2lvbn0pIGJ5IFN0ZXA3NzUwIGAsXG4gICAgICAgICdiYWNrZ3JvdW5kOiAjMDA0NTk0OyBjb2xvcjogI2ZmZjsnXG4gICAgKTtcbiAgICBjb25zb2xlLmxvZyhcbiAgICAgICAgJyVjIENoYW5nZWxvZyBjYW4gYmUgZm91bmQgaGVyZTogaHR0cHM6Ly9naXRodWIuY29tL2NzZmxvYXQvZXh0ZW5zaW9uICcsXG4gICAgICAgICdiYWNrZ3JvdW5kOiAjMDA0NTk0OyBjb2xvcjogI2ZmZjsnXG4gICAgKTtcbn1cbiIsImV4cG9ydCBmdW5jdGlvbiBpc0ZpcmVmb3goKSB7XG4gICAgcmV0dXJuIG5hdmlnYXRvci51c2VyQWdlbnQudG9Mb3dlckNhc2UoKS5pbmRleE9mKCdmaXJlZm94JykgPiAtMTtcbn1cblxuLyoqXG4gKiBUaGFua3MgdG8gb3VyIGJyb3dzZXIgb3ZlcmxvcmRzLCB3ZSBoYXZlIHR3byBuYW1lc3BhY2VzIGZvciBgeC5ydW50aW1lLmZuKClgXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBydW50aW1lTmFtZXNwYWNlKCkge1xuICAgIGlmIChpc0ZpcmVmb3goKSkge1xuICAgICAgICByZXR1cm4gYnJvd3NlcjtcbiAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gY2hyb21lO1xuICAgIH1cbn1cbiIsImV4cG9ydCBmdW5jdGlvbiBPYnNlcnZlPFQ+KGNvbXB1dGVPYmplY3Q6ICgpID0+IFQsIGNiOiAoKSA9PiBhbnksIHBvbGxSYXRlTXMgPSA1MCkge1xuICAgIGxldCBwcmV2ID0gY29tcHV0ZU9iamVjdCgpO1xuXG4gICAgc2V0SW50ZXJ2YWwoKCkgPT4ge1xuICAgICAgICBjb25zdCBub3cgPSBjb21wdXRlT2JqZWN0KCk7XG4gICAgICAgIGlmIChwcmV2ICE9PSBub3cpIHtcbiAgICAgICAgICAgIGNiKCk7XG4gICAgICAgIH1cbiAgICAgICAgcHJldiA9IG5vdztcbiAgICB9LCBwb2xsUmF0ZU1zKTtcbn1cbiIsImV4cG9ydCBmdW5jdGlvbiBpblBhZ2VDb250ZXh0KCkge1xuICAgIHJldHVybiB0eXBlb2YgY2hyb21lID09PSAndW5kZWZpbmVkJyB8fCAhY2hyb21lLmV4dGVuc2lvbjtcbn1cbiIsIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE5IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL1xuY29uc3QgdD13aW5kb3csZT10LlNoYWRvd1Jvb3QmJih2b2lkIDA9PT10LlNoYWR5Q1NTfHx0LlNoYWR5Q1NTLm5hdGl2ZVNoYWRvdykmJlwiYWRvcHRlZFN0eWxlU2hlZXRzXCJpbiBEb2N1bWVudC5wcm90b3R5cGUmJlwicmVwbGFjZVwiaW4gQ1NTU3R5bGVTaGVldC5wcm90b3R5cGUscz1TeW1ib2woKSxuPW5ldyBXZWFrTWFwO2NsYXNzIG97Y29uc3RydWN0b3IodCxlLG4pe2lmKHRoaXMuXyRjc3NSZXN1bHQkPSEwLG4hPT1zKXRocm93IEVycm9yKFwiQ1NTUmVzdWx0IGlzIG5vdCBjb25zdHJ1Y3RhYmxlLiBVc2UgYHVuc2FmZUNTU2Agb3IgYGNzc2AgaW5zdGVhZC5cIik7dGhpcy5jc3NUZXh0PXQsdGhpcy50PWV9Z2V0IHN0eWxlU2hlZXQoKXtsZXQgdD10aGlzLm87Y29uc3Qgcz10aGlzLnQ7aWYoZSYmdm9pZCAwPT09dCl7Y29uc3QgZT12b2lkIDAhPT1zJiYxPT09cy5sZW5ndGg7ZSYmKHQ9bi5nZXQocykpLHZvaWQgMD09PXQmJigodGhpcy5vPXQ9bmV3IENTU1N0eWxlU2hlZXQpLnJlcGxhY2VTeW5jKHRoaXMuY3NzVGV4dCksZSYmbi5zZXQocyx0KSl9cmV0dXJuIHR9dG9TdHJpbmcoKXtyZXR1cm4gdGhpcy5jc3NUZXh0fX1jb25zdCByPXQ9Pm5ldyBvKFwic3RyaW5nXCI9PXR5cGVvZiB0P3Q6dCtcIlwiLHZvaWQgMCxzKSxpPSh0LC4uLmUpPT57Y29uc3Qgbj0xPT09dC5sZW5ndGg/dFswXTplLnJlZHVjZSgoKGUscyxuKT0+ZSsodD0+e2lmKCEwPT09dC5fJGNzc1Jlc3VsdCQpcmV0dXJuIHQuY3NzVGV4dDtpZihcIm51bWJlclwiPT10eXBlb2YgdClyZXR1cm4gdDt0aHJvdyBFcnJvcihcIlZhbHVlIHBhc3NlZCB0byAnY3NzJyBmdW5jdGlvbiBtdXN0IGJlIGEgJ2NzcycgZnVuY3Rpb24gcmVzdWx0OiBcIit0K1wiLiBVc2UgJ3Vuc2FmZUNTUycgdG8gcGFzcyBub24tbGl0ZXJhbCB2YWx1ZXMsIGJ1dCB0YWtlIGNhcmUgdG8gZW5zdXJlIHBhZ2Ugc2VjdXJpdHkuXCIpfSkocykrdFtuKzFdKSx0WzBdKTtyZXR1cm4gbmV3IG8obix0LHMpfSxTPShzLG4pPT57ZT9zLmFkb3B0ZWRTdHlsZVNoZWV0cz1uLm1hcCgodD0+dCBpbnN0YW5jZW9mIENTU1N0eWxlU2hlZXQ/dDp0LnN0eWxlU2hlZXQpKTpuLmZvckVhY2goKGU9Pntjb25zdCBuPWRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoXCJzdHlsZVwiKSxvPXQubGl0Tm9uY2U7dm9pZCAwIT09byYmbi5zZXRBdHRyaWJ1dGUoXCJub25jZVwiLG8pLG4udGV4dENvbnRlbnQ9ZS5jc3NUZXh0LHMuYXBwZW5kQ2hpbGQobil9KSl9LGM9ZT90PT50OnQ9PnQgaW5zdGFuY2VvZiBDU1NTdHlsZVNoZWV0Pyh0PT57bGV0IGU9XCJcIjtmb3IoY29uc3QgcyBvZiB0LmNzc1J1bGVzKWUrPXMuY3NzVGV4dDtyZXR1cm4gcihlKX0pKHQpOnQ7ZXhwb3J0e28gYXMgQ1NTUmVzdWx0LFMgYXMgYWRvcHRTdHlsZXMsaSBhcyBjc3MsYyBhcyBnZXRDb21wYXRpYmxlU3R5bGUsZSBhcyBzdXBwb3J0c0Fkb3B0aW5nU3R5bGVTaGVldHMsciBhcyB1bnNhZmVDU1N9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9Y3NzLXRhZy5qcy5tYXBcbiIsIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL1xuY29uc3QgZT0oZSx0LG8pPT57T2JqZWN0LmRlZmluZVByb3BlcnR5KHQsbyxlKX0sdD0oZSx0KT0+KHtraW5kOlwibWV0aG9kXCIscGxhY2VtZW50OlwicHJvdG90eXBlXCIsa2V5OnQua2V5LGRlc2NyaXB0b3I6ZX0pLG89KHtmaW5pc2hlcjplLGRlc2NyaXB0b3I6dH0pPT4obyxuKT0+e3ZhciByO2lmKHZvaWQgMD09PW4pe2NvbnN0IG49bnVsbCE9PShyPW8ub3JpZ2luYWxLZXkpJiZ2b2lkIDAhPT1yP3I6by5rZXksaT1udWxsIT10P3traW5kOlwibWV0aG9kXCIscGxhY2VtZW50OlwicHJvdG90eXBlXCIsa2V5Om4sZGVzY3JpcHRvcjp0KG8ua2V5KX06ey4uLm8sa2V5Om59O3JldHVybiBudWxsIT1lJiYoaS5maW5pc2hlcj1mdW5jdGlvbih0KXtlKHQsbil9KSxpfXtjb25zdCByPW8uY29uc3RydWN0b3I7dm9pZCAwIT09dCYmT2JqZWN0LmRlZmluZVByb3BlcnR5KG8sbix0KG4pKSxudWxsPT1lfHxlKHIsbil9fTtleHBvcnR7byBhcyBkZWNvcmF0ZVByb3BlcnR5LGUgYXMgbGVnYWN5UHJvdG90eXBlTWV0aG9kLHQgYXMgc3RhbmRhcmRQcm90b3R5cGVNZXRob2R9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9YmFzZS5qcy5tYXBcbiIsIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL1xuY29uc3QgZT1lPT5uPT5cImZ1bmN0aW9uXCI9PXR5cGVvZiBuPygoZSxuKT0+KGN1c3RvbUVsZW1lbnRzLmRlZmluZShlLG4pLG4pKShlLG4pOigoZSxuKT0+e2NvbnN0e2tpbmQ6dCxlbGVtZW50czpzfT1uO3JldHVybntraW5kOnQsZWxlbWVudHM6cyxmaW5pc2hlcihuKXtjdXN0b21FbGVtZW50cy5kZWZpbmUoZSxuKX19fSkoZSxuKTtleHBvcnR7ZSBhcyBjdXN0b21FbGVtZW50fTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWN1c3RvbS1lbGVtZW50LmpzLm1hcFxuIiwiaW1wb3J0e2RlY29yYXRlUHJvcGVydHkgYXMgcn1mcm9tXCIuL2Jhc2UuanNcIjtcbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL2Z1bmN0aW9uIGUoZSl7cmV0dXJuIHIoe2ZpbmlzaGVyOihyLHQpPT57T2JqZWN0LmFzc2lnbihyLnByb3RvdHlwZVt0XSxlKX19KX1leHBvcnR7ZSBhcyBldmVudE9wdGlvbnN9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9ZXZlbnQtb3B0aW9ucy5qcy5tYXBcbiIsIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL1xuY29uc3QgaT0oaSxlKT0+XCJtZXRob2RcIj09PWUua2luZCYmZS5kZXNjcmlwdG9yJiYhKFwidmFsdWVcImluIGUuZGVzY3JpcHRvcik/ey4uLmUsZmluaXNoZXIobil7bi5jcmVhdGVQcm9wZXJ0eShlLmtleSxpKX19OntraW5kOlwiZmllbGRcIixrZXk6U3ltYm9sKCkscGxhY2VtZW50Olwib3duXCIsZGVzY3JpcHRvcjp7fSxvcmlnaW5hbEtleTplLmtleSxpbml0aWFsaXplcigpe1wiZnVuY3Rpb25cIj09dHlwZW9mIGUuaW5pdGlhbGl6ZXImJih0aGlzW2Uua2V5XT1lLmluaXRpYWxpemVyLmNhbGwodGhpcykpfSxmaW5pc2hlcihuKXtuLmNyZWF0ZVByb3BlcnR5KGUua2V5LGkpfX07ZnVuY3Rpb24gZShlKXtyZXR1cm4obix0KT0+dm9pZCAwIT09dD8oKGksZSxuKT0+e2UuY29uc3RydWN0b3IuY3JlYXRlUHJvcGVydHkobixpKX0pKGUsbix0KTppKGUsbil9ZXhwb3J0e2UgYXMgcHJvcGVydHl9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cHJvcGVydHkuanMubWFwXG4iLCJpbXBvcnR7ZGVjb3JhdGVQcm9wZXJ0eSBhcyByfWZyb21cIi4vYmFzZS5qc1wiO1xuLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IDIwMTcgR29vZ2xlIExMQ1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEJTRC0zLUNsYXVzZVxuICovZnVuY3Rpb24gZShlKXtyZXR1cm4gcih7ZGVzY3JpcHRvcjpyPT4oe2dldCgpe3ZhciByLG87cmV0dXJuIG51bGwhPT0obz1udWxsPT09KHI9dGhpcy5yZW5kZXJSb290KXx8dm9pZCAwPT09cj92b2lkIDA6ci5xdWVyeVNlbGVjdG9yQWxsKGUpKSYmdm9pZCAwIT09bz9vOltdfSxlbnVtZXJhYmxlOiEwLGNvbmZpZ3VyYWJsZTohMH0pfSl9ZXhwb3J0e2UgYXMgcXVlcnlBbGx9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cXVlcnktYWxsLmpzLm1hcFxuIiwiaW1wb3J0e2RlY29yYXRlUHJvcGVydHkgYXMgb31mcm9tXCIuL2Jhc2UuanNcIjtcbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDIxIEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL3ZhciBuO2NvbnN0IGU9bnVsbCE9KG51bGw9PT0obj13aW5kb3cuSFRNTFNsb3RFbGVtZW50KXx8dm9pZCAwPT09bj92b2lkIDA6bi5wcm90b3R5cGUuYXNzaWduZWRFbGVtZW50cyk/KG8sbik9Pm8uYXNzaWduZWRFbGVtZW50cyhuKToobyxuKT0+by5hc3NpZ25lZE5vZGVzKG4pLmZpbHRlcigobz0+by5ub2RlVHlwZT09PU5vZGUuRUxFTUVOVF9OT0RFKSk7ZnVuY3Rpb24gbChuKXtjb25zdHtzbG90Omwsc2VsZWN0b3I6dH09bnVsbCE9bj9uOnt9O3JldHVybiBvKHtkZXNjcmlwdG9yOm89Pih7Z2V0KCl7dmFyIG87Y29uc3Qgcj1cInNsb3RcIisobD9gW25hbWU9JHtsfV1gOlwiOm5vdChbbmFtZV0pXCIpLGk9bnVsbD09PShvPXRoaXMucmVuZGVyUm9vdCl8fHZvaWQgMD09PW8/dm9pZCAwOm8ucXVlcnlTZWxlY3RvcihyKSxzPW51bGwhPWk/ZShpLG4pOltdO3JldHVybiB0P3MuZmlsdGVyKChvPT5vLm1hdGNoZXModCkpKTpzfSxlbnVtZXJhYmxlOiEwLGNvbmZpZ3VyYWJsZTohMH0pfSl9ZXhwb3J0e2wgYXMgcXVlcnlBc3NpZ25lZEVsZW1lbnRzfTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXF1ZXJ5LWFzc2lnbmVkLWVsZW1lbnRzLmpzLm1hcFxuIiwiaW1wb3J0e2RlY29yYXRlUHJvcGVydHkgYXMgZX1mcm9tXCIuL2Jhc2UuanNcIjtpbXBvcnR7cXVlcnlBc3NpZ25lZEVsZW1lbnRzIGFzIHR9ZnJvbVwiLi9xdWVyeS1hc3NpZ25lZC1lbGVtZW50cy5qc1wiO1xuLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IDIwMTcgR29vZ2xlIExMQ1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEJTRC0zLUNsYXVzZVxuICovZnVuY3Rpb24gbyhvLG4scil7bGV0IGwscz1vO3JldHVyblwib2JqZWN0XCI9PXR5cGVvZiBvPyhzPW8uc2xvdCxsPW8pOmw9e2ZsYXR0ZW46bn0scj90KHtzbG90OnMsZmxhdHRlbjpuLHNlbGVjdG9yOnJ9KTplKHtkZXNjcmlwdG9yOmU9Pih7Z2V0KCl7dmFyIGUsdDtjb25zdCBvPVwic2xvdFwiKyhzP2BbbmFtZT0ke3N9XWA6XCI6bm90KFtuYW1lXSlcIiksbj1udWxsPT09KGU9dGhpcy5yZW5kZXJSb290KXx8dm9pZCAwPT09ZT92b2lkIDA6ZS5xdWVyeVNlbGVjdG9yKG8pO3JldHVybiBudWxsIT09KHQ9bnVsbD09bj92b2lkIDA6bi5hc3NpZ25lZE5vZGVzKGwpKSYmdm9pZCAwIT09dD90OltdfSxlbnVtZXJhYmxlOiEwLGNvbmZpZ3VyYWJsZTohMH0pfSl9ZXhwb3J0e28gYXMgcXVlcnlBc3NpZ25lZE5vZGVzfTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXF1ZXJ5LWFzc2lnbmVkLW5vZGVzLmpzLm1hcFxuIiwiaW1wb3J0e2RlY29yYXRlUHJvcGVydHkgYXMgcn1mcm9tXCIuL2Jhc2UuanNcIjtcbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL1xuZnVuY3Rpb24gZShlKXtyZXR1cm4gcih7ZGVzY3JpcHRvcjpyPT4oe2FzeW5jIGdldCgpe3ZhciByO3JldHVybiBhd2FpdCB0aGlzLnVwZGF0ZUNvbXBsZXRlLG51bGw9PT0ocj10aGlzLnJlbmRlclJvb3QpfHx2b2lkIDA9PT1yP3ZvaWQgMDpyLnF1ZXJ5U2VsZWN0b3IoZSl9LGVudW1lcmFibGU6ITAsY29uZmlndXJhYmxlOiEwfSl9KX1leHBvcnR7ZSBhcyBxdWVyeUFzeW5jfTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXF1ZXJ5LWFzeW5jLmpzLm1hcFxuIiwiaW1wb3J0e2RlY29yYXRlUHJvcGVydHkgYXMgb31mcm9tXCIuL2Jhc2UuanNcIjtcbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL2Z1bmN0aW9uIGkoaSxuKXtyZXR1cm4gbyh7ZGVzY3JpcHRvcjpvPT57Y29uc3QgdD17Z2V0KCl7dmFyIG8sbjtyZXR1cm4gbnVsbCE9PShuPW51bGw9PT0obz10aGlzLnJlbmRlclJvb3QpfHx2b2lkIDA9PT1vP3ZvaWQgMDpvLnF1ZXJ5U2VsZWN0b3IoaSkpJiZ2b2lkIDAhPT1uP246bnVsbH0sZW51bWVyYWJsZTohMCxjb25maWd1cmFibGU6ITB9O2lmKG4pe2NvbnN0IG49XCJzeW1ib2xcIj09dHlwZW9mIG8/U3ltYm9sKCk6XCJfX1wiK287dC5nZXQ9ZnVuY3Rpb24oKXt2YXIgbyx0O3JldHVybiB2b2lkIDA9PT10aGlzW25dJiYodGhpc1tuXT1udWxsIT09KHQ9bnVsbD09PShvPXRoaXMucmVuZGVyUm9vdCl8fHZvaWQgMD09PW8/dm9pZCAwOm8ucXVlcnlTZWxlY3RvcihpKSkmJnZvaWQgMCE9PXQ/dDpudWxsKSx0aGlzW25dfX1yZXR1cm4gdH19KX1leHBvcnR7aSBhcyBxdWVyeX07XG4vLyMgc291cmNlTWFwcGluZ1VSTD1xdWVyeS5qcy5tYXBcbiIsImltcG9ydHtwcm9wZXJ0eSBhcyByfWZyb21cIi4vcHJvcGVydHkuanNcIjtcbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL2Z1bmN0aW9uIHQodCl7cmV0dXJuIHIoey4uLnQsc3RhdGU6ITB9KX1leHBvcnR7dCBhcyBzdGF0ZX07XG4vLyMgc291cmNlTWFwcGluZ1VSTD1zdGF0ZS5qcy5tYXBcbiIsImltcG9ydHtnZXRDb21wYXRpYmxlU3R5bGUgYXMgdCxhZG9wdFN0eWxlcyBhcyBpfWZyb21cIi4vY3NzLXRhZy5qc1wiO2V4cG9ydHtDU1NSZXN1bHQsYWRvcHRTdHlsZXMsY3NzLGdldENvbXBhdGlibGVTdHlsZSxzdXBwb3J0c0Fkb3B0aW5nU3R5bGVTaGVldHMsdW5zYWZlQ1NTfWZyb21cIi4vY3NzLXRhZy5qc1wiO1xuLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IDIwMTcgR29vZ2xlIExMQ1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEJTRC0zLUNsYXVzZVxuICovdmFyIHM7Y29uc3QgZT13aW5kb3cscj1lLnRydXN0ZWRUeXBlcyxoPXI/ci5lbXB0eVNjcmlwdDpcIlwiLG89ZS5yZWFjdGl2ZUVsZW1lbnRQb2x5ZmlsbFN1cHBvcnQsbj17dG9BdHRyaWJ1dGUodCxpKXtzd2l0Y2goaSl7Y2FzZSBCb29sZWFuOnQ9dD9oOm51bGw7YnJlYWs7Y2FzZSBPYmplY3Q6Y2FzZSBBcnJheTp0PW51bGw9PXQ/dDpKU09OLnN0cmluZ2lmeSh0KX1yZXR1cm4gdH0sZnJvbUF0dHJpYnV0ZSh0LGkpe2xldCBzPXQ7c3dpdGNoKGkpe2Nhc2UgQm9vbGVhbjpzPW51bGwhPT10O2JyZWFrO2Nhc2UgTnVtYmVyOnM9bnVsbD09PXQ/bnVsbDpOdW1iZXIodCk7YnJlYWs7Y2FzZSBPYmplY3Q6Y2FzZSBBcnJheTp0cnl7cz1KU09OLnBhcnNlKHQpfWNhdGNoKHQpe3M9bnVsbH19cmV0dXJuIHN9fSxhPSh0LGkpPT5pIT09dCYmKGk9PWl8fHQ9PXQpLGw9e2F0dHJpYnV0ZTohMCx0eXBlOlN0cmluZyxjb252ZXJ0ZXI6bixyZWZsZWN0OiExLGhhc0NoYW5nZWQ6YX07Y2xhc3MgZCBleHRlbmRzIEhUTUxFbGVtZW50e2NvbnN0cnVjdG9yKCl7c3VwZXIoKSx0aGlzLl8kRWk9bmV3IE1hcCx0aGlzLmlzVXBkYXRlUGVuZGluZz0hMSx0aGlzLmhhc1VwZGF0ZWQ9ITEsdGhpcy5fJEVsPW51bGwsdGhpcy51KCl9c3RhdGljIGFkZEluaXRpYWxpemVyKHQpe3ZhciBpO251bGwhPT0oaT10aGlzLmgpJiZ2b2lkIDAhPT1pfHwodGhpcy5oPVtdKSx0aGlzLmgucHVzaCh0KX1zdGF0aWMgZ2V0IG9ic2VydmVkQXR0cmlidXRlcygpe3RoaXMuZmluYWxpemUoKTtjb25zdCB0PVtdO3JldHVybiB0aGlzLmVsZW1lbnRQcm9wZXJ0aWVzLmZvckVhY2goKChpLHMpPT57Y29uc3QgZT10aGlzLl8kRXAocyxpKTt2b2lkIDAhPT1lJiYodGhpcy5fJEV2LnNldChlLHMpLHQucHVzaChlKSl9KSksdH1zdGF0aWMgY3JlYXRlUHJvcGVydHkodCxpPWwpe2lmKGkuc3RhdGUmJihpLmF0dHJpYnV0ZT0hMSksdGhpcy5maW5hbGl6ZSgpLHRoaXMuZWxlbWVudFByb3BlcnRpZXMuc2V0KHQsaSksIWkubm9BY2Nlc3NvciYmIXRoaXMucHJvdG90eXBlLmhhc093blByb3BlcnR5KHQpKXtjb25zdCBzPVwic3ltYm9sXCI9PXR5cGVvZiB0P1N5bWJvbCgpOlwiX19cIit0LGU9dGhpcy5nZXRQcm9wZXJ0eURlc2NyaXB0b3IodCxzLGkpO3ZvaWQgMCE9PWUmJk9iamVjdC5kZWZpbmVQcm9wZXJ0eSh0aGlzLnByb3RvdHlwZSx0LGUpfX1zdGF0aWMgZ2V0UHJvcGVydHlEZXNjcmlwdG9yKHQsaSxzKXtyZXR1cm57Z2V0KCl7cmV0dXJuIHRoaXNbaV19LHNldChlKXtjb25zdCByPXRoaXNbdF07dGhpc1tpXT1lLHRoaXMucmVxdWVzdFVwZGF0ZSh0LHIscyl9LGNvbmZpZ3VyYWJsZTohMCxlbnVtZXJhYmxlOiEwfX1zdGF0aWMgZ2V0UHJvcGVydHlPcHRpb25zKHQpe3JldHVybiB0aGlzLmVsZW1lbnRQcm9wZXJ0aWVzLmdldCh0KXx8bH1zdGF0aWMgZmluYWxpemUoKXtpZih0aGlzLmhhc093blByb3BlcnR5KFwiZmluYWxpemVkXCIpKXJldHVybiExO3RoaXMuZmluYWxpemVkPSEwO2NvbnN0IHQ9T2JqZWN0LmdldFByb3RvdHlwZU9mKHRoaXMpO2lmKHQuZmluYWxpemUoKSx0aGlzLmVsZW1lbnRQcm9wZXJ0aWVzPW5ldyBNYXAodC5lbGVtZW50UHJvcGVydGllcyksdGhpcy5fJEV2PW5ldyBNYXAsdGhpcy5oYXNPd25Qcm9wZXJ0eShcInByb3BlcnRpZXNcIikpe2NvbnN0IHQ9dGhpcy5wcm9wZXJ0aWVzLGk9Wy4uLk9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzKHQpLC4uLk9iamVjdC5nZXRPd25Qcm9wZXJ0eVN5bWJvbHModCldO2Zvcihjb25zdCBzIG9mIGkpdGhpcy5jcmVhdGVQcm9wZXJ0eShzLHRbc10pfXJldHVybiB0aGlzLmVsZW1lbnRTdHlsZXM9dGhpcy5maW5hbGl6ZVN0eWxlcyh0aGlzLnN0eWxlcyksITB9c3RhdGljIGZpbmFsaXplU3R5bGVzKGkpe2NvbnN0IHM9W107aWYoQXJyYXkuaXNBcnJheShpKSl7Y29uc3QgZT1uZXcgU2V0KGkuZmxhdCgxLzApLnJldmVyc2UoKSk7Zm9yKGNvbnN0IGkgb2YgZSlzLnVuc2hpZnQodChpKSl9ZWxzZSB2b2lkIDAhPT1pJiZzLnB1c2godChpKSk7cmV0dXJuIHN9c3RhdGljIF8kRXAodCxpKXtjb25zdCBzPWkuYXR0cmlidXRlO3JldHVybiExPT09cz92b2lkIDA6XCJzdHJpbmdcIj09dHlwZW9mIHM/czpcInN0cmluZ1wiPT10eXBlb2YgdD90LnRvTG93ZXJDYXNlKCk6dm9pZCAwfXUoKXt2YXIgdDt0aGlzLl8kRV89bmV3IFByb21pc2UoKHQ9PnRoaXMuZW5hYmxlVXBkYXRpbmc9dCkpLHRoaXMuXyRBTD1uZXcgTWFwLHRoaXMuXyRFZygpLHRoaXMucmVxdWVzdFVwZGF0ZSgpLG51bGw9PT0odD10aGlzLmNvbnN0cnVjdG9yLmgpfHx2b2lkIDA9PT10fHx0LmZvckVhY2goKHQ9PnQodGhpcykpKX1hZGRDb250cm9sbGVyKHQpe3ZhciBpLHM7KG51bGwhPT0oaT10aGlzLl8kRVMpJiZ2b2lkIDAhPT1pP2k6dGhpcy5fJEVTPVtdKS5wdXNoKHQpLHZvaWQgMCE9PXRoaXMucmVuZGVyUm9vdCYmdGhpcy5pc0Nvbm5lY3RlZCYmKG51bGw9PT0ocz10Lmhvc3RDb25uZWN0ZWQpfHx2b2lkIDA9PT1zfHxzLmNhbGwodCkpfXJlbW92ZUNvbnRyb2xsZXIodCl7dmFyIGk7bnVsbD09PShpPXRoaXMuXyRFUyl8fHZvaWQgMD09PWl8fGkuc3BsaWNlKHRoaXMuXyRFUy5pbmRleE9mKHQpPj4+MCwxKX1fJEVnKCl7dGhpcy5jb25zdHJ1Y3Rvci5lbGVtZW50UHJvcGVydGllcy5mb3JFYWNoKCgodCxpKT0+e3RoaXMuaGFzT3duUHJvcGVydHkoaSkmJih0aGlzLl8kRWkuc2V0KGksdGhpc1tpXSksZGVsZXRlIHRoaXNbaV0pfSkpfWNyZWF0ZVJlbmRlclJvb3QoKXt2YXIgdDtjb25zdCBzPW51bGwhPT0odD10aGlzLnNoYWRvd1Jvb3QpJiZ2b2lkIDAhPT10P3Q6dGhpcy5hdHRhY2hTaGFkb3codGhpcy5jb25zdHJ1Y3Rvci5zaGFkb3dSb290T3B0aW9ucyk7cmV0dXJuIGkocyx0aGlzLmNvbnN0cnVjdG9yLmVsZW1lbnRTdHlsZXMpLHN9Y29ubmVjdGVkQ2FsbGJhY2soKXt2YXIgdDt2b2lkIDA9PT10aGlzLnJlbmRlclJvb3QmJih0aGlzLnJlbmRlclJvb3Q9dGhpcy5jcmVhdGVSZW5kZXJSb290KCkpLHRoaXMuZW5hYmxlVXBkYXRpbmcoITApLG51bGw9PT0odD10aGlzLl8kRVMpfHx2b2lkIDA9PT10fHx0LmZvckVhY2goKHQ9Pnt2YXIgaTtyZXR1cm4gbnVsbD09PShpPXQuaG9zdENvbm5lY3RlZCl8fHZvaWQgMD09PWk/dm9pZCAwOmkuY2FsbCh0KX0pKX1lbmFibGVVcGRhdGluZyh0KXt9ZGlzY29ubmVjdGVkQ2FsbGJhY2soKXt2YXIgdDtudWxsPT09KHQ9dGhpcy5fJEVTKXx8dm9pZCAwPT09dHx8dC5mb3JFYWNoKCh0PT57dmFyIGk7cmV0dXJuIG51bGw9PT0oaT10Lmhvc3REaXNjb25uZWN0ZWQpfHx2b2lkIDA9PT1pP3ZvaWQgMDppLmNhbGwodCl9KSl9YXR0cmlidXRlQ2hhbmdlZENhbGxiYWNrKHQsaSxzKXt0aGlzLl8kQUsodCxzKX1fJEVPKHQsaSxzPWwpe3ZhciBlO2NvbnN0IHI9dGhpcy5jb25zdHJ1Y3Rvci5fJEVwKHQscyk7aWYodm9pZCAwIT09ciYmITA9PT1zLnJlZmxlY3Qpe2NvbnN0IGg9KHZvaWQgMCE9PShudWxsPT09KGU9cy5jb252ZXJ0ZXIpfHx2b2lkIDA9PT1lP3ZvaWQgMDplLnRvQXR0cmlidXRlKT9zLmNvbnZlcnRlcjpuKS50b0F0dHJpYnV0ZShpLHMudHlwZSk7dGhpcy5fJEVsPXQsbnVsbD09aD90aGlzLnJlbW92ZUF0dHJpYnV0ZShyKTp0aGlzLnNldEF0dHJpYnV0ZShyLGgpLHRoaXMuXyRFbD1udWxsfX1fJEFLKHQsaSl7dmFyIHM7Y29uc3QgZT10aGlzLmNvbnN0cnVjdG9yLHI9ZS5fJEV2LmdldCh0KTtpZih2b2lkIDAhPT1yJiZ0aGlzLl8kRWwhPT1yKXtjb25zdCB0PWUuZ2V0UHJvcGVydHlPcHRpb25zKHIpLGg9XCJmdW5jdGlvblwiPT10eXBlb2YgdC5jb252ZXJ0ZXI/e2Zyb21BdHRyaWJ1dGU6dC5jb252ZXJ0ZXJ9OnZvaWQgMCE9PShudWxsPT09KHM9dC5jb252ZXJ0ZXIpfHx2b2lkIDA9PT1zP3ZvaWQgMDpzLmZyb21BdHRyaWJ1dGUpP3QuY29udmVydGVyOm47dGhpcy5fJEVsPXIsdGhpc1tyXT1oLmZyb21BdHRyaWJ1dGUoaSx0LnR5cGUpLHRoaXMuXyRFbD1udWxsfX1yZXF1ZXN0VXBkYXRlKHQsaSxzKXtsZXQgZT0hMDt2b2lkIDAhPT10JiYoKChzPXN8fHRoaXMuY29uc3RydWN0b3IuZ2V0UHJvcGVydHlPcHRpb25zKHQpKS5oYXNDaGFuZ2VkfHxhKSh0aGlzW3RdLGkpPyh0aGlzLl8kQUwuaGFzKHQpfHx0aGlzLl8kQUwuc2V0KHQsaSksITA9PT1zLnJlZmxlY3QmJnRoaXMuXyRFbCE9PXQmJih2b2lkIDA9PT10aGlzLl8kRUMmJih0aGlzLl8kRUM9bmV3IE1hcCksdGhpcy5fJEVDLnNldCh0LHMpKSk6ZT0hMSksIXRoaXMuaXNVcGRhdGVQZW5kaW5nJiZlJiYodGhpcy5fJEVfPXRoaXMuXyRFaigpKX1hc3luYyBfJEVqKCl7dGhpcy5pc1VwZGF0ZVBlbmRpbmc9ITA7dHJ5e2F3YWl0IHRoaXMuXyRFX31jYXRjaCh0KXtQcm9taXNlLnJlamVjdCh0KX1jb25zdCB0PXRoaXMuc2NoZWR1bGVVcGRhdGUoKTtyZXR1cm4gbnVsbCE9dCYmYXdhaXQgdCwhdGhpcy5pc1VwZGF0ZVBlbmRpbmd9c2NoZWR1bGVVcGRhdGUoKXtyZXR1cm4gdGhpcy5wZXJmb3JtVXBkYXRlKCl9cGVyZm9ybVVwZGF0ZSgpe3ZhciB0O2lmKCF0aGlzLmlzVXBkYXRlUGVuZGluZylyZXR1cm47dGhpcy5oYXNVcGRhdGVkLHRoaXMuXyRFaSYmKHRoaXMuXyRFaS5mb3JFYWNoKCgodCxpKT0+dGhpc1tpXT10KSksdGhpcy5fJEVpPXZvaWQgMCk7bGV0IGk9ITE7Y29uc3Qgcz10aGlzLl8kQUw7dHJ5e2k9dGhpcy5zaG91bGRVcGRhdGUocyksaT8odGhpcy53aWxsVXBkYXRlKHMpLG51bGw9PT0odD10aGlzLl8kRVMpfHx2b2lkIDA9PT10fHx0LmZvckVhY2goKHQ9Pnt2YXIgaTtyZXR1cm4gbnVsbD09PShpPXQuaG9zdFVwZGF0ZSl8fHZvaWQgMD09PWk/dm9pZCAwOmkuY2FsbCh0KX0pKSx0aGlzLnVwZGF0ZShzKSk6dGhpcy5fJEVrKCl9Y2F0Y2godCl7dGhyb3cgaT0hMSx0aGlzLl8kRWsoKSx0fWkmJnRoaXMuXyRBRShzKX13aWxsVXBkYXRlKHQpe31fJEFFKHQpe3ZhciBpO251bGw9PT0oaT10aGlzLl8kRVMpfHx2b2lkIDA9PT1pfHxpLmZvckVhY2goKHQ9Pnt2YXIgaTtyZXR1cm4gbnVsbD09PShpPXQuaG9zdFVwZGF0ZWQpfHx2b2lkIDA9PT1pP3ZvaWQgMDppLmNhbGwodCl9KSksdGhpcy5oYXNVcGRhdGVkfHwodGhpcy5oYXNVcGRhdGVkPSEwLHRoaXMuZmlyc3RVcGRhdGVkKHQpKSx0aGlzLnVwZGF0ZWQodCl9XyRFaygpe3RoaXMuXyRBTD1uZXcgTWFwLHRoaXMuaXNVcGRhdGVQZW5kaW5nPSExfWdldCB1cGRhdGVDb21wbGV0ZSgpe3JldHVybiB0aGlzLmdldFVwZGF0ZUNvbXBsZXRlKCl9Z2V0VXBkYXRlQ29tcGxldGUoKXtyZXR1cm4gdGhpcy5fJEVffXNob3VsZFVwZGF0ZSh0KXtyZXR1cm4hMH11cGRhdGUodCl7dm9pZCAwIT09dGhpcy5fJEVDJiYodGhpcy5fJEVDLmZvckVhY2goKCh0LGkpPT50aGlzLl8kRU8oaSx0aGlzW2ldLHQpKSksdGhpcy5fJEVDPXZvaWQgMCksdGhpcy5fJEVrKCl9dXBkYXRlZCh0KXt9Zmlyc3RVcGRhdGVkKHQpe319ZC5maW5hbGl6ZWQ9ITAsZC5lbGVtZW50UHJvcGVydGllcz1uZXcgTWFwLGQuZWxlbWVudFN0eWxlcz1bXSxkLnNoYWRvd1Jvb3RPcHRpb25zPXttb2RlOlwib3BlblwifSxudWxsPT1vfHxvKHtSZWFjdGl2ZUVsZW1lbnQ6ZH0pLChudWxsIT09KHM9ZS5yZWFjdGl2ZUVsZW1lbnRWZXJzaW9ucykmJnZvaWQgMCE9PXM/czplLnJlYWN0aXZlRWxlbWVudFZlcnNpb25zPVtdKS5wdXNoKFwiMS40LjBcIik7ZXhwb3J0e2QgYXMgUmVhY3RpdmVFbGVtZW50LG4gYXMgZGVmYXVsdENvbnZlcnRlcixhIGFzIG5vdEVxdWFsfTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXJlYWN0aXZlLWVsZW1lbnQuanMubWFwXG4iLCJpbXBvcnR7UmVhY3RpdmVFbGVtZW50IGFzIHR9ZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50XCI7ZXhwb3J0KmZyb21cIkBsaXQvcmVhY3RpdmUtZWxlbWVudFwiO2ltcG9ydHtyZW5kZXIgYXMgZSxub0NoYW5nZSBhcyBpfWZyb21cImxpdC1odG1sXCI7ZXhwb3J0KmZyb21cImxpdC1odG1sXCI7XG4vKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgMjAxNyBHb29nbGUgTExDXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQlNELTMtQ2xhdXNlXG4gKi92YXIgbCxvO2NvbnN0IHI9dDtjbGFzcyBzIGV4dGVuZHMgdHtjb25zdHJ1Y3Rvcigpe3N1cGVyKC4uLmFyZ3VtZW50cyksdGhpcy5yZW5kZXJPcHRpb25zPXtob3N0OnRoaXN9LHRoaXMuXyREbz12b2lkIDB9Y3JlYXRlUmVuZGVyUm9vdCgpe3ZhciB0LGU7Y29uc3QgaT1zdXBlci5jcmVhdGVSZW5kZXJSb290KCk7cmV0dXJuIG51bGwhPT0odD0oZT10aGlzLnJlbmRlck9wdGlvbnMpLnJlbmRlckJlZm9yZSkmJnZvaWQgMCE9PXR8fChlLnJlbmRlckJlZm9yZT1pLmZpcnN0Q2hpbGQpLGl9dXBkYXRlKHQpe2NvbnN0IGk9dGhpcy5yZW5kZXIoKTt0aGlzLmhhc1VwZGF0ZWR8fCh0aGlzLnJlbmRlck9wdGlvbnMuaXNDb25uZWN0ZWQ9dGhpcy5pc0Nvbm5lY3RlZCksc3VwZXIudXBkYXRlKHQpLHRoaXMuXyREbz1lKGksdGhpcy5yZW5kZXJSb290LHRoaXMucmVuZGVyT3B0aW9ucyl9Y29ubmVjdGVkQ2FsbGJhY2soKXt2YXIgdDtzdXBlci5jb25uZWN0ZWRDYWxsYmFjaygpLG51bGw9PT0odD10aGlzLl8kRG8pfHx2b2lkIDA9PT10fHx0LnNldENvbm5lY3RlZCghMCl9ZGlzY29ubmVjdGVkQ2FsbGJhY2soKXt2YXIgdDtzdXBlci5kaXNjb25uZWN0ZWRDYWxsYmFjaygpLG51bGw9PT0odD10aGlzLl8kRG8pfHx2b2lkIDA9PT10fHx0LnNldENvbm5lY3RlZCghMSl9cmVuZGVyKCl7cmV0dXJuIGl9fXMuZmluYWxpemVkPSEwLHMuXyRsaXRFbGVtZW50JD0hMCxudWxsPT09KGw9Z2xvYmFsVGhpcy5saXRFbGVtZW50SHlkcmF0ZVN1cHBvcnQpfHx2b2lkIDA9PT1sfHxsLmNhbGwoZ2xvYmFsVGhpcyx7TGl0RWxlbWVudDpzfSk7Y29uc3Qgbj1nbG9iYWxUaGlzLmxpdEVsZW1lbnRQb2x5ZmlsbFN1cHBvcnQ7bnVsbD09bnx8bih7TGl0RWxlbWVudDpzfSk7Y29uc3QgaD17XyRBSzoodCxlLGkpPT57dC5fJEFLKGUsaSl9LF8kQUw6dD0+dC5fJEFMfTsobnVsbCE9PShvPWdsb2JhbFRoaXMubGl0RWxlbWVudFZlcnNpb25zKSYmdm9pZCAwIT09bz9vOmdsb2JhbFRoaXMubGl0RWxlbWVudFZlcnNpb25zPVtdKS5wdXNoKFwiMy4yLjJcIik7ZXhwb3J0e3MgYXMgTGl0RWxlbWVudCxyIGFzIFVwZGF0aW5nRWxlbWVudCxoIGFzIF8kTEV9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bGl0LWVsZW1lbnQuanMubWFwXG4iLCIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgMjAxNyBHb29nbGUgTExDXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQlNELTMtQ2xhdXNlXG4gKi9cbmNvbnN0IHQ9e0FUVFJJQlVURToxLENISUxEOjIsUFJPUEVSVFk6MyxCT09MRUFOX0FUVFJJQlVURTo0LEVWRU5UOjUsRUxFTUVOVDo2fSxlPXQ9PiguLi5lKT0+KHtfJGxpdERpcmVjdGl2ZSQ6dCx2YWx1ZXM6ZX0pO2NsYXNzIGl7Y29uc3RydWN0b3IodCl7fWdldCBfJEFVKCl7cmV0dXJuIHRoaXMuXyRBTS5fJEFVfV8kQVQodCxlLGkpe3RoaXMuXyRDdD10LHRoaXMuXyRBTT1lLHRoaXMuXyRDaT1pfV8kQVModCxlKXtyZXR1cm4gdGhpcy51cGRhdGUodCxlKX11cGRhdGUodCxlKXtyZXR1cm4gdGhpcy5yZW5kZXIoLi4uZSl9fWV4cG9ydHtpIGFzIERpcmVjdGl2ZSx0IGFzIFBhcnRUeXBlLGUgYXMgZGlyZWN0aXZlfTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWRpcmVjdGl2ZS5qcy5tYXBcbiIsImltcG9ydHtub0NoYW5nZSBhcyB0fWZyb21cIi4uL2xpdC1odG1sLmpzXCI7aW1wb3J0e2RpcmVjdGl2ZSBhcyBpLERpcmVjdGl2ZSBhcyBzLFBhcnRUeXBlIGFzIHJ9ZnJvbVwiLi4vZGlyZWN0aXZlLmpzXCI7XG4vKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgMjAxOCBHb29nbGUgTExDXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQlNELTMtQ2xhdXNlXG4gKi9jb25zdCBvPWkoY2xhc3MgZXh0ZW5kcyBze2NvbnN0cnVjdG9yKHQpe3ZhciBpO2lmKHN1cGVyKHQpLHQudHlwZSE9PXIuQVRUUklCVVRFfHxcImNsYXNzXCIhPT10Lm5hbWV8fChudWxsPT09KGk9dC5zdHJpbmdzKXx8dm9pZCAwPT09aT92b2lkIDA6aS5sZW5ndGgpPjIpdGhyb3cgRXJyb3IoXCJgY2xhc3NNYXAoKWAgY2FuIG9ubHkgYmUgdXNlZCBpbiB0aGUgYGNsYXNzYCBhdHRyaWJ1dGUgYW5kIG11c3QgYmUgdGhlIG9ubHkgcGFydCBpbiB0aGUgYXR0cmlidXRlLlwiKX1yZW5kZXIodCl7cmV0dXJuXCIgXCIrT2JqZWN0LmtleXModCkuZmlsdGVyKChpPT50W2ldKSkuam9pbihcIiBcIikrXCIgXCJ9dXBkYXRlKGksW3NdKXt2YXIgcixvO2lmKHZvaWQgMD09PXRoaXMubnQpe3RoaXMubnQ9bmV3IFNldCx2b2lkIDAhPT1pLnN0cmluZ3MmJih0aGlzLnN0PW5ldyBTZXQoaS5zdHJpbmdzLmpvaW4oXCIgXCIpLnNwbGl0KC9cXHMvKS5maWx0ZXIoKHQ9PlwiXCIhPT10KSkpKTtmb3IoY29uc3QgdCBpbiBzKXNbdF0mJiEobnVsbD09PShyPXRoaXMuc3QpfHx2b2lkIDA9PT1yP3ZvaWQgMDpyLmhhcyh0KSkmJnRoaXMubnQuYWRkKHQpO3JldHVybiB0aGlzLnJlbmRlcihzKX1jb25zdCBlPWkuZWxlbWVudC5jbGFzc0xpc3Q7dGhpcy5udC5mb3JFYWNoKCh0PT57dCBpbiBzfHwoZS5yZW1vdmUodCksdGhpcy5udC5kZWxldGUodCkpfSkpO2Zvcihjb25zdCB0IGluIHMpe2NvbnN0IGk9ISFzW3RdO2k9PT10aGlzLm50Lmhhcyh0KXx8KG51bGw9PT0obz10aGlzLnN0KXx8dm9pZCAwPT09bz92b2lkIDA6by5oYXModCkpfHwoaT8oZS5hZGQodCksdGhpcy5udC5hZGQodCkpOihlLnJlbW92ZSh0KSx0aGlzLm50LmRlbGV0ZSh0KSkpfXJldHVybiB0fX0pO2V4cG9ydHtvIGFzIGNsYXNzTWFwfTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWNsYXNzLW1hcC5qcy5tYXBcbiIsIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDE3IEdvb2dsZSBMTENcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBCU0QtMy1DbGF1c2VcbiAqL1xudmFyIHQ7Y29uc3QgaT13aW5kb3cscz1pLnRydXN0ZWRUeXBlcyxlPXM/cy5jcmVhdGVQb2xpY3koXCJsaXQtaHRtbFwiLHtjcmVhdGVIVE1MOnQ9PnR9KTp2b2lkIDAsbz1gbGl0JCR7KE1hdGgucmFuZG9tKCkrXCJcIikuc2xpY2UoOSl9JGAsbj1cIj9cIitvLGw9YDwke259PmAsaD1kb2N1bWVudCxyPSh0PVwiXCIpPT5oLmNyZWF0ZUNvbW1lbnQodCksZD10PT5udWxsPT09dHx8XCJvYmplY3RcIiE9dHlwZW9mIHQmJlwiZnVuY3Rpb25cIiE9dHlwZW9mIHQsdT1BcnJheS5pc0FycmF5LGM9dD0+dSh0KXx8XCJmdW5jdGlvblwiPT10eXBlb2YobnVsbD09dD92b2lkIDA6dFtTeW1ib2wuaXRlcmF0b3JdKSx2PS88KD86KCEtLXxcXC9bXmEtekEtWl0pfChcXC8/W2EtekEtWl1bXj5cXHNdKil8KFxcLz8kKSkvZyxhPS8tLT4vZyxmPS8+L2csXz1SZWdFeHAoXCI+fFsgXFx0XFxuXFxmXFxyXSg/OihbXlxcXFxzXFxcIic+PS9dKykoWyBcXHRcXG5cXGZcXHJdKj1bIFxcdFxcblxcZlxccl0qKD86W14gXFx0XFxuXFxmXFxyXFxcIidgPD49XXwoXFxcInwnKXwpKXwkKVwiLFwiZ1wiKSxtPS8nL2cscD0vXCIvZywkPS9eKD86c2NyaXB0fHN0eWxlfHRleHRhcmVhfHRpdGxlKSQvaSxnPXQ9PihpLC4uLnMpPT4oe18kbGl0VHlwZSQ6dCxzdHJpbmdzOmksdmFsdWVzOnN9KSx5PWcoMSksdz1nKDIpLHg9U3ltYm9sLmZvcihcImxpdC1ub0NoYW5nZVwiKSxiPVN5bWJvbC5mb3IoXCJsaXQtbm90aGluZ1wiKSxUPW5ldyBXZWFrTWFwLEE9KHQsaSxzKT0+e3ZhciBlLG87Y29uc3Qgbj1udWxsIT09KGU9bnVsbD09cz92b2lkIDA6cy5yZW5kZXJCZWZvcmUpJiZ2b2lkIDAhPT1lP2U6aTtsZXQgbD1uLl8kbGl0UGFydCQ7aWYodm9pZCAwPT09bCl7Y29uc3QgdD1udWxsIT09KG89bnVsbD09cz92b2lkIDA6cy5yZW5kZXJCZWZvcmUpJiZ2b2lkIDAhPT1vP286bnVsbDtuLl8kbGl0UGFydCQ9bD1uZXcgUyhpLmluc2VydEJlZm9yZShyKCksdCksdCx2b2lkIDAsbnVsbCE9cz9zOnt9KX1yZXR1cm4gbC5fJEFJKHQpLGx9LEU9aC5jcmVhdGVUcmVlV2Fsa2VyKGgsMTI5LG51bGwsITEpLEM9KHQsaSk9Pntjb25zdCBzPXQubGVuZ3RoLTEsbj1bXTtsZXQgaCxyPTI9PT1pP1wiPHN2Zz5cIjpcIlwiLGQ9djtmb3IobGV0IGk9MDtpPHM7aSsrKXtjb25zdCBzPXRbaV07bGV0IGUsdSxjPS0xLGc9MDtmb3IoO2c8cy5sZW5ndGgmJihkLmxhc3RJbmRleD1nLHU9ZC5leGVjKHMpLG51bGwhPT11KTspZz1kLmxhc3RJbmRleCxkPT09dj9cIiEtLVwiPT09dVsxXT9kPWE6dm9pZCAwIT09dVsxXT9kPWY6dm9pZCAwIT09dVsyXT8oJC50ZXN0KHVbMl0pJiYoaD1SZWdFeHAoXCI8L1wiK3VbMl0sXCJnXCIpKSxkPV8pOnZvaWQgMCE9PXVbM10mJihkPV8pOmQ9PT1fP1wiPlwiPT09dVswXT8oZD1udWxsIT1oP2g6dixjPS0xKTp2b2lkIDA9PT11WzFdP2M9LTI6KGM9ZC5sYXN0SW5kZXgtdVsyXS5sZW5ndGgsZT11WzFdLGQ9dm9pZCAwPT09dVszXT9fOidcIic9PT11WzNdP3A6bSk6ZD09PXB8fGQ9PT1tP2Q9XzpkPT09YXx8ZD09PWY/ZD12OihkPV8saD12b2lkIDApO2NvbnN0IHk9ZD09PV8mJnRbaSsxXS5zdGFydHNXaXRoKFwiLz5cIik/XCIgXCI6XCJcIjtyKz1kPT09dj9zK2w6Yz49MD8obi5wdXNoKGUpLHMuc2xpY2UoMCxjKStcIiRsaXQkXCIrcy5zbGljZShjKStvK3kpOnMrbysoLTI9PT1jPyhuLnB1c2godm9pZCAwKSxpKTp5KX1jb25zdCB1PXIrKHRbc118fFwiPD8+XCIpKygyPT09aT9cIjwvc3ZnPlwiOlwiXCIpO2lmKCFBcnJheS5pc0FycmF5KHQpfHwhdC5oYXNPd25Qcm9wZXJ0eShcInJhd1wiKSl0aHJvdyBFcnJvcihcImludmFsaWQgdGVtcGxhdGUgc3RyaW5ncyBhcnJheVwiKTtyZXR1cm5bdm9pZCAwIT09ZT9lLmNyZWF0ZUhUTUwodSk6dSxuXX07Y2xhc3MgUHtjb25zdHJ1Y3Rvcih7c3RyaW5nczp0LF8kbGl0VHlwZSQ6aX0sZSl7bGV0IGw7dGhpcy5wYXJ0cz1bXTtsZXQgaD0wLGQ9MDtjb25zdCB1PXQubGVuZ3RoLTEsYz10aGlzLnBhcnRzLFt2LGFdPUModCxpKTtpZih0aGlzLmVsPVAuY3JlYXRlRWxlbWVudCh2LGUpLEUuY3VycmVudE5vZGU9dGhpcy5lbC5jb250ZW50LDI9PT1pKXtjb25zdCB0PXRoaXMuZWwuY29udGVudCxpPXQuZmlyc3RDaGlsZDtpLnJlbW92ZSgpLHQuYXBwZW5kKC4uLmkuY2hpbGROb2Rlcyl9Zm9yKDtudWxsIT09KGw9RS5uZXh0Tm9kZSgpKSYmYy5sZW5ndGg8dTspe2lmKDE9PT1sLm5vZGVUeXBlKXtpZihsLmhhc0F0dHJpYnV0ZXMoKSl7Y29uc3QgdD1bXTtmb3IoY29uc3QgaSBvZiBsLmdldEF0dHJpYnV0ZU5hbWVzKCkpaWYoaS5lbmRzV2l0aChcIiRsaXQkXCIpfHxpLnN0YXJ0c1dpdGgobykpe2NvbnN0IHM9YVtkKytdO2lmKHQucHVzaChpKSx2b2lkIDAhPT1zKXtjb25zdCB0PWwuZ2V0QXR0cmlidXRlKHMudG9Mb3dlckNhc2UoKStcIiRsaXQkXCIpLnNwbGl0KG8pLGk9LyhbLj9AXSk/KC4qKS8uZXhlYyhzKTtjLnB1c2goe3R5cGU6MSxpbmRleDpoLG5hbWU6aVsyXSxzdHJpbmdzOnQsY3RvcjpcIi5cIj09PWlbMV0/UjpcIj9cIj09PWlbMV0/SDpcIkBcIj09PWlbMV0/STpNfSl9ZWxzZSBjLnB1c2goe3R5cGU6NixpbmRleDpofSl9Zm9yKGNvbnN0IGkgb2YgdClsLnJlbW92ZUF0dHJpYnV0ZShpKX1pZigkLnRlc3QobC50YWdOYW1lKSl7Y29uc3QgdD1sLnRleHRDb250ZW50LnNwbGl0KG8pLGk9dC5sZW5ndGgtMTtpZihpPjApe2wudGV4dENvbnRlbnQ9cz9zLmVtcHR5U2NyaXB0OlwiXCI7Zm9yKGxldCBzPTA7czxpO3MrKylsLmFwcGVuZCh0W3NdLHIoKSksRS5uZXh0Tm9kZSgpLGMucHVzaCh7dHlwZToyLGluZGV4OisraH0pO2wuYXBwZW5kKHRbaV0scigpKX19fWVsc2UgaWYoOD09PWwubm9kZVR5cGUpaWYobC5kYXRhPT09biljLnB1c2goe3R5cGU6MixpbmRleDpofSk7ZWxzZXtsZXQgdD0tMTtmb3IoOy0xIT09KHQ9bC5kYXRhLmluZGV4T2Yobyx0KzEpKTspYy5wdXNoKHt0eXBlOjcsaW5kZXg6aH0pLHQrPW8ubGVuZ3RoLTF9aCsrfX1zdGF0aWMgY3JlYXRlRWxlbWVudCh0LGkpe2NvbnN0IHM9aC5jcmVhdGVFbGVtZW50KFwidGVtcGxhdGVcIik7cmV0dXJuIHMuaW5uZXJIVE1MPXQsc319ZnVuY3Rpb24gVih0LGkscz10LGUpe3ZhciBvLG4sbCxoO2lmKGk9PT14KXJldHVybiBpO2xldCByPXZvaWQgMCE9PWU/bnVsbD09PShvPXMuXyRDbCl8fHZvaWQgMD09PW8/dm9pZCAwOm9bZV06cy5fJEN1O2NvbnN0IHU9ZChpKT92b2lkIDA6aS5fJGxpdERpcmVjdGl2ZSQ7cmV0dXJuKG51bGw9PXI/dm9pZCAwOnIuY29uc3RydWN0b3IpIT09dSYmKG51bGw9PT0obj1udWxsPT1yP3ZvaWQgMDpyLl8kQU8pfHx2b2lkIDA9PT1ufHxuLmNhbGwociwhMSksdm9pZCAwPT09dT9yPXZvaWQgMDoocj1uZXcgdSh0KSxyLl8kQVQodCxzLGUpKSx2b2lkIDAhPT1lPyhudWxsIT09KGw9KGg9cykuXyRDbCkmJnZvaWQgMCE9PWw/bDpoLl8kQ2w9W10pW2VdPXI6cy5fJEN1PXIpLHZvaWQgMCE9PXImJihpPVYodCxyLl8kQVModCxpLnZhbHVlcykscixlKSksaX1jbGFzcyBOe2NvbnN0cnVjdG9yKHQsaSl7dGhpcy52PVtdLHRoaXMuXyRBTj12b2lkIDAsdGhpcy5fJEFEPXQsdGhpcy5fJEFNPWl9Z2V0IHBhcmVudE5vZGUoKXtyZXR1cm4gdGhpcy5fJEFNLnBhcmVudE5vZGV9Z2V0IF8kQVUoKXtyZXR1cm4gdGhpcy5fJEFNLl8kQVV9cCh0KXt2YXIgaTtjb25zdHtlbDp7Y29udGVudDpzfSxwYXJ0czplfT10aGlzLl8kQUQsbz0obnVsbCE9PShpPW51bGw9PXQ/dm9pZCAwOnQuY3JlYXRpb25TY29wZSkmJnZvaWQgMCE9PWk/aTpoKS5pbXBvcnROb2RlKHMsITApO0UuY3VycmVudE5vZGU9bztsZXQgbj1FLm5leHROb2RlKCksbD0wLHI9MCxkPWVbMF07Zm9yKDt2b2lkIDAhPT1kOyl7aWYobD09PWQuaW5kZXgpe2xldCBpOzI9PT1kLnR5cGU/aT1uZXcgUyhuLG4ubmV4dFNpYmxpbmcsdGhpcyx0KToxPT09ZC50eXBlP2k9bmV3IGQuY3RvcihuLGQubmFtZSxkLnN0cmluZ3MsdGhpcyx0KTo2PT09ZC50eXBlJiYoaT1uZXcgTChuLHRoaXMsdCkpLHRoaXMudi5wdXNoKGkpLGQ9ZVsrK3JdfWwhPT0obnVsbD09ZD92b2lkIDA6ZC5pbmRleCkmJihuPUUubmV4dE5vZGUoKSxsKyspfXJldHVybiBvfW0odCl7bGV0IGk9MDtmb3IoY29uc3QgcyBvZiB0aGlzLnYpdm9pZCAwIT09cyYmKHZvaWQgMCE9PXMuc3RyaW5ncz8ocy5fJEFJKHQscyxpKSxpKz1zLnN0cmluZ3MubGVuZ3RoLTIpOnMuXyRBSSh0W2ldKSksaSsrfX1jbGFzcyBTe2NvbnN0cnVjdG9yKHQsaSxzLGUpe3ZhciBvO3RoaXMudHlwZT0yLHRoaXMuXyRBSD1iLHRoaXMuXyRBTj12b2lkIDAsdGhpcy5fJEFBPXQsdGhpcy5fJEFCPWksdGhpcy5fJEFNPXMsdGhpcy5vcHRpb25zPWUsdGhpcy5fJENfPW51bGw9PT0obz1udWxsPT1lP3ZvaWQgMDplLmlzQ29ubmVjdGVkKXx8dm9pZCAwPT09b3x8b31nZXQgXyRBVSgpe3ZhciB0LGk7cmV0dXJuIG51bGwhPT0oaT1udWxsPT09KHQ9dGhpcy5fJEFNKXx8dm9pZCAwPT09dD92b2lkIDA6dC5fJEFVKSYmdm9pZCAwIT09aT9pOnRoaXMuXyRDX31nZXQgcGFyZW50Tm9kZSgpe2xldCB0PXRoaXMuXyRBQS5wYXJlbnROb2RlO2NvbnN0IGk9dGhpcy5fJEFNO3JldHVybiB2b2lkIDAhPT1pJiYxMT09PXQubm9kZVR5cGUmJih0PWkucGFyZW50Tm9kZSksdH1nZXQgc3RhcnROb2RlKCl7cmV0dXJuIHRoaXMuXyRBQX1nZXQgZW5kTm9kZSgpe3JldHVybiB0aGlzLl8kQUJ9XyRBSSh0LGk9dGhpcyl7dD1WKHRoaXMsdCxpKSxkKHQpP3Q9PT1ifHxudWxsPT10fHxcIlwiPT09dD8odGhpcy5fJEFIIT09YiYmdGhpcy5fJEFSKCksdGhpcy5fJEFIPWIpOnQhPT10aGlzLl8kQUgmJnQhPT14JiZ0aGlzLiQodCk6dm9pZCAwIT09dC5fJGxpdFR5cGUkP3RoaXMuVCh0KTp2b2lkIDAhPT10Lm5vZGVUeXBlP3RoaXMuayh0KTpjKHQpP3RoaXMuTyh0KTp0aGlzLiQodCl9Uyh0LGk9dGhpcy5fJEFCKXtyZXR1cm4gdGhpcy5fJEFBLnBhcmVudE5vZGUuaW5zZXJ0QmVmb3JlKHQsaSl9ayh0KXt0aGlzLl8kQUghPT10JiYodGhpcy5fJEFSKCksdGhpcy5fJEFIPXRoaXMuUyh0KSl9JCh0KXt0aGlzLl8kQUghPT1iJiZkKHRoaXMuXyRBSCk/dGhpcy5fJEFBLm5leHRTaWJsaW5nLmRhdGE9dDp0aGlzLmsoaC5jcmVhdGVUZXh0Tm9kZSh0KSksdGhpcy5fJEFIPXR9VCh0KXt2YXIgaTtjb25zdHt2YWx1ZXM6cyxfJGxpdFR5cGUkOmV9PXQsbz1cIm51bWJlclwiPT10eXBlb2YgZT90aGlzLl8kQUModCk6KHZvaWQgMD09PWUuZWwmJihlLmVsPVAuY3JlYXRlRWxlbWVudChlLmgsdGhpcy5vcHRpb25zKSksZSk7aWYoKG51bGw9PT0oaT10aGlzLl8kQUgpfHx2b2lkIDA9PT1pP3ZvaWQgMDppLl8kQUQpPT09byl0aGlzLl8kQUgubShzKTtlbHNle2NvbnN0IHQ9bmV3IE4obyx0aGlzKSxpPXQucCh0aGlzLm9wdGlvbnMpO3QubShzKSx0aGlzLmsoaSksdGhpcy5fJEFIPXR9fV8kQUModCl7bGV0IGk9VC5nZXQodC5zdHJpbmdzKTtyZXR1cm4gdm9pZCAwPT09aSYmVC5zZXQodC5zdHJpbmdzLGk9bmV3IFAodCkpLGl9Tyh0KXt1KHRoaXMuXyRBSCl8fCh0aGlzLl8kQUg9W10sdGhpcy5fJEFSKCkpO2NvbnN0IGk9dGhpcy5fJEFIO2xldCBzLGU9MDtmb3IoY29uc3QgbyBvZiB0KWU9PT1pLmxlbmd0aD9pLnB1c2gocz1uZXcgUyh0aGlzLlMocigpKSx0aGlzLlMocigpKSx0aGlzLHRoaXMub3B0aW9ucykpOnM9aVtlXSxzLl8kQUkobyksZSsrO2U8aS5sZW5ndGgmJih0aGlzLl8kQVIocyYmcy5fJEFCLm5leHRTaWJsaW5nLGUpLGkubGVuZ3RoPWUpfV8kQVIodD10aGlzLl8kQUEubmV4dFNpYmxpbmcsaSl7dmFyIHM7Zm9yKG51bGw9PT0ocz10aGlzLl8kQVApfHx2b2lkIDA9PT1zfHxzLmNhbGwodGhpcywhMSwhMCxpKTt0JiZ0IT09dGhpcy5fJEFCOyl7Y29uc3QgaT10Lm5leHRTaWJsaW5nO3QucmVtb3ZlKCksdD1pfX1zZXRDb25uZWN0ZWQodCl7dmFyIGk7dm9pZCAwPT09dGhpcy5fJEFNJiYodGhpcy5fJENfPXQsbnVsbD09PShpPXRoaXMuXyRBUCl8fHZvaWQgMD09PWl8fGkuY2FsbCh0aGlzLHQpKX19Y2xhc3MgTXtjb25zdHJ1Y3Rvcih0LGkscyxlLG8pe3RoaXMudHlwZT0xLHRoaXMuXyRBSD1iLHRoaXMuXyRBTj12b2lkIDAsdGhpcy5lbGVtZW50PXQsdGhpcy5uYW1lPWksdGhpcy5fJEFNPWUsdGhpcy5vcHRpb25zPW8scy5sZW5ndGg+Mnx8XCJcIiE9PXNbMF18fFwiXCIhPT1zWzFdPyh0aGlzLl8kQUg9QXJyYXkocy5sZW5ndGgtMSkuZmlsbChuZXcgU3RyaW5nKSx0aGlzLnN0cmluZ3M9cyk6dGhpcy5fJEFIPWJ9Z2V0IHRhZ05hbWUoKXtyZXR1cm4gdGhpcy5lbGVtZW50LnRhZ05hbWV9Z2V0IF8kQVUoKXtyZXR1cm4gdGhpcy5fJEFNLl8kQVV9XyRBSSh0LGk9dGhpcyxzLGUpe2NvbnN0IG89dGhpcy5zdHJpbmdzO2xldCBuPSExO2lmKHZvaWQgMD09PW8pdD1WKHRoaXMsdCxpLDApLG49IWQodCl8fHQhPT10aGlzLl8kQUgmJnQhPT14LG4mJih0aGlzLl8kQUg9dCk7ZWxzZXtjb25zdCBlPXQ7bGV0IGwsaDtmb3IodD1vWzBdLGw9MDtsPG8ubGVuZ3RoLTE7bCsrKWg9Vih0aGlzLGVbcytsXSxpLGwpLGg9PT14JiYoaD10aGlzLl8kQUhbbF0pLG58fChuPSFkKGgpfHxoIT09dGhpcy5fJEFIW2xdKSxoPT09Yj90PWI6dCE9PWImJih0Kz0obnVsbCE9aD9oOlwiXCIpK29bbCsxXSksdGhpcy5fJEFIW2xdPWh9biYmIWUmJnRoaXMuUCh0KX1QKHQpe3Q9PT1iP3RoaXMuZWxlbWVudC5yZW1vdmVBdHRyaWJ1dGUodGhpcy5uYW1lKTp0aGlzLmVsZW1lbnQuc2V0QXR0cmlidXRlKHRoaXMubmFtZSxudWxsIT10P3Q6XCJcIil9fWNsYXNzIFIgZXh0ZW5kcyBNe2NvbnN0cnVjdG9yKCl7c3VwZXIoLi4uYXJndW1lbnRzKSx0aGlzLnR5cGU9M31QKHQpe3RoaXMuZWxlbWVudFt0aGlzLm5hbWVdPXQ9PT1iP3ZvaWQgMDp0fX1jb25zdCBrPXM/cy5lbXB0eVNjcmlwdDpcIlwiO2NsYXNzIEggZXh0ZW5kcyBNe2NvbnN0cnVjdG9yKCl7c3VwZXIoLi4uYXJndW1lbnRzKSx0aGlzLnR5cGU9NH1QKHQpe3QmJnQhPT1iP3RoaXMuZWxlbWVudC5zZXRBdHRyaWJ1dGUodGhpcy5uYW1lLGspOnRoaXMuZWxlbWVudC5yZW1vdmVBdHRyaWJ1dGUodGhpcy5uYW1lKX19Y2xhc3MgSSBleHRlbmRzIE17Y29uc3RydWN0b3IodCxpLHMsZSxvKXtzdXBlcih0LGkscyxlLG8pLHRoaXMudHlwZT01fV8kQUkodCxpPXRoaXMpe3ZhciBzO2lmKCh0PW51bGwhPT0ocz1WKHRoaXMsdCxpLDApKSYmdm9pZCAwIT09cz9zOmIpPT09eClyZXR1cm47Y29uc3QgZT10aGlzLl8kQUgsbz10PT09YiYmZSE9PWJ8fHQuY2FwdHVyZSE9PWUuY2FwdHVyZXx8dC5vbmNlIT09ZS5vbmNlfHx0LnBhc3NpdmUhPT1lLnBhc3NpdmUsbj10IT09YiYmKGU9PT1ifHxvKTtvJiZ0aGlzLmVsZW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lcih0aGlzLm5hbWUsdGhpcyxlKSxuJiZ0aGlzLmVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcih0aGlzLm5hbWUsdGhpcyx0KSx0aGlzLl8kQUg9dH1oYW5kbGVFdmVudCh0KXt2YXIgaSxzO1wiZnVuY3Rpb25cIj09dHlwZW9mIHRoaXMuXyRBSD90aGlzLl8kQUguY2FsbChudWxsIT09KHM9bnVsbD09PShpPXRoaXMub3B0aW9ucyl8fHZvaWQgMD09PWk/dm9pZCAwOmkuaG9zdCkmJnZvaWQgMCE9PXM/czp0aGlzLmVsZW1lbnQsdCk6dGhpcy5fJEFILmhhbmRsZUV2ZW50KHQpfX1jbGFzcyBMe2NvbnN0cnVjdG9yKHQsaSxzKXt0aGlzLmVsZW1lbnQ9dCx0aGlzLnR5cGU9Nix0aGlzLl8kQU49dm9pZCAwLHRoaXMuXyRBTT1pLHRoaXMub3B0aW9ucz1zfWdldCBfJEFVKCl7cmV0dXJuIHRoaXMuXyRBTS5fJEFVfV8kQUkodCl7Vih0aGlzLHQpfX1jb25zdCB6PXtBOlwiJGxpdCRcIixNOm8sQzpuLEw6MSxSOkMsRDpOLFY6YyxJOlYsSDpTLE46TSxVOkgsQjpJLEY6UixXOkx9LFo9aS5saXRIdG1sUG9seWZpbGxTdXBwb3J0O251bGw9PVp8fFooUCxTKSwobnVsbCE9PSh0PWkubGl0SHRtbFZlcnNpb25zKSYmdm9pZCAwIT09dD90OmkubGl0SHRtbFZlcnNpb25zPVtdKS5wdXNoKFwiMi4zLjFcIik7ZXhwb3J0e3ogYXMgXyRMSCx5IGFzIGh0bWwseCBhcyBub0NoYW5nZSxiIGFzIG5vdGhpbmcsQSBhcyByZW5kZXIsdyBhcyBzdmd9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bGl0LWh0bWwuanMubWFwXG4iLCJleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvY3VzdG9tLWVsZW1lbnQuanNcIjtleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvcHJvcGVydHkuanNcIjtleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvc3RhdGUuanNcIjtleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvZXZlbnQtb3B0aW9ucy5qc1wiO2V4cG9ydCpmcm9tXCJAbGl0L3JlYWN0aXZlLWVsZW1lbnQvZGVjb3JhdG9ycy9xdWVyeS5qc1wiO2V4cG9ydCpmcm9tXCJAbGl0L3JlYWN0aXZlLWVsZW1lbnQvZGVjb3JhdG9ycy9xdWVyeS1hbGwuanNcIjtleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvcXVlcnktYXN5bmMuanNcIjtleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvcXVlcnktYXNzaWduZWQtZWxlbWVudHMuanNcIjtleHBvcnQqZnJvbVwiQGxpdC9yZWFjdGl2ZS1lbGVtZW50L2RlY29yYXRvcnMvcXVlcnktYXNzaWduZWQtbm9kZXMuanNcIjtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWRlY29yYXRvcnMuanMubWFwXG4iLCJpbXBvcnRcIkBsaXQvcmVhY3RpdmUtZWxlbWVudFwiO2ltcG9ydFwibGl0LWh0bWxcIjtleHBvcnQqZnJvbVwibGl0LWVsZW1lbnQvbGl0LWVsZW1lbnQuanNcIjtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWluZGV4LmpzLm1hcFxuIiwiLy8gVGhlIG1vZHVsZSBjYWNoZVxudmFyIF9fd2VicGFja19tb2R1bGVfY2FjaGVfXyA9IHt9O1xuXG4vLyBUaGUgcmVxdWlyZSBmdW5jdGlvblxuZnVuY3Rpb24gX193ZWJwYWNrX3JlcXVpcmVfXyhtb2R1bGVJZCkge1xuXHQvLyBDaGVjayBpZiBtb2R1bGUgaXMgaW4gY2FjaGVcblx0dmFyIGNhY2hlZE1vZHVsZSA9IF9fd2VicGFja19tb2R1bGVfY2FjaGVfX1ttb2R1bGVJZF07XG5cdGlmIChjYWNoZWRNb2R1bGUgIT09IHVuZGVmaW5lZCkge1xuXHRcdHJldHVybiBjYWNoZWRNb2R1bGUuZXhwb3J0cztcblx0fVxuXHQvLyBDcmVhdGUgYSBuZXcgbW9kdWxlIChhbmQgcHV0IGl0IGludG8gdGhlIGNhY2hlKVxuXHR2YXIgbW9kdWxlID0gX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fW21vZHVsZUlkXSA9IHtcblx0XHQvLyBubyBtb2R1bGUuaWQgbmVlZGVkXG5cdFx0Ly8gbm8gbW9kdWxlLmxvYWRlZCBuZWVkZWRcblx0XHRleHBvcnRzOiB7fVxuXHR9O1xuXG5cdC8vIEV4ZWN1dGUgdGhlIG1vZHVsZSBmdW5jdGlvblxuXHRfX3dlYnBhY2tfbW9kdWxlc19fW21vZHVsZUlkXShtb2R1bGUsIG1vZHVsZS5leHBvcnRzLCBfX3dlYnBhY2tfcmVxdWlyZV9fKTtcblxuXHQvLyBSZXR1cm4gdGhlIGV4cG9ydHMgb2YgdGhlIG1vZHVsZVxuXHRyZXR1cm4gbW9kdWxlLmV4cG9ydHM7XG59XG5cbiIsIi8vIGRlZmluZSBnZXR0ZXIgZnVuY3Rpb25zIGZvciBoYXJtb255IGV4cG9ydHNcbl9fd2VicGFja19yZXF1aXJlX18uZCA9IChleHBvcnRzLCBkZWZpbml0aW9uKSA9PiB7XG5cdGZvcih2YXIga2V5IGluIGRlZmluaXRpb24pIHtcblx0XHRpZihfX3dlYnBhY2tfcmVxdWlyZV9fLm8oZGVmaW5pdGlvbiwga2V5KSAmJiAhX193ZWJwYWNrX3JlcXVpcmVfXy5vKGV4cG9ydHMsIGtleSkpIHtcblx0XHRcdE9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBrZXksIHsgZW51bWVyYWJsZTogdHJ1ZSwgZ2V0OiBkZWZpbml0aW9uW2tleV0gfSk7XG5cdFx0fVxuXHR9XG59OyIsIl9fd2VicGFja19yZXF1aXJlX18ubyA9IChvYmosIHByb3ApID0+IChPYmplY3QucHJvdG90eXBlLmhhc093blByb3BlcnR5LmNhbGwob2JqLCBwcm9wKSkiLCJpbXBvcnQge2luaXR9IGZyb20gJy4vdXRpbHMnO1xuaW1wb3J0ICcuLi9jb21wb25lbnRzL3Byb2ZpbGUvY29tbWVudF93YXJuaW5nJztcblxuaW5pdCgnc3JjL2xpYi9wYWdlX3NjcmlwdHMvcHJvZmlsZS5qcycsIG1haW4pO1xuXG5hc3luYyBmdW5jdGlvbiBtYWluKCkge31cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==