/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "init": () => (/* binding */ init)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_execute_script__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bridge_handlers_execute_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







function initiateChromium(scriptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_execute_css__WEBPACK_IMPORTED_MODULE_3__.ExecuteCssOnPage, {
            path: 'src/global.css',
        });
        (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_execute_script__WEBPACK_IMPORTED_MODULE_0__.ExecuteScriptOnPage, {
            path: scriptPath,
        });
    });
}
function initiateFirefox(scriptPath) {
    return __awaiter(this, void 0, void 0, function* () {
        _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_6__.g_PostMessageBus.handleRequests();
        // Why do we need to use manual DOM script injection and
        // fetch the text of the script?
        // See https://github.com/csfloat/extension/issues/155#issuecomment-1639781914
        // We want to inject the ID of the extension
        const id = browser.runtime.id;
        const entryScript = document.createElement('script');
        entryScript.appendChild(document.createTextNode(`
        window.CSFLOAT_EXTENSION_ID = '${id}';
    `));
        document.head.appendChild(entryScript);
        const scriptResp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__.FetchExtensionFile, {
            path: scriptPath,
        });
        const script = document.createElement('script');
        script.appendChild(document.createTextNode(scriptResp.text));
        document.head.appendChild(script);
        const styleResp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_extension_file__WEBPACK_IMPORTED_MODULE_4__.FetchExtensionFile, {
            path: 'src/global.css',
        });
        const style = document.createElement('style');
        style.appendChild(document.createTextNode(styleResp.text));
        document.head.appendChild(style);
    });
}
/**
 * Initializes a page script, executing it in the page context if necessary
 *
 * @param scriptPath Relative path of the script (always in .js)
 * @param ifPage Fn to run if we are in the page's execution context
 */
function init(scriptPath, ifPage) {
    return __awaiter(this, void 0, void 0, function* () {
        // Don't allow the page script to run this.
        if ((0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)()) {
            // @ts-ignore Set global identifier for other extensions to use
            window.csfloat = true;
            // @ts-ignore Deprecated name
            window.csgofloat = true;
            ifPage();
            return;
        }
        if ((0,_utils_detect__WEBPACK_IMPORTED_MODULE_5__.isFirefox)()) {
            yield initiateFirefox(scriptPath);
        }
        else {
            yield initiateChromium(scriptPath);
        }
        console.log(`%c CSFloat Market Checker (v${chrome.runtime.getManifest().version}) by Step7750 `, 'background: #004594; color: #fff;');
        console.log('%c Changelog can be found here: https://github.com/csfloat/extension ', 'background: #004594; color: #fff;');
    });
}


/***/ }),
/* 2 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteScriptOnPage": () => (/* binding */ ExecuteScriptOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteScriptOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_SCRIPT_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    // We need to inject the extension ID dynamically so the client knows who to
    // communicate with.
    //
    // On Firefox, extension IDs are random, so this is necessary.
    yield chrome.scripting.executeScript({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        world: 'MAIN',
        args: [chrome.runtime.id],
        func: function ExtensionId(extensionId) {
            window.CSFLOAT_EXTENSION_ID = extensionId;
        },
    });
    yield chrome.scripting.executeScript({
        target: { tabId: (_b = sender.tab) === null || _b === void 0 ? void 0 : _b.id },
        files: [req.path],
        world: 'MAIN',
    });
})));


/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EmptyResponseHandler": () => (/* binding */ EmptyResponseHandler),
/* harmony export */   "SimpleHandler": () => (/* binding */ SimpleHandler)
/* harmony export */ });
/* unused harmony export EmptyRequestHandler */
class SimpleHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}
class EmptyRequestHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(sender);
    }
}
class EmptyResponseHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}


/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RequestType": () => (/* binding */ RequestType)
/* harmony export */ });
var RequestType;
(function (RequestType) {
    RequestType[RequestType["EXECUTE_SCRIPT_ON_PAGE"] = 0] = "EXECUTE_SCRIPT_ON_PAGE";
    RequestType[RequestType["EXECUTE_CSS_ON_PAGE"] = 1] = "EXECUTE_CSS_ON_PAGE";
    RequestType[RequestType["FETCH_INSPECT_INFO"] = 2] = "FETCH_INSPECT_INFO";
    RequestType[RequestType["FETCH_STALL"] = 3] = "FETCH_STALL";
    RequestType[RequestType["STORAGE_GET"] = 4] = "STORAGE_GET";
    RequestType[RequestType["STORAGE_SET"] = 5] = "STORAGE_SET";
    RequestType[RequestType["STORAGE_REMOVE"] = 6] = "STORAGE_REMOVE";
    RequestType[RequestType["FETCH_PENDING_TRADES"] = 7] = "FETCH_PENDING_TRADES";
    RequestType[RequestType["FETCH_EXTENSION_FILE"] = 8] = "FETCH_EXTENSION_FILE";
    RequestType[RequestType["ANNOTATE_OFFER"] = 9] = "ANNOTATE_OFFER";
    RequestType[RequestType["EXTENSION_VERSION"] = 10] = "EXTENSION_VERSION";
    RequestType[RequestType["TRADE_HISTORY_STATUS"] = 11] = "TRADE_HISTORY_STATUS";
    RequestType[RequestType["TRADE_OFFER_STATUS"] = 12] = "TRADE_OFFER_STATUS";
    RequestType[RequestType["HAS_PERMISSIONS"] = 13] = "HAS_PERMISSIONS";
    RequestType[RequestType["PING_SETUP_EXTENSION"] = 14] = "PING_SETUP_EXTENSION";
    RequestType[RequestType["PING_EXTENSION_STATUS"] = 15] = "PING_EXTENSION_STATUS";
    RequestType[RequestType["PING_CANCEL_TRADE"] = 16] = "PING_CANCEL_TRADE";
    RequestType[RequestType["CREATE_TRADE_OFFER"] = 17] = "CREATE_TRADE_OFFER";
    RequestType[RequestType["FETCH_STEAM_USER"] = 18] = "FETCH_STEAM_USER";
    RequestType[RequestType["PING_TRADE_STATUS"] = 19] = "PING_TRADE_STATUS";
    RequestType[RequestType["PING_STATUS"] = 20] = "PING_STATUS";
    RequestType[RequestType["FETCH_OWN_INVENTORY"] = 21] = "FETCH_OWN_INVENTORY";
    RequestType[RequestType["CANCEL_TRADE_OFFER"] = 22] = "CANCEL_TRADE_OFFER";
})(RequestType || (RequestType = {}));


/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PrivilegedHandler": () => (/* binding */ PrivilegedHandler)
/* harmony export */ });
/**
 * Restricts a given handler such that it can only run if the sender is
 * verified to be from the extension's origin (ie. content script)
 */
class PrivilegedHandler {
    constructor(handler) {
        this.handler = handler;
    }
    getType() {
        return this.handler.getType();
    }
    handleRequest(request, sender) {
        if (sender.id !== chrome.runtime.id) {
            throw new Error('Attempt to access restricted method outside of secure context (ie. content script)');
        }
        return this.handler.handleRequest(request, sender);
    }
}


/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClientSend": () => (/* binding */ ClientSend)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function canUseSendMessage() {
    // Not supported in Firefox Page Context
    return !((0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.isFirefox)() && (0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)());
}
/**
 * Send a request to be handled by the background worker
 *
 * Can be called from a content script or page itself
 */
function ClientSend(handler, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const bundle = {
            version: _types__WEBPACK_IMPORTED_MODULE_0__.Version.V1,
            request_type: handler.getType(),
            request: args,
            id: Math.ceil(Math.random() * 100000000000),
        };
        if (canUseSendMessage()) {
            return new Promise((resolve, reject) => {
                // @ts-ignore Bad types
                (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(window.CSFLOAT_EXTENSION_ID || chrome.runtime.id, bundle, 
                // @ts-ignore Bad types
                (resp) => {
                    if (resp === null || resp === void 0 ? void 0 : resp.response) {
                        resolve(resp.response);
                    }
                    else {
                        reject(resp === null || resp === void 0 ? void 0 : resp.error);
                    }
                });
            });
        }
        else {
            // Fallback to postmessage bus for browsers that don't implement
            // specs fully
            return _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__.g_PostMessageBus.sendRequest(bundle);
        }
    });
}


/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Version": () => (/* binding */ Version)
/* harmony export */ });
var Version;
(function (Version) {
    Version["V1"] = "CSFLOAT_V1";
})(Version || (Version = {}));


/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isFirefox": () => (/* binding */ isFirefox),
/* harmony export */   "runtimeNamespace": () => (/* binding */ runtimeNamespace)
/* harmony export */ });
function isFirefox() {
    return navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
}
/**
 * Thanks to our browser overlords, we have two namespaces for `x.runtime.fn()`
 */
function runtimeNamespace() {
    if (isFirefox()) {
        return browser;
    }
    else {
        return chrome;
    }
}


/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "inPageContext": () => (/* binding */ inPageContext)
/* harmony export */ });
function inPageContext() {
    return typeof chrome === 'undefined' || !chrome.extension;
}


/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g_PostMessageBus": () => (/* binding */ g_PostMessageBus)
/* harmony export */ });
/* harmony import */ var _bridge_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);


/**
 * Message bus that uses `postMessage` in order to communicate with the background
 * service worker/script.
 *
 * Why? Because the client page (ie. Steam page) on Firefox is not capable of
 * sending a message directly to the extension background.
 *
 * So it requires us to do the following dance:
 * page <--(postmessage)--> content script <--(sendmessage)--> background script
 *
 * This dance is abstracted in `ClientSend`, and only uses this bus if
 * `sendmessage` is not supported in the page.
 */
class PostMessageBus {
    /**
     * For the requester (ie. page), to wait until it gets a response
     * from the content script via. postMessage for the given request ID
     *
     * @param id Request ID
     */
    waitUntilResponseFor(id) {
        return new Promise((resolve, reject) => {
            const handler = (e) => {
                const resp = e.data;
                if (resp.id !== id || !resp.response) {
                    return;
                }
                // Prevent leaks
                window.removeEventListener('message', handler, false);
                if (resp === null || resp === void 0 ? void 0 : resp.response) {
                    resolve(resp.response);
                }
                else {
                    reject(resp === null || resp === void 0 ? void 0 : resp.error);
                }
            };
            window.addEventListener('message', handler);
        });
    }
    /**
     * Sends a request to be done through the bus, returns the appropriate
     * response for the input bundle handler
     *
     * @param bundle Request Bundle
     */
    sendRequest(bundle) {
        window.postMessage(bundle);
        return this.waitUntilResponseFor(bundle.id);
    }
    /**
     * Request handler (content script) for new requests from the page.
     *
     * Each request is effectively "proxied" to the background script/worker
     * to actually execute it's handler.
     */
    handleRequests() {
        const h = (e) => {
            if (e.data.version !== _bridge_types__WEBPACK_IMPORTED_MODULE_0__.Version.V1 || !e.data.request) {
                // Ignore messages that aren't for this bridge
                return;
            }
            // Send to the background script
            // @ts-ignore Bad types
            (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(chrome.runtime.id, e.data, 
            // @ts-ignore Bad types
            (resp) => {
                window.postMessage(resp);
            });
        };
        window.addEventListener('message', h);
    }
}
const g_PostMessageBus = new PostMessageBus();


/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteCssOnPage": () => (/* binding */ ExecuteCssOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteCssOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_CSS_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    yield chrome.scripting.insertCSS({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        files: [req.path],
    });
})));


/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchExtensionFile": () => (/* binding */ FetchExtensionFile)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchExtensionFile = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_EXTENSION_FILE, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const url = chrome.runtime.getURL(req.path);
    const r = yield fetch(url);
    const text = yield r.text();
    return {
        text,
    };
})));


/***/ }),
/* 13 */,
/* 14 */,
/* 15 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony export InventoryItemHolderMetadata */
/* harmony import */ var _injectors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/* harmony import */ var _common_item_holder_metadata__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


let InventoryItemHolderMetadata = class InventoryItemHolderMetadata extends _common_item_holder_metadata__WEBPACK_IMPORTED_MODULE_1__.ItemHolderMetadata {
    get asset() {
        var _a;
        if (!this.assetId)
            return;
        return (_a = g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_rgAssets[this.assetId]) === null || _a === void 0 ? void 0 : _a.description;
    }
    get ownerSteamId() {
        var _a, _b;
        if (g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_owner) {
            return (_a = g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_owner) === null || _a === void 0 ? void 0 : _a.strSteamId;
        }
        else if (g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.owner) {
            return (_b = g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.owner) === null || _b === void 0 ? void 0 : _b.strSteamId;
        }
    }
};
InventoryItemHolderMetadata = __decorate([
    (0,_injectors__WEBPACK_IMPORTED_MODULE_0__.CustomElement)(),
    (0,_injectors__WEBPACK_IMPORTED_MODULE_0__.InjectAppend)('#active_inventory_page div.inventory_page:not([style*="display: none"]) .itemHolder div.app730', _injectors__WEBPACK_IMPORTED_MODULE_0__.InjectionMode.CONTINUOUS)
], InventoryItemHolderMetadata);



/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CustomElement": () => (/* binding */ CustomElement),
/* harmony export */   "InjectAfter": () => (/* binding */ InjectAfter),
/* harmony export */   "InjectAppend": () => (/* binding */ InjectAppend),
/* harmony export */   "InjectionMode": () => (/* binding */ InjectionMode)
/* harmony export */ });
/* unused harmony export InjectBefore */
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9);


var InjectionMode;
(function (InjectionMode) {
    // Injects once at page load for elements matching the selector
    InjectionMode[InjectionMode["ONCE"] = 0] = "ONCE";
    // Continually injects whenever new elements that match the
    // selector exist that haven't been injected into yet
    //
    // Should be use for "dynamic" elements
    InjectionMode[InjectionMode["CONTINUOUS"] = 1] = "CONTINUOUS";
})(InjectionMode || (InjectionMode = {}));
var InjectionType;
(function (InjectionType) {
    InjectionType[InjectionType["Append"] = 0] = "Append";
    InjectionType[InjectionType["Before"] = 1] = "Before";
    InjectionType[InjectionType["After"] = 2] = "After";
})(InjectionType || (InjectionType = {}));
const InjectionConfigs = {
    [InjectionType.Append]: {
        exists: (ctx, selector) => !!ctx.children(selector).length,
        op: (ctx, target) => ctx.append(target.elem()),
    },
    [InjectionType.Before]: {
        exists: (ctx, selector) => !!ctx.parent().children(selector).length,
        op: (ctx, target) => ctx.before(target.elem()),
    },
    [InjectionType.After]: {
        exists: (ctx, selector) => !!ctx.parent().children(selector).length,
        op: (ctx, target) => ctx.after(target.elem()),
    },
};
function CustomElement() {
    return function (target, propertyKey, descriptor) {
        if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_1__.inPageContext)()) {
            return;
        }
        if (customElements.get(target.tag())) {
            // Already defined
            return;
        }
        (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_0__.customElement)(target.tag())(target);
    };
}
function Inject(selector, mode, type) {
    return function (target, propertyKey, descriptor) {
        if (!(0,_utils_snips__WEBPACK_IMPORTED_MODULE_1__.inPageContext)()) {
            return;
        }
        switch (mode) {
            case InjectionMode.ONCE:
                $J(selector).each(function () {
                    InjectionConfigs[type].op($J(this), target);
                });
                break;
            case InjectionMode.CONTINUOUS:
                setInterval(() => {
                    $J(selector).each(function () {
                        // Don't add the item again if we already have
                        if (InjectionConfigs[type].exists($J(this), target.tag()))
                            return;
                        InjectionConfigs[type].op($J(this), target);
                    });
                }, 250);
                break;
        }
    };
}
function InjectAppend(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.Append);
}
function InjectBefore(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.Before);
}
function InjectAfter(selector, mode = InjectionMode.ONCE) {
    return Inject(selector, mode, InjectionType.After);
}


/***/ }),
/* 17 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "customElement": () => (/* reexport safe */ _lit_reactive_element_decorators_custom_element_js__WEBPACK_IMPORTED_MODULE_0__.customElement),
/* harmony export */   "state": () => (/* reexport safe */ _lit_reactive_element_decorators_state_js__WEBPACK_IMPORTED_MODULE_2__.state)
/* harmony export */ });
/* harmony import */ var _lit_reactive_element_decorators_custom_element_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _lit_reactive_element_decorators_property_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _lit_reactive_element_decorators_state_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _lit_reactive_element_decorators_event_options_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _lit_reactive_element_decorators_query_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23);
/* harmony import */ var _lit_reactive_element_decorators_query_all_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24);
/* harmony import */ var _lit_reactive_element_decorators_query_async_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(25);
/* harmony import */ var _lit_reactive_element_decorators_query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(26);
/* harmony import */ var _lit_reactive_element_decorators_query_assigned_nodes_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27);

//# sourceMappingURL=decorators.js.map


/***/ }),
/* 18 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "customElement": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e=e=>n=>"function"==typeof n?((e,n)=>(customElements.define(e,n),n))(e,n):((e,n)=>{const{kind:t,elements:s}=n;return{kind:t,elements:s,finisher(n){customElements.define(e,n)}}})(e,n);
//# sourceMappingURL=custom-element.js.map


/***/ }),
/* 19 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "property": () => (/* binding */ e)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const i=(i,e)=>"method"===e.kind&&e.descriptor&&!("value"in e.descriptor)?{...e,finisher(n){n.createProperty(e.key,i)}}:{kind:"field",key:Symbol(),placement:"own",descriptor:{},originalKey:e.key,initializer(){"function"==typeof e.initializer&&(this[e.key]=e.initializer.call(this))},finisher(n){n.createProperty(e.key,i)}};function e(e){return(n,t)=>void 0!==t?((i,e,n)=>{e.constructor.createProperty(n,i)})(e,n,t):i(e,n)}
//# sourceMappingURL=property.js.map


/***/ }),
/* 20 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "state": () => (/* binding */ t)
/* harmony export */ });
/* harmony import */ var _property_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function t(t){return (0,_property_js__WEBPACK_IMPORTED_MODULE_0__.property)({...t,state:!0})}
//# sourceMappingURL=state.js.map


/***/ }),
/* 21 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export eventOptions */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({finisher:(r,t)=>{Object.assign(r.prototype[t],e)}})}
//# sourceMappingURL=event-options.js.map


/***/ }),
/* 22 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "decorateProperty": () => (/* binding */ o)
/* harmony export */ });
/* unused harmony exports legacyPrototypeMethod, standardPrototypeMethod */
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e=(e,t,o)=>{Object.defineProperty(t,o,e)},t=(e,t)=>({kind:"method",placement:"prototype",key:t.key,descriptor:e}),o=({finisher:e,descriptor:t})=>(o,n)=>{var r;if(void 0===n){const n=null!==(r=o.originalKey)&&void 0!==r?r:o.key,i=null!=t?{kind:"method",placement:"prototype",key:n,descriptor:t(o.key)}:{...o,key:n};return null!=e&&(i.finisher=function(t){e(t,n)}),i}{const r=o.constructor;void 0!==t&&Object.defineProperty(o,n,t(n)),null==e||e(r,n)}};
//# sourceMappingURL=base.js.map


/***/ }),
/* 23 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export query */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function i(i,n){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:o=>{const t={get(){var o,n;return null!==(n=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(i))&&void 0!==n?n:null},enumerable:!0,configurable:!0};if(n){const n="symbol"==typeof o?Symbol():"__"+o;t.get=function(){var o,t;return void 0===this[n]&&(this[n]=null!==(t=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(i))&&void 0!==t?t:null),this[n]}}return t}})}
//# sourceMappingURL=query.js.map


/***/ }),
/* 24 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAll */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:r=>({get(){var r,o;return null!==(o=null===(r=this.renderRoot)||void 0===r?void 0:r.querySelectorAll(e))&&void 0!==o?o:[]},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-all.js.map


/***/ }),
/* 25 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAsync */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
function e(e){return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:r=>({async get(){var r;return await this.updateComplete,null===(r=this.renderRoot)||void 0===r?void 0:r.querySelector(e)},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-async.js.map


/***/ }),
/* 26 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "queryAssignedElements": () => (/* binding */ l)
/* harmony export */ });
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var n;const e=null!=(null===(n=window.HTMLSlotElement)||void 0===n?void 0:n.prototype.assignedElements)?(o,n)=>o.assignedElements(n):(o,n)=>o.assignedNodes(n).filter((o=>o.nodeType===Node.ELEMENT_NODE));function l(n){const{slot:l,selector:t}=null!=n?n:{};return (0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:o=>({get(){var o;const r="slot"+(l?`[name=${l}]`:":not([name])"),i=null===(o=this.renderRoot)||void 0===o?void 0:o.querySelector(r),s=null!=i?e(i,n):[];return t?s.filter((o=>o.matches(t))):s},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-assigned-elements.js.map


/***/ }),
/* 27 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* unused harmony export queryAssignedNodes */
/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);
/* harmony import */ var _query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function o(o,n,r){let l,s=o;return"object"==typeof o?(s=o.slot,l=o):l={flatten:n},r?(0,_query_assigned_elements_js__WEBPACK_IMPORTED_MODULE_1__.queryAssignedElements)({slot:s,flatten:n,selector:r}):(0,_base_js__WEBPACK_IMPORTED_MODULE_0__.decorateProperty)({descriptor:e=>({get(){var e,t;const o="slot"+(s?`[name=${s}]`:":not([name])"),n=null===(e=this.renderRoot)||void 0===e?void 0:e.querySelector(o);return null!==(t=null==n?void 0:n.assignedNodes(l))&&void 0!==t?t:[]},enumerable:!0,configurable:!0})})}
//# sourceMappingURL=query-assigned-nodes.js.map


/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ItemHolderMetadata": () => (/* binding */ ItemHolderMetadata)
/* harmony export */ });
/* harmony import */ var _custom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29);
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30);
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17);
/* harmony import */ var _services_float_fetcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35);
/* harmony import */ var _utils_skin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(40);
/* harmony import */ var _utils_ranks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(48);
/* harmony import */ var _utils_observers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








// Generic annotator of item holder metadata (float, seed, etc...)
// Must be extended to use as a component
class ItemHolderMetadata extends _custom__WEBPACK_IMPORTED_MODULE_0__.FloatElement {
    get assetId() {
        var _a;
        return (_a = $J(this).parent().attr('id')) === null || _a === void 0 ? void 0 : _a.split('_')[2];
    }
    get inspectLink() {
        var _a, _b, _c, _d;
        if (!this.asset)
            return;
        if (!((_a = this.asset) === null || _a === void 0 ? void 0 : _a.actions) || ((_c = (_b = this.asset) === null || _b === void 0 ? void 0 : _b.actions) === null || _c === void 0 ? void 0 : _c.length) === 0)
            return;
        if (!this.ownerSteamId) {
            return;
        }
        return (_d = this.asset) === null || _d === void 0 ? void 0 : _d.actions[0].link.replace('%owner_steamid%', this.ownerSteamId).replace('%assetid%', this.assetId);
    }
    render() {
        var _a;
        if (!this.itemInfo || !this.asset)
            return lit__WEBPACK_IMPORTED_MODULE_1__.html ``;
        if ((0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.isSkin)(this.asset)) {
            const fadePercentage = this.asset && (0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.getFadePercentage)(this.asset, this.itemInfo);
            if (fadePercentage === 100) {
                $J(this).parent().addClass('full-fade-border');
            }
            const rank = (0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.getLowestRank)(this.itemInfo);
            return lit__WEBPACK_IMPORTED_MODULE_1__.html `
                <span>
                    <span class="float">${(0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.formatFloatWithRank)(this.itemInfo, 6)}</span>
                    <span class="seed"
                        >${(0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.formatSeed)(this.itemInfo)}
                        ${fadePercentage !== undefined
                ? lit__WEBPACK_IMPORTED_MODULE_1__.html `<span class="fade ${rank && rank <= 5 ? 'csfloat-shine-fade-text' : ''}"
                                  >(${(0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.floor)(fadePercentage, 1)}%)</span
                              >`
                : lit__WEBPACK_IMPORTED_MODULE_1__.nothing}</span
                    >
                </span>
            `;
        }
        else if ((0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.isCharm)(this.asset)) {
            return lit__WEBPACK_IMPORTED_MODULE_1__.html `
                <span>
                    <span class="seed"
                        >#${((_a = this.itemInfo.keychains) === null || _a === void 0 ? void 0 : _a.length) > 0 ? this.itemInfo.keychains[0].pattern : 'NA'}</span
                    >
                </span>
            `;
        }
        else {
            return lit__WEBPACK_IMPORTED_MODULE_1__.html ``;
        }
    }
    connectedCallback() {
        const _super = Object.create(null, {
            connectedCallback: { get: () => super.connectedCallback }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.connectedCallback.call(this);
            if (this.inspectLink) {
                this.onInit();
            }
            else {
                // Wait until the asset exists
                (0,_utils_observers__WEBPACK_IMPORTED_MODULE_6__.Observe)(() => this.inspectLink, () => {
                    if (this.inspectLink) {
                        this.onInit();
                    }
                }, 200);
            }
        });
    }
    onInit() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.asset)
                return;
            if (!(0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.isSkin)(this.asset) && !(0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.isCharm)(this.asset))
                return;
            // Commodities won't have inspect links
            if (!this.inspectLink)
                return;
            try {
                this.itemInfo = yield _services_float_fetcher__WEBPACK_IMPORTED_MODULE_3__.gFloatFetcher.fetch({
                    link: this.inspectLink,
                });
            }
            catch (e) {
                console.error(`Failed to fetch float for ${this.assetId}: ${e.toString()}`);
            }
            if (this.itemInfo) {
                this.annotateRankShine(this.itemInfo);
            }
        });
    }
    annotateRankShine(info) {
        const rank = (0,_utils_skin__WEBPACK_IMPORTED_MODULE_4__.getLowestRank)(info);
        if (!rank || rank > 5) {
            return;
        }
        // Make the inventory box coloured ;)
        $J(this).parent().css('color', 'black');
        $J(this).parent().find('img').css('background-color', (0,_utils_ranks__WEBPACK_IMPORTED_MODULE_5__.getRankColour)(rank));
        $J(this).parent().addClass('csfloat-shine');
    }
}
ItemHolderMetadata.styles = [
    ..._custom__WEBPACK_IMPORTED_MODULE_0__.FloatElement.styles,
    lit__WEBPACK_IMPORTED_MODULE_1__.css `
            .float {
                position: absolute;
                bottom: 3px;
                right: 3px;
                font-size: 12px;
            }

            .seed {
                position: absolute;
                top: 3px;
                right: 3px;
                font-size: 12px;
            }

            .fade {
                background: -webkit-linear-gradient(0deg, #d9bba5 0%, #e5903b 33%, #db5977 66%, #6775e1 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
            }

            .csfloat-shine-fade-text {
                font-weight: 1000;
                -webkit-text-stroke: 1px black;
            }
        `,
];
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_2__.state)()
], ItemHolderMetadata.prototype, "itemInfo", void 0);


/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FloatElement": () => (/* binding */ FloatElement)
/* harmony export */ });
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30);

function camelToDashCase(str) {
    return str
        .split(/(?=[A-Z])/)
        .join('-')
        .toLowerCase();
}
// LitElement wrapper with a pre-determined tag
class FloatElement extends lit__WEBPACK_IMPORTED_MODULE_0__.LitElement {
    static tag() {
        return `csfloat-${camelToDashCase(this.name)}`;
    }
    static elem() {
        return document.createElement(this.tag());
    }
}
FloatElement.styles = [
    lit__WEBPACK_IMPORTED_MODULE_0__.css `
            hr {
                background-color: #1b2939;
                border-style: solid none none;
                border-color: black;
                border-width: 1px 0 0;
                height: 2px;
            }

            a {
                color: #ebebeb;
                cursor: pointer;
            }

            input[type='text'],
            input[type='password'],
            input[type='number'],
            select {
                color: #909090;
                background-color: rgba(0, 0, 0, 0.2);
                border: 1px solid #000;
                border-radius: 3px;
            }

            input[type='color'] {
                float: left;
                margin-top: 2px;
                -webkit-appearance: none;
                border: none;
                width: 20px;
                height: 20px;
                padding: 0;
            }

            input[type='color']::-webkit-color-swatch-wrapper {
                padding: 0;
            }

            input[type='color']::-webkit-color-swatch {
                border: none;
            }
        `,
];


/***/ }),
/* 30 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LitElement": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.LitElement),
/* harmony export */   "css": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.css),
/* harmony export */   "html": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.html),
/* harmony export */   "nothing": () => (/* reexport safe */ lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__.nothing)
/* harmony export */ });
/* harmony import */ var _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/* harmony import */ var lit_element_lit_element_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);

//# sourceMappingURL=index.js.map


/***/ }),
/* 31 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReactiveElement": () => (/* binding */ d),
/* harmony export */   "css": () => (/* reexport safe */ _css_tag_js__WEBPACK_IMPORTED_MODULE_0__.css)
/* harmony export */ });
/* unused harmony exports defaultConverter, notEqual */
/* harmony import */ var _css_tag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var s;const e=window,r=e.trustedTypes,h=r?r.emptyScript:"",o=e.reactiveElementPolyfillSupport,n={toAttribute(t,i){switch(i){case Boolean:t=t?h:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t)}return t},fromAttribute(t,i){let s=t;switch(i){case Boolean:s=null!==t;break;case Number:s=null===t?null:Number(t);break;case Object:case Array:try{s=JSON.parse(t)}catch(t){s=null}}return s}},a=(t,i)=>i!==t&&(i==i||t==t),l={attribute:!0,type:String,converter:n,reflect:!1,hasChanged:a};class d extends HTMLElement{constructor(){super(),this._$Ei=new Map,this.isUpdatePending=!1,this.hasUpdated=!1,this._$El=null,this.u()}static addInitializer(t){var i;null!==(i=this.h)&&void 0!==i||(this.h=[]),this.h.push(t)}static get observedAttributes(){this.finalize();const t=[];return this.elementProperties.forEach(((i,s)=>{const e=this._$Ep(s,i);void 0!==e&&(this._$Ev.set(e,s),t.push(e))})),t}static createProperty(t,i=l){if(i.state&&(i.attribute=!1),this.finalize(),this.elementProperties.set(t,i),!i.noAccessor&&!this.prototype.hasOwnProperty(t)){const s="symbol"==typeof t?Symbol():"__"+t,e=this.getPropertyDescriptor(t,s,i);void 0!==e&&Object.defineProperty(this.prototype,t,e)}}static getPropertyDescriptor(t,i,s){return{get(){return this[i]},set(e){const r=this[t];this[i]=e,this.requestUpdate(t,r,s)},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)||l}static finalize(){if(this.hasOwnProperty("finalized"))return!1;this.finalized=!0;const t=Object.getPrototypeOf(this);if(t.finalize(),this.elementProperties=new Map(t.elementProperties),this._$Ev=new Map,this.hasOwnProperty("properties")){const t=this.properties,i=[...Object.getOwnPropertyNames(t),...Object.getOwnPropertySymbols(t)];for(const s of i)this.createProperty(s,t[s])}return this.elementStyles=this.finalizeStyles(this.styles),!0}static finalizeStyles(i){const s=[];if(Array.isArray(i)){const e=new Set(i.flat(1/0).reverse());for(const i of e)s.unshift((0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.getCompatibleStyle)(i))}else void 0!==i&&s.push((0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.getCompatibleStyle)(i));return s}static _$Ep(t,i){const s=i.attribute;return!1===s?void 0:"string"==typeof s?s:"string"==typeof t?t.toLowerCase():void 0}u(){var t;this._$E_=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$Eg(),this.requestUpdate(),null===(t=this.constructor.h)||void 0===t||t.forEach((t=>t(this)))}addController(t){var i,s;(null!==(i=this._$ES)&&void 0!==i?i:this._$ES=[]).push(t),void 0!==this.renderRoot&&this.isConnected&&(null===(s=t.hostConnected)||void 0===s||s.call(t))}removeController(t){var i;null===(i=this._$ES)||void 0===i||i.splice(this._$ES.indexOf(t)>>>0,1)}_$Eg(){this.constructor.elementProperties.forEach(((t,i)=>{this.hasOwnProperty(i)&&(this._$Ei.set(i,this[i]),delete this[i])}))}createRenderRoot(){var t;const s=null!==(t=this.shadowRoot)&&void 0!==t?t:this.attachShadow(this.constructor.shadowRootOptions);return (0,_css_tag_js__WEBPACK_IMPORTED_MODULE_0__.adoptStyles)(s,this.constructor.elementStyles),s}connectedCallback(){var t;void 0===this.renderRoot&&(this.renderRoot=this.createRenderRoot()),this.enableUpdating(!0),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostConnected)||void 0===i?void 0:i.call(t)}))}enableUpdating(t){}disconnectedCallback(){var t;null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostDisconnected)||void 0===i?void 0:i.call(t)}))}attributeChangedCallback(t,i,s){this._$AK(t,s)}_$EO(t,i,s=l){var e;const r=this.constructor._$Ep(t,s);if(void 0!==r&&!0===s.reflect){const h=(void 0!==(null===(e=s.converter)||void 0===e?void 0:e.toAttribute)?s.converter:n).toAttribute(i,s.type);this._$El=t,null==h?this.removeAttribute(r):this.setAttribute(r,h),this._$El=null}}_$AK(t,i){var s;const e=this.constructor,r=e._$Ev.get(t);if(void 0!==r&&this._$El!==r){const t=e.getPropertyOptions(r),h="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==(null===(s=t.converter)||void 0===s?void 0:s.fromAttribute)?t.converter:n;this._$El=r,this[r]=h.fromAttribute(i,t.type),this._$El=null}}requestUpdate(t,i,s){let e=!0;void 0!==t&&(((s=s||this.constructor.getPropertyOptions(t)).hasChanged||a)(this[t],i)?(this._$AL.has(t)||this._$AL.set(t,i),!0===s.reflect&&this._$El!==t&&(void 0===this._$EC&&(this._$EC=new Map),this._$EC.set(t,s))):e=!1),!this.isUpdatePending&&e&&(this._$E_=this._$Ej())}async _$Ej(){this.isUpdatePending=!0;try{await this._$E_}catch(t){Promise.reject(t)}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){var t;if(!this.isUpdatePending)return;this.hasUpdated,this._$Ei&&(this._$Ei.forEach(((t,i)=>this[i]=t)),this._$Ei=void 0);let i=!1;const s=this._$AL;try{i=this.shouldUpdate(s),i?(this.willUpdate(s),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostUpdate)||void 0===i?void 0:i.call(t)})),this.update(s)):this._$Ek()}catch(t){throw i=!1,this._$Ek(),t}i&&this._$AE(s)}willUpdate(t){}_$AE(t){var i;null===(i=this._$ES)||void 0===i||i.forEach((t=>{var i;return null===(i=t.hostUpdated)||void 0===i?void 0:i.call(t)})),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t)}_$Ek(){this._$AL=new Map,this.isUpdatePending=!1}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$E_}shouldUpdate(t){return!0}update(t){void 0!==this._$EC&&(this._$EC.forEach(((t,i)=>this._$EO(i,this[i],t))),this._$EC=void 0),this._$Ek()}updated(t){}firstUpdated(t){}}d.finalized=!0,d.elementProperties=new Map,d.elementStyles=[],d.shadowRootOptions={mode:"open"},null==o||o({ReactiveElement:d}),(null!==(s=e.reactiveElementVersions)&&void 0!==s?s:e.reactiveElementVersions=[]).push("1.4.0");
//# sourceMappingURL=reactive-element.js.map


/***/ }),
/* 32 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "adoptStyles": () => (/* binding */ S),
/* harmony export */   "css": () => (/* binding */ i),
/* harmony export */   "getCompatibleStyle": () => (/* binding */ c)
/* harmony export */ });
/* unused harmony exports CSSResult, supportsAdoptingStyleSheets, unsafeCSS */
/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t=window,e=t.ShadowRoot&&(void 0===t.ShadyCSS||t.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s=Symbol(),n=new WeakMap;class o{constructor(t,e,n){if(this._$cssResult$=!0,n!==s)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e}get styleSheet(){let t=this.o;const s=this.t;if(e&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=n.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&n.set(s,t))}return t}toString(){return this.cssText}}const r=t=>new o("string"==typeof t?t:t+"",void 0,s),i=(t,...e)=>{const n=1===t.length?t[0]:e.reduce(((e,s,n)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[n+1]),t[0]);return new o(n,t,s)},S=(s,n)=>{e?s.adoptedStyleSheets=n.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet)):n.forEach((e=>{const n=document.createElement("style"),o=t.litNonce;void 0!==o&&n.setAttribute("nonce",o),n.textContent=e.cssText,s.appendChild(n)}))},c=e?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r(e)})(t):t;
//# sourceMappingURL=css-tag.js.map


/***/ }),
/* 33 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "html": () => (/* binding */ y),
/* harmony export */   "noChange": () => (/* binding */ x),
/* harmony export */   "nothing": () => (/* binding */ b),
/* harmony export */   "render": () => (/* binding */ A)
/* harmony export */ });
/* unused harmony exports _$LH, svg */
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
var t;const i=window,s=i.trustedTypes,e=s?s.createPolicy("lit-html",{createHTML:t=>t}):void 0,o=`lit$${(Math.random()+"").slice(9)}$`,n="?"+o,l=`<${n}>`,h=document,r=(t="")=>h.createComment(t),d=t=>null===t||"object"!=typeof t&&"function"!=typeof t,u=Array.isArray,c=t=>u(t)||"function"==typeof(null==t?void 0:t[Symbol.iterator]),v=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,a=/-->/g,f=/>/g,_=RegExp(">|[ \t\n\f\r](?:([^\\s\"'>=/]+)([ \t\n\f\r]*=[ \t\n\f\r]*(?:[^ \t\n\f\r\"'`<>=]|(\"|')|))|$)","g"),m=/'/g,p=/"/g,$=/^(?:script|style|textarea|title)$/i,g=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),y=g(1),w=g(2),x=Symbol.for("lit-noChange"),b=Symbol.for("lit-nothing"),T=new WeakMap,A=(t,i,s)=>{var e,o;const n=null!==(e=null==s?void 0:s.renderBefore)&&void 0!==e?e:i;let l=n._$litPart$;if(void 0===l){const t=null!==(o=null==s?void 0:s.renderBefore)&&void 0!==o?o:null;n._$litPart$=l=new S(i.insertBefore(r(),t),t,void 0,null!=s?s:{})}return l._$AI(t),l},E=h.createTreeWalker(h,129,null,!1),C=(t,i)=>{const s=t.length-1,n=[];let h,r=2===i?"<svg>":"",d=v;for(let i=0;i<s;i++){const s=t[i];let e,u,c=-1,g=0;for(;g<s.length&&(d.lastIndex=g,u=d.exec(s),null!==u);)g=d.lastIndex,d===v?"!--"===u[1]?d=a:void 0!==u[1]?d=f:void 0!==u[2]?($.test(u[2])&&(h=RegExp("</"+u[2],"g")),d=_):void 0!==u[3]&&(d=_):d===_?">"===u[0]?(d=null!=h?h:v,c=-1):void 0===u[1]?c=-2:(c=d.lastIndex-u[2].length,e=u[1],d=void 0===u[3]?_:'"'===u[3]?p:m):d===p||d===m?d=_:d===a||d===f?d=v:(d=_,h=void 0);const y=d===_&&t[i+1].startsWith("/>")?" ":"";r+=d===v?s+l:c>=0?(n.push(e),s.slice(0,c)+"$lit$"+s.slice(c)+o+y):s+o+(-2===c?(n.push(void 0),i):y)}const u=r+(t[s]||"<?>")+(2===i?"</svg>":"");if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return[void 0!==e?e.createHTML(u):u,n]};class P{constructor({strings:t,_$litType$:i},e){let l;this.parts=[];let h=0,d=0;const u=t.length-1,c=this.parts,[v,a]=C(t,i);if(this.el=P.createElement(v,e),E.currentNode=this.el.content,2===i){const t=this.el.content,i=t.firstChild;i.remove(),t.append(...i.childNodes)}for(;null!==(l=E.nextNode())&&c.length<u;){if(1===l.nodeType){if(l.hasAttributes()){const t=[];for(const i of l.getAttributeNames())if(i.endsWith("$lit$")||i.startsWith(o)){const s=a[d++];if(t.push(i),void 0!==s){const t=l.getAttribute(s.toLowerCase()+"$lit$").split(o),i=/([.?@])?(.*)/.exec(s);c.push({type:1,index:h,name:i[2],strings:t,ctor:"."===i[1]?R:"?"===i[1]?H:"@"===i[1]?I:M})}else c.push({type:6,index:h})}for(const i of t)l.removeAttribute(i)}if($.test(l.tagName)){const t=l.textContent.split(o),i=t.length-1;if(i>0){l.textContent=s?s.emptyScript:"";for(let s=0;s<i;s++)l.append(t[s],r()),E.nextNode(),c.push({type:2,index:++h});l.append(t[i],r())}}}else if(8===l.nodeType)if(l.data===n)c.push({type:2,index:h});else{let t=-1;for(;-1!==(t=l.data.indexOf(o,t+1));)c.push({type:7,index:h}),t+=o.length-1}h++}}static createElement(t,i){const s=h.createElement("template");return s.innerHTML=t,s}}function V(t,i,s=t,e){var o,n,l,h;if(i===x)return i;let r=void 0!==e?null===(o=s._$Cl)||void 0===o?void 0:o[e]:s._$Cu;const u=d(i)?void 0:i._$litDirective$;return(null==r?void 0:r.constructor)!==u&&(null===(n=null==r?void 0:r._$AO)||void 0===n||n.call(r,!1),void 0===u?r=void 0:(r=new u(t),r._$AT(t,s,e)),void 0!==e?(null!==(l=(h=s)._$Cl)&&void 0!==l?l:h._$Cl=[])[e]=r:s._$Cu=r),void 0!==r&&(i=V(t,r._$AS(t,i.values),r,e)),i}class N{constructor(t,i){this.v=[],this._$AN=void 0,this._$AD=t,this._$AM=i}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}p(t){var i;const{el:{content:s},parts:e}=this._$AD,o=(null!==(i=null==t?void 0:t.creationScope)&&void 0!==i?i:h).importNode(s,!0);E.currentNode=o;let n=E.nextNode(),l=0,r=0,d=e[0];for(;void 0!==d;){if(l===d.index){let i;2===d.type?i=new S(n,n.nextSibling,this,t):1===d.type?i=new d.ctor(n,d.name,d.strings,this,t):6===d.type&&(i=new L(n,this,t)),this.v.push(i),d=e[++r]}l!==(null==d?void 0:d.index)&&(n=E.nextNode(),l++)}return o}m(t){let i=0;for(const s of this.v)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++}}class S{constructor(t,i,s,e){var o;this.type=2,this._$AH=b,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$C_=null===(o=null==e?void 0:e.isConnected)||void 0===o||o}get _$AU(){var t,i;return null!==(i=null===(t=this._$AM)||void 0===t?void 0:t._$AU)&&void 0!==i?i:this._$C_}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===t.nodeType&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=V(this,t,i),d(t)?t===b||null==t||""===t?(this._$AH!==b&&this._$AR(),this._$AH=b):t!==this._$AH&&t!==x&&this.$(t):void 0!==t._$litType$?this.T(t):void 0!==t.nodeType?this.k(t):c(t)?this.O(t):this.$(t)}S(t,i=this._$AB){return this._$AA.parentNode.insertBefore(t,i)}k(t){this._$AH!==t&&(this._$AR(),this._$AH=this.S(t))}$(t){this._$AH!==b&&d(this._$AH)?this._$AA.nextSibling.data=t:this.k(h.createTextNode(t)),this._$AH=t}T(t){var i;const{values:s,_$litType$:e}=t,o="number"==typeof e?this._$AC(t):(void 0===e.el&&(e.el=P.createElement(e.h,this.options)),e);if((null===(i=this._$AH)||void 0===i?void 0:i._$AD)===o)this._$AH.m(s);else{const t=new N(o,this),i=t.p(this.options);t.m(s),this.k(i),this._$AH=t}}_$AC(t){let i=T.get(t.strings);return void 0===i&&T.set(t.strings,i=new P(t)),i}O(t){u(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const o of t)e===i.length?i.push(s=new S(this.S(r()),this.S(r()),this,this.options)):s=i[e],s._$AI(o),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e)}_$AR(t=this._$AA.nextSibling,i){var s;for(null===(s=this._$AP)||void 0===s||s.call(this,!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i}}setConnected(t){var i;void 0===this._$AM&&(this._$C_=t,null===(i=this._$AP)||void 0===i||i.call(this,t))}}class M{constructor(t,i,s,e,o){this.type=1,this._$AH=b,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=o,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=b}get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}_$AI(t,i=this,s,e){const o=this.strings;let n=!1;if(void 0===o)t=V(this,t,i,0),n=!d(t)||t!==this._$AH&&t!==x,n&&(this._$AH=t);else{const e=t;let l,h;for(t=o[0],l=0;l<o.length-1;l++)h=V(this,e[s+l],i,l),h===x&&(h=this._$AH[l]),n||(n=!d(h)||h!==this._$AH[l]),h===b?t=b:t!==b&&(t+=(null!=h?h:"")+o[l+1]),this._$AH[l]=h}n&&!e&&this.P(t)}P(t){t===b?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,null!=t?t:"")}}class R extends M{constructor(){super(...arguments),this.type=3}P(t){this.element[this.name]=t===b?void 0:t}}const k=s?s.emptyScript:"";class H extends M{constructor(){super(...arguments),this.type=4}P(t){t&&t!==b?this.element.setAttribute(this.name,k):this.element.removeAttribute(this.name)}}class I extends M{constructor(t,i,s,e,o){super(t,i,s,e,o),this.type=5}_$AI(t,i=this){var s;if((t=null!==(s=V(this,t,i,0))&&void 0!==s?s:b)===x)return;const e=this._$AH,o=t===b&&e!==b||t.capture!==e.capture||t.once!==e.once||t.passive!==e.passive,n=t!==b&&(e===b||o);o&&this.element.removeEventListener(this.name,this,e),n&&this.element.addEventListener(this.name,this,t),this._$AH=t}handleEvent(t){var i,s;"function"==typeof this._$AH?this._$AH.call(null!==(s=null===(i=this.options)||void 0===i?void 0:i.host)&&void 0!==s?s:this.element,t):this._$AH.handleEvent(t)}}class L{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s}get _$AU(){return this._$AM._$AU}_$AI(t){V(this,t)}}const z={A:"$lit$",M:o,C:n,L:1,R:C,D:N,V:c,I:V,H:S,N:M,U:H,B:I,F:R,W:L},Z=i.litHtmlPolyfillSupport;null==Z||Z(P,S),(null!==(t=i.litHtmlVersions)&&void 0!==t?t:i.litHtmlVersions=[]).push("2.3.1");
//# sourceMappingURL=lit-html.js.map


/***/ }),
/* 34 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LitElement": () => (/* binding */ s),
/* harmony export */   "css": () => (/* reexport safe */ _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.css),
/* harmony export */   "html": () => (/* reexport safe */ lit_html__WEBPACK_IMPORTED_MODULE_1__.html),
/* harmony export */   "nothing": () => (/* reexport safe */ lit_html__WEBPACK_IMPORTED_MODULE_1__.nothing)
/* harmony export */ });
/* unused harmony exports UpdatingElement, _$LE */
/* harmony import */ var _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var l,o;const r=_lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.ReactiveElement;class s extends _lit_reactive_element__WEBPACK_IMPORTED_MODULE_0__.ReactiveElement{constructor(){super(...arguments),this.renderOptions={host:this},this._$Do=void 0}createRenderRoot(){var t,e;const i=super.createRenderRoot();return null!==(t=(e=this.renderOptions).renderBefore)&&void 0!==t||(e.renderBefore=i.firstChild),i}update(t){const i=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this._$Do=(0,lit_html__WEBPACK_IMPORTED_MODULE_1__.render)(i,this.renderRoot,this.renderOptions)}connectedCallback(){var t;super.connectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!0)}disconnectedCallback(){var t;super.disconnectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!1)}render(){return lit_html__WEBPACK_IMPORTED_MODULE_1__.noChange}}s.finalized=!0,s._$litElement$=!0,null===(l=globalThis.litElementHydrateSupport)||void 0===l||l.call(globalThis,{LitElement:s});const n=globalThis.litElementPolyfillSupport;null==n||n({LitElement:s});const h={_$AK:(t,e,i)=>{t._$AK(e,i)},_$AL:t=>t._$AL};(null!==(o=globalThis.litElementVersions)&&void 0!==o?o:globalThis.litElementVersions=[]).push("3.2.2");
//# sourceMappingURL=lit-element.js.map


/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gFloatFetcher": () => (/* binding */ gFloatFetcher)
/* harmony export */ });
/* harmony import */ var _utils_queue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _bridge_handlers_fetch_inspect_info__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class InspectJob extends _utils_queue__WEBPACK_IMPORTED_MODULE_0__.Job {
    hashCode() {
        return this.data.link;
    }
}
class FloatFetcher extends _utils_queue__WEBPACK_IMPORTED_MODULE_0__.SimpleCachedQueue {
    constructor() {
        /** allow up to 10 simultaneous float fetch reqs */
        super(10);
    }
    fetch(req) {
        return this.add(new InspectJob(req));
    }
    process(req) {
        return __awaiter(this, void 0, void 0, function* () {
            const resp = yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(_bridge_handlers_fetch_inspect_info__WEBPACK_IMPORTED_MODULE_2__.FetchInspectInfo, req);
            return resp.iteminfo;
        });
    }
}
const gFloatFetcher = new FloatFetcher();


/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GenericJob": () => (/* binding */ GenericJob),
/* harmony export */   "Job": () => (/* binding */ Job),
/* harmony export */   "SimpleCachedQueue": () => (/* binding */ SimpleCachedQueue)
/* harmony export */ });
/* unused harmony exports Queue, CachedQueue, TTLCachedQueue */
/* harmony import */ var _cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _deferred_promise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class Job {
    constructor(data) {
        this.data = data;
    }
    getData() {
        return this.data;
    }
    /**
     * Hash that uniquely identifies this job.
     *
     * If two jobs have the same hashcode, they are considered identical.
     * */
    hashCode() {
        return JSON.stringify(this.data);
    }
}
class GenericJob extends Job {
}
/**
 * Queue to handle processing of "Jobs" with a request that
 * return a response. Ensures a max concurrency of processing
 * simultaneous jobs.
 */
class Queue {
    constructor(maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        this.internalQueue = [];
        this.jobsProcessing = 0;
    }
    /** Amount of jobs currently in the queue */
    size() {
        return this.internalQueue.length;
    }
    has(job) {
        return !!this.internalQueue.find((e) => e.job.hashCode() === job.hashCode());
    }
    getOrThrow(job) {
        if (!this.has(job)) {
            throw new Error(`Job[${job.hashCode()}] is not queued`);
        }
        // Guaranteed
        return this.internalQueue.find((e) => e.job.hashCode() === job.hashCode());
    }
    checkQueue() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.internalQueue.length === 0 || this.jobsProcessing >= this.maxConcurrency) {
                // Don't want to launch more instances
                return;
            }
            this.jobsProcessing += 1;
            const queuedJob = this.internalQueue.shift();
            const req = queuedJob.job.getData();
            try {
                const resp = yield this.process(req);
                queuedJob.deferredPromise.resolve(resp);
            }
            catch (e) {
                queuedJob.deferredPromise.reject(e.toString());
            }
            this.jobsProcessing -= 1;
            this.checkQueue();
        });
    }
    add(job) {
        var _a;
        if (this.has(job)) {
            return (_a = this.getOrThrow(job)) === null || _a === void 0 ? void 0 : _a.deferredPromise.promise();
        }
        const promise = new _deferred_promise__WEBPACK_IMPORTED_MODULE_1__.DeferredPromise();
        this.internalQueue.push({ job, deferredPromise: promise });
        setTimeout(() => this.checkQueue(), 0);
        return promise.promise();
    }
}
/**
 * Like a queue, but has an internal cache for elements already requested
 */
class CachedQueue extends Queue {
    /** Amount of previously requested jobs stored in the cache */
    cacheSize() {
        return this.cache().size();
    }
    getCached(job) {
        if (this.cache().has(job.hashCode())) {
            return this.cache().getOrThrow(job.hashCode());
        }
        else {
            return null;
        }
    }
    setCached(job, resp) {
        this.cache().set(job.hashCode(), resp);
    }
    add(job) {
        if (this.getCached(job)) {
            return Promise.resolve(this.getCached(job));
        }
        return super.add(job).then((resp) => {
            this.setCached(job, resp);
            return resp;
        });
    }
}
class SimpleCachedQueue extends CachedQueue {
    constructor() {
        super(...arguments);
        this.cache_ = new _cache__WEBPACK_IMPORTED_MODULE_0__.Cache();
    }
    cache() {
        return this.cache_;
    }
}
class TTLCachedQueue extends CachedQueue {
    constructor(maxConcurrency, ttlMs) {
        super(maxConcurrency);
        this.ttlMs = ttlMs;
        this.cache_ = new _cache__WEBPACK_IMPORTED_MODULE_0__.TTLCache(ttlMs);
    }
    cache() {
        return this.cache_;
    }
}


/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Cache": () => (/* binding */ Cache),
/* harmony export */   "TTLCache": () => (/* binding */ TTLCache)
/* harmony export */ });
/**
 * Simple Generic Cache with stringified keys
 */
class Cache {
    constructor() {
        this.cache_ = {};
    }
    set(key, value) {
        this.cache_[key] = value;
    }
    get(key) {
        return this.cache_[key];
    }
    getOrThrow(key) {
        if (!this.has(key)) {
            throw new Error(`key ${key} does not exist in map [getOrThrow]`);
        }
        return this.cache_[key];
    }
    has(key) {
        return key in this.cache_;
    }
    size() {
        return Object.keys(this.cache_).length;
    }
}
/**
 * Extension of {@link Cache} that allows setting a TTL (time-to-live) on a key
 * such that automatically expires after a specified time.
 *
 * By default, keys will expire with {@link defaultTTLMs}.
 */
class TTLCache {
    constructor(defaultTTLMs) {
        this.defaultTTLMs = defaultTTLMs;
        this.cache_ = {};
    }
    get(key) {
        const value = this.cache_[key];
        if (!value) {
            return;
        }
        // Check if it also respects TTL
        if (value.expiresEpoch < Date.now()) {
            return;
        }
        return value.data;
    }
    has(key) {
        return !!this.get(key);
    }
    getOrThrow(key) {
        if (!this.has(key)) {
            throw new Error(`key ${key} does not exist in map [getOrThrow]`);
        }
        return this.get(key);
    }
    setWithTTL(key, value, ttlMs) {
        this.cache_[key] = {
            data: value,
            expiresEpoch: Date.now() + ttlMs,
        };
    }
    set(key, value) {
        this.setWithTTL(key, value, this.defaultTTLMs);
    }
    size() {
        return Object.keys(this.cache_).length;
    }
}


/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DeferredPromise": () => (/* binding */ DeferredPromise)
/* harmony export */ });
/**
 * Similar to a promise, but allows the ability to resolve/reject in a different context
 * */
class DeferredPromise {
    constructor() {
        this.promise_ = new Promise((resolve, reject) => {
            this.resolve_ = resolve;
            this.reject_ = reject;
        });
    }
    resolve(value) {
        this.resolve_(value);
    }
    reject(reason) {
        this.reject_(reason);
    }
    promise() {
        return this.promise_;
    }
}


/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchInspectInfo": () => (/* binding */ FetchInspectInfo)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);


const FetchInspectInfo = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_INSPECT_INFO, (req) => {
    const apiUrl = `https://api.csfloat.com/?url=${req.link}&minimal=true${req.listPrice ? '&listPrice=' + req.listPrice : ''}`;
    return fetch(apiUrl).then((resp) => {
        return resp.json().then((json) => {
            if (resp.ok) {
                return json;
            }
            else {
                throw Error(json.error);
            }
        });
    });
});


/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "floor": () => (/* binding */ floor),
/* harmony export */   "formatFloatWithRank": () => (/* binding */ formatFloatWithRank),
/* harmony export */   "formatSeed": () => (/* binding */ formatSeed),
/* harmony export */   "getFadePercentage": () => (/* binding */ getFadePercentage),
/* harmony export */   "getLowestRank": () => (/* binding */ getLowestRank),
/* harmony export */   "isCharm": () => (/* binding */ isCharm),
/* harmony export */   "isSkin": () => (/* binding */ isSkin),
/* harmony export */   "renderClickableRank": () => (/* binding */ renderClickableRank)
/* harmony export */ });
/* unused harmony exports rangeFromWear, parseRank, getFadeCalculatorAndSupportedWeapon */
/* harmony import */ var _dopplers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41);
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30);
/* harmony import */ var csgo_fade_percentage_calculator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);



function rangeFromWear(wear) {
    const wearRanges = [
        [0.0, 0.07],
        [0.07, 0.15],
        [0.15, 0.38],
        [0.38, 0.45],
        [0.45, 1.0],
    ];
    for (const range of wearRanges) {
        if (wear > range[0] && wear <= range[1]) {
            return range;
        }
    }
    return null;
}
function getLowestRank(info) {
    if (!info.low_rank && !info.high_rank) {
        // Item has no rank to return
        return;
    }
    return (info.low_rank || 1001) < (info.high_rank || 1001) ? info.low_rank : info.high_rank;
}
function parseRank(info) {
    const rank = getLowestRank(info);
    if (rank && rank <= 1000) {
        return {
            order: rank === info.low_rank ? OrderType.LOW_RANK : OrderType.HIGH_RANK,
            rank,
        };
    }
}
function formatFloatWithRank(info, precisionDigits = 14) {
    let r = info.floatvalue.toFixed(precisionDigits);
    const ranked = parseRank(info);
    if (ranked) {
        r += ` (#${ranked.rank})`;
    }
    return r;
}
function formatSeed(info) {
    let r = info.paintseed.toString();
    if ((0,_dopplers__WEBPACK_IMPORTED_MODULE_0__.hasDopplerPhase)(info.paintindex)) {
        r += ` (${(0,_dopplers__WEBPACK_IMPORTED_MODULE_0__.getDopplerPhase)(info.paintindex)})`;
    }
    return r;
}
var OrderType;
(function (OrderType) {
    OrderType[OrderType["LOW_RANK"] = 1] = "LOW_RANK";
    OrderType[OrderType["HIGH_RANK"] = -1] = "HIGH_RANK";
})(OrderType || (OrderType = {}));
/**
 * Gets formatted link for floatdb for the specified item type and order
 * @param info item properties dict
 * @param order 1 for low float, -1 for high float ordering
 */
function getFloatDbLink(info, order) {
    function getFloatDbCategory(item) {
        var _a, _b;
        if ((_a = item.full_item_name) === null || _a === void 0 ? void 0 : _a.includes('StatTrak')) {
            return 2;
        }
        else if ((_b = item.full_item_name) === null || _b === void 0 ? void 0 : _b.includes('Souvenir')) {
            return 3;
        }
        else {
            // "Normal"
            return 1;
        }
    }
    return `https://csfloat.com/db?defIndex=${info.defindex}&paintIndex=${info.paintindex}&order=${order}&category=${getFloatDbCategory(info)}`;
}
function renderClickableRank(info) {
    const parsedRank = parseRank(info);
    if (!parsedRank) {
        return lit__WEBPACK_IMPORTED_MODULE_1__.html ``;
    }
    return lit__WEBPACK_IMPORTED_MODULE_1__.html ` <a
        style="color: #ebebeb; text-decoration: none; cursor: pointer;"
        href="${getFloatDbLink(info, parsedRank.order)}"
        target="_blank"
    >
        (Rank #${parsedRank.rank})
    </a>`;
}
function isSkin(asset) {
    return asset.tags
        ? asset.tags.some((a) => a.category === 'Weapon' || (a.category === 'Type' && a.internal_name === 'Type_Hands'))
        : ['★', 'Factory New', 'Minimal Wear', 'Field-Tested', 'Well-Worn', 'Battle-Scarred'].some((keyword) => asset.market_hash_name.includes(keyword));
}
function isCharm(asset) {
    if (asset.market_hash_name.startsWith('Charm')) {
        // Tags aren't available on SCM items, so use a MHN heuristic instead
        return true;
    }
    if (!asset.tags) {
        return false;
    }
    return asset.tags.some((e) => e.category === 'Type' && e.internal_name === 'CSGO_Tool_Keychain');
}
function getFadeCalculatorAndSupportedWeapon(asset) {
    const FADE_TYPE_TO_CALCULATOR = {
        Fade: csgo_fade_percentage_calculator__WEBPACK_IMPORTED_MODULE_2__.FadeCalculator,
        'Acid Fade': csgo_fade_percentage_calculator__WEBPACK_IMPORTED_MODULE_2__.AcidFadeCalculator,
        'Amber Fade': csgo_fade_percentage_calculator__WEBPACK_IMPORTED_MODULE_2__.AmberFadeCalculator,
    };
    for (const [fadeType, calculator] of Object.entries(FADE_TYPE_TO_CALCULATOR)) {
        for (const supportedWeapon of calculator.getSupportedWeapons()) {
            if (asset.market_hash_name.includes(`${supportedWeapon} | ${fadeType}`)) {
                return [calculator, supportedWeapon.toString()];
            }
        }
    }
}
function getFadePercentage(asset, itemInfo) {
    const fadeCalculatorAndSupportedWeapon = getFadeCalculatorAndSupportedWeapon(asset);
    if (fadeCalculatorAndSupportedWeapon !== undefined) {
        const [calculator, supportedWeapon] = fadeCalculatorAndSupportedWeapon;
        return calculator.getFadePercentage(supportedWeapon, itemInfo.paintseed).percentage;
    }
}
function floor(n, precision) {
    const p = Math.pow(10, (precision || 0));
    return Math.floor(n * p) / p;
}


/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getDopplerPhase": () => (/* binding */ getDopplerPhase),
/* harmony export */   "hasDopplerPhase": () => (/* binding */ hasDopplerPhase)
/* harmony export */ });
const dopplerPhases = {
    418: 'Phase 1',
    419: 'Phase 2',
    420: 'Phase 3',
    421: 'Phase 4',
    415: 'Ruby',
    416: 'Sapphire',
    417: 'Black Pearl',
    569: 'Phase 1',
    570: 'Phase 2',
    571: 'Phase 3',
    572: 'Phase 4',
    568: 'Emerald',
    618: 'Phase 2',
    619: 'Sapphire',
    617: 'Black Pearl',
    852: 'Phase 1',
    853: 'Phase 2',
    854: 'Phase 3',
    855: 'Phase 4',
    1119: 'Emerald',
    1120: 'Phase 1',
    1121: 'Phase 2',
    1122: 'Phase 3',
    1123: 'Phase 4',
};
function hasDopplerPhase(paintIndex) {
    return paintIndex in dopplerPhases;
}
function getDopplerPhase(paintIndex) {
    return dopplerPhases[paintIndex];
}


/***/ }),
/* 42 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AcidFadeCalculator": () => (/* binding */ AcidFadeCalculator),
/* harmony export */   "AmberFadeCalculator": () => (/* binding */ AmberFadeCalculator),
/* harmony export */   "FadeCalculator": () => (/* binding */ FadeCalculator)
/* harmony export */ });
/* harmony import */ var _modules_FadeCalculator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/* harmony import */ var _modules_AmberFadeCalculator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46);
/* harmony import */ var _modules_AcidFadeCalculator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47);



const FadeCalculator = new _modules_FadeCalculator_js__WEBPACK_IMPORTED_MODULE_0__["default"]();
const AmberFadeCalculator = new _modules_AmberFadeCalculator_js__WEBPACK_IMPORTED_MODULE_1__["default"]();
const AcidFadeCalculator = new _modules_AcidFadeCalculator_js__WEBPACK_IMPORTED_MODULE_2__["default"]();
//# sourceMappingURL=index.js.map

/***/ }),
/* 43 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseCalculator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);

class FadeCalculator extends _BaseCalculator_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
    constructor() {
        super(...arguments);
        this.weapons = [
            'AWP',
            'Bayonet',
            'Bowie Knife',
            'Butterfly Knife',
            'Classic Knife',
            'Falchion Knife',
            'Flip Knife',
            'Glock-18',
            'Gut Knife',
            'Huntsman Knife',
            'Karambit',
            'Kukri Knife',
            'M4A1-S',
            'M9 Bayonet',
            'MAC-10',
            'MP7',
            'Navaja Knife',
            'Nomad Knife',
            'Paracord Knife',
            'R8 Revolver',
            'Shadow Daggers',
            'Skeleton Knife',
            'Stiletto Knife',
            'Survival Knife',
            'Talon Knife',
            'UMP-45',
            'Ursus Knife',
        ];
        this.reversedWeapons = [
            'AWP',
            'Karambit',
            'MP7',
            'Talon Knife',
        ];
        this.tradeUpWeapons = [
            'AWP',
            'Glock-18',
            'M4A1-S',
            'MAC-10',
            'MP7',
            'R8 Revolver',
            'UMP-45',
        ];
        this.configs = {
            default: {
                pattern_offset_x_start: -0.7,
                pattern_offset_x_end: -0.7,
                pattern_offset_y_start: -0.7,
                pattern_offset_y_end: -0.7,
                pattern_rotate_start: -55,
                pattern_rotate_end: -65,
            },
            MP7: {
                pattern_offset_x_start: -0.9,
                pattern_offset_x_end: -0.3,
                pattern_offset_y_start: -0.7,
                pattern_offset_y_end: -0.5,
                pattern_rotate_start: -55,
                pattern_rotate_end: -65,
            },
            'M4A1-S': {
                pattern_offset_x_start: -0.14,
                pattern_offset_x_end: 0.05,
                pattern_offset_y_start: 0,
                pattern_offset_y_end: 0,
                pattern_rotate_start: -45,
                pattern_rotate_end: -45,
            },
        };
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FadeCalculator);
//# sourceMappingURL=FadeCalculator.js.map

/***/ }),
/* 44 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _RandomNumberGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(45);

class BaseCalculator {
    constructor() {
        this.minPercentage = 80;
    }
    getSupportedWeapons() {
        return this.weapons;
    }
    getFadePercentage(weapon, seed) {
        const percentages = this.getFadePercentages(weapon);
        return percentages[seed];
    }
    getAllFadePercentages() {
        return this.weapons.map((weapon) => ({
            weapon,
            percentages: this.getFadePercentages(weapon),
        }));
    }
    getFadePercentages(weapon) {
        if (!this.weapons.includes(weapon)) {
            throw new Error(`The weapon "${weapon}" is currently not supported.`);
        }
        const config = this.configs[weapon] || this.configs.default;
        const rawResults = [];
        const maxSeed = this.tradeUpWeapons.includes(weapon)
            ? 1000
            : 999;
        for (let i = 0; i <= maxSeed; i += 1) {
            const randomNumberGenerator = new _RandomNumberGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"]();
            randomNumberGenerator.setSeed(i);
            const xOffset = randomNumberGenerator.randomFloat(config.pattern_offset_x_start, config.pattern_offset_x_end);
            randomNumberGenerator.randomFloat(config.pattern_offset_y_start, config.pattern_offset_y_end);
            const rotation = randomNumberGenerator.randomFloat(config.pattern_rotate_start, config.pattern_rotate_end);
            let rawResult;
            const usesRotation = config.pattern_rotate_start !== config.pattern_rotate_end;
            const usesXOffset = config.pattern_offset_x_start !== config.pattern_offset_x_end;
            if (usesRotation && usesXOffset) {
                rawResult = rotation * xOffset;
            }
            else if (usesRotation) {
                rawResult = rotation;
            }
            else {
                rawResult = xOffset;
            }
            rawResults.push(rawResult);
        }
        const isReversed = this.reversedWeapons.includes(weapon);
        let bestResult;
        let worstResult;
        if (isReversed) {
            bestResult = Math.min(...rawResults);
            worstResult = Math.max(...rawResults);
        }
        else {
            bestResult = Math.max(...rawResults);
            worstResult = Math.min(...rawResults);
        }
        const resultRange = worstResult - bestResult;
        const percentageResults = rawResults.map((rawResult) => (worstResult - rawResult) / resultRange);
        const sortedPercentageResults = [...percentageResults].sort((a, b) => a - b);
        return percentageResults.map((percentageResult, i) => ({
            seed: i,
            percentage: this.minPercentage + (percentageResult * (100 - this.minPercentage)),
            ranking: Math.min(sortedPercentageResults.indexOf(percentageResult) + 1, sortedPercentageResults.length - sortedPercentageResults.indexOf(percentageResult)),
        }));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseCalculator);
//# sourceMappingURL=BaseCalculator.js.map

/***/ }),
/* 45 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
class RandomNumberGenerator {
    constructor() {
        this.mIdum = 0;
        this.mIy = 0;
        this.mIv = [];
        this.NTAB = 32;
        this.IA = 16807;
        this.IM = 2147483647;
        this.IQ = 127773;
        this.IR = 2836;
        this.NDIV = 1 + (this.IM - 1) / this.NTAB;
        this.AM = 1.0 / this.IM;
        this.RNMX = 1.0 - 1.2e-7;
    }
    setSeed(seed) {
        this.mIdum = seed;
        if (seed >= 0) {
            this.mIdum = -seed;
        }
        this.mIy = 0;
    }
    generateRandomNumber() {
        let k;
        let j;
        if (this.mIdum <= 0 || this.mIy === 0) {
            if (-this.mIdum < 1) {
                this.mIdum = 1;
            }
            else {
                this.mIdum = -this.mIdum;
            }
            for (j = this.NTAB + 7; j >= 0; j -= 1) {
                k = Math.floor(this.mIdum / this.IQ);
                this.mIdum = Math.floor(this.IA * (this.mIdum - k * this.IQ) - this.IR * k);
                if (this.mIdum < 0) {
                    this.mIdum += this.IM;
                }
                if (j < this.NTAB) {
                    this.mIv[j] = this.mIdum;
                }
            }
            [this.mIy] = this.mIv;
        }
        k = Math.floor(this.mIdum / this.IQ);
        this.mIdum = Math.floor(this.IA * (this.mIdum - k * this.IQ) - this.IR * k);
        if (this.mIdum < 0) {
            this.mIdum += this.IM;
        }
        j = Math.floor(this.mIy / this.NDIV);
        this.mIy = Math.floor(this.mIv[j]);
        this.mIv[j] = this.mIdum;
        return this.mIy;
    }
    randomFloat(low, high) {
        let float = this.AM * this.generateRandomNumber();
        if (float > this.RNMX) {
            float = this.RNMX;
        }
        return (float * (high - low)) + low;
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RandomNumberGenerator);
//# sourceMappingURL=RandomNumberGenerator.js.map

/***/ }),
/* 46 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseCalculator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);

class AmberFadeCalculator extends _BaseCalculator_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
    constructor() {
        super(...arguments);
        this.weapons = [
            'AUG',
            'Galil AR',
            'MAC-10',
            'P2000',
            'R8 Revolver',
            'Sawed-Off',
        ];
        this.reversedWeapons = [];
        this.tradeUpWeapons = [
            'AUG',
            'Galil AR',
            'MAC-10',
            'P2000',
            'R8 Revolver',
            'Sawed-Off',
        ];
        this.configs = {
            default: {
                pattern_offset_x_start: -0.7,
                pattern_offset_x_end: -0.7,
                pattern_offset_y_start: -0.7,
                pattern_offset_y_end: -0.7,
                pattern_rotate_start: -55,
                pattern_rotate_end: -65,
            },
        };
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AmberFadeCalculator);
//# sourceMappingURL=AmberFadeCalculator.js.map

/***/ }),
/* 47 */
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BaseCalculator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44);

class AcidFadeCalculator extends _BaseCalculator_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
    constructor() {
        super(...arguments);
        this.weapons = [
            'SSG 08',
        ];
        this.reversedWeapons = [
            'SSG 08',
        ];
        this.tradeUpWeapons = [
            'SSG 08',
        ];
        this.configs = {
            default: {
                pattern_offset_x_start: -2.4,
                pattern_offset_x_end: -2.1,
                pattern_offset_y_start: 0.0,
                pattern_offset_y_end: 0.0,
                pattern_rotate_start: -55,
                pattern_rotate_end: -65,
            },
        };
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AcidFadeCalculator);
//# sourceMappingURL=AcidFadeCalculator.js.map

/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getRankColour": () => (/* binding */ getRankColour)
/* harmony export */ });
function getRankColour(rank) {
    switch (rank) {
        case 1:
            return '#c3a508';
        case 2:
        case 3:
            return '#9a9999';
        case 4:
        case 5:
            return '#8a5929';
        default:
            return '';
    }
}


/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Observe": () => (/* binding */ Observe)
/* harmony export */ });
function Observe(computeObject, cb, pollRateMs = 50) {
    let prev = computeObject();
    setInterval(() => {
        const now = computeObject();
        if (prev !== now) {
            cb();
        }
        prev = now;
    }, pollRateMs);
}


/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony export SelectedItemInfo */
/* harmony import */ var _custom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29);
/* harmony import */ var _injectors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(30);
/* harmony import */ var lit_decorators_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17);
/* harmony import */ var _services_float_fetcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35);
/* harmony import */ var _utils_skin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(40);
/* harmony import */ var _utils_observers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49);
/* harmony import */ var _services_stall_fetcher__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(51);
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








/**
 * Why do we bind to iteminfo0 AND iteminfo1?
 *
 * Steam uses two divs that are interchanged (presumably to make a "fade" animation between them) for each selected
 * item click.
 */
let SelectedItemInfo = class SelectedItemInfo extends _custom__WEBPACK_IMPORTED_MODULE_0__.FloatElement {
    constructor() {
        super(...arguments);
        this.loading = false;
    }
    get asset() {
        return g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.selectedItem;
    }
    get inspectLink() {
        var _a, _b, _c, _d;
        if (!this.asset)
            return;
        if (!((_a = this.asset.description) === null || _a === void 0 ? void 0 : _a.actions) || ((_c = (_b = this.asset.description) === null || _b === void 0 ? void 0 : _b.actions) === null || _c === void 0 ? void 0 : _c.length) === 0)
            return;
        if (!(g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_owner)) {
            return;
        }
        return (_d = this.asset.description) === null || _d === void 0 ? void 0 : _d.actions[0].link.replace('%owner_steamid%', g_ActiveInventory.m_owner.strSteamId).replace('%assetid%', this.asset.assetid);
    }
    get stallListing() {
        if (!this.stall) {
            return;
        }
        return (this.stall.data || []).find((e) => { var _a; return e.item.asset_id === ((_a = this.asset) === null || _a === void 0 ? void 0 : _a.assetid); });
    }
    render() {
        var _a, _b;
        if (this.loading) {
            return lit__WEBPACK_IMPORTED_MODULE_2__.html `<div>Loading...</div>`;
        }
        if (!this.itemInfo || !((_a = this.asset) === null || _a === void 0 ? void 0 : _a.description)) {
            return lit__WEBPACK_IMPORTED_MODULE_2__.html ``;
        }
        if ((0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.isSkin)(this.asset.description)) {
            const fadePercentage = this.asset && (0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.getFadePercentage)(this.asset.description, this.itemInfo);
            return lit__WEBPACK_IMPORTED_MODULE_2__.html `
                <div class="container">
                    <div>Float: ${this.itemInfo.floatvalue.toFixed(14)} ${(0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.renderClickableRank)(this.itemInfo)}</div>
                    <div>Paint Seed: ${(0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.formatSeed)(this.itemInfo)}</div>
                    ${fadePercentage !== undefined ? lit__WEBPACK_IMPORTED_MODULE_2__.html `<div>Fade: ${(0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.floor)(fadePercentage, 5)}%</div>` : lit__WEBPACK_IMPORTED_MODULE_2__.nothing}
                    ${this.renderListOnCSFloat()} ${this.renderFloatMarketListing()}
                </div>
            `;
        }
        else if ((0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.isCharm)(this.asset.description)) {
            return lit__WEBPACK_IMPORTED_MODULE_2__.html `
                <div class="container">
                    <div>
                        Pattern:
                        #${((_b = this.itemInfo.keychains) === null || _b === void 0 ? void 0 : _b.length) > 0 ? this.itemInfo.keychains[0].pattern : 'Unknown'}
                    </div>
                </div>
            `;
        }
        else {
            return lit__WEBPACK_IMPORTED_MODULE_2__.html ``;
        }
    }
    renderFloatMarketListing() {
        if (!this.stallListing) {
            return lit__WEBPACK_IMPORTED_MODULE_2__.html ``;
        }
        return lit__WEBPACK_IMPORTED_MODULE_2__.html `
            <div class="market-btn-container">
                <a class="market-btn" href="https://csfloat.com/item/${this.stallListing.id}" target="_blank">
                    <img src="https://csfloat.com/assets/n_full_logo.png" height="21" style="margin-right: 5px;" />
                    <span>
                        Listed for
                        <b>$${(this.stallListing.price / 100).toFixed(2)}</b>
                    </span>
                </a>
            </div>
        `;
    }
    renderListOnCSFloat() {
        var _a;
        if (this.stallListing) {
            // Don't tell them to list it if it's already listed...
            return lit__WEBPACK_IMPORTED_MODULE_2__.html ``;
        }
        if (((_a = g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_owner) === null || _a === void 0 ? void 0 : _a.strSteamId) !== g_steamID) {
            // Not the signed-in user, don't show
            return lit__WEBPACK_IMPORTED_MODULE_2__.html ``;
        }
        return lit__WEBPACK_IMPORTED_MODULE_2__.html `
            <div class="market-btn-container">
                <a class="market-btn" href="https://csfloat.com" target="_blank">
                    <span>List on </span>
                    <img src="https://csfloat.com/assets/n_full_logo.png" height="21" style="margin-left: 5px;" />
                </a>
            </div>
        `;
    }
    processSelectChange() {
        return __awaiter(this, void 0, void 0, function* () {
            // Reset state in-case they swap between skin and non-skin
            this.itemInfo = undefined;
            if (!this.asset)
                return;
            if (!(0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.isSkin)(this.asset.description) && !(0,_utils_skin__WEBPACK_IMPORTED_MODULE_5__.isCharm)(this.asset.description))
                return;
            // Commodities won't have inspect links
            if (!this.inspectLink)
                return;
            try {
                this.loading = true;
                this.itemInfo = yield _services_float_fetcher__WEBPACK_IMPORTED_MODULE_4__.gFloatFetcher.fetch({
                    link: this.inspectLink,
                });
            }
            catch (e) {
                console.error(`Failed to fetch float for ${this.asset.assetid}: ${e.toString()}`);
            }
            finally {
                this.loading = false;
            }
        });
    }
    connectedCallback() {
        var _a;
        super.connectedCallback();
        // For the initial load, in case an item is pre-selected
        this.processSelectChange();
        (0,_utils_observers__WEBPACK_IMPORTED_MODULE_6__.Observe)(() => this.asset, () => {
            this.processSelectChange();
        });
        if ((_a = g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_owner) === null || _a === void 0 ? void 0 : _a.strSteamId) {
            // Ignore errors
            _services_stall_fetcher__WEBPACK_IMPORTED_MODULE_7__.gStallFetcher.fetch({ steam_id64: g_ActiveInventory === null || g_ActiveInventory === void 0 ? void 0 : g_ActiveInventory.m_owner.strSteamId })
                .then((stall) => (this.stall = stall));
        }
    }
};
SelectedItemInfo.styles = [
    ..._custom__WEBPACK_IMPORTED_MODULE_0__.FloatElement.styles,
    lit__WEBPACK_IMPORTED_MODULE_2__.css `
            .container {
                margin-bottom: 10px;
            }

            .market-btn-container {
                margin: 10px 0 10px 0;
                padding: 5px;
                width: fit-content;
                border: 1px #5a5a5a solid;
                background-color: #383838;
                border-radius: 3px;
            }

            .market-btn {
                font-size: 15px;
                display: flex;
                align-items: center;
                color: #ebebeb;
                text-decoration: none;
            }
        `,
];
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_3__.state)()
], SelectedItemInfo.prototype, "itemInfo", void 0);
__decorate([
    (0,lit_decorators_js__WEBPACK_IMPORTED_MODULE_3__.state)()
], SelectedItemInfo.prototype, "loading", void 0);
SelectedItemInfo = __decorate([
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.CustomElement)(),
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.InjectAfter)('div#iteminfo0_content .item_desc_description div.item_desc_game_info', _injectors__WEBPACK_IMPORTED_MODULE_1__.InjectionMode.CONTINUOUS),
    (0,_injectors__WEBPACK_IMPORTED_MODULE_1__.InjectAfter)('div#iteminfo1_content .item_desc_description div.item_desc_game_info', _injectors__WEBPACK_IMPORTED_MODULE_1__.InjectionMode.CONTINUOUS)
], SelectedItemInfo);



/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gStallFetcher": () => (/* binding */ gStallFetcher)
/* harmony export */ });
/* harmony import */ var _utils_queue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36);
/* harmony import */ var _bridge_handlers_fetch_stall__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52);
/* harmony import */ var _bridge_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class StallFetcher extends _utils_queue__WEBPACK_IMPORTED_MODULE_0__.SimpleCachedQueue {
    fetch(req) {
        return this.add(new _utils_queue__WEBPACK_IMPORTED_MODULE_0__.GenericJob(req));
    }
    process(req) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield (0,_bridge_client__WEBPACK_IMPORTED_MODULE_2__.ClientSend)(_bridge_handlers_fetch_stall__WEBPACK_IMPORTED_MODULE_1__.FetchStall, req);
            }
            catch (e) {
                // Stub out to prevent future calls
                return { data: [] };
            }
        });
    }
}
const gStallFetcher = new StallFetcher(1);


/***/ }),
/* 52 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchStall": () => (/* binding */ FetchStall)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchStall = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_STALL, (req) => __awaiter(void 0, void 0, void 0, function* () {
    return fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/users/${req.steam_id64}/stall`).then((resp) => {
        return resp.json().then((json) => {
            if (resp.ok) {
                return json;
            }
            else {
                throw Error(json.message);
            }
        });
    });
}));


/***/ }),
/* 53 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "environment": () => (/* binding */ environment)
/* harmony export */ });
const environment = {
    csfloat_base_api_url: 'https://csfloat.com/api',
};


/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _components_inventory_inventory_item_holder_metadata__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15);
/* harmony import */ var _components_inventory_selected_item_info__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



(0,_utils__WEBPACK_IMPORTED_MODULE_0__.init)('src/lib/page_scripts/inventory.js', main);
function main() {
    return __awaiter(this, void 0, void 0, function* () { });
}

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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