/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 53:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "environment": () => (/* binding */ environment)
/* harmony export */ });
const environment = {
    csfloat_base_api_url: 'https://csfloat.com/api',
};


/***/ }),

/***/ 408:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearAccessTokenFromStorage": () => (/* binding */ clearAccessTokenFromStorage),
/* harmony export */   "getAccessToken": () => (/* binding */ getAccessToken)
/* harmony export */ });
/* unused harmony export saveAccessToken */
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62);
/* harmony import */ var _storage_keys__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function getAccessToken(expectedSteamID) {
    return __awaiter(this, void 0, void 0, function* () {
        // Do we have a fresh local copy?
        const tokenData = yield _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.getWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_1__.StorageKey.ACCESS_TOKEN);
        if ((tokenData === null || tokenData === void 0 ? void 0 : tokenData.token) && tokenData.updated_at > Date.now() - 30 * 60 * 1000) {
            // Token refreshed within the last 30 min, we can re-use
            if (!expectedSteamID || expectedSteamID === (tokenData === null || tokenData === void 0 ? void 0 : tokenData.steam_id)) {
                return tokenData;
            }
        }
        // Need to fetch a new one
        const resp = yield fetch(`https://steamcommunity.com`, {
            credentials: 'include',
            headers: {
                // Required for Steam to refresh the JWT when it expires
                Accept: 'text/html,application/xhtml+xml,application/xml;q=0.9;q=0.8,application/signed-exchange;v=b3;q=0.7',
            },
        });
        const body = yield resp.text();
        const webAPITokenMatch = /data-loyalty_webapi_token="&quot;([a-zA-Z0-9_.-]+)&quot;"/.exec(body);
        if (!webAPITokenMatch || webAPITokenMatch.length === 0) {
            throw new Error('failed to parse web api token');
        }
        const token = webAPITokenMatch[1];
        const steamID = extractSteamID(body);
        if (steamID && expectedSteamID && steamID !== expectedSteamID) {
            throw new Error('user is not logged into the expected steam account');
        }
        try {
            yield saveAccessToken(token, steamID);
        }
        catch (e) {
            console.error('failed ot save access token to storage', e);
        }
        return { token, steam_id: steamID, updated_at: Date.now() };
    });
}
function extractSteamID(body) {
    const steamIDMatch = /g_steamID = "(\d+?)"/.exec(body);
    if (!steamIDMatch || steamIDMatch.length === 0) {
        return null;
    }
    return steamIDMatch[1];
}
function saveAccessToken(token, steamID) {
    // Explicitly use local storage to prevent issues with sync storage quota or connectivity issues
    return _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.setWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_1__.StorageKey.ACCESS_TOKEN, {
        token,
        steam_id: steamID,
        updated_at: Date.now(),
    });
}
function clearAccessTokenFromStorage() {
    return _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.removeWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_1__.StorageKey.ACCESS_TOKEN);
}


/***/ }),

/***/ 405:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PING_CSFLOAT_TRADE_STATUS_ALARM_NAME": () => (/* binding */ PING_CSFLOAT_TRADE_STATUS_ALARM_NAME),
/* harmony export */   "pingTradeStatus": () => (/* binding */ pingTradeStatus)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_fetch_pending_trades__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(396);
/* harmony import */ var _trade_history__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(406);
/* harmony import */ var _trade_offer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(409);
/* harmony import */ var _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(398);
/* harmony import */ var _bridge_handlers_ping_extension_status__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(414);
/* harmony import */ var _access_token__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(408);
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(62);
/* harmony import */ var _storage_keys__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(60);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








const PING_CSFLOAT_TRADE_STATUS_ALARM_NAME = 'ping_csfloat_trade_status_alarm';
function pingTradeStatus(expectedSteamID) {
    return __awaiter(this, void 0, void 0, function* () {
        yield _storage_store__WEBPACK_IMPORTED_MODULE_6__.gStore.setWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_7__.StorageKey.LAST_TRADE_PING_ATTEMPT, Date.now());
        const hasPermissions = yield _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_3__.HasPermissions.handleRequest({
            permissions: [],
            origins: ['*://*.steampowered.com/*'],
        }, {});
        if (!hasPermissions.granted) {
            // They didn't enable offer tracking, skip for now
            return;
        }
        let pendingTrades;
        try {
            const resp = yield _bridge_handlers_fetch_pending_trades__WEBPACK_IMPORTED_MODULE_0__.FetchPendingTrades.handleRequest({ limit: 1000 }, {});
            pendingTrades = resp.trades;
        }
        catch (e) {
            console.error(e);
            console.log('cannot fetch pending trades for CSFloat, may not be logged in or CSFloat down');
            return;
        }
        let access = null;
        try {
            access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_5__.getAccessToken)(expectedSteamID);
        }
        catch (e) {
            console.error('failed to fetch access token', e);
        }
        let errors;
        if (pendingTrades.length > 0) {
            errors = yield pingUpdates(pendingTrades);
        }
        // Ping status of ext + permissions
        try {
            yield _bridge_handlers_ping_extension_status__WEBPACK_IMPORTED_MODULE_4__.PingExtensionStatus.handleRequest({
                access_token_steam_id: access === null || access === void 0 ? void 0 : access.steam_id,
                history_error: errors === null || errors === void 0 ? void 0 : errors.history_error,
                trade_offer_error: errors === null || errors === void 0 ? void 0 : errors.trade_offer_error,
            }, {});
        }
        catch (e) {
            console.error('failed to ping extension status to csfloat', e);
        }
    });
}
function pingUpdates(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const errors = {};
        try {
            yield (0,_trade_offer__WEBPACK_IMPORTED_MODULE_2__.cancelUnconfirmedTradeOffers)(pendingTrades);
        }
        catch (e) {
            console.error(`failed to cancel unconfirmed trade offers`, e);
        }
        try {
            yield (0,_trade_history__WEBPACK_IMPORTED_MODULE_1__.pingTradeHistory)(pendingTrades);
        }
        catch (e) {
            console.error('failed to ping trade history', e);
            errors.history_error = e.toString();
        }
        try {
            yield (0,_trade_offer__WEBPACK_IMPORTED_MODULE_2__.pingSentTradeOffers)(pendingTrades);
        }
        catch (e) {
            console.error('failed to ping sent trade offer state', e);
            errors.trade_offer_error = e.toString();
        }
        try {
            yield (0,_trade_offer__WEBPACK_IMPORTED_MODULE_2__.pingCancelTrades)(pendingTrades);
        }
        catch (e) {
            console.error('failed to ping cancel ping trade offers', e);
        }
        return errors;
    });
}


/***/ }),

/***/ 404:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "alarmListener": () => (/* binding */ alarmListener),
/* harmony export */   "registerTradeAlarmIfPossible": () => (/* binding */ registerTradeAlarmIfPossible)
/* harmony export */ });
/* harmony import */ var _csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(405);
/* harmony import */ var _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(398);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function alarmListener(alarm) {
    return __awaiter(this, void 0, void 0, function* () {
        if (alarm.name === _csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME) {
            yield (0,_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.pingTradeStatus)();
        }
    });
}
function registerAlarmListenerIfPossible() {
    return __awaiter(this, void 0, void 0, function* () {
        if (chrome.alarms) {
            chrome.alarms.onAlarm.addListener(alarmListener);
        }
    });
}
function registerTradeAlarmIfPossible() {
    return __awaiter(this, void 0, void 0, function* () {
        const hasPermissions = yield _bridge_handlers_has_permissions__WEBPACK_IMPORTED_MODULE_1__.HasPermissions.handleRequest({ permissions: ['alarms'], origins: [] }, {});
        if (!hasPermissions.granted) {
            return;
        }
        yield registerAlarmListenerIfPossible();
        const alarm = yield chrome.alarms.get(_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME);
        const hasAlarmWithOutdatedTimer = ((alarm === null || alarm === void 0 ? void 0 : alarm.periodInMinutes) && (alarm === null || alarm === void 0 ? void 0 : alarm.periodInMinutes) > 3) ||
            ((alarm === null || alarm === void 0 ? void 0 : alarm.scheduledTime) && (alarm === null || alarm === void 0 ? void 0 : alarm.scheduledTime) > Date.now() + 10 * 60 * 1000); // Alarm scheduled more than 10 minutes in the future (can be caused by bad system clock)
        if (!alarm || hasAlarmWithOutdatedTimer) {
            yield chrome.alarms.create(_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_0__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME, {
                periodInMinutes: 3,
                delayInMinutes: 1,
            });
        }
    });
}


/***/ }),

/***/ 406:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "pingTradeHistory": () => (/* binding */ pingTradeHistory)
/* harmony export */ });
/* harmony import */ var _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(407);
/* harmony import */ var _types_steam_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58);
/* harmony import */ var _access_token__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(408);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



function pingTradeHistory(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const { history, type } = yield getTradeHistory();
        // premature optimization in case it's 100 trades
        const assetsToFind = pendingTrades.reduce((acc, e) => {
            acc[e.contract.item.asset_id] = true;
            return acc;
        }, {});
        // We only want to send history that is relevant to verifying trades on CSFloat
        const historyForCSFloat = history.filter((e) => {
            const received_ids = e.received_assets.map((e) => e.asset_id);
            const given_ids = e.given_assets.map((e) => e.asset_id);
            return !![...received_ids, ...given_ids].find((e) => {
                return assetsToFind[e];
            });
        });
        if (historyForCSFloat.length === 0) {
            return;
        }
        yield _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__.TradeHistoryStatus.handleRequest({ history: historyForCSFloat, type }, {});
    });
}
function getTradeHistory() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const history = yield getTradeHistoryFromAPI();
            if (history.length > 0) {
                // Hedge in case this endpoint gets killed, only return if there are results, fallback to HTML parser
                return { history, type: _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__.TradeHistoryType.API };
            }
            else {
                throw new Error('failed to get trade history');
            }
        }
        catch (e) {
            yield (0,_access_token__WEBPACK_IMPORTED_MODULE_2__.clearAccessTokenFromStorage)();
            // Fallback to HTML parsing
            const history = yield getTradeHistoryFromHTML();
            return { history, type: _bridge_handlers_trade_history_status__WEBPACK_IMPORTED_MODULE_0__.TradeHistoryType.HTML };
        }
    });
}
function getTradeHistoryFromAPI() {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_2__.getAccessToken)();
        // This only works if they have granted permission for https://api.steampowered.com
        const resp = yield fetch(`https://api.steampowered.com/IEconService/GetTradeHistory/v1/?access_token=${access.token}&max_trades=200`, {
            credentials: 'include',
        });
        if (resp.status !== 200) {
            throw new Error('invalid status');
        }
        const data = (yield resp.json());
        return (((_a = data.response) === null || _a === void 0 ? void 0 : _a.trades) || [])
            .filter((e) => e.status === 3) // Ensure we only count _complete_ trades (k_ETradeStatus_Complete)
            .filter((e) => !e.time_escrow_end || new Date(parseInt(e.time_escrow_end) * 1000).getTime() < Date.now())
            .map((e) => {
            return {
                other_party_url: `https://steamcommunity.com/profiles/${e.steamid_other}`,
                received_assets: (e.assets_received || [])
                    .filter((e) => e.appid === _types_steam_constants__WEBPACK_IMPORTED_MODULE_1__.AppId.CSGO)
                    .map((e) => {
                    return { asset_id: e.assetid, new_asset_id: e.new_assetid };
                }),
                given_assets: (e.assets_given || [])
                    .filter((e) => e.appid === _types_steam_constants__WEBPACK_IMPORTED_MODULE_1__.AppId.CSGO)
                    .map((e) => {
                    return { asset_id: e.assetid, new_asset_id: e.new_assetid };
                }),
            };
        })
            .filter((e) => {
            // Remove non-CS related assets
            return e.received_assets.length > 0 || e.given_assets.length > 0;
        });
    });
}
function getTradeHistoryFromHTML() {
    return __awaiter(this, void 0, void 0, function* () {
        const resp = yield fetch(`https://steamcommunity.com/id/me/tradehistory`, {
            credentials: 'include',
            // Expect redirect since we're using `me` above
            redirect: 'follow',
        });
        const body = yield resp.text();
        if (body.includes('too many requests')) {
            throw 'Too many requests';
        }
        return parseTradeHistoryHTML(body);
    });
}
function parseTradeHistoryHTML(body) {
    const links = body.matchAll(/<div class="tradehistory_event_description">.+?<a href="https:\/\/steamcommunity\.com\/(.+?)">/gms);
    const statuses = [...links].map((e) => {
        return {
            other_party_url: `https://steamcommunity.com/${e[1]}`,
            received_assets: [],
            given_assets: [],
        };
    });
    const matches = body.matchAll(/HistoryPageCreateItemHover\( 'trade(\d+)_(received|given)item\d+', 730, '2', '(\d+)', '1' \);/g);
    for (const match of matches) {
        const [text, index, type, assetId] = match;
        const tradeIndex = parseInt(index);
        if (type === 'received') {
            statuses[tradeIndex].received_assets.push({ asset_id: assetId });
        }
        else if (type === 'given') {
            statuses[tradeIndex].given_assets.push({ asset_id: assetId });
        }
    }
    return statuses;
}


/***/ }),

/***/ 409:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cancelUnconfirmedTradeOffers": () => (/* binding */ cancelUnconfirmedTradeOffers),
/* harmony export */   "pingCancelTrades": () => (/* binding */ pingCancelTrades),
/* harmony export */   "pingSentTradeOffers": () => (/* binding */ pingSentTradeOffers)
/* harmony export */ });
/* harmony import */ var _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58);
/* harmony import */ var _types_float_market__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(397);
/* harmony import */ var _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(410);
/* harmony import */ var _access_token__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(408);
/* harmony import */ var _bridge_handlers_annotate_offer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(400);
/* harmony import */ var _bridge_handlers_ping_cancel_trade__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(411);
/* harmony import */ var _bridge_handlers_cancel_trade_offer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(412);
/* harmony import */ var _bridge_handlers_fetch_steam_user__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(413);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};








function pingSentTradeOffers(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const { offers, type } = yield getSentTradeOffers();
        const offersToFind = pendingTrades.reduce((acc, e) => {
            acc[e.steam_offer.id] = true;
            return acc;
        }, {});
        // We only want to send offers that are relevant to verifying trades on CSFloat
        const offersForCSFloat = offers.filter((e) => {
            return !!offersToFind[e.offer_id];
        });
        if (offersForCSFloat.length > 0) {
            yield _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__.TradeOfferStatus.handleRequest({ sent_offers: offersForCSFloat, type }, {});
        }
        // Any trade offers to attempt to annotate in case they sent the trade offer outside of CSFloat
        // This is something they shouldn't do, but you can't control the will of users to defy
        for (const offer of offers) {
            if (offer.state !== _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Active) {
                // If it was already accepted, trade history will send the appropriate ping
                continue;
            }
            const hasTradeWithNoOfferAnnotated = pendingTrades.find((e) => {
                if (e.steam_offer.id) {
                    // Already has a steam offer
                    return false;
                }
                return (offer.given_asset_ids || []).includes(e.contract.item.asset_id);
            });
            if (!hasTradeWithNoOfferAnnotated) {
                // Couldn't find matching trade on CSFloat
                continue;
            }
            try {
                yield _bridge_handlers_annotate_offer__WEBPACK_IMPORTED_MODULE_4__.AnnotateOffer.handleRequest({
                    offer_id: offer.offer_id,
                    given_asset_ids: offer.given_asset_ids || [],
                    received_asset_ids: offer.received_asset_ids || [],
                    other_steam_id64: offer.other_steam_id64,
                }, {});
            }
            catch (e) {
                console.error(`failed to annotate offer ${offer.offer_id} post-hoc`, e);
            }
        }
    });
}
function pingCancelTrades(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const hasWaitForCancelPing = pendingTrades.find((e) => e.state === _types_float_market__WEBPACK_IMPORTED_MODULE_1__.TradeState.PENDING && e.wait_for_cancel_ping);
        if (!hasWaitForCancelPing) {
            // Nothing to process/ping, exit
            return;
        }
        const tradeOffers = yield getSentAndReceivedTradeOffersFromAPI();
        const allTradeOffers = [...(tradeOffers.sent || []), ...(tradeOffers.received || [])];
        for (const trade of pendingTrades) {
            if (trade.state !== _types_float_market__WEBPACK_IMPORTED_MODULE_1__.TradeState.PENDING) {
                continue;
            }
            if (!trade.wait_for_cancel_ping) {
                continue;
            }
            const tradeOffer = allTradeOffers.find((e) => e.offer_id === trade.steam_offer.id);
            if (tradeOffer &&
                (tradeOffer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Active || tradeOffer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Accepted)) {
                // We don't want to send a cancel ping if the offer is active or valid
                continue;
            }
            try {
                yield _bridge_handlers_ping_cancel_trade__WEBPACK_IMPORTED_MODULE_5__.PingCancelTrade.handleRequest({ trade_id: trade.id, steam_id: tradeOffers.steam_id }, {});
            }
            catch (e) {
                console.error(`failed to send cancel ping for trade ${trade.id}`, e);
            }
        }
    });
}
// cancelUnconfirmedTradeOffers related to sales on CSFloat that haven't been confirmed for a while
// Helps prevent the user from sending a trade offer _way after_ the sale has already failed
function cancelUnconfirmedTradeOffers(pendingTrades) {
    return __awaiter(this, void 0, void 0, function* () {
        const offerIDsToCancel = [
            ...new Set(pendingTrades
                .filter((e) => e.steam_offer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.CreatedNeedsConfirmation &&
                new Date(e.steam_offer.sent_at).getTime() < Date.now() - 60 * 60 * 1000)
                .map((e) => e.steam_offer.id)),
        ];
        if (offerIDsToCancel.length === 0) {
            return;
        }
        const resp = yield getSentTradeOffers();
        const offersIDsStillNeedsConfirmation = offerIDsToCancel.filter((id) => {
            const sentOffer = resp.offers.find((offer) => offer.offer_id === id);
            if (!sentOffer) {
                return false;
            }
            return sentOffer.state === _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.CreatedNeedsConfirmation;
        });
        if (offersIDsStillNeedsConfirmation.length === 0) {
            return;
        }
        const steamUser = yield _bridge_handlers_fetch_steam_user__WEBPACK_IMPORTED_MODULE_7__.FetchSteamUser.handleRequest({}, {});
        if (!steamUser.sessionID) {
            // Can't cancel offers without a session
            return;
        }
        for (const offerID of offersIDsStillNeedsConfirmation) {
            try {
                yield _bridge_handlers_cancel_trade_offer__WEBPACK_IMPORTED_MODULE_6__.CancelTradeOffer.handleRequest({ trade_offer_id: offerID, session_id: steamUser.sessionID }, {});
            }
            catch (e) {
                console.error(`failed to cancel needs confirmation trade, returning early: ${e.toString()}`);
                return;
            }
        }
    });
}
function getEnglishSentTradeOffersHTML() {
    return __awaiter(this, void 0, void 0, function* () {
        const resp = yield fetch(`https://steamcommunity.com/id/me/tradeoffers/sent`, {
            credentials: 'include',
            // Expect redirect since we're using `me` above
            redirect: 'follow',
        });
        const body = yield resp.text();
        if (body.match(/<html .+? lang="en">/)) {
            // Already english, return
            return body;
        }
        // Explicitly fetch in english instead (we need to use the redirect URL)
        const englishResp = yield fetch(`${resp.url}?l=english`, {
            credentials: 'include',
            // Expect redirect since we're using `me` above
            redirect: 'follow',
        });
        return englishResp.text();
    });
}
function getSentTradeOffers() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const offers = yield getSentTradeOffersFromAPI();
            if (offers.length > 0) {
                // Hedge in case this endpoint gets killed, only return if there are results, fallback to HTML parser
                return { offers, type: _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__.TradeOffersType.API };
            }
            else {
                throw new Error('failed to get trade offers');
            }
        }
        catch (e) {
            yield (0,_access_token__WEBPACK_IMPORTED_MODULE_3__.clearAccessTokenFromStorage)();
            // Fallback to HTML parsing
            const offers = yield getTradeOffersFromHTML();
            return { offers, type: _bridge_handlers_trade_offer_status__WEBPACK_IMPORTED_MODULE_2__.TradeOffersType.HTML };
        }
    });
}
function offerStateMapper(e) {
    return {
        offer_id: e.tradeofferid,
        state: e.trade_offer_state,
        given_asset_ids: (e.items_to_give || []).map((e) => e.assetid),
        received_asset_ids: (e.items_to_receive || []).map((e) => e.assetid),
        time_created: e.time_created,
        time_updated: e.time_updated,
        other_steam_id64: (BigInt('76561197960265728') + BigInt(e.accountid_other)).toString(),
    };
}
function getSentTradeOffersFromAPI() {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_3__.getAccessToken)();
        const resp = yield fetch(`https://api.steampowered.com/IEconService/GetTradeOffers/v1/?access_token=${access.token}&get_sent_offers=true`, {
            credentials: 'include',
        });
        if (resp.status !== 200) {
            throw new Error('invalid status');
        }
        const data = (yield resp.json());
        return (((_a = data.response) === null || _a === void 0 ? void 0 : _a.trade_offers_sent) || []).map(offerStateMapper);
    });
}
function getSentAndReceivedTradeOffersFromAPI() {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function* () {
        const access = yield (0,_access_token__WEBPACK_IMPORTED_MODULE_3__.getAccessToken)();
        const resp = yield fetch(`https://api.steampowered.com/IEconService/GetTradeOffers/v1/?access_token=${access.token}&get_received_offers=true&get_sent_offers=true`, {
            credentials: 'include',
        });
        if (resp.status !== 200) {
            throw new Error('invalid status');
        }
        const data = (yield resp.json());
        return {
            received: (((_a = data.response) === null || _a === void 0 ? void 0 : _a.trade_offers_received) || []).map(offerStateMapper),
            sent: (((_b = data.response) === null || _b === void 0 ? void 0 : _b.trade_offers_sent) || []).map(offerStateMapper),
            steam_id: access.steam_id,
        };
    });
}
const BANNER_TO_STATE = {
    accepted: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Accepted,
    counter: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Countered,
    expired: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Expired,
    cancel: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Canceled,
    declined: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Declined,
    invalid: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.InvalidItems,
    'mobile confirmation': _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.CreatedNeedsConfirmation,
    escrow: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.InEscrow,
};
function getTradeOffersFromHTML() {
    return __awaiter(this, void 0, void 0, function* () {
        const body = yield getEnglishSentTradeOffersHTML();
        return parseTradeOffersHTML(body);
    });
}
function parseTradeOffersHTML(body) {
    const matches = body.matchAll(/<div class="tradeoffer" id="tradeofferid_(\d+?)">.+?tradeoffer_items_ctn(.+?inactive.+?tradeoffer_items_banner\s*">([^<]+))?/gms);
    return [...matches]
        .map((e) => {
        const offerID = e[1];
        if (!e[2]) {
            // It is active since it didn't match on inactive groups
            return {
                offer_id: offerID,
                state: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Active,
            };
        }
        const bannerText = e[3].toLowerCase();
        const stateEntry = Object.entries(BANNER_TO_STATE).find((e) => bannerText.includes(e[0]));
        if (!stateEntry) {
            return {
                offer_id: offerID,
                state: _types_steam_constants__WEBPACK_IMPORTED_MODULE_0__.TradeOfferState.Invalid,
            };
        }
        return {
            offer_id: offerID,
            state: stateEntry[1],
        };
    })
        .filter((e) => !!e.offer_id);
}


/***/ }),

/***/ 6:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ClientSend": () => (/* binding */ ClientSend)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _utils_snips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




function canUseSendMessage() {
    // Not supported in Firefox Page Context
    return !((0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.isFirefox)() && (0,_utils_snips__WEBPACK_IMPORTED_MODULE_2__.inPageContext)());
}
/**
 * Send a request to be handled by the background worker
 *
 * Can be called from a content script or page itself
 */
function ClientSend(handler, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const bundle = {
            version: _types__WEBPACK_IMPORTED_MODULE_0__.Version.V1,
            request_type: handler.getType(),
            request: args,
            id: Math.ceil(Math.random() * 100000000000),
        };
        if (canUseSendMessage()) {
            return new Promise((resolve, reject) => {
                // @ts-ignore Bad types
                (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(window.CSFLOAT_EXTENSION_ID || chrome.runtime.id, bundle, 
                // @ts-ignore Bad types
                (resp) => {
                    if (resp === null || resp === void 0 ? void 0 : resp.response) {
                        resolve(resp.response);
                    }
                    else {
                        reject(resp === null || resp === void 0 ? void 0 : resp.error);
                    }
                });
            });
        }
        else {
            // Fallback to postmessage bus for browsers that don't implement
            // specs fully
            return _bus_post_message_bus__WEBPACK_IMPORTED_MODULE_3__.g_PostMessageBus.sendRequest(bundle);
        }
    });
}


/***/ }),

/***/ 400:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnnotateOffer": () => (/* binding */ AnnotateOffer)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const AnnotateOffer = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.ANNOTATE_OFFER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/steam-status/new-offer`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 412:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CancelTradeOffer": () => (/* binding */ CancelTradeOffer)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const CancelTradeOffer = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.CANCEL_TRADE_OFFER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const formData = {
        sessionid: req.session_id,
    };
    const resp = yield fetch(`https://steamcommunity.com/tradeoffer/${req.trade_offer_id}/cancel`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
        },
        body: new URLSearchParams(formData).toString(),
    });
    if (!resp.ok) {
        throw new Error(`failed to cancel offer: ${resp.status}`);
    }
    return {};
}));


/***/ }),

/***/ 419:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CreateTradeOffer": () => (/* binding */ CreateTradeOffer)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const CreateTradeOffer = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.CREATE_TRADE_OFFER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    function itemMapper(assetID) {
        return {
            appid: 730,
            contextid: 2,
            amount: 1,
            assetid: assetID,
        };
    }
    const offerData = {
        newversion: true,
        version: req.assetIDsToGive.length + req.assetIDsToReceive.length + 1,
        me: {
            assets: req.assetIDsToGive.map(itemMapper),
            currency: [],
            ready: false,
        },
        them: {
            assets: req.assetIDsToReceive.map(itemMapper),
            currency: [],
            ready: false,
        },
    };
    const params = {
        trade_offer_access_token: req.tradeToken,
    };
    const formData = {
        sessionid: req.sessionID,
        serverid: 1,
        partner: req.toSteamID64,
        tradeoffermessage: req.message || 'CSFloat Trade Offer',
        json_tradeoffer: JSON.stringify(offerData),
        captcha: '',
        trade_offer_create_params: JSON.stringify(params),
    };
    const url = req.forceEnglish
        ? 'https://steamcommunity.com/tradeoffer/new/send?l=english'
        : 'https://steamcommunity.com/tradeoffer/new/send';
    const resp = yield fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            // Referer is actually set in the declarative net static rules since
            // it is a "protected" header. Setting it here does nothing in major browsers.
            // Without it, Steam rejects the request as part of their anti-cross origin block.
        },
        body: new URLSearchParams(formData).toString(),
    });
    const res = {
        status: resp.status,
    };
    const text = yield resp.text();
    res.text = text;
    try {
        const data = JSON.parse(res.text);
        res.json = data;
    }
    catch (e) {
        console.error(`failed to parse json from Steam create offer: ${e.toString()}`);
    }
    return res;
}));


/***/ }),

/***/ 11:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteCssOnPage": () => (/* binding */ ExecuteCssOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteCssOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_CSS_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    yield chrome.scripting.insertCSS({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        files: [req.path],
    });
})));


/***/ }),

/***/ 2:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExecuteScriptOnPage": () => (/* binding */ ExecuteScriptOnPage)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExecuteScriptOnPage = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyResponseHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXECUTE_SCRIPT_ON_PAGE, (req, sender) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    // We need to inject the extension ID dynamically so the client knows who to
    // communicate with.
    //
    // On Firefox, extension IDs are random, so this is necessary.
    yield chrome.scripting.executeScript({
        target: { tabId: (_a = sender.tab) === null || _a === void 0 ? void 0 : _a.id },
        world: 'MAIN',
        args: [chrome.runtime.id],
        func: function ExtensionId(extensionId) {
            window.CSFLOAT_EXTENSION_ID = extensionId;
        },
    });
    yield chrome.scripting.executeScript({
        target: { tabId: (_b = sender.tab) === null || _b === void 0 ? void 0 : _b.id },
        files: [req.path],
        world: 'MAIN',
    });
})));


/***/ }),

/***/ 13:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExtensionVersion": () => (/* binding */ ExtensionVersion)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const ExtensionVersion = new _main__WEBPACK_IMPORTED_MODULE_0__.EmptyRequestHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.EXTENSION_VERSION, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const manifest = (0,_utils_detect__WEBPACK_IMPORTED_MODULE_2__.runtimeNamespace)().runtime.getManifest();
    return {
        version: manifest.version,
    };
}));


/***/ }),

/***/ 12:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchExtensionFile": () => (/* binding */ FetchExtensionFile)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchExtensionFile = new _wrappers_privileged__WEBPACK_IMPORTED_MODULE_2__.PrivilegedHandler(new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_EXTENSION_FILE, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const url = chrome.runtime.getURL(req.path);
    const r = yield fetch(url);
    const text = yield r.text();
    return {
        text,
    };
})));


/***/ }),

/***/ 39:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchInspectInfo": () => (/* binding */ FetchInspectInfo)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);


const FetchInspectInfo = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_INSPECT_INFO, (req) => {
    const apiUrl = `https://api.csfloat.com/?url=${req.link}&minimal=true${req.listPrice ? '&listPrice=' + req.listPrice : ''}`;
    return fetch(apiUrl).then((resp) => {
        return resp.json().then((json) => {
            if (resp.ok) {
                return json;
            }
            else {
                throw Error(json.error);
            }
        });
    });
});


/***/ }),

/***/ 422:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchOwnInventory": () => (/* binding */ FetchOwnInventory)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const FetchOwnInventory = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_OWN_INVENTORY, (req) => __awaiter(void 0, void 0, void 0, function* () {
    // Will error out if expected_steam_id != logged in user
    const resp = yield fetch(`https://steamcommunity.com/profiles/${req.expected_steam_id}/inventory/json/${req.app_id}/${req.context_id}/?trading=1`, {
        credentials: 'include',
    });
    if (!resp.ok) {
        throw new Error(`Invalid response code: ${resp.status}`);
    }
    const inventory = (yield resp.json());
    return {
        inventory,
    };
}));


/***/ }),

/***/ 396:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchPendingTrades": () => (/* binding */ FetchPendingTrades)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchPendingTrades = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_PENDING_TRADES, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const state = req.state ? req.state : 'pending';
    const limit = req.limit ? req.limit : 100;
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/me/trades?state=${state}&limit=${limit}&page=0`, {
        credentials: 'include',
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 52:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchStall": () => (/* binding */ FetchStall)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const FetchStall = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_STALL, (req) => __awaiter(void 0, void 0, void 0, function* () {
    return fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/users/${req.steam_id64}/stall`).then((resp) => {
        return resp.json().then((json) => {
            if (resp.ok) {
                return json;
            }
            else {
                throw Error(json.message);
            }
        });
    });
}));


/***/ }),

/***/ 413:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchSteamUser": () => (/* binding */ FetchSteamUser)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const FetchSteamUser = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.FETCH_STEAM_USER, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch('https://steamcommunity.com', {
        headers: {
            // Required for Steam to refresh the JWT when it expires
            Accept: 'text/html,application/xhtml+xml,application/xml;q=0.9;q=0.8,application/signed-exchange;v=b3;q=0.7',
        },
    });
    if (!resp.ok) {
        throw new Error('non-ok response for steamcommunity.com');
    }
    const res = {
        isLoggedIn: false,
    };
    const text = yield resp.text();
    const steamIDMatch = text.match(/g_steamID = "(\d+)"/);
    if (steamIDMatch) {
        res.isLoggedIn = true;
        res.steamID = steamIDMatch[1];
    }
    const sessionIDMatch = text.match(/g_sessionID = "([0-9a-fA-F]+)"/);
    if (sessionIDMatch) {
        res.sessionID = sessionIDMatch[1];
    }
    return res;
}));


/***/ }),

/***/ 418:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HANDLERS_MAP": () => (/* binding */ HANDLERS_MAP)
/* harmony export */ });
/* harmony import */ var _execute_script__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _fetch_stall__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52);
/* harmony import */ var _fetch_inspect_info__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39);
/* harmony import */ var _execute_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _storage_get__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61);
/* harmony import */ var _storage_set__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(66);
/* harmony import */ var _fetch_pending_trades__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(396);
/* harmony import */ var _storage_remove__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(352);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4);
/* harmony import */ var _fetch_extension_file__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12);
/* harmony import */ var _annotate_offer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(400);
/* harmony import */ var _extension_version__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(13);
/* harmony import */ var _trade_history_status__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(407);
/* harmony import */ var _trade_offer_status__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(410);
/* harmony import */ var _has_permissions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(398);
/* harmony import */ var _ping_setup_extension__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(403);
/* harmony import */ var _ping_extension_status__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(414);
/* harmony import */ var _ping_cancel_trade__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(411);
/* harmony import */ var _create_trade_offer__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(419);
/* harmony import */ var _fetch_steam_user__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(413);
/* harmony import */ var _ping_trade_status__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(420);
/* harmony import */ var _ping_status__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(421);
/* harmony import */ var _fetch_own_inventory__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(422);
/* harmony import */ var _cancel_trade_offer__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(412);
























const HANDLERS_MAP = {
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.EXECUTE_SCRIPT_ON_PAGE]: _execute_script__WEBPACK_IMPORTED_MODULE_0__.ExecuteScriptOnPage,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.EXECUTE_CSS_ON_PAGE]: _execute_css__WEBPACK_IMPORTED_MODULE_3__.ExecuteCssOnPage,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.FETCH_INSPECT_INFO]: _fetch_inspect_info__WEBPACK_IMPORTED_MODULE_2__.FetchInspectInfo,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.FETCH_STALL]: _fetch_stall__WEBPACK_IMPORTED_MODULE_1__.FetchStall,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.STORAGE_GET]: _storage_get__WEBPACK_IMPORTED_MODULE_4__.StorageGet,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.STORAGE_SET]: _storage_set__WEBPACK_IMPORTED_MODULE_5__.StorageSet,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.STORAGE_REMOVE]: _storage_remove__WEBPACK_IMPORTED_MODULE_7__.StorageRemove,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.FETCH_PENDING_TRADES]: _fetch_pending_trades__WEBPACK_IMPORTED_MODULE_6__.FetchPendingTrades,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.FETCH_EXTENSION_FILE]: _fetch_extension_file__WEBPACK_IMPORTED_MODULE_9__.FetchExtensionFile,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.ANNOTATE_OFFER]: _annotate_offer__WEBPACK_IMPORTED_MODULE_10__.AnnotateOffer,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.EXTENSION_VERSION]: _extension_version__WEBPACK_IMPORTED_MODULE_11__.ExtensionVersion,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.TRADE_HISTORY_STATUS]: _trade_history_status__WEBPACK_IMPORTED_MODULE_12__.TradeHistoryStatus,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.TRADE_OFFER_STATUS]: _trade_offer_status__WEBPACK_IMPORTED_MODULE_13__.TradeOfferStatus,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.HAS_PERMISSIONS]: _has_permissions__WEBPACK_IMPORTED_MODULE_14__.HasPermissions,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.PING_SETUP_EXTENSION]: _ping_setup_extension__WEBPACK_IMPORTED_MODULE_15__.PingSetupExtension,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.PING_EXTENSION_STATUS]: _ping_extension_status__WEBPACK_IMPORTED_MODULE_16__.PingExtensionStatus,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.PING_CANCEL_TRADE]: _ping_cancel_trade__WEBPACK_IMPORTED_MODULE_17__.PingCancelTrade,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.CREATE_TRADE_OFFER]: _create_trade_offer__WEBPACK_IMPORTED_MODULE_18__.CreateTradeOffer,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.FETCH_STEAM_USER]: _fetch_steam_user__WEBPACK_IMPORTED_MODULE_19__.FetchSteamUser,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.PING_TRADE_STATUS]: _ping_trade_status__WEBPACK_IMPORTED_MODULE_20__.PingTradeStatus,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.PING_STATUS]: _ping_status__WEBPACK_IMPORTED_MODULE_21__.PingStatus,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.FETCH_OWN_INVENTORY]: _fetch_own_inventory__WEBPACK_IMPORTED_MODULE_22__.FetchOwnInventory,
    [_types__WEBPACK_IMPORTED_MODULE_8__.RequestType.CANCEL_TRADE_OFFER]: _cancel_trade_offer__WEBPACK_IMPORTED_MODULE_23__.CancelTradeOffer,
};


/***/ }),

/***/ 398:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HasPermissions": () => (/* binding */ HasPermissions)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const HasPermissions = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.HAS_PERMISSIONS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    // @ts-ignore
    const granted = (yield chrome.permissions.contains({
        permissions: req.permissions,
        origins: req.origins,
    }));
    return {
        granted,
    };
}));


/***/ }),

/***/ 3:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EmptyRequestHandler": () => (/* binding */ EmptyRequestHandler),
/* harmony export */   "EmptyResponseHandler": () => (/* binding */ EmptyResponseHandler),
/* harmony export */   "SimpleHandler": () => (/* binding */ SimpleHandler)
/* harmony export */ });
class SimpleHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}
class EmptyRequestHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(sender);
    }
}
class EmptyResponseHandler {
    constructor(type, handler) {
        this.type = type;
        this.handler = handler;
    }
    getType() {
        return this.type;
    }
    handleRequest(request, sender) {
        return this.handler(request, sender);
    }
}


/***/ }),

/***/ 411:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingCancelTrade": () => (/* binding */ PingCancelTrade)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const PingCancelTrade = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_CANCEL_TRADE, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/${req.trade_id}/cancel-ping`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            steam_id: req.steam_id,
        }),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    const trade = (yield resp.json());
    return {
        trade,
    };
}));


/***/ }),

/***/ 414:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingExtensionStatus": () => (/* binding */ PingExtensionStatus)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
/* harmony import */ var _has_permissions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(398);
/* harmony import */ var _extension_version__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const PingExtensionStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_EXTENSION_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const steamPoweredPermissions = yield _has_permissions__WEBPACK_IMPORTED_MODULE_3__.HasPermissions.handleRequest({
        permissions: [],
        origins: ['*://*.steampowered.com/*'],
    }, {});
    const steamCommunityPermissions = yield _has_permissions__WEBPACK_IMPORTED_MODULE_3__.HasPermissions.handleRequest({
        permissions: [],
        origins: ['*://*.steamcommunity.com/*'],
    }, {});
    const versionResp = yield _extension_version__WEBPACK_IMPORTED_MODULE_4__.ExtensionVersion.handleRequest({}, {});
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/me/extension/status`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            steam_community_permission: steamCommunityPermissions.granted,
            steam_powered_permission: steamPoweredPermissions.granted,
            version: versionResp.version,
            access_token_steam_id: req.access_token_steam_id || '',
            history_error: req.history_error || '',
            trade_offer_error: req.trade_offer_error || '',
        }),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 403:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingSetupExtension": () => (/* binding */ PingSetupExtension)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
/* harmony import */ var _alarms_setup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(404);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const PingSetupExtension = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_SETUP_EXTENSION, (req) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0,_alarms_setup__WEBPACK_IMPORTED_MODULE_3__.registerTradeAlarmIfPossible)();
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/me/extension/setup`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 421:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingStatus": () => (/* binding */ PingStatus)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62);
/* harmony import */ var _storage_keys__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60);
/* harmony import */ var _alarms_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(405);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const PingStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = {};
    const lastPing = yield _storage_store__WEBPACK_IMPORTED_MODULE_2__.gStore.getWithStorage(chrome.storage.local, _storage_keys__WEBPACK_IMPORTED_MODULE_3__.StorageKey.LAST_TRADE_PING_ATTEMPT);
    if (lastPing) {
        resp.last_ping_ms = lastPing;
    }
    if (chrome.alarms) {
        const alarm = yield chrome.alarms.get(_alarms_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_4__.PING_CSFLOAT_TRADE_STATUS_ALARM_NAME);
        if (alarm) {
            resp.next_ping_ms = alarm.scheduledTime;
        }
    }
    return resp;
}));


/***/ }),

/***/ 420:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PingTradeStatus": () => (/* binding */ PingTradeStatus)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _alarms_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(405);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const PingTradeStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.PING_TRADE_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0,_alarms_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_2__.pingTradeStatus)(req.steam_id);
    return {};
}));


/***/ }),

/***/ 61:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageGet": () => (/* binding */ StorageGet)
/* harmony export */ });
/* unused harmony export Get */
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62);
/* harmony import */ var _client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class StorageGetHandler {
    getType() {
        return _types__WEBPACK_IMPORTED_MODULE_2__.RequestType.STORAGE_GET;
    }
    handleRequest(request, sender) {
        return __awaiter(this, void 0, void 0, function* () {
            const value = yield _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.get(request.key);
            return { value };
        });
    }
}
function Get(row) {
    return __awaiter(this, void 0, void 0, function* () {
        const resp = yield (0,_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(new StorageGetHandler(), { key: row.key });
        return resp.value;
    });
}
const StorageGet = new StorageGetHandler();


/***/ }),

/***/ 352:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageRemove": () => (/* binding */ StorageRemove)
/* harmony export */ });
/* unused harmony export Remove */
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62);
/* harmony import */ var _client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class StorageRemoveHandler {
    getType() {
        return _types__WEBPACK_IMPORTED_MODULE_2__.RequestType.STORAGE_REMOVE;
    }
    handleRequest(request, sender) {
        return __awaiter(this, void 0, void 0, function* () {
            yield _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.remove(request.key);
            return {};
        });
    }
}
const StorageRemove = new StorageRemoveHandler();
function Remove(row) {
    return (0,_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(StorageRemove, { key: row.key });
}


/***/ }),

/***/ 66:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageSet": () => (/* binding */ StorageSet)
/* harmony export */ });
/* unused harmony export Set */
/* harmony import */ var _storage_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62);
/* harmony import */ var _client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class StorageSetHandler {
    getType() {
        return _types__WEBPACK_IMPORTED_MODULE_2__.RequestType.STORAGE_SET;
    }
    handleRequest(request, sender) {
        return __awaiter(this, void 0, void 0, function* () {
            yield _storage_store__WEBPACK_IMPORTED_MODULE_0__.gStore.set(request.key, request.value);
            return {};
        });
    }
}
const StorageSet = new StorageSetHandler();
function Set(row, value) {
    return (0,_client__WEBPACK_IMPORTED_MODULE_1__.ClientSend)(StorageSet, { key: row.key, value });
}


/***/ }),

/***/ 407:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TradeHistoryStatus": () => (/* binding */ TradeHistoryStatus),
/* harmony export */   "TradeHistoryType": () => (/* binding */ TradeHistoryType)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



var TradeHistoryType;
(function (TradeHistoryType) {
    TradeHistoryType[TradeHistoryType["API"] = 1] = "API";
    TradeHistoryType[TradeHistoryType["HTML"] = 2] = "HTML";
})(TradeHistoryType || (TradeHistoryType = {}));
const TradeHistoryStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.TRADE_HISTORY_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/steam-status/trade-history`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 410:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TradeOfferStatus": () => (/* binding */ TradeOfferStatus),
/* harmony export */   "TradeOffersType": () => (/* binding */ TradeOffersType)
/* harmony export */ });
/* harmony import */ var _main__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



var TradeOffersType;
(function (TradeOffersType) {
    TradeOffersType[TradeOffersType["API"] = 1] = "API";
    TradeOffersType[TradeOffersType["HTML"] = 2] = "HTML";
})(TradeOffersType || (TradeOffersType = {}));
const TradeOfferStatus = new _main__WEBPACK_IMPORTED_MODULE_0__.SimpleHandler(_types__WEBPACK_IMPORTED_MODULE_1__.RequestType.TRADE_OFFER_STATUS, (req) => __awaiter(void 0, void 0, void 0, function* () {
    const resp = yield fetch(`${_environment__WEBPACK_IMPORTED_MODULE_2__.environment.csfloat_base_api_url}/v1/trades/steam-status/offer`, {
        credentials: 'include',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(req),
    });
    if (resp.status !== 200) {
        throw new Error('invalid status');
    }
    return resp.json();
}));


/***/ }),

/***/ 4:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RequestType": () => (/* binding */ RequestType)
/* harmony export */ });
var RequestType;
(function (RequestType) {
    RequestType[RequestType["EXECUTE_SCRIPT_ON_PAGE"] = 0] = "EXECUTE_SCRIPT_ON_PAGE";
    RequestType[RequestType["EXECUTE_CSS_ON_PAGE"] = 1] = "EXECUTE_CSS_ON_PAGE";
    RequestType[RequestType["FETCH_INSPECT_INFO"] = 2] = "FETCH_INSPECT_INFO";
    RequestType[RequestType["FETCH_STALL"] = 3] = "FETCH_STALL";
    RequestType[RequestType["STORAGE_GET"] = 4] = "STORAGE_GET";
    RequestType[RequestType["STORAGE_SET"] = 5] = "STORAGE_SET";
    RequestType[RequestType["STORAGE_REMOVE"] = 6] = "STORAGE_REMOVE";
    RequestType[RequestType["FETCH_PENDING_TRADES"] = 7] = "FETCH_PENDING_TRADES";
    RequestType[RequestType["FETCH_EXTENSION_FILE"] = 8] = "FETCH_EXTENSION_FILE";
    RequestType[RequestType["ANNOTATE_OFFER"] = 9] = "ANNOTATE_OFFER";
    RequestType[RequestType["EXTENSION_VERSION"] = 10] = "EXTENSION_VERSION";
    RequestType[RequestType["TRADE_HISTORY_STATUS"] = 11] = "TRADE_HISTORY_STATUS";
    RequestType[RequestType["TRADE_OFFER_STATUS"] = 12] = "TRADE_OFFER_STATUS";
    RequestType[RequestType["HAS_PERMISSIONS"] = 13] = "HAS_PERMISSIONS";
    RequestType[RequestType["PING_SETUP_EXTENSION"] = 14] = "PING_SETUP_EXTENSION";
    RequestType[RequestType["PING_EXTENSION_STATUS"] = 15] = "PING_EXTENSION_STATUS";
    RequestType[RequestType["PING_CANCEL_TRADE"] = 16] = "PING_CANCEL_TRADE";
    RequestType[RequestType["CREATE_TRADE_OFFER"] = 17] = "CREATE_TRADE_OFFER";
    RequestType[RequestType["FETCH_STEAM_USER"] = 18] = "FETCH_STEAM_USER";
    RequestType[RequestType["PING_TRADE_STATUS"] = 19] = "PING_TRADE_STATUS";
    RequestType[RequestType["PING_STATUS"] = 20] = "PING_STATUS";
    RequestType[RequestType["FETCH_OWN_INVENTORY"] = 21] = "FETCH_OWN_INVENTORY";
    RequestType[RequestType["CANCEL_TRADE_OFFER"] = 22] = "CANCEL_TRADE_OFFER";
})(RequestType || (RequestType = {}));


/***/ }),

/***/ 417:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Handle": () => (/* binding */ Handle)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _handlers_handlers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(418);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function findHandler(type) {
    return _handlers_handlers__WEBPACK_IMPORTED_MODULE_1__.HANDLERS_MAP[type];
}
function Handle(blob, sender) {
    return __awaiter(this, void 0, void 0, function* () {
        if (blob.version !== _types__WEBPACK_IMPORTED_MODULE_0__.Version.V1) {
            // Ignore messages that aren't for this bridge
            return;
        }
        const req = blob;
        const handler = findHandler(req.request_type);
        if (!handler) {
            throw new Error(`couldn't find handler for request type ${req.request_type}`);
        }
        return handler.handleRequest(req.request, sender);
    });
}


/***/ }),

/***/ 7:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Version": () => (/* binding */ Version)
/* harmony export */ });
var Version;
(function (Version) {
    Version["V1"] = "CSFLOAT_V1";
})(Version || (Version = {}));


/***/ }),

/***/ 5:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PrivilegedHandler": () => (/* binding */ PrivilegedHandler)
/* harmony export */ });
/**
 * Restricts a given handler such that it can only run if the sender is
 * verified to be from the extension's origin (ie. content script)
 */
class PrivilegedHandler {
    constructor(handler) {
        this.handler = handler;
    }
    getType() {
        return this.handler.getType();
    }
    handleRequest(request, sender) {
        if (sender.id !== chrome.runtime.id) {
            throw new Error('Attempt to access restricted method outside of secure context (ie. content script)');
        }
        return this.handler.handleRequest(request, sender);
    }
}


/***/ }),

/***/ 10:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "g_PostMessageBus": () => (/* binding */ g_PostMessageBus)
/* harmony export */ });
/* harmony import */ var _bridge_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _utils_detect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);


/**
 * Message bus that uses `postMessage` in order to communicate with the background
 * service worker/script.
 *
 * Why? Because the client page (ie. Steam page) on Firefox is not capable of
 * sending a message directly to the extension background.
 *
 * So it requires us to do the following dance:
 * page <--(postmessage)--> content script <--(sendmessage)--> background script
 *
 * This dance is abstracted in `ClientSend`, and only uses this bus if
 * `sendmessage` is not supported in the page.
 */
class PostMessageBus {
    /**
     * For the requester (ie. page), to wait until it gets a response
     * from the content script via. postMessage for the given request ID
     *
     * @param id Request ID
     */
    waitUntilResponseFor(id) {
        return new Promise((resolve, reject) => {
            const handler = (e) => {
                const resp = e.data;
                if (resp.id !== id || !resp.response) {
                    return;
                }
                // Prevent leaks
                window.removeEventListener('message', handler, false);
                if (resp === null || resp === void 0 ? void 0 : resp.response) {
                    resolve(resp.response);
                }
                else {
                    reject(resp === null || resp === void 0 ? void 0 : resp.error);
                }
            };
            window.addEventListener('message', handler);
        });
    }
    /**
     * Sends a request to be done through the bus, returns the appropriate
     * response for the input bundle handler
     *
     * @param bundle Request Bundle
     */
    sendRequest(bundle) {
        window.postMessage(bundle);
        return this.waitUntilResponseFor(bundle.id);
    }
    /**
     * Request handler (content script) for new requests from the page.
     *
     * Each request is effectively "proxied" to the background script/worker
     * to actually execute it's handler.
     */
    handleRequests() {
        const h = (e) => {
            if (e.data.version !== _bridge_types__WEBPACK_IMPORTED_MODULE_0__.Version.V1 || !e.data.request) {
                // Ignore messages that aren't for this bridge
                return;
            }
            // Send to the background script
            // @ts-ignore Bad types
            (0,_utils_detect__WEBPACK_IMPORTED_MODULE_1__.runtimeNamespace)().runtime.sendMessage(chrome.runtime.id, e.data, 
            // @ts-ignore Bad types
            (resp) => {
                window.postMessage(resp);
            });
        };
        window.addEventListener('message', h);
    }
}
const g_PostMessageBus = new PostMessageBus();


/***/ }),

/***/ 60:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageKey": () => (/* binding */ StorageKey)
/* harmony export */ });
/* unused harmony exports PAGE_SIZE, DYNAMIC_ITEM_FILTERS, GLOBAL_FILTERS */
var StorageKey;
(function (StorageKey) {
    // Backwards compatible with <3.0.0
    StorageKey["PAGE_SIZE"] = "pageSize";
    StorageKey["ITEM_FILTERS"] = "expressions";
    StorageKey["GLOBAL_FILTERS"] = "global";
    StorageKey["ACCESS_TOKEN"] = "access_token";
    StorageKey["LAST_TRADE_PING_ATTEMPT"] = "last_trade_ping_attempt";
})(StorageKey || (StorageKey = {}));
function newRow(name) {
    return { key: name };
}
/**
 * Allows defining a "dynamic" row that has different keys at runtime, but share a similar
 * type.
 *
 * NOTE: This is generally **discouraged** and you should instead store under a static key with
 * an object of your desire. It exists to be compatible with historical poor decisions.
 *
 * @param suffix Storage key used as a suffix for the internal storage key
 */
function newDynamicRow(suffix) {
    return function (prefix) {
        return { key: `${prefix}_${suffix}` };
    };
}
// Explicitly create each row here that is used in the application
// This is designed to have type safety for all operations on the same key
const PAGE_SIZE = newRow(StorageKey.PAGE_SIZE);
// Dynamic prefixes should be the market hash name of the item
const DYNAMIC_ITEM_FILTERS = newDynamicRow(StorageKey.ITEM_FILTERS);
const GLOBAL_FILTERS = newRow(StorageKey.GLOBAL_FILTERS);


/***/ }),

/***/ 62:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "gStore": () => (/* binding */ gStore)
/* harmony export */ });
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class Store {
    // Prefer to use sync storage if possible
    get defaultStorageLayer() {
        return chrome.storage.sync ? chrome.storage.sync : chrome.storage.local;
    }
    // getWithStorage using a specified storage layer
    getWithStorage(storage, key) {
        return __awaiter(this, void 0, void 0, function* () {
            const a = yield storage.get(key);
            if (!a || !(key in a)) {
                return null;
            }
            try {
                return JSON.parse(a[key]);
            }
            catch (e) {
                // Fallback if this is an old key not stored as JSON
                return a[key];
            }
        });
    }
    // get using the default storage layer
    get(key) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.getWithStorage(this.defaultStorageLayer, key);
        });
    }
    // setWithStorage using a specified storage layer
    setWithStorage(storage, key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            return storage.set({ [key]: JSON.stringify(value) });
        });
    }
    // set using the default storage layer
    set(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.setWithStorage(this.defaultStorageLayer, key, value);
        });
    }
    // removeWithStorage using a specified storage layer
    removeWithStorage(storage, key) {
        return __awaiter(this, void 0, void 0, function* () {
            return storage.remove([key]);
        });
    }
    // remove using the default storage layer
    remove(key) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.removeWithStorage(this.defaultStorageLayer, key);
        });
    }
}
const gStore = new Store();


/***/ }),

/***/ 397:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TradeState": () => (/* binding */ TradeState)
/* harmony export */ });
/* unused harmony exports ContractState, ContractType */
var ContractState;
(function (ContractState) {
    ContractState["SOLD"] = "sold";
    ContractState["LISTED"] = "listed";
    ContractState["DELISTED"] = "delisted";
    ContractState["REFUNDED"] = "refunded";
})(ContractState || (ContractState = {}));
var ContractType;
(function (ContractType) {
    ContractType["BUY_NOW"] = "buy_now";
    ContractType["AUCTION"] = "auction";
})(ContractType || (ContractType = {}));
var TradeState;
(function (TradeState) {
    TradeState["QUEUED"] = "queued";
    TradeState["PENDING"] = "pending";
    TradeState["VERIFIED"] = "verified";
    TradeState["FAILED"] = "failed";
    TradeState["CANCELLED"] = "cancelled";
})(TradeState || (TradeState = {}));


/***/ }),

/***/ 58:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppId": () => (/* binding */ AppId),
/* harmony export */   "TradeOfferState": () => (/* binding */ TradeOfferState)
/* harmony export */ });
/* unused harmony exports Currency, ContextId */
// See g_rgCurrencyData
var Currency;
(function (Currency) {
    Currency[Currency["USD"] = 2001] = "USD";
})(Currency || (Currency = {}));
var AppId;
(function (AppId) {
    AppId[AppId["CSGO"] = 730] = "CSGO";
})(AppId || (AppId = {}));
var ContextId;
(function (ContextId) {
    ContextId[ContextId["PRIMARY"] = 2] = "PRIMARY";
})(ContextId || (ContextId = {}));
// https://developer.valvesoftware.com/wiki/Steam_Web_API/IEconService
var TradeOfferState;
(function (TradeOfferState) {
    TradeOfferState[TradeOfferState["Invalid"] = 1] = "Invalid";
    TradeOfferState[TradeOfferState["Active"] = 2] = "Active";
    TradeOfferState[TradeOfferState["Accepted"] = 3] = "Accepted";
    TradeOfferState[TradeOfferState["Countered"] = 4] = "Countered";
    TradeOfferState[TradeOfferState["Expired"] = 5] = "Expired";
    TradeOfferState[TradeOfferState["Canceled"] = 6] = "Canceled";
    TradeOfferState[TradeOfferState["Declined"] = 7] = "Declined";
    TradeOfferState[TradeOfferState["InvalidItems"] = 8] = "InvalidItems";
    TradeOfferState[TradeOfferState["CreatedNeedsConfirmation"] = 9] = "CreatedNeedsConfirmation";
    TradeOfferState[TradeOfferState["CancelledBySecondFactor"] = 10] = "CancelledBySecondFactor";
    TradeOfferState[TradeOfferState["InEscrow"] = 11] = "InEscrow";
})(TradeOfferState || (TradeOfferState = {}));


/***/ }),

/***/ 8:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isFirefox": () => (/* binding */ isFirefox),
/* harmony export */   "runtimeNamespace": () => (/* binding */ runtimeNamespace)
/* harmony export */ });
function isFirefox() {
    return navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
}
/**
 * Thanks to our browser overlords, we have two namespaces for `x.runtime.fn()`
 */
function runtimeNamespace() {
    if (isFirefox()) {
        return browser;
    }
    else {
        return chrome;
    }
}


/***/ }),

/***/ 9:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "inPageContext": () => (/* binding */ inPageContext)
/* harmony export */ });
function inPageContext() {
    return typeof chrome === 'undefined' || !chrome.extension;
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/* harmony import */ var _lib_bridge_server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(417);
/* harmony import */ var _lib_alarms_setup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(404);
/* harmony import */ var _lib_alarms_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(405);
/* harmony import */ var _lib_storage_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62);
/* harmony import */ var _lib_storage_keys__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60);
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





function unifiedHandler(request, sender, sendResponse) {
    (0,_lib_bridge_server__WEBPACK_IMPORTED_MODULE_0__.Handle)(request, sender)
        .then((response) => {
        sendResponse({
            request_type: request.request_type,
            id: request.id,
            response,
        });
    })
        .catch((error) => {
        sendResponse({
            request_type: request.request_type,
            id: request.id,
            error: error.toString(),
        });
    });
}
function requestPermissions(permissions, origins, sendResponse) {
    chrome.permissions.request({ permissions, origins }, (granted) => sendResponse(granted));
    return true;
}
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.message === 'requestPermissions') {
        return requestPermissions(request.permissions, request.origins, sendResponse);
    }
    unifiedHandler(request, sender, sendResponse);
    return true;
});
chrome.runtime.onMessageExternal.addListener((request, sender, sendResponse) => {
    unifiedHandler(request, sender, sendResponse);
    return true;
});
if (chrome.alarms) {
    // Install at the root level to make sure events wake up the service worker
    chrome.alarms.onAlarm.addListener(_lib_alarms_setup__WEBPACK_IMPORTED_MODULE_1__.alarmListener);
}
function checkAlarmState() {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0,_lib_alarms_setup__WEBPACK_IMPORTED_MODULE_1__.registerTradeAlarmIfPossible)();
    });
}
checkAlarmState();
// Ping trade status upon service worker wake-up
// Why do this even though there's an alarm? Well, some people turn on their device briefly to send a trade offer
// then close it quickly, it's hard to rely on Chrome's scheduling in that case
function checkTradeStatus() {
    return __awaiter(this, void 0, void 0, function* () {
        const lastPing = yield _lib_storage_store__WEBPACK_IMPORTED_MODULE_3__.gStore.getWithStorage(chrome.storage.local, _lib_storage_keys__WEBPACK_IMPORTED_MODULE_4__.StorageKey.LAST_TRADE_PING_ATTEMPT);
        if (!lastPing || lastPing < Date.now() - 3 * 60 * 1000) {
            // Last ping was over 3 minutes ago
            (0,_lib_alarms_csfloat_trade_pings__WEBPACK_IMPORTED_MODULE_2__.pingTradeStatus)();
        }
    });
}
checkTradeStatus();

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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